﻿class CSSPalette {
	constructor() {
		this.DOMobject = [];
		this.draggingDOM = null;
	}

	initialize() {
		this.DOMobject = document.getElementsByClassName('csspal');
		for (let cnt = 0; cnt < this.DOMobject.length; cnt++) {
			this.DOMobject[cnt].addEventListener('mousedown', this.onMouseDown.bind(this), false);
		}
	}





	onMouseDown(evt) {
		this.draggingDOM = evt.target;
		let palid = evt.target.dataset.palid;
		let dragclass = evt.target.dataset.value;

		// Mouse eventをDisplayFieldからCSSPalに渡してもらうように設定
		window.displayField.setMouseEventObj(this.mouseMove.bind(this), this.mouseUp.bind(this));
	}
	mouseMove(evt) {
	}
	mouseUp(evt) {
		// Mouse event callback設定をクリア
		window.displayField.setMouseEventObj(null, null);

		let dropele = document.elementFromPoint(evt.pageX, evt.pageY);
		dropele.classList.remove();
		dropele.classList.add(this.draggingDOM.dataset.value);
	}

} // class CSSPalette
