/*
 * 複数のサイコロの目の数の確率を求める
 * X面体のサイコロ　n個で出る目の数を与えると
 * 場合の数と確率を求めて表示。
 *      2016/11/23
 */
package diceexample;

import static java.lang.Math.pow;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author ishin
 */
public class DiceExample {

    /**
     * 確率を求める
     *
     * @param acv
     * @param caseNum
     * @return
     */
    public double getProbability(int caseNum, double acv) {
        double pr = (double) caseNum / acv;
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(pr));
        return bigDecimal.setScale(5, RoundingMode.HALF_UP).doubleValue();
    }

    /**
     * 場合数の総数を求める
     *
     * @param fa
     * @param num
     * @return
     */
    public double getAllCaseValue(int fa, int num) {
        return pow((double) fa, (double) num);
    }

    /**
     * 場合の数を求める
     *
     * @param face
     * @param num
     * @param outNum
     * @return
     */
    public int getCaseNumber(int face, int num, int outNum) {

        Map<Integer, Map<Integer, Integer>> map = new HashMap<>();

        for (int nn = 1; nn <= num; nn++) {
            Map<Integer, Integer> cv = new HashMap<>();
            if (nn == 1) {
                for (int i = nn; i <= (nn * face); i++) {
                    cv.put(i, 1);
                }
            } else {
                int n = nn - 1;
                for (int i = nn; i <= (nn * face); i++) {
                    int cc = 0;
                    for (int fc = 1; fc <= face; fc++) {
                        int cx = i - fc;
                        if (n <= cx && cx <= (n * face)) {
                            cc = cc + map.get(n).get(cx);
                        }
                    }
                    cv.put(i, cc);
                }
            }
            map.put(nn, cv);
        }

        return map.get(num).get(outNum);
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        // サイコロの面数 face 面数は６面以上とする。
        int face = 6;
        // サイコロの個数 num
        int num = 2;
        // 出る目　求める確率
        int outNum = 8;
        
        DiceExample de = new DiceExample();
        
        //  場合の総数
        double acv = de.getAllCaseValue(face, num);
        
        // 場合の数
        int cn = 0;
        if (num <= outNum && outNum <= (num * face)) {
            cn = de.getCaseNumber(face, num, outNum);
        }
        
        // 確率
        double pr = de.getProbability(cn, acv);
        
        // 出力
        System.out.println("面数 : " + face);
        System.out.println("個数 : " + num);
        System.out.println("出目 : " + outNum);
        System.out.println("場合の数 : " + cn);
        System.out.println("確率 : " + pr);

    }

}
