/*
 * Decompiled with CFR 0.152.
 */
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DynamicLights {
    private static Map<Integer, DynamicLight> mapDynamicLights = new HashMap<Integer, DynamicLight>();
    private static long timeUpdateMs = 0L;
    private static final double MAX_DIST = 7.5;
    private static final double MAX_DIST_SQ = 56.25;
    private static final int LIGHT_LEVEL_MAX = 15;
    private static final int LIGHT_LEVEL_FIRE = 15;
    private static final int LIGHT_LEVEL_BLAZE = 10;
    private static final int LIGHT_LEVEL_MAGMA_CUBE = 8;
    private static final int LIGHT_LEVEL_MAGMA_CUBE_CORE = 13;
    private static final int LIGHT_LEVEL_GLOWSTONE_DUST = 8;
    private static final int LIGHT_LEVEL_PRISMARINE_CRYSTALS = 8;

    public static void entityAdded(pk entityIn, bfr renderGlobal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entityRemoved(pk entityIn, bfr renderGlobal) {
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            DynamicLight dynamicLight = mapDynamicLights.remove(IntegerCache.valueOf(entityIn.F()));
            if (dynamicLight != null) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(bfr renderGlobal) {
        long timeNowMs = System.currentTimeMillis();
        if (timeNowMs < timeUpdateMs + 50L) {
            return;
        }
        timeUpdateMs = timeNowMs;
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            DynamicLights.updateMapDynamicLights(renderGlobal);
            if (mapDynamicLights.size() <= 0) {
                return;
            }
            Collection<DynamicLight> dynamicLights = mapDynamicLights.values();
            for (DynamicLight dynamicLight : dynamicLights) {
                dynamicLight.update(renderGlobal);
            }
        }
    }

    private static void updateMapDynamicLights(bfr renderGlobal) {
        bdb world = renderGlobal.getWorld();
        if (world == null) {
            return;
        }
        List entities = world.E();
        for (pk entity : entities) {
            DynamicLight dynamicLight;
            Integer key;
            int lightLevel = DynamicLights.getLightLevel(entity);
            if (lightLevel > 0) {
                key = IntegerCache.valueOf(entity.F());
                dynamicLight = mapDynamicLights.get(key);
                if (dynamicLight != null) continue;
                dynamicLight = new DynamicLight(entity);
                mapDynamicLights.put(key, dynamicLight);
                continue;
            }
            key = IntegerCache.valueOf(entity.F());
            dynamicLight = mapDynamicLights.remove(key);
            if (dynamicLight == null) continue;
            dynamicLight.updateLitChunks(renderGlobal);
        }
    }

    public static int getCombinedLight(cj pos, int combinedLight) {
        double lightPlayer = DynamicLights.getLightLevel(pos);
        combinedLight = DynamicLights.getCombinedLight(lightPlayer, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(pk entity, int combinedLight) {
        double lightPlayer = DynamicLights.getLightLevel(entity);
        combinedLight = DynamicLights.getCombinedLight(lightPlayer, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(double lightPlayer, int combinedLight) {
        int lightBlockFF;
        int lightPlayerFF;
        if (lightPlayer > 0.0 && (lightPlayerFF = (int)(lightPlayer * 16.0)) > (lightBlockFF = combinedLight & 0xFF)) {
            combinedLight &= 0xFFFFFF00;
            combinedLight |= lightPlayerFF;
        }
        return combinedLight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getLightLevel(cj pos) {
        double lightLevelMax = 0.0;
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            Collection<DynamicLight> dynamicLights = mapDynamicLights.values();
            for (DynamicLight dynamicLight : dynamicLights) {
                double dist;
                double light;
                double lightLevel;
                int dynamicLightLevel = dynamicLight.getLastLightLevel();
                if (dynamicLightLevel <= 0) continue;
                double px = dynamicLight.getLastPosX();
                double py = dynamicLight.getLastPosY();
                double pz = dynamicLight.getLastPosZ();
                double dx = (double)pos.n() - px;
                double dy = (double)pos.o() - py;
                double dz = (double)pos.p() - pz;
                double distSq = dx * dx + dy * dy + dz * dz;
                if (dynamicLight.isUnderwater() && !Config.isClearWater()) {
                    dynamicLightLevel = Config.limit(dynamicLightLevel - 2, 0, 15);
                    distSq *= 2.0;
                }
                if (distSq > 56.25 || !((lightLevel = (light = 1.0 - (dist = Math.sqrt(distSq)) / 7.5) * (double)dynamicLightLevel) > lightLevelMax)) continue;
                lightLevelMax = lightLevel;
            }
        }
        double lightPlayer = Config.limit(lightLevelMax, 0.0, 15.0);
        return lightPlayer;
    }

    public static int getLightLevel(zx itemStack) {
        yo itemBlock;
        afh block;
        if (itemStack == null) {
            return 0;
        }
        zw item = itemStack.b();
        if (item instanceof yo && (block = (itemBlock = (yo)item).d()) != null) {
            return block.r();
        }
        if (item == zy.ay) {
            return afi.l.r();
        }
        if (item == zy.bv || item == zy.bD) {
            return 10;
        }
        if (item == zy.aT) {
            return 8;
        }
        if (item == zy.cD) {
            return 8;
        }
        if (item == zy.bE) {
            return 8;
        }
        if (item == zy.bZ) {
            return afi.bY.r() / 2;
        }
        return 0;
    }

    public static int getLightLevel(pk entity) {
        vn entityCreeper;
        wn player;
        if (entity == Config.getMinecraft().ac() && !Config.isDynamicHandLight()) {
            return 0;
        }
        if (entity instanceof wn && (player = (wn)entity).v()) {
            return 0;
        }
        if (entity.at()) {
            return 15;
        }
        if (entity instanceof ws) {
            return 15;
        }
        if (entity instanceof vj) {
            return 15;
        }
        if (entity instanceof vl) {
            vl entityBlaze = (vl)entity;
            if (entityBlaze.n()) {
                return 15;
            }
            return 10;
        }
        if (entity instanceof vu) {
            vu emc = (vu)entity;
            if ((double)emc.b > 0.6) {
                return 13;
            }
            return 8;
        }
        if (entity instanceof vn && (double)(entityCreeper = (vn)entity).a(0.0f) > 0.001) {
            return 15;
        }
        if (entity instanceof pr) {
            player = (pr)entity;
            zx stackMain = player.bA();
            int levelMain = DynamicLights.getLightLevel(stackMain);
            zx stackHead = player.p(4);
            int levelHead = DynamicLights.getLightLevel(stackHead);
            return Math.max(levelMain, levelHead);
        }
        if (entity instanceof uz) {
            uz entityItem = (uz)entity;
            zx itemStack = DynamicLights.getItemStack(entityItem);
            return DynamicLights.getLightLevel(itemStack);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLights(bfr renderGlobal) {
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            Collection<DynamicLight> lights = mapDynamicLights.values();
            Iterator<DynamicLight> it = lights.iterator();
            while (it.hasNext()) {
                DynamicLight dynamicLight = it.next();
                it.remove();
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount() {
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            return mapDynamicLights.size();
        }
    }

    public static zx getItemStack(uz entityItem) {
        zx itemstack = entityItem.H().f(10);
        return itemstack;
    }
}

