/*
 * Decompiled with CFR 0.152.
 */
package CarnageHack;

import CarnageHack.CHArrayList;
import CarnageHack.CHmessageboxEvent;
import CarnageHack.CHtimerAutoClose;
import CarnageHack.CHviewImage;
import CarnageHack.CHviewSplash;
import CarnageHack.CarnageHack;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.util.Timer;
import java.util.TimerTask;

public class CHutil {
    static Image defaultIcon;
    static long[] SinTable;
    static long[] CosTable;
    static long[] TanTable;

    public static void init(Object obj, MediaTracker mt) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        defaultIcon = tk.getImage(obj.getClass().getResource("icon/manji.png"));
        mt.addImage(defaultIcon, 0);
    }

    public static int calc_distance(int x, int y) {
        return (int)Math.floor(Math.sqrt(x * x + y * y) + 0.5);
    }

    public static int calc_deg_delta(int basedeg, int tdeg) {
        int d2;
        int d1;
        int b = basedeg;
        int t = tdeg;
        if (b < 0) {
            b += 360;
        }
        if (t < 0) {
            t += 360;
        }
        if ((d1 = Math.abs(t - b)) > (d2 = Math.abs(tdeg - basedeg))) {
            return d2;
        }
        return d1;
    }

    public static int atan2(int y, int x) {
        int n;
        if (x == 0) {
            if (y < 0) {
                return -90;
            }
            return 90;
        }
        if (y == 0) {
            if (x < 0) {
                return 180;
            }
            return 0;
        }
        long t = (long)y * 10000L / (long)x;
        if (t >= 0L) {
            n = 90;
            for (int i = 1; i < 90; ++i) {
                if (TanTable[i] <= t) continue;
                n = i - 1;
                break;
            }
        } else {
            n = 91;
            for (int i = 179; i > 90; --i) {
                if (TanTable[i] >= t) continue;
                n = i + 1;
                break;
            }
        }
        if (y < 0) {
            n = n == 180 ? 0 : (n -= 180);
        }
        return n;
    }

    public static long sin(int deg) {
        if (deg < 0) {
            deg += 360;
        } else if (deg >= 360) {
            deg -= 360;
        }
        return SinTable[deg];
    }

    public static long cos(int deg) {
        if (deg < 0) {
            deg += 360;
        } else if (deg >= 360) {
            deg -= 360;
        }
        return CosTable[deg];
    }

    public static String[] split(String s, char c) {
        return CHutil.split(s, c, -1);
    }

    public static String[] split(String s, char c, int n) {
        int count = 1;
        int nmax = s.length();
        CHArrayList list = new CHArrayList();
        String wk = "";
        for (int i = 0; i < nmax; ++i) {
            if (s.charAt(i) == c) {
                list.add(wk);
                wk = "";
                if (++count != n) continue;
                wk = s.substring(i + 1);
                break;
            }
            wk = wk + s.charAt(i);
        }
        list.add(wk);
        Object[] field = new String[count];
        return (String[])list.toArray(field);
    }

    static void make_text_labels(Dialog dialog, String s) {
        String wk;
        int ns = 0;
        int pos = s.indexOf(10);
        Panel panel = new Panel(new GridLayout(0, 1));
        while (pos != -1) {
            wk = s.substring(ns, pos);
            panel.add(new Label(wk));
            ns = pos + 1;
            pos = s.indexOf(10, ns);
        }
        wk = s.substring(ns);
        panel.add(new Label(wk));
        dialog.add((Component)panel, "Center");
    }

    public static boolean MessageBox(String message, String title, Image icon, boolean ask, long autotimeout) {
        Button okbutton;
        Button button;
        Panel panel;
        Dialog dialog = new Dialog(CarnageHack.getFrame(), title, true);
        CHmessageboxEvent msgevent = new CHmessageboxEvent(dialog);
        CHtimerAutoClose closeevent = null;
        Timer autotimer = null;
        if (icon == null) {
            icon = defaultIcon;
        }
        dialog.addWindowListener(msgevent);
        dialog.add((Component)new CHviewImage(icon), "West");
        CHutil.make_text_labels(dialog, message);
        if (ask) {
            panel = new Panel();
            button = new Button(CarnageHack.resource.getString("buttonYES"));
            button.setActionCommand("OK");
            button.addActionListener(msgevent);
            panel.add(button);
            okbutton = button;
            button = new Button(CarnageHack.resource.getString("buttonNO"));
            button.setActionCommand("CANCEL");
            button.addActionListener(msgevent);
            panel.add(button);
            dialog.add((Component)panel, "South");
        } else {
            panel = new Panel();
            button = new Button(CarnageHack.resource.getString("buttonOK"));
            button.setActionCommand("OK");
            button.addActionListener(msgevent);
            panel.add(button);
            okbutton = button;
            dialog.add((Component)panel, "South");
        }
        dialog.pack();
        if (autotimeout > 0L) {
            closeevent = new CHtimerAutoClose(dialog);
            closeevent.set_timeout(autotimeout);
            closeevent.set_button(okbutton, okbutton.getLabel());
            autotimer = new Timer();
            autotimer.schedule((TimerTask)closeevent, 0L, 1000L);
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension sz = dialog.getSize();
        Dimension scsz = tk.getScreenSize();
        dialog.setLocation((scsz.width - sz.width) / 2, (scsz.height - sz.height) / 2);
        dialog.setVisible(true);
        if (autotimer != null) {
            autotimer.cancel();
        }
        if (closeevent != null) {
            closeevent.cancel();
        }
        return msgevent.isok();
    }

    public static boolean MessageBox(String message, String title, Image icon, boolean ask) {
        return CHutil.MessageBox(message, title, icon, ask, 0L);
    }

    public static String InputBox(String message, String title, String deftext, Image icon) {
        Dialog dialog = new Dialog(CarnageHack.getFrame(), title, true);
        CHmessageboxEvent msgevent = new CHmessageboxEvent(dialog);
        if (icon == null) {
            icon = defaultIcon;
        }
        dialog.addWindowListener(msgevent);
        dialog.add((Component)new CHviewImage(icon), "West");
        Panel panel = new Panel();
        TextField text = new TextField(deftext, 40);
        panel.add(new Label(message));
        panel.add(text);
        text.selectAll();
        dialog.add((Component)panel, "Center");
        panel = new Panel();
        Button button = new Button(CarnageHack.resource.getString("buttonOK"));
        button.setActionCommand("OK");
        button.addActionListener(msgevent);
        panel.add(button);
        button = new Button(CarnageHack.resource.getString("buttonCANCEL"));
        button.setActionCommand("CANCEL");
        button.addActionListener(msgevent);
        panel.add(button);
        dialog.add((Component)panel, "South");
        dialog.pack();
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension sz = dialog.getSize();
        Dimension scsz = tk.getScreenSize();
        dialog.setLocation((scsz.width - sz.width) / 2, (scsz.height - sz.height) / 2);
        dialog.setVisible(true);
        if (msgevent.isok()) {
            return text.getText();
        }
        return null;
    }

    public static boolean SplashBox(String title) {
        Dialog dialog = new Dialog(CarnageHack.getFrame(), title, true);
        CHmessageboxEvent msgevent = new CHmessageboxEvent(dialog);
        dialog.setLayout(new BorderLayout());
        dialog.addWindowListener(msgevent);
        Panel panel1 = new Panel();
        panel1.add(new CHviewSplash());
        dialog.add((Component)panel1, "Center");
        Panel panel2 = new Panel();
        Button button = new Button(CarnageHack.resource.getString("buttonOK"));
        button.setActionCommand("OK");
        button.addActionListener(msgevent);
        panel2.add(button);
        dialog.add((Component)panel2, "South");
        dialog.pack();
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension sz = dialog.getSize();
        Dimension scsz = tk.getScreenSize();
        dialog.setLocation((scsz.width - sz.width) / 2, (scsz.height - sz.height) / 2);
        dialog.setVisible(true);
        return msgevent.isok();
    }

    static int findIndex(Object[] list, Object src) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(src)) continue;
            return i;
        }
        return -1;
    }

    static {
        double radian;
        int i;
        SinTable = new long[360];
        CosTable = new long[360];
        TanTable = new long[180];
        CHutil.SinTable[0] = 0L;
        CHutil.CosTable[0] = 10000L;
        for (i = 1; i < 360; ++i) {
            radian = (double)i * Math.PI / 180.0;
            CHutil.SinTable[i] = (long)(Math.sin(radian) * 10000.0);
            CHutil.CosTable[i] = (long)(Math.cos(radian) * 10000.0);
        }
        CHutil.SinTable[90] = 10000L;
        CHutil.CosTable[90] = 0L;
        CHutil.SinTable[180] = 0L;
        CHutil.CosTable[180] = -10000L;
        CHutil.SinTable[270] = -10000L;
        CHutil.CosTable[270] = 0L;
        CHutil.TanTable[90] = 0L;
        for (i = 0; i < 90; ++i) {
            radian = (double)i * Math.PI / 180.0;
            CHutil.TanTable[i] = (long)(Math.tan(radian) * 10000.0);
        }
        for (i = 91; i < 179; ++i) {
            radian = (double)i * Math.PI / 180.0;
            CHutil.TanTable[i] = (long)(Math.tan(radian) * 10000.0);
        }
    }
}

