/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sample;

import java.lang.annotation.Documented;
import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.ElementType.CONSTRUCTOR;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;
import java.lang.annotation.Retention;
import static java.lang.annotation.RetentionPolicy.RUNTIME;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.Payload;

/**
 *
 * @author konishiyuji
 */
@Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER})
@Retention(RUNTIME)
@Documented
// バリデーション処理のクラスを設定
@Constraint(validatedBy = {ByteValidator.class})
public @interface PersonCorrelation {
    // 独自属性の定義
    int min() default 0;
    int max() default Integer.MAX_VALUE;
//    String charset() default "UTF-8";
    
    Class<?>[] groups() default {};
//    String message() default 
//            "{charset}で{min}バイトから{max}バイトにしてください。";
    String message() default 
            "{min}バイトから{max}バイトにしてください。";
    Class<? extends Payload>[] payload() default {};
    
    @Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER})
    @Retention(RUNTIME)
    @Documented
    @interface List {
        PersonCorrelation[] value();
    }
}
