/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sample.managedbean;

import com.sample.BackingDTO;
import com.sample.FacesContextUtil;
import com.sample.Person;
import com.sample.SessionDTO;
import com.sample.ifacade.BackingBeanFacade01;
import com.sample.ifacade.BackingBeanFacade41;
import com.sample.ifacade.BackingBeanFacade61;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.servlet.http.Part;

/**
 *
 * @author konishiyuji
 */
@ManagedBean
@ViewScoped
public class PersonListBean implements Serializable {
    @Inject
    private FacesContextUtil facesContextUtil;
    @Inject
    private SessionDTO sessionDTO;
    @Inject
    private BackingBeanFacade01 backingBeanFacade;
    @Inject
    private BackingBeanFacade41 backingBeanFacade2;
    @Inject
    private BackingBeanFacade61 backingBeanFacade3;

    // CDI
    private List<Person> list;
    private String text;
    private Part uploadedFile;
    
    // 業務ロジックの呼び出し
    @PostConstruct
    public void execute() {
        System.err.println("BEGIN: PersonListBean.execute()");
        
        List<String> messages = (List<String>) sessionDTO.get("MESSAGES");
        facesContextUtil.addMessages(messages);
        sessionDTO.put("MESSAGES", null);

        // 初期化
        sessionDTO.put("PERSON", null);
        sessionDTO.put("UPLOADED", null);
        
        text = (String) sessionDTO.get("TEXT");
        
        BackingDTO backingDto = new BackingDTO();
        backingDto.put("TEXT", text);

        // 業務ロジックの呼び出し
        String errorCode = backingBeanFacade.execute(backingDto);
        if (!errorCode.equals("000")){
            // エラー
            sessionDTO.put("MESSAGES", messages);
            facesContextUtil.redirect("personList");
            return;
        }

        List<Person> resultList = (List<Person>) backingDto.get("LIST");
        setList(resultList);
        System.err.println("END  : PersonListBean.execute() " + resultList);
    }

    public String action() {
        sessionDTO.put("TEXT", text);
        return "personList";
    }
    
    public String add(){
        return "addPerson";
    }
    
    public String update(){
        return "updatePerson";
    }

    public String delete(){
        return "deletePerson";
    }
    
    public String upload(){
        System.err.println("BEGIN: PersonListBean.upload()");
        
        BackingDTO backingDto = new BackingDTO();
        backingDto.put("FILE", uploadedFile);
        List<Person> uploadedList = new ArrayList<>();
        backingDto.put("UPLOADED", uploadedList);

        // 業務ロジックの呼び出し
        // TODO
        String errorCode = backingBeanFacade2.execute(backingDto);
        sessionDTO.put("UPLOADED", uploadedList);
        
        System.err.println("END  : PersonListBean.upload()");
        
        return "uploadFile";
    }

    public void download(){
        System.err.println("BEGIN: PersonListBean.download()");

        BackingDTO backingDto = new BackingDTO();
        // TODO
        String errorCode = backingBeanFacade3.execute(backingDto);        
        System.err.println("END  : PersonListBean.download()");
        
//        return null;
    }
    
    public String cancel(){
        return "personList";
    }
    
    public Part getUploadedFile() {
        return uploadedFile;
    }

    public void setUploadedFile(Part uploadedFile) {
        this.uploadedFile = uploadedFile;
    }

    /**
     * @return the list
     */
    public List<Person> getList() {
        return list;
    }

    /**
     * @param list the list to set
     */
    public void setList(List<Person> list) {
        this.list = list;
    }

    /**
     * @return the text
     */
    public String getText() {
        return text;
    }

    /**
     * @param text the text to set
     */
    public void setText(String text) {
        this.text = text;
    }
}
