/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.Iterator;

@GwtCompatible
public class MultimapKeysTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testKeys() {
        this.resetContainer(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0), Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e1), Helpers.mapEntry(this.sampleKeys().e1, this.sampleValues().e0));
        Multiset keys = this.multimap().keys();
        MultimapKeysTester.assertEquals((int)2, (int)keys.count(this.sampleKeys().e0));
        MultimapKeysTester.assertEquals((int)1, (int)keys.count(this.sampleKeys().e1));
        MultimapKeysTester.assertEquals((int)3, (int)keys.size());
        Truth.assertThat((Collection)keys).has().allOf(this.sampleKeys().e0, this.sampleKeys().e1, new Object[0]);
        Truth.assertThat((Collection)keys.entrySet()).has().allOf((Object)Multisets.immutableEntry(this.sampleKeys().e0, (int)2), (Object)Multisets.immutableEntry(this.sampleKeys().e1, (int)1), (Object[])new Multiset.Entry[0]);
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testKeysCountAbsentNullKey() {
        MultimapKeysTester.assertEquals((int)0, (int)this.multimap().keys().count(null));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testKeysWithNullKey() {
        this.resetContainer(Helpers.mapEntry(null, this.sampleValues().e0), Helpers.mapEntry(null, this.sampleValues().e1), Helpers.mapEntry(this.sampleKeys().e1, this.sampleValues().e0));
        Multiset keys = this.multimap().keys();
        MultimapKeysTester.assertEquals((int)2, (int)keys.count(null));
        MultimapKeysTester.assertEquals((int)1, (int)keys.count(this.sampleKeys().e1));
        MultimapKeysTester.assertEquals((int)3, (int)keys.size());
        Truth.assertThat((Collection)keys).has().allOf(null, this.sampleKeys().e1, new Object[0]);
        Truth.assertThat((Collection)keys.entrySet()).has().allOf((Object)Multisets.immutableEntry((Object)null, (int)2), (Object)Multisets.immutableEntry(this.sampleKeys().e1, (int)1), (Object[])new Multiset.Entry[0]);
    }

    public void testKeysElementSet() {
        MultimapKeysTester.assertEquals((Object)this.multimap().keySet(), (Object)this.multimap().keys().elementSet());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testKeysRemove() {
        int original = this.multimap().keys().remove(this.sampleKeys().e0, 1);
        MultimapKeysTester.assertEquals((int)Math.max(original - 1, 0), (int)this.multimap().get(this.sampleKeys().e0).size());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testKeysEntrySetIteratorRemove() {
        Multiset keys = this.multimap().keys();
        Iterator itr = keys.entrySet().iterator();
        MultimapKeysTester.assertEquals((Object)Multisets.immutableEntry(this.sampleKeys().e0, (int)1), itr.next());
        itr.remove();
        MultimapKeysTester.assertTrue((boolean)this.multimap().isEmpty());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testKeysEntrySetRemove() {
        this.resetContainer(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0), Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e1), Helpers.mapEntry(this.sampleKeys().e1, this.sampleValues().e0));
        MultimapKeysTester.assertTrue((boolean)this.multimap().keys().entrySet().remove(Multisets.immutableEntry(this.sampleKeys().e0, (int)2)));
        MultimapKeysTester.assertEquals((int)1, (int)this.multimap().size());
        MultimapKeysTester.assertTrue((boolean)this.multimap().containsEntry(this.sampleKeys().e1, this.sampleValues().e0));
    }
}

