/// Copyright (C) 2017, Mocchi
/// Tcl Thin Wrapper
/// License: Boost ver.1


#include "tcl.h"
#include "tk.h"
#include "tommath.h"

/// ===================================
/// Tcl_Obj l擾֐Q
bool TTW_GetBoolean(Tcl_Interp *interp, Tcl_Obj *obj);
bool TTW_GetBoolean(Tcl_Obj *obj);

// ByteArray

double TTW_GetDouble(Tcl_Interp *interp, Tcl_Obj *obj);
double TTW_GetDouble(Tcl_Obj *obj);

// Index

int TTW_GetInt(Tcl_Interp *interp, Tcl_Obj *obj);
int TTW_GetInt(Tcl_Obj *obj);

long TTW_GetLong(Tcl_Interp *interp, Tcl_Obj *obj);
long TTW_GetLong(Tcl_Obj *obj);

const char *TTW_GetString(Tcl_Obj *obj);
const char *TTW_GetString(Tcl_Obj *obj, int &length);

Tcl_UniChar *TTW_GetUnicode(Tcl_Obj *obj);
Tcl_UniChar *TTW_GetUnicode(Tcl_Obj *obj, int &length);

Tcl_WideInt TTW_GetWideInt(Tcl_Interp *interp, Tcl_Obj *obj);
Tcl_WideInt TTW_GetWideInt(Tcl_Obj *obj);

mp_int TTW_GetBignum(Tcl_Interp *interp, Tcl_Obj *obj);
mp_int TTW_GetBignum(Tcl_Obj *obj);

// RegExp

/// ===================================
/// Tcl_DString ₷NX

class TTW_DString{
	/// Tcl_DString ̃GR[fBO͏󋵈ˑ
	/// ǂȃGR[fBOœĂǂɁA
	/// ǂ̃GR[fBOœĂ邩͎gp҂ǗB
	Tcl_DString dstr;
public:
	/// ====== CX^X ======
	TTW_DString();
	TTW_DString(int length);
	TTW_DString(const char *str);
	TTW_DString(const char *str, int length);
	TTW_DString(const Tcl_DString &rhs); 
	TTW_DString(const TTW_DString &rhs); 
	TTW_DString(Tcl_Obj *obj); // Tcl_Obj ̓` utf-8 

	TTW_DString &operator =(const char *rhs);
	TTW_DString &operator =(const Tcl_DString &rhs);
	TTW_DString &operator =(const TTW_DString &rhs);
	TTW_DString &operator =(Tcl_Obj *obj);
	~TTW_DString();

	/// ====== ̃ZbgAǉ ======
	//  Tcl_DString CX^XɈړB
	TTW_DString &Move(Tcl_DString &rhs);
	TTW_DString &Move(TTW_DString &rhs);

	TTW_DString &Set(const char *str, int length);
	TTW_DString &Append(const char *str, int length);

	TTW_DString &operator << (const char *rhs);
	TTW_DString &operator << (const Tcl_DString &rhs);
	TTW_DString &operator << (const TTW_DString &rhs);
	TTW_DString &operator << (Tcl_Obj *obj);

	/// ====== R[hϊ ======
	// ŗ^ꂽVXeGR[fBO UTF8 ɕϊĊi[
	TTW_DString &SysToUtf8(const char *str, bool append = true);
	TTW_DString &SysToUtf8(const char *str, int length, bool append = true);
	TTW_DString &SysToUtf8(const Tcl_DString &str, bool append = true);
	TTW_DString &SysToUtf8(const TTW_DString &str, bool append = true);

	// ŗ^ꂽ w肳ꂽGR[fBOƂ݂ȂAUTF8 ɕϊĊi[
	TTW_DString &ToUtf8(Tcl_Encoding src_enc, const char *str, bool append = true);
	TTW_DString &ToUtf8(Tcl_Encoding src_enc, const char *str, int length, bool append = true);
	TTW_DString &ToUtf8(Tcl_Encoding src_enc, const Tcl_DString &str, bool append = true);
	TTW_DString &ToUtf8(Tcl_Encoding src_enc, const TTW_DString &str, bool append = true);

	// ŗ^ꂽ UTF8 VXeGR[fBOɕϊĊi[
	TTW_DString &Utf8ToSys(const char *str, bool append = true);
	TTW_DString &Utf8ToSys(const char *str, int length, bool append = true);
	TTW_DString &Utf8ToSys(const Tcl_DString &str, bool append = true);
	TTW_DString &Utf8ToSys(const TTW_DString &str, bool append = true);
	TTW_DString &Utf8ToSys(Tcl_Obj *obj, bool append = true);

	// ŗ^ꂽ UTF8 w肳ꂽGR[fBOɕϊĊi[
	TTW_DString &Utf8To(Tcl_Encoding dst_enc, const char *utf8_str, bool append = true);
	TTW_DString &Utf8To(Tcl_Encoding dst_enc, const char *utf8_str, int length, bool append = true);
	TTW_DString &Utf8To(Tcl_Encoding dst_enc, const Tcl_DString &utf8_str, bool append = true);
	TTW_DString &Utf8To(Tcl_Encoding dst_enc, const TTW_DString &utf8_str, bool append = true);
	TTW_DString &Utf8To(Tcl_Encoding dst_enc, Tcl_Obj *obj, bool append = true);

	/// ====== 擾 ======
	operator const char *() const;
	operator char *();
	const char *Value() const;
	char *Value();

	/// ====== 񒷎擾AύX ======
	int Length() const;
	void SetLength(int len);
	void Clear();

	/// ====== Tcl List֘A ======
	//  { B Ō̕Xy[XnłȂꍇ̓Xy[XB
	void StartSubList();
	//  } B
	void EndSubList();

	TTW_DString &AppendElement(const char *rhs);
	TTW_DString &AppendElement(const Tcl_DString &rhs);
	TTW_DString &AppendElement(const TTW_DString &rhs);
	TTW_DString &AppendElement(Tcl_Obj *obj);

};

