/*
 * NPlot - A charting library for .NET
 * 
 * IGraphics.cs
 * Copyright (C) 2003-2006 Matt Howlett and others.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of NPlot nor the names of its contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * patch for writing to PDF using iTextSharp.
 * Copyright (C) 2006-2007 mocchi
 */

using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace NPlot {
	/// <summary>
	/// Common interface for drawing chart.
	/// </summary>
	public interface IGraphics : IDisposable{
		/// <summary>
		/// Draw a rectangle.
		/// </summary>
		/// <param name="pen"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="width"></param>
		/// <param name="height"></param>
		void DrawRectangle(Pen pen, int x, int y, int width, int height);

		/// <summary>
		/// Draw a rectangle.
		/// </summary>
		/// <param name="pen"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="width"></param>
		/// <param name="height"></param>
		void DrawRectangle(Pen pen, float x, float y, float width, float height);

		/// <summary>
		/// Draw rectangle.
		/// </summary>
		/// <param name="pen"></param>
		/// <param name="rect"></param>
		void DrawRectangle(System.Drawing.Pen pen, Rectangle rect);

		/// <summary>
		/// Fill a rectangle.
		/// </summary>
		/// <param name="brush"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="width"></param>
		/// <param name="height"></param>
		void FillRectangle(Brush brush, int x, int y, int width, int height);

		/// <summary>
		/// Fill a rectangle.
		/// </summary>
		/// <param name="brush"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="width"></param>
		/// <param name="height"></param>
		void FillRectangle(Brush brush, float x, float y, float width, float height);

		/// <summary>
		/// Fill rectangle.
		/// </summary>
		/// <param name="brush"></param>
		/// <param name="rect"></param>
		void FillRectangle(System.Drawing.Brush brush, Rectangle rect);
			
		/// <summary>
		/// Draw a line.
		/// </summary>
		/// <param name="pen"></param>
		/// <param name="p1"></param>
		/// <param name="p2"></param>
		void DrawLine(Pen pen, Point p1, Point p2);

		/// <summary>
		/// Draw a line.
		/// </summary>
		/// <param name="pen"></param>
		/// <param name="x1"></param>
		/// <param name="y1"></param>
		/// <param name="x2"></param>
		/// <param name="y2"></param>
		void DrawLine(Pen pen, int x1, int y1, int x2, int y2);


		/// <summary>
		/// Draw a line.
		/// </summary>
		/// <param name="pen"></param>
		/// <param name="x1"></param>
		/// <param name="y1"></param>
		/// <param name="x2"></param>
		/// <param name="y2"></param>
		void DrawLine(Pen pen, float x1, float y1, float x2, float y2);

		/// <summary>
		/// Fill a polygon.
		/// </summary>
		/// <param name="brush"></param>
		/// <param name="pts"></param>
		void FillPolygon(Brush brush, Point[] pts);

		/// <summary>
		/// Fill a polygon.
		/// </summary>
		/// <param name="brush"></param>
		/// <param name="pts"></param>
		void FillPolygon(Brush brush, PointF[] pts);

		/// <summary>
		/// Draw a polygon.
		/// </summary>
		/// <param name="pen"></param>
		/// <param name="pts"></param>
		void DrawPolygon(Pen pen, Point[] pts);
/*
		/// <summary>
		/// Fill path
		/// </summary>
		/// <param name="brush"></param>
		/// <param name="gp"></param>
		void FillPath(Brush brush, GraphicsPath gp);
*/
		/// <summary>
		/// Setting and getting clip rectangle
		/// </summary>
		System.Drawing.RectangleF ClipRectangle{get; set;}

		/// <summary>
		/// Reset clip rectangle.
		/// </summary>
		void ResetClipRectangle();

		/// <summary>
		/// SmoothingMode
		/// </summary>
		SmoothingMode SmoothingMode{get; set;}

		/// <summary>
		/// Measure size of string.
		/// </summary>
		/// <param name="text"></param>
		/// <param name="font"></param>
		/// <returns></returns>
		SizeF MeasureString(string text, Font font);

		/// <summary>
		/// Draw a string.
		/// </summary>
		/// <param name="text"></param>
		/// <param name="font"></param>
		/// <param name="brush"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		void DrawString( string text, Font font, Brush brush, int x, int y);

		/// <summary>
		/// Draw a string
		/// </summary>
		/// <param name="text"></param>
		/// <param name="font"></param>
		/// <param name="brush"></param>
		/// <param name="ptf"></param>
		void DrawString(string text, Font font, Brush brush, PointF ptf);

		/// <summary>
		/// Draw a string
		/// </summary>
		/// <param name="text"></param>
		/// <param name="font"></param>
		/// <param name="brush"></param>
		/// <param name="ptf"></param>
		/// <param name="sf"></param>
		void DrawString(string text, Font font, Brush brush, PointF ptf, StringFormat sf);

		/// <summary>
		/// Draw a string
		/// </summary>
		/// <param name="text"></param>
		/// <param name="font"></param>
		/// <param name="brush"></param>
		/// <param name="rcf"></param>
		/// <param name="sf"></param>
		void DrawString(string text, Font font, Brush brush, RectangleF rcf, StringFormat sf);
			
		/// <summary>
		/// Draw image.
		/// </summary>
		/// <param name="img"></param>
		/// <param name="rect"></param>
		void DrawImage(Image img, Rectangle rect);

		/// <summary>
		/// Draw ellipse
		/// </summary>
		/// <param name="pen"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="width"></param>
		/// <param name="height"></param>
		void DrawEllipse(Pen pen, int x, int y, int width, int height);

		/// <summary>
		/// Fill ellipse
		/// </summary>
		/// <param name="brush"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="width"></param>
		/// <param name="height"></param>
		void FillEllipse(Brush brush, int x, int y, int width, int height);

		/// <summary>
		/// Transformation Matrix
		/// </summary>
		Matrix Transform{get; set;}

		/// <summary>
		/// Reset transform matrix
		/// </summary>
		void ResetTransform();

		/// <summary>
		/// 
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		void TranslateTransform(float x, float y);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="theta"></param>
		void RotateTransform(float theta);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sx"></param>
		/// <param name="sy"></param>
		void ScaleTransform(float sx, float sy);
	}
}
