/*
 * Decompiled with CFR 0.152.
 */
package javax.portlet;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.WindowState;

public abstract class GenericPortlet
implements Portlet,
PortletConfig,
EventPortlet,
ResourceServingPortlet {
    private transient PortletConfig config;

    public void init(PortletConfig config) throws PortletException {
        this.config = config;
        this.init();
    }

    public void init() throws PortletException {
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        throw new PortletException("processAction method not implemented");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        Object renderPartAttrValue = request.getAttribute("javax.portlet.render_part");
        if (renderPartAttrValue != null) {
            if (renderPartAttrValue.equals("RENDER_HEADERS")) {
                this.doHeaders(request, response);
                Collection nextModes = this.getNextPossiblePortletModes(request);
                if (nextModes != null) {
                    response.setNextPossiblePortletModes(nextModes);
                }
                response.setTitle(this.getTitle(request));
                return;
            } else {
                if (!renderPartAttrValue.equals("RENDER_MARKUP")) throw new PortletException("Unknown value of the 'javax.portlet.render_part' request attribute");
                this.doDispatch(request, response);
            }
            return;
        } else {
            this.doHeaders(request, response);
            Collection nextModes = this.getNextPossiblePortletModes(request);
            if (nextModes != null) {
                response.setNextPossiblePortletModes(nextModes);
            }
            response.setTitle(this.getTitle(request));
            this.doDispatch(request, response);
        }
    }

    protected String getTitle(RenderRequest request) {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getResourceBundle(request.getLocale()).getString("javax.portlet.title");
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        WindowState state = request.getWindowState();
        if (!state.equals(WindowState.MINIMIZED)) {
            PortletMode mode = request.getPortletMode();
            if (mode.equals(PortletMode.VIEW)) {
                this.doView(request, response);
            } else if (mode.equals(PortletMode.EDIT)) {
                this.doEdit(request, response);
            } else if (mode.equals(PortletMode.HELP)) {
                this.doHelp(request, response);
            } else {
                throw new PortletException("unknown portlet mode: " + mode);
            }
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        throw new PortletException("doView method not implemented");
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        throw new PortletException("doEdit method not implemented");
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        throw new PortletException("doHelp method not implemented");
    }

    public PortletConfig getPortletConfig() {
        return this.config;
    }

    public void destroy() {
    }

    public String getPortletName() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getPortletName();
    }

    public PortletContext getPortletContext() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getPortletContext();
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getResourceBundle(locale);
    }

    public String getInitParameter(String name) {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getInitParameterNames();
    }

    public Enumeration getProcessingEventQNames() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getProcessingEventQNames();
    }

    public Enumeration getPublishingEventQNames() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getPublishingEventQNames();
    }

    public Enumeration getSupportedLocales() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getSupportedLocales();
    }

    public Map getContainerRuntimeOptions() {
        return this.config.getContainerRuntimeOptions();
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        PortletRequestDispatcher rd;
        if (request.getResourceID() != null && (rd = this.getPortletConfig().getPortletContext().getRequestDispatcher(request.getResourceID())) != null) {
            rd.forward(request, response);
        }
    }

    public void processEvent(EventRequest request, EventResponse response) throws PortletException, IOException {
        String eventName = request.getEvent().getQName().toString();
        response.setRenderParameters(request);
    }

    protected void doHeaders(RenderRequest request, RenderResponse response) {
    }

    protected Collection getNextPossiblePortletModes(RenderRequest request) {
        return null;
    }

    public Enumeration getPublicRenderParameterNames() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getPublicRenderParameterNames();
    }

    public String getDefaultNamespace() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getDefaultNamespace();
    }
}

