## ウォーターマーク入れる君とは？

自身が作成したり描いた画像に対し、薄い透かしと透かし文字(以下、ウォーターマークと呼びます)を入れて新規作成するプログラムです。
元の画像には一切手を加えませんのでご安心下さい。

本プログラムはPython3.6.2を用いて作成されました。
ソースコードを公開していますので、知識のある方は以下から自由に改造していただいても結構です

[ウォーターマーク入れる君](https://gist.github.com/sakage24/1b6a2a22c0a4672bf92eb6f9f49c5885)

## 使い方

1. ウォーターマークを入れる君.exeを起動して下さい。もしくはご自身でsourcesフォルダを作成して下さい。
2. sourcesフォルダが作成されますので、その中にウォーターマークを入れたい画像を放り込んで下さい。
3. ウォーターマークを入れる君.exeを起動して下さい。黒い窓が立ち上がります。枚数によりますがそれなりに時間がかかるかもしれません。
4. destフォルダが作成されます。その中に透かしと透かし文字を入れた画像が新規作成されます。

## config.iniの設定方法
透かし文字の色だったり、文字サイズだったり変換元のフォルダの場所とかを記述しています。
自由に設定して頂いて結構ですが、一応バックアップを取ってから修正することをオススメ致します。

```ini
[files]
# 変換元の画像を入れるフォルダの名前
sources_dir = sources
# 変換先の画像を入れるフォルダの名前
dest_dir = dest
[texts]
# 透かし文字
text = www.kiwi-bird.xyz
# 透かし文字の色
text_color = gray
# 透かし文字のサイズ
font_size = 48
# 使用するフォント名
fonts = arial.ttf
```

## 注意

- 本プログラムを利用して発生したあらゆる問題に対し、作者は何の責任も負いません。
- 画像は元の画像を直接編集するのではなく、新規作成してから編集しますので元の画像には影響を及ぼしません。
- 透かし文字に日本語を含めないで下さい。文字化けします。
- config.ini中に日本語を含めるとエラー落ちします。
- スクリプトを直接実行する場合、事前にPython3.6.2をインストールした上で、`pip install pillow`をコマンドラインから実行して下さい。
    - 上記処理は.exe形式を利用する場合は必要ありません。
- 本プログラムはGNU General Public License v3.0に基いています。

## 開発者情報

### Author

[Operation KIWI](https://www.kiwi-bird.xyz/)