/*
 * Decompiled with CFR 0.152.
 */
package com.japaricraft.japaricraftmod.mob.ai;

import com.japaricraft.japaricraftmod.handler.JapariItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityAIAttackSweep
extends EntityAIBase {
    World world;
    protected EntityCreature attacker;
    protected int attackTick;
    double speedTowardsTarget;
    boolean longMemory;
    Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    protected final int attackInterval = 20;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;

    public EntityAIAttackSweep(EntityCreature creature, double speedIn, boolean useLongMemory) {
        this.attacker = creature;
        this.world = creature.field_70170_p;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.delayCounter <= 0) {
                this.path = this.attacker.func_70661_as().func_75494_a((Entity)entitylivingbase);
                this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.attacker.func_70661_as().func_75494_a((Entity)entitylivingbase);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(entitylivingbase) >= this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
    }

    public boolean func_75253_b() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        if (!this.longMemory) {
            return !this.attacker.func_70661_as().func_75500_f();
        }
        if (!this.attacker.func_180485_d(new BlockPos((Entity)entitylivingbase))) {
            return false;
        }
        return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).func_175149_v() && !((EntityPlayer)entitylivingbase).func_184812_l_();
    }

    public void func_75249_e() {
        this.attacker.func_70661_as().func_75484_a(this.path, this.speedTowardsTarget);
        this.delayCounter = 0;
    }

    public void func_75251_c() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase instanceof EntityPlayer && (((EntityPlayer)entitylivingbase).func_175149_v() || ((EntityPlayer)entitylivingbase).func_184812_l_())) {
            this.attacker.func_70624_b((EntityLivingBase)null);
        }
        this.attacker.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        this.attacker.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
        double d0 = this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
        --this.delayCounter;
        if ((this.longMemory || this.attacker.func_70635_at().func_75522_a((Entity)entitylivingbase)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || entitylivingbase.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.func_70681_au().nextFloat() < 0.05f)) {
            this.targetX = entitylivingbase.field_70165_t;
            this.targetY = entitylivingbase.func_174813_aQ().field_72338_b;
            this.targetZ = entitylivingbase.field_70161_v;
            this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
            if (this.canPenalize) {
                PathPoint finalPathPoint;
                this.delayCounter += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.attacker.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.attacker.func_70661_as().func_75505_d().func_75870_c()) != null && entitylivingbase.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (d0 > 1024.0) {
                this.delayCounter += 10;
            } else if (d0 > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.attacker.func_70661_as().func_75497_a((Entity)entitylivingbase, this.speedTowardsTarget)) {
                this.delayCounter += 15;
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        this.checkAndPerformAttack(entitylivingbase, d0);
    }

    protected void checkAndPerformAttack(EntityLivingBase p_190102_1_, double p_190102_2_) {
        double d0 = this.getAttackReachSqr(p_190102_1_);
        if (p_190102_2_ <= d0 && this.attackTick <= 0) {
            float f3 = 0.6f * (float)this.attacker.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            for (EntityMob entitymob : this.world.func_72872_a(EntityMob.class, this.attacker.func_70638_az().func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                if (this.attacker.func_184614_ca() == new ItemStack(JapariItems.itemIronGlove)) {
                    if (entitymob == this.attacker || entitymob == this.attacker.func_70638_az() || entitymob.func_184191_r((Entity)entitymob) || !(entitymob.func_70068_e((Entity)entitymob) < 9.0)) continue;
                    entitymob.func_70653_a((Entity)this.attacker, 0.5f, (double)MathHelper.func_76126_a((float)(this.attacker.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.attacker.field_70177_z * ((float)Math.PI / 180)))));
                    entitymob.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.attacker), Float.valueOf(f3).floatValue());
                    continue;
                }
                if (entitymob == this.attacker || entitymob == this.attacker.func_70638_az() || entitymob.func_184191_r((Entity)entitymob) || !(entitymob.func_70068_e((Entity)entitymob) < 9.0)) continue;
                entitymob.func_70653_a((Entity)this.attacker, 0.4f, (double)MathHelper.func_76126_a((float)(this.attacker.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.attacker.field_70177_z * ((float)Math.PI / 180)))));
                entitymob.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.attacker), Float.valueOf(f3).floatValue());
            }
            this.world.func_184148_a((EntityPlayer)null, this.attacker.field_70165_t, this.attacker.field_70163_u, this.attacker.field_70161_v, SoundEvents.field_187730_dW, this.attacker.func_184176_by(), 1.0f, 1.0f);
            this.spawnSweepParticles();
            this.attackTick = 20;
            this.attacker.func_184609_a(EnumHand.MAIN_HAND);
            this.attacker.func_70652_k((Entity)p_190102_1_);
        }
    }

    public void spawnSweepParticles() {
        double d0 = -MathHelper.func_76126_a((float)(this.attacker.field_70177_z * ((float)Math.PI / 180)));
        double d1 = MathHelper.func_76134_b((float)(this.attacker.field_70177_z * ((float)Math.PI / 180)));
        if (this.world instanceof WorldServer) {
            ((WorldServer)this.world).func_175739_a(EnumParticleTypes.SWEEP_ATTACK, this.attacker.field_70165_t + d0, this.attacker.field_70163_u + (double)this.attacker.field_70131_O * 0.5, this.attacker.field_70161_v + d1, 0, d0, 0.0, d1, 0.0, new int[0]);
        }
    }

    protected double getAttackReachSqr(EntityLivingBase attackTarget) {
        return this.attacker.field_70130_N * 2.5f * this.attacker.field_70130_N * 2.5f + attackTarget.field_70130_N;
    }
}

