/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclApproximation;
import jp.go.ipa.jgcl.JgclApproximation3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector3D;

class JgclApproximationSurface3D {
    protected static boolean debug;
    private boolean uIsClosed;
    private boolean vIsClosed;
    private int uNPoints;
    private int vNPoints;
    private JgclPoint3D[][] points;
    private double[] uParams;
    private double[] vParams;
    private static final int degree = 3;
    private static final int MARGIN = 4;
    private static final boolean CHECK_EVERY_POLYGONS_STEADILY = false;
    private static final int MYDEF_NMAX = 5;

    JgclApproximationSurface3D(JgclPoint3D[][] points, double[] uParams, double[] vParams, boolean uIsClosed, boolean vIsClosed) {
        this.uIsClosed = uIsClosed;
        this.vIsClosed = vIsClosed;
        this.uNPoints = points.length;
        this.vNPoints = points[0].length;
        this.points = points;
        this.uParams = uParams;
        this.vParams = vParams;
    }

    private void compRes(JgclBsplineSurface3D bss, double[][] res) {
        int i = 0;
        while (i < this.uNPoints) {
            int j = 0;
            while (j < this.vNPoints) {
                JgclPoint3D bpnt = bss.coordinates(this.uParams[i], this.vParams[j]);
                res[i][j] = this.points[i][j].distance(bpnt);
                ++j;
            }
            ++i;
        }
    }

    JgclBsplineSurface3D getApproximationWithKnots(int u_nseg, int v_nseg, double[] u_knots, double[] v_knots) {
        JgclApproximation3D aprx;
        JgclBsplineCurve3D[] v_bscs = new JgclBsplineCurve3D[this.uNPoints];
        int i = 0;
        while (i < this.uNPoints) {
            if (v_nseg > 0) {
                aprx = new JgclApproximation3D(this.points[i], this.vParams, null, this.vIsClosed);
                v_bscs[i] = aprx.getApproximationWithKnots(v_nseg, v_knots);
            } else {
                v_bscs[i] = new JgclBsplineCurve3D(this.points[i], this.vParams, null, this.vIsClosed);
            }
            ++i;
        }
        int v_uicp = v_bscs[0].nControlPoints();
        JgclBsplineCurve3D[] u_bscs = new JgclBsplineCurve3D[v_uicp];
        JgclPoint3D[] aux_pnts = new JgclPoint3D[this.uNPoints];
        int j = 0;
        while (j < v_uicp) {
            i = 0;
            while (i < this.uNPoints) {
                aux_pnts[i] = v_bscs[i].controlPointAt(j);
                ++i;
            }
            if (u_nseg > 0) {
                aprx = new JgclApproximation3D(aux_pnts, this.uParams, null, this.uIsClosed);
                u_bscs[j] = aprx.getApproximationWithKnots(u_nseg, u_knots);
            } else {
                u_bscs[j] = new JgclBsplineCurve3D(aux_pnts, this.uParams, null, this.uIsClosed);
            }
            ++j;
        }
        int u_uicp = u_bscs[0].nControlPoints();
        JgclPoint3D[][] controlPoints = new JgclPoint3D[u_uicp][v_uicp];
        i = 0;
        while (i < u_uicp) {
            j = 0;
            while (j < v_uicp) {
                controlPoints[i][j] = u_bscs[j].controlPointAt(i);
                ++j;
            }
            ++i;
        }
        return new JgclBsplineSurface3D(u_bscs[0].knotData(), v_bscs[0].knotData(), controlPoints, null);
    }

    private static int checkSegmentNumberRange(int nseg, int nPoints, boolean isClosed, int degree) {
        int min_nseg = JgclApproximation.minSegmentNumber(isClosed, degree);
        if (nseg < min_nseg) {
            nseg = min_nseg;
        }
        if (nseg > JgclApproximation.maxSegmentNumber(nPoints, isClosed, degree)) {
            nseg = -1;
        }
        return nseg;
    }

    private int[] initSegmentNumber(JgclToleranceForDistance tol) {
        int nseg;
        JgclBsplineCurve3D bsc;
        int idx;
        SumOfZigZag sum;
        JgclToleranceForDistance mid_tol = new JgclToleranceForDistance(tol.value() * 100.0);
        JgclPoint3D[] cpoints = new JgclPoint3D[this.uNPoints];
        SumOfZigZagInfo[] max_sz = new SumOfZigZagInfo[5];
        ChngSignInfo[] max_cs = new ChngSignInfo[5];
        int j = 0;
        while (j < 5) {
            max_sz[j] = new SumOfZigZagInfo(-1.0, -1);
            max_cs[j] = new ChngSignInfo(-1, -1);
            ++j;
        }
        int i = 0;
        while (i < this.vNPoints) {
            j = 0;
            while (j < this.uNPoints) {
                cpoints[j] = this.points[j][i];
                ++j;
            }
            sum = new SumOfZigZag(cpoints);
            if (max_sz[0].val < sum.abs_val) {
                max_sz[0].val = sum.abs_val;
                max_sz[0].idx = i;
                max_sz[0].sort(max_sz);
            }
            if (max_cs[0].val < sum.chg_sgn) {
                max_cs[0].val = sum.chg_sgn;
                max_cs[0].idx = i;
                max_cs[0].sort(max_cs);
            }
            ++i;
        }
        int u_nseg = 0;
        i = 0;
        while (i < 10) {
            block24: {
                block23: {
                    block22: {
                        if (i >= 5) break block22;
                        idx = max_sz[i].idx;
                        if (idx >= 0) break block23;
                        break block24;
                    }
                    idx = max_cs[i - 5].idx;
                    if (idx < 0) break block24;
                    j = 0;
                    while (j < 5) {
                        if (idx == max_sz[j].idx) break;
                        ++j;
                    }
                    if (j < 5) break block24;
                }
                j = 0;
                while (j < this.uNPoints) {
                    cpoints[j] = this.points[j][idx];
                    ++j;
                }
                bsc = new JgclBsplineCurve3D(cpoints, this.uParams, null, this.uIsClosed, tol, mid_tol);
                nseg = bsc.nSegments();
                if (u_nseg < nseg) {
                    u_nseg = nseg;
                }
            }
            ++i;
        }
        u_nseg = JgclApproximationSurface3D.checkSegmentNumberRange(u_nseg, this.uNPoints, this.uIsClosed, 3);
        j = 0;
        while (j < 5) {
            max_sz[j].val = -1.0;
            max_sz[j].idx = -1;
            max_cs[j].val = -1;
            max_cs[j].idx = -1;
            ++j;
        }
        i = 0;
        while (i < this.uNPoints) {
            sum = new SumOfZigZag(this.points[i]);
            if (max_sz[0].val < sum.abs_val) {
                max_sz[0].val = sum.abs_val;
                max_sz[0].idx = i;
                max_sz[0].sort(max_sz);
            }
            if (max_cs[0].val < sum.chg_sgn) {
                max_cs[0].val = sum.chg_sgn;
                max_cs[0].idx = i;
                max_cs[0].sort(max_cs);
            }
            ++i;
        }
        int v_nseg = 0;
        i = 0;
        while (i < 10) {
            block27: {
                block26: {
                    block25: {
                        if (i >= 5) break block25;
                        idx = max_sz[i].idx;
                        if (idx >= 0) break block26;
                        break block27;
                    }
                    idx = max_cs[i - 5].idx;
                    if (idx < 0) break block27;
                    j = 0;
                    while (j < 5) {
                        if (idx == max_sz[j].idx) break;
                        ++j;
                    }
                    if (j < 5) break block27;
                }
                if (v_nseg < (nseg = (bsc = new JgclBsplineCurve3D(this.points[idx], this.vParams, null, this.vIsClosed, tol, mid_tol)).nSegments())) {
                    v_nseg = nseg;
                }
            }
            ++i;
        }
        v_nseg = JgclApproximationSurface3D.checkSegmentNumberRange(v_nseg, this.vNPoints, this.vIsClosed, 3);
        return new int[]{u_nseg, v_nseg};
    }

    private static int incr_nseg(int nseg, int n_ng, boolean closed, int npnt) {
        if (nseg < 0) {
            return -1;
        }
        int new_nseg = nseg + n_ng;
        int max_nseg = JgclApproximation.maxSegmentNumber(npnt, closed, 3);
        if (new_nseg >= max_nseg) {
            return -1;
        }
        return new_nseg;
    }

    private static void compKnots(double sp, double ep, int nseg, int nPoints, double[] k) {
        if (nseg < 0) {
            return;
        }
        double intvl = (ep - sp) / (double)nseg;
        k[0] = sp;
        int i = 1;
        while (i < nseg) {
            k[i] = k[i - 1] + intvl;
            ++i;
        }
        k[nseg] = ep;
    }

    private static void comp_new_knots(double[] knots, int nseg, boolean[] ng_segs, int nPoints, double[] new_knots) {
        new_knots[0] = knots[0];
        int i = 0;
        int j = 1;
        while (i < nseg) {
            if (ng_segs[i]) {
                new_knots[j++] = knots[i + 1];
            } else {
                new_knots[j++] = (knots[i] + knots[i + 1]) / 2.0;
                new_knots[j++] = knots[i + 1];
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean converged(int u_nseg, int v_nseg, double[] u_knots, double[] v_knots, double[][] res, double tol, int[] n_ng, boolean[] u_ng_segs, boolean[] v_ng_segs) {
        block11: {
            block10: {
                n_ng[0] = 0;
                if (u_nseg <= 0) break block10;
                k = 0;
                while (k < u_nseg) {
                    u_ng_segs[k] = true;
                    ++k;
                }
                k = 0;
                i = 0;
                ** GOTO lbl22
                {
                    ++k;
                    do {
                        if (!(this.uParams[i] < u_knots[k + 1]) && k < u_nseg - 1) continue block1;
                        j = 0;
                        while (j < this.vNPoints) {
                            if (res[i][j] > tol && u_ng_segs[k]) {
                                u_ng_segs[k] = false;
                                n_ng[0] = n_ng[0] + 1;
                            }
                            ++j;
                        }
                        ++i;
lbl22:
                        // 2 sources

                    } while (i < this.uNPoints);
                }
            }
            n_ng[1] = 0;
            if (v_nseg <= 0) break block11;
            k = 0;
            while (k < v_nseg) {
                v_ng_segs[k] = true;
                ++k;
            }
            k = 0;
            j = 0;
            ** GOTO lbl45
            {
                ++k;
                do {
                    if (!(this.vParams[j] < v_knots[k + 1]) && k < v_nseg - 1) continue block5;
                    i = 0;
                    while (i < this.uNPoints) {
                        if (res[i][j] > tol && v_ng_segs[k]) {
                            v_ng_segs[k] = false;
                            n_ng[1] = n_ng[1] + 1;
                        }
                        ++i;
                    }
                    ++j;
lbl45:
                    // 2 sources

                } while (j < this.vNPoints);
            }
        }
        return n_ng[0] == 0 && n_ng[1] == 0;
    }

    private JgclBsplineSurface3D getInterpolated() {
        return new JgclBsplineSurface3D(this.points, this.uParams, this.vParams, this.uIsClosed, this.vIsClosed);
    }

    JgclBsplineSurface3D getApproximationWithTolerance(JgclToleranceForDistance tol) {
        int v_new_nseg;
        int u_new_nseg;
        double[] u_cnt_knots = new double[this.uNPoints + 4];
        double[] u_new_knots = new double[this.uNPoints + 4];
        double[] v_cnt_knots = new double[this.vNPoints + 4];
        double[] v_new_knots = new double[this.vNPoints + 4];
        double[][] res = new double[this.uNPoints][this.vNPoints];
        int[] n_ng = new int[2];
        boolean[] u_ng_segs = new boolean[this.uNPoints + 4];
        boolean[] v_ng_segs = new boolean[this.vNPoints + 4];
        int[] nsegs = this.initSegmentNumber(tol);
        if (nsegs[0] < 0 && nsegs[1] < 0) {
            return this.getInterpolated();
        }
        double ep = !this.uIsClosed ? this.uParams[this.uNPoints - 1] : this.uParams[this.uNPoints];
        JgclApproximationSurface3D.compKnots(this.uParams[0], ep, nsegs[0], this.uNPoints, u_cnt_knots);
        ep = !this.vIsClosed ? this.vParams[this.vNPoints - 1] : this.vParams[this.vNPoints];
        JgclApproximationSurface3D.compKnots(this.vParams[0], ep, nsegs[1], this.vNPoints, v_cnt_knots);
        do {
            double[] tmp_p;
            JgclBsplineSurface3D bss = this.getApproximationWithKnots(nsegs[0], nsegs[1], u_cnt_knots, v_cnt_knots);
            if (debug) {
                bss.output(System.out);
            }
            this.compRes(bss, res);
            if (this.converged(nsegs[0], nsegs[1], u_cnt_knots, v_cnt_knots, res, tol.value(), n_ng, u_ng_segs, v_ng_segs)) {
                return bss;
            }
            u_new_nseg = JgclApproximationSurface3D.incr_nseg(nsegs[0], n_ng[0], this.uIsClosed, this.uNPoints);
            if (u_new_nseg > 0) {
                JgclApproximationSurface3D.comp_new_knots(u_cnt_knots, nsegs[0], u_ng_segs, this.uNPoints, u_new_knots);
                nsegs[0] = u_new_nseg;
                tmp_p = u_cnt_knots;
                u_cnt_knots = u_new_knots;
                u_new_knots = tmp_p;
            }
            if ((v_new_nseg = JgclApproximationSurface3D.incr_nseg(nsegs[1], n_ng[1], this.vIsClosed, this.vNPoints)) <= 0) continue;
            JgclApproximationSurface3D.comp_new_knots(v_cnt_knots, nsegs[1], v_ng_segs, this.vNPoints, v_new_knots);
            nsegs[1] = v_new_nseg;
            tmp_p = v_cnt_knots;
            v_cnt_knots = v_new_knots;
            v_new_knots = tmp_p;
        } while (u_new_nseg >= 0 || v_new_nseg >= 0);
        return this.getInterpolated();
    }

    public static void main(String[] argv) {
        JgclToleranceForDistance tol = new JgclToleranceForDistance(0.1);
        System.out.println("Main: [creating JgclApproximationSurface3D.]");
        JgclCartesianPoint3D p00 = new JgclCartesianPoint3D(0.0, 0.0, 0.0);
        JgclCartesianPoint3D p01 = new JgclCartesianPoint3D(0.4, 0.6, 0.0);
        JgclCartesianPoint3D p02 = new JgclCartesianPoint3D(1.0, 1.0, 0.0);
        JgclCartesianPoint3D p03 = new JgclCartesianPoint3D(1.6, 0.6, 0.0);
        JgclCartesianPoint3D p04 = new JgclCartesianPoint3D(2.0, 0.0, 0.0);
        JgclCartesianPoint3D p05 = new JgclCartesianPoint3D(1.6, -0.6, 0.0);
        JgclCartesianPoint3D p06 = new JgclCartesianPoint3D(1.0, -1.0, 0.0);
        JgclCartesianPoint3D p07 = new JgclCartesianPoint3D(0.4, -0.6, 0.0);
        JgclCartesianPoint3D p10 = new JgclCartesianPoint3D(0.0, 0.0, 1.0);
        JgclCartesianPoint3D p11 = new JgclCartesianPoint3D(0.4, 0.6, 1.0);
        JgclCartesianPoint3D p12 = new JgclCartesianPoint3D(1.0, 1.0, 1.0);
        JgclCartesianPoint3D p13 = new JgclCartesianPoint3D(1.6, 0.6, 1.0);
        JgclCartesianPoint3D p14 = new JgclCartesianPoint3D(2.0, 0.0, 1.0);
        JgclCartesianPoint3D p15 = new JgclCartesianPoint3D(1.6, -0.6, 1.0);
        JgclCartesianPoint3D p16 = new JgclCartesianPoint3D(1.0, -1.0, 1.0);
        JgclCartesianPoint3D p17 = new JgclCartesianPoint3D(0.4, -0.6, 1.0);
        JgclCartesianPoint3D p20 = new JgclCartesianPoint3D(0.0, 0.0, 2.0);
        JgclCartesianPoint3D p21 = new JgclCartesianPoint3D(0.4, 0.6, 2.0);
        JgclCartesianPoint3D p22 = new JgclCartesianPoint3D(1.0, 1.0, 2.0);
        JgclCartesianPoint3D p23 = new JgclCartesianPoint3D(1.6, 0.6, 2.0);
        JgclCartesianPoint3D p24 = new JgclCartesianPoint3D(2.0, 0.0, 2.0);
        JgclCartesianPoint3D p25 = new JgclCartesianPoint3D(1.6, -0.6, 2.0);
        JgclCartesianPoint3D p26 = new JgclCartesianPoint3D(1.0, -1.0, 2.0);
        JgclCartesianPoint3D p27 = new JgclCartesianPoint3D(0.4, -0.6, 2.0);
        JgclCartesianPoint3D p30 = new JgclCartesianPoint3D(0.0, 0.0, 3.0);
        JgclCartesianPoint3D p31 = new JgclCartesianPoint3D(0.4, 0.6, 3.0);
        JgclCartesianPoint3D p32 = new JgclCartesianPoint3D(1.0, 1.0, 3.0);
        JgclCartesianPoint3D p33 = new JgclCartesianPoint3D(1.6, 0.6, 3.0);
        JgclCartesianPoint3D p34 = new JgclCartesianPoint3D(2.0, 0.0, 3.0);
        JgclCartesianPoint3D p35 = new JgclCartesianPoint3D(1.6, -0.6, 3.0);
        JgclCartesianPoint3D p36 = new JgclCartesianPoint3D(1.0, -1.0, 3.0);
        JgclCartesianPoint3D p37 = new JgclCartesianPoint3D(0.4, -0.6, 3.0);
        JgclPoint3D[][] pntsClosed = new JgclCartesianPoint3D[][]{{p00, p01, p02, p03, p04, p05, p06, p07}, {p10, p11, p12, p13, p14, p15, p16, p17}, {p20, p21, p22, p23, p24, p25, p26, p27}, {p30, p31, p32, p33, p34, p35, p36, p37}};
        double[] dArray = new double[4];
        dArray[1] = 1.0;
        dArray[2] = 2.0;
        dArray[3] = 3.0;
        double[] uPrmsClosed = dArray;
        double[] dArray2 = new double[9];
        dArray2[1] = 0.125;
        dArray2[2] = 0.25;
        dArray2[3] = 0.375;
        dArray2[4] = 0.5;
        dArray2[5] = 0.625;
        dArray2[6] = 0.75;
        dArray2[7] = 0.875;
        dArray2[8] = 1.0;
        double[] vPrmsClosed = dArray2;
        JgclApproximationSurface3D aprxClosed = new JgclApproximationSurface3D(pntsClosed, uPrmsClosed, vPrmsClosed, false, true);
        System.out.println("Main: [creating JgclBsplineSurface3D.]");
        JgclBsplineSurface3D bsplineClosed = aprxClosed.getApproximationWithTolerance(tol);
        System.out.println("\nMain: [JgclApproximationSurface3D Closed Test]");
        bsplineClosed.output(System.out);
        JgclCartesianPoint3D p002 = new JgclCartesianPoint3D(0.0, 0.0, 0.0);
        JgclCartesianPoint3D p012 = new JgclCartesianPoint3D(0.4, 0.2, 0.0);
        JgclCartesianPoint3D p022 = new JgclCartesianPoint3D(1.0, 0.3, 0.0);
        JgclCartesianPoint3D p032 = new JgclCartesianPoint3D(1.6, 0.25, 0.0);
        JgclCartesianPoint3D p042 = new JgclCartesianPoint3D(2.0, 0.2, 0.0);
        JgclCartesianPoint3D p052 = new JgclCartesianPoint3D(2.4, 0.25, 0.0);
        JgclCartesianPoint3D p062 = new JgclCartesianPoint3D(3.0, 0.3, 0.0);
        JgclCartesianPoint3D p072 = new JgclCartesianPoint3D(3.6, 0.25, 0.0);
        JgclCartesianPoint3D p08 = new JgclCartesianPoint3D(4.0, 0.2, 0.0);
        JgclCartesianPoint3D p102 = new JgclCartesianPoint3D(0.0, 0.0, 1.0);
        JgclCartesianPoint3D p112 = new JgclCartesianPoint3D(0.4, 0.2, 1.0);
        JgclCartesianPoint3D p122 = new JgclCartesianPoint3D(1.0, 0.3, 1.0);
        JgclCartesianPoint3D p132 = new JgclCartesianPoint3D(1.6, 0.25, 1.0);
        JgclCartesianPoint3D p142 = new JgclCartesianPoint3D(2.0, 0.2, 1.0);
        JgclCartesianPoint3D p152 = new JgclCartesianPoint3D(2.4, 0.25, 1.0);
        JgclCartesianPoint3D p162 = new JgclCartesianPoint3D(3.0, 0.3, 1.0);
        JgclCartesianPoint3D p172 = new JgclCartesianPoint3D(3.6, 0.25, 1.0);
        JgclCartesianPoint3D p18 = new JgclCartesianPoint3D(4.0, 0.2, 1.0);
        JgclCartesianPoint3D p202 = new JgclCartesianPoint3D(0.0, 0.0, 2.0);
        JgclCartesianPoint3D p212 = new JgclCartesianPoint3D(0.4, 0.2, 2.0);
        JgclCartesianPoint3D p222 = new JgclCartesianPoint3D(1.0, 0.3, 2.0);
        JgclCartesianPoint3D p232 = new JgclCartesianPoint3D(1.6, 0.25, 2.0);
        JgclCartesianPoint3D p242 = new JgclCartesianPoint3D(2.0, 0.2, 2.0);
        JgclCartesianPoint3D p252 = new JgclCartesianPoint3D(2.4, 0.25, 2.0);
        JgclCartesianPoint3D p262 = new JgclCartesianPoint3D(3.0, 0.3, 2.0);
        JgclCartesianPoint3D p272 = new JgclCartesianPoint3D(3.6, 0.25, 2.0);
        JgclCartesianPoint3D p28 = new JgclCartesianPoint3D(4.0, 0.2, 2.0);
        JgclCartesianPoint3D p302 = new JgclCartesianPoint3D(0.0, 0.0, 3.0);
        JgclCartesianPoint3D p312 = new JgclCartesianPoint3D(0.4, 0.2, 3.0);
        JgclCartesianPoint3D p322 = new JgclCartesianPoint3D(1.0, 0.3, 3.0);
        JgclCartesianPoint3D p332 = new JgclCartesianPoint3D(1.6, 0.25, 3.0);
        JgclCartesianPoint3D p342 = new JgclCartesianPoint3D(2.0, 0.2, 3.0);
        JgclCartesianPoint3D p352 = new JgclCartesianPoint3D(2.4, 0.25, 3.0);
        JgclCartesianPoint3D p362 = new JgclCartesianPoint3D(3.0, 0.3, 3.0);
        JgclCartesianPoint3D p372 = new JgclCartesianPoint3D(3.6, 0.25, 3.0);
        JgclCartesianPoint3D p38 = new JgclCartesianPoint3D(4.0, 0.2, 3.0);
        JgclCartesianPoint3D p40 = new JgclCartesianPoint3D(0.0, 0.0, 4.0);
        JgclCartesianPoint3D p41 = new JgclCartesianPoint3D(0.4, 0.2, 4.0);
        JgclCartesianPoint3D p42 = new JgclCartesianPoint3D(1.0, 0.3, 4.0);
        JgclCartesianPoint3D p43 = new JgclCartesianPoint3D(1.6, 0.25, 4.0);
        JgclCartesianPoint3D p44 = new JgclCartesianPoint3D(2.0, 0.2, 4.0);
        JgclCartesianPoint3D p45 = new JgclCartesianPoint3D(2.4, 0.25, 4.0);
        JgclCartesianPoint3D p46 = new JgclCartesianPoint3D(3.0, 0.3, 4.0);
        JgclCartesianPoint3D p47 = new JgclCartesianPoint3D(3.6, 0.25, 4.0);
        JgclCartesianPoint3D p48 = new JgclCartesianPoint3D(4.0, 0.2, 4.0);
        JgclPoint3D[][] pntsOpen = new JgclCartesianPoint3D[][]{{p002, p012, p022, p032, p042, p052, p062, p072, p08}, {p102, p112, p122, p132, p142, p152, p162, p172, p18}, {p202, p212, p222, p232, p242, p252, p262, p272, p28}, {p302, p312, p322, p332, p342, p352, p362, p372, p38}, {p40, p41, p42, p43, p44, p45, p46, p47, p48}};
        double[] dArray3 = new double[5];
        dArray3[1] = 1.0;
        dArray3[2] = 2.0;
        dArray3[3] = 3.0;
        dArray3[4] = 4.0;
        double[] uPrmsOpen = dArray3;
        double[] dArray4 = new double[9];
        dArray4[1] = 0.125;
        dArray4[2] = 0.25;
        dArray4[3] = 0.375;
        dArray4[4] = 0.5;
        dArray4[5] = 0.625;
        dArray4[6] = 0.75;
        dArray4[7] = 0.875;
        dArray4[8] = 1.0;
        double[] vPrmsOpen = dArray4;
        JgclApproximationSurface3D aprxOpen = new JgclApproximationSurface3D(pntsOpen, uPrmsOpen, vPrmsOpen, false, false);
        System.out.println("\n\nMain: [creating Open JgclBsplineSurface3D.]");
        JgclBsplineSurface3D bsplineOpen = aprxOpen.getApproximationWithTolerance(tol);
        System.out.println("\nMain: [JgclApproximationSurface3D Open Test]");
        bsplineOpen.output(System.out);
    }

    private class SumOfZigZag {
        double abs_val;
        int chg_sgn;

        private SumOfZigZag(JgclPoint3D[] pnts) {
            JgclApproximationSurface3D.this = JgclApproximationSurface3D.this;
            double sum_zz = 0.0;
            int n_chng = 0;
            JgclVector3D bvec = pnts[1].subtract(pnts[0]);
            JgclVector3D pcrs = null;
            JgclVector3D ccrs = null;
            int n_interval = pnts.length - 1;
            int i = 1;
            while (i < n_interval) {
                JgclVector3D tvec = pnts[i + 1].subtract(pnts[i]);
                if ((bvec = bvec.unitized()) != JgclVector3D.zeroVector) {
                    ccrs = bvec.crossProduct(tvec);
                    sum_zz += ccrs.length();
                    if (i > 1 && pcrs.dotProduct(ccrs) < 0.0) {
                        ++n_chng;
                    }
                }
                JgclVector3D svec = bvec;
                bvec = tvec;
                tvec = svec;
                svec = pcrs;
                pcrs = ccrs;
                ccrs = svec;
                ++i;
            }
            this.abs_val = sum_zz;
            this.chg_sgn = n_chng;
        }
    }

    private class SumOfZigZagInfo {
        double val;
        int idx;

        private SumOfZigZagInfo(double val, int idx) {
            JgclApproximationSurface3D.this = JgclApproximationSurface3D.this;
            this.val = val;
            this.idx = idx;
        }

        private void sort(SumOfZigZagInfo[] data) {
            int nData = data.length;
            int j = 0;
            while (j < nData) {
                int i = nData - 1;
                while (i > j) {
                    if (data[i - 1].val > data[i].val) {
                        SumOfZigZagInfo tmp = data[i - 1];
                        data[i - 1] = data[i];
                        data[i] = tmp;
                    }
                    --i;
                }
                ++j;
            }
        }
    }

    private class ChngSignInfo {
        int val;
        int idx;

        private ChngSignInfo(int val, int idx) {
            JgclApproximationSurface3D.this = JgclApproximationSurface3D.this;
            this.val = val;
            this.idx = idx;
        }

        private void sort(ChngSignInfo[] data) {
            int nData = data.length;
            int j = 0;
            while (j < nData) {
                int i = nData - 1;
                while (i > j) {
                    if (data[i - 1].val > data[i].val) {
                        ChngSignInfo tmp = data[i - 1];
                        data[i - 1] = data[i];
                        data[i] = tmp;
                    }
                    --i;
                }
                ++j;
            }
        }
    }
}

