/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBoundedCurve2D;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCommonNormal2D;
import jp.go.ipa.jgcl.JgclCommonTangent2D;
import jp.go.ipa.jgcl.JgclCompositeCurve2D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment2D;
import jp.go.ipa.jgcl.JgclCurveCurvature2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference2D;
import jp.go.ipa.jgcl.JgclCurveDerivative2D;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclEnclosingBox2D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclFilletObject2D;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclOverlapCurve2D;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;

public class JgclBoundedLine2D
extends JgclBoundedCurve2D {
    private JgclPoint2D spnt;
    private JgclPoint2D epnt;

    private void setPoints(JgclPoint2D spnt, JgclPoint2D epnt, boolean doCheck) {
        if (doCheck && spnt.identical(epnt)) {
            throw new JgclInvalidArgumentValue();
        }
        this.spnt = spnt;
        this.epnt = epnt;
    }

    public JgclBoundedLine2D(JgclPoint2D spnt, JgclPoint2D epnt) {
        this.setPoints(spnt, epnt, true);
    }

    JgclBoundedLine2D(JgclPoint2D spnt, JgclPoint2D epnt, boolean doCheck) {
        this.setPoints(spnt, epnt, doCheck);
    }

    public JgclBoundedLine2D(JgclPoint2D spnt, JgclVector2D dir) {
        this.setPoints(spnt, spnt.add(dir), true);
    }

    JgclBoundedLine2D(JgclPoint2D spnt, JgclVector2D dir, boolean doCheck) {
        this.setPoints(spnt, spnt.add(dir), doCheck);
    }

    public JgclPoint2D spnt() {
        return this.spnt;
    }

    public JgclPoint2D epnt() {
        return this.epnt;
    }

    public double length(JgclParameterSection pint) {
        this.checkParameter(pint.start());
        this.checkParameter(pint.end());
        return this.length() * Math.abs(pint.increase());
    }

    public double length() {
        return this.spnt().distance(this.epnt());
    }

    public JgclPoint2D coordinates(double param) {
        param = this.checkParameter(param);
        return this.epnt().linearInterpolate(this.spnt(), param);
    }

    public JgclVector2D tangentVector(double param) {
        param = this.checkParameter(param);
        return this.epnt().subtract(this.spnt());
    }

    public JgclCurveCurvature2D curvature(double param) {
        param = this.checkParameter(param);
        return new JgclCurveCurvature2D(0.0, JgclVector2D.zeroVector);
    }

    public JgclCurveDerivative2D evaluation(double param) {
        param = this.checkParameter(param);
        return new JgclCurveDerivative2D(this.coordinates(param), this.tangentVector(param), JgclVector2D.zeroVector);
    }

    public JgclPointOnCurve2D[] singular() {
        return new JgclPointOnCurve2D[0];
    }

    public JgclPointOnCurve2D[] inflexion() {
        return new JgclPointOnCurve2D[0];
    }

    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point) {
        JgclPointOnCurve2D poc = this.project1From(point);
        if (poc == null) {
            return new JgclPointOnCurve2D[0];
        }
        JgclPointOnCurve2D[] prjp = new JgclPointOnCurve2D[]{poc};
        return prjp;
    }

    public JgclPointOnCurve2D project1From(JgclPoint2D point) {
        JgclPointOnCurve2D poc = this.toLine().project1From(point);
        double param = poc.parameter();
        Object result = null;
        if (!this.isValid(param)) {
            return null;
        }
        return new JgclPointOnCurve2D(this, param, false);
    }

    public JgclPolyline2D toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol) {
        JgclPoint2D[] points = new JgclPoint2D[]{new JgclPointOnCurve2D(this, pint.start(), false), new JgclPointOnCurve2D(this, pint.end(), false)};
        return new JgclPolyline2D(points);
    }

    JgclPolyline2D toPolyline() {
        JgclPoint2D[] points = new JgclPoint2D[]{this.spnt, this.epnt};
        return new JgclPolyline2D(points);
    }

    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
        return this.toLine().toBsplineCurve(pint);
    }

    public JgclLine2D toLine() {
        return new JgclLine2D(this.spnt(), this.epnt());
    }

    public JgclVector2D unitizedDirection() {
        return this.tangentVector(0.0).unitized();
    }

    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    private int haveIntsWithLine(JgclLine2D lin, JgclVector2D ludir) {
        double[] dists = new double[2];
        double d_tol = this.getToleranceForDistance();
        JgclVector2D dir = this.spnt.subtract(lin.pnt());
        dists[0] = dir.zOfCrossProduct(ludir);
        dir = this.epnt.subtract(lin.pnt());
        dists[1] = dir.zOfCrossProduct(ludir);
        if (Math.abs(dists[0]) < d_tol && Math.abs(dists[1]) < d_tol) {
            return -1;
        }
        if (Math.abs(dists[0] - dists[1]) < d_tol) {
            return 0;
        }
        return 1;
    }

    private void isThisInBase(JgclBoundedLine2D bas, JgclVector2D BUdir, double BLeng, int[] is_in, double[] param) {
        double d_tol = this.getToleranceForDistance();
        int i = 0;
        while (i < 2) {
            JgclVector2D dir = i == 0 ? this.spnt().subtract(bas.spnt()) : this.epnt().subtract(bas.spnt());
            param[i] = BUdir.dotProduct(dir);
            if (param[i] < 0.0 - d_tol || param[i] > BLeng + d_tol) {
                is_in[i] = 0;
            } else {
                is_in[i] = 1;
                if (param[i] < 0.0 + d_tol) {
                    param[i] = 0.0;
                }
                if (param[i] > BLeng - d_tol) {
                    param[i] = BLeng;
                }
                int n = i;
                param[n] = param[n] / BLeng;
            }
            ++i;
        }
    }

    private JgclIntersectionPoint2D toIntersectionPoint(JgclBoundedCurve2D mate, double Aparam, double Bparam) {
        JgclPoint2D crd1 = this.coordinates(Aparam);
        JgclPoint2D crd2 = mate.coordinates(Bparam);
        JgclPointOnCurve2D poc1 = new JgclPointOnCurve2D(crd1, this, Aparam, false);
        JgclPointOnCurve2D poc2 = new JgclPointOnCurve2D(crd2, mate, Bparam, false);
        crd1 = crd1.linearInterpolate(crd2, 0.5);
        return new JgclIntersectionPoint2D(crd1, poc1, poc2, false);
    }

    private JgclCurveCurveInterference2D haveCommonSection(boolean needOverlap, JgclBoundedLine2D mate, JgclVector2D AUdir, JgclVector2D BUdir, double Aleng, double Bleng) throws JgclIndefiniteSolution {
        JgclGeometry intf;
        int[] A_inB = new int[2];
        int[] B_inA = new int[2];
        double[] pA_inA = new double[2];
        double[] pA_inB = new double[2];
        double[] pB_inA = new double[2];
        double[] pB_inB = new double[2];
        double[] Ap = new double[2];
        double[] Bp = new double[2];
        this.isThisInBase(mate, BUdir, Bleng, A_inB, pA_inB);
        mate.isThisInBase(this, AUdir, Aleng, B_inA, pB_inA);
        if (A_inB[0] + A_inB[1] + B_inA[0] + B_inA[1] < 2) {
            return null;
        }
        pA_inA[0] = 0.0;
        pA_inA[1] = 1.0;
        pB_inB[0] = 0.0;
        pB_inB[1] = 1.0;
        switch (A_inB[0] + A_inB[1] + B_inA[0] + B_inA[1]) {
            case 2: {
                int i = 0;
                if (A_inB[0] != 0) {
                    Ap[i] = pA_inA[0];
                    Bp[i] = pA_inB[0];
                    ++i;
                }
                if (A_inB[1] != 0) {
                    Ap[i] = pA_inA[1];
                    Bp[i] = pA_inB[1];
                    ++i;
                }
                if (B_inA[0] != 0) {
                    Ap[i] = pB_inA[0];
                    Bp[i] = pB_inB[0];
                    ++i;
                }
                if (B_inA[1] == 0) break;
                Ap[i] = pB_inA[1];
                Bp[i] = pB_inB[1];
                ++i;
                break;
            }
            case 3: {
                if (A_inB[0] != 0 && A_inB[1] != 0) {
                    Ap[0] = pA_inA[0];
                    Bp[0] = pA_inB[0];
                    Ap[1] = pA_inA[1];
                    Bp[1] = pA_inB[1];
                    break;
                }
                Ap[0] = pB_inA[0];
                Bp[0] = pB_inB[0];
                Ap[1] = pB_inA[1];
                Bp[1] = pB_inB[1];
                break;
            }
            case 4: {
                if (Aleng > Bleng) {
                    Ap[0] = pA_inA[0];
                    Bp[0] = pA_inB[0];
                    Ap[1] = pA_inA[1];
                    Bp[1] = pA_inB[1];
                    break;
                }
                Ap[0] = pB_inA[0];
                Bp[0] = pB_inB[0];
                Ap[1] = pB_inA[1];
                Bp[1] = pB_inB[1];
                break;
            }
        }
        double d_tol = this.getToleranceForDistance();
        boolean hasWidth = true;
        boolean throwIndefinite = false;
        if (Math.abs(Ap[0] - Ap[1]) * Aleng < d_tol || Math.abs(Bp[0] - Bp[1]) * Bleng < d_tol) {
            hasWidth = false;
        } else if (!needOverlap) {
            hasWidth = false;
            throwIndefinite = true;
        }
        if (hasWidth) {
            JgclParameterSection sec1 = new JgclParameterSection(Ap[0], Ap[1] - Ap[0]);
            JgclParameterSection sec2 = new JgclParameterSection(Bp[0], Bp[1] - Bp[0]);
            intf = new JgclOverlapCurve2D(this, sec1, mate, sec2, false);
        } else {
            Ap[0] = (Ap[0] + Ap[1]) / 2.0;
            Bp[0] = (Bp[0] + Bp[1]) / 2.0;
            intf = this.toIntersectionPoint(mate, Ap[0], Bp[0]);
            if (throwIndefinite) {
                throw new JgclIndefiniteSolution(intf.toIntersectionPoint());
            }
        }
        return intf;
    }

    private JgclIntersectionPoint2D getIntsWithBln(JgclBoundedLine2D mate, JgclLine2D Alin, JgclLine2D Blin) {
        double Bparam;
        double Aparam;
        JgclVector2D a2b = Blin.pnt().subtract(Alin.pnt());
        double crosz = Alin.dir().zOfCrossProduct(Blin.dir());
        try {
            Aparam = a2b.zOfCrossProduct(Blin.dir()) / crosz;
            Aparam = this.checkParameter(Aparam);
            Bparam = a2b.zOfCrossProduct(Alin.dir()) / crosz;
            Bparam = mate.checkParameter(Bparam);
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            return null;
        }
        return this.toIntersectionPoint(mate, Aparam, Bparam);
    }

    JgclCurveCurveInterference2D interfere1(JgclBoundedLine2D mate, JgclVector2D thisUdir, JgclVector2D mateUdir, double thisLeng, double mateLeng) {
        JgclLine2D Blin = mate.toLine();
        if (this.haveIntsWithLine(Blin, mateUdir) < 0) {
            try {
                return this.haveCommonSection(true, mate, thisUdir, mateUdir, thisLeng, mateLeng);
            }
            catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                throw new JgclFatal();
            }
        }
        JgclLine2D Alin = this.toLine();
        switch (mate.haveIntsWithLine(Alin, thisUdir)) {
            case -1: {
                try {
                    return this.haveCommonSection(true, mate, thisUdir, mateUdir, thisLeng, mateLeng);
                }
                catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                    throw new JgclFatal();
                }
            }
            case 0: {
                return null;
            }
        }
        return this.getIntsWithBln(mate, Alin, Blin);
    }

    public JgclCurveCurveInterference2D interfere1(JgclBoundedLine2D mate) {
        JgclVector2D AUdir = this.unitizedDirection();
        JgclVector2D BUdir = mate.unitizedDirection();
        double Aleng = this.length();
        double Bleng = mate.length();
        return this.interfere1(mate, AUdir, BUdir, Aleng, Bleng);
    }

    JgclCurveCurveInterference2D[] interfere(JgclBoundedLine2D mate, JgclVector2D thisUdir, JgclVector2D mateUdir, double thisLeng, double mateLeng) {
        JgclCurveCurveInterference2D sol = this.interfere1(mate, thisUdir, mateUdir, thisLeng, mateLeng);
        if (sol == null) {
            return new JgclCurveCurveInterference2D[0];
        }
        JgclCurveCurveInterference2D[] intf = new JgclCurveCurveInterference2D[]{sol};
        return intf;
    }

    JgclCurveCurveInterference2D[] interfere(JgclBoundedLine2D mate, boolean doExchange) {
        JgclBoundedLine2D Bbln;
        JgclBoundedLine2D Abln;
        if (!doExchange) {
            Abln = this;
            Bbln = mate;
        } else {
            Abln = mate;
            Bbln = this;
        }
        JgclVector2D AUdir = Abln.unitizedDirection();
        JgclVector2D BUdir = Bbln.unitizedDirection();
        double Aleng = Abln.length();
        double Bleng = Bbln.length();
        return Abln.interfere(Bbln, AUdir, BUdir, Aleng, Bleng);
    }

    private JgclCurveCurveInterference2D[] convertInterferences(JgclCurveCurveInterference2D[] sourceInterferences, boolean doExchange) {
        Vector<JgclCurveCurveInterference2D> resultVector = new Vector<JgclCurveCurveInterference2D>();
        int i = 0;
        while (i < sourceInterferences.length) {
            JgclCurveCurveInterference2D intf = !doExchange ? sourceInterferences[i].changeCurve1(this) : sourceInterferences[i].changeCurve2(this);
            if (intf != null) {
                resultVector.addElement(intf);
            }
            ++i;
        }
        Object[] result = new JgclCurveCurveInterference2D[resultVector.size()];
        resultVector.copyInto(result);
        return result;
    }

    JgclCurveCurveInterference2D[] interfere(JgclPolyline2D mate, boolean doExchange) {
        return this.convertInterferences(this.toPolyline().interfere(mate, doExchange), doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclPureBezierCurve2D mate, boolean doExchange) {
        return this.convertInterferences(this.toBsplineCurve().interfere(mate, doExchange), doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclBsplineCurve2D mate, boolean doExchange) {
        return this.convertInterferences(this.toBsplineCurve().interfere(mate, doExchange), doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclTrimmedCurve2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurve2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    public JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate) {
        return mate.interfere(this, true);
    }

    JgclIntersectionPoint2D intersect1(JgclBoundedLine2D mate, JgclVector2D AUdir, JgclVector2D BUdir, double Aleng, double Bleng) throws JgclIndefiniteSolution {
        JgclLine2D Blin = mate.toLine();
        if (this.haveIntsWithLine(Blin, BUdir) < 0) {
            JgclCurveCurveInterference2D com_sec = this.haveCommonSection(false, mate, AUdir, BUdir, Aleng, Bleng);
            if (com_sec == null) {
                return null;
            }
            return com_sec.toIntersectionPoint();
        }
        JgclLine2D Alin = this.toLine();
        switch (mate.haveIntsWithLine(Alin, AUdir)) {
            case -1: {
                JgclCurveCurveInterference2D com_sec = this.haveCommonSection(false, mate, AUdir, BUdir, Aleng, Bleng);
                if (com_sec == null) {
                    return null;
                }
                return com_sec.toIntersectionPoint();
            }
            case 0: {
                return null;
            }
        }
        return this.getIntsWithBln(mate, Alin, Blin);
    }

    public JgclIntersectionPoint2D intersect1(JgclBoundedLine2D mate) throws JgclIndefiniteSolution {
        JgclVector2D AUdir = this.unitizedDirection();
        JgclVector2D BUdir = mate.unitizedDirection();
        double Aleng = this.length();
        double Bleng = mate.length();
        return this.intersect1(mate, AUdir, BUdir, Aleng, Bleng);
    }

    public JgclIntersectionPoint2D intersect1AsInfiniteLine(JgclLine2D mate) throws JgclIndefiniteSolution {
        double paramB;
        double paramA;
        boolean overlap;
        switch (this.haveIntsWithLine(mate, mate.dir().unitized())) {
            case 0: {
                return null;
            }
            case -1: {
                overlap = true;
                break;
            }
            default: {
                overlap = false;
            }
        }
        JgclLine2D lineA = this.toLine();
        JgclLine2D lineB = mate;
        if (!overlap) {
            JgclVector2D a2b = lineB.pnt().subtract(lineA.pnt());
            double crosz = lineA.dir().zOfCrossProduct(lineB.dir());
            paramA = a2b.zOfCrossProduct(lineB.dir()) / crosz;
            paramB = a2b.zOfCrossProduct(lineA.dir()) / crosz;
        } else {
            paramA = 0.0;
            paramB = lineB.project1From(lineA.coordinates(paramA)).parameter();
        }
        JgclIntersectionPoint2D intersection = new JgclIntersectionPoint2D(lineA, paramA, lineB, paramB, false);
        if (overlap) {
            throw new JgclIndefiniteSolution("Two curves overlap.", intersection);
        }
        return intersection;
    }

    public JgclBsplineCurve2D offsetByBsplineCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        return this.toLine().offsetByBsplineCurve(pint, magni, side, tol);
    }

    public JgclBoundedCurve2D offsetByBoundedCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        JgclVector2D lineDirection = this.tangentVector(0.0);
        JgclVector2D offsetVector = side == 1 ? JgclVector2D.of(lineDirection.y(), -lineDirection.x()) : JgclVector2D.of(-lineDirection.y(), lineDirection.x());
        offsetVector = offsetVector.unitized().multiply(magni);
        if (pint.increase() < 0.0) {
            offsetVector = offsetVector.reverse();
        }
        return new JgclBoundedLine2D(this.coordinates(pint.start()).add(offsetVector), this.coordinates(pint.end()).add(offsetVector));
    }

    JgclFilletObject2D[] doFillet(JgclParameterSection pint1, int side1, JgclParametricCurve2D mate, JgclParameterSection pint2, int side2, double radius, boolean doExchange) throws JgclIndefiniteSolution {
        JgclFilletObject2D[] flts;
        JgclLine2D lin = this.toLine();
        boolean indefinite = false;
        try {
            flts = lin.fillet(pint1, side1, mate, pint2, side2, radius);
        }
        catch (JgclIndefiniteSolution e) {
            flts = new JgclFilletObject2D[]{(JgclFilletObject2D)e.suitable()};
            indefinite = true;
        }
        int i = 0;
        while (i < flts.length) {
            JgclPointOnCurve2D poc1 = new JgclPointOnCurve2D(this, flts[i].pointOnCurve1().parameter(), false);
            flts[i] = !doExchange ? new JgclFilletObject2D(radius, flts[i].center(), poc1, flts[i].pointOnCurve2()) : new JgclFilletObject2D(radius, flts[i].center(), flts[i].pointOnCurve2(), poc1);
            ++i;
        }
        if (indefinite) {
            throw new JgclIndefiniteSolution(flts[0]);
        }
        return flts;
    }

    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    public JgclCommonNormal2D[] commonNormal(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    JgclEnclosingBox2D enclosingBox() {
        double max_y;
        double min_y;
        double max_x;
        double min_x;
        if (this.spnt().x() < this.epnt().x()) {
            min_x = this.spnt().x();
            max_x = this.epnt().x();
        } else {
            min_x = this.epnt().x();
            max_x = this.spnt().x();
        }
        if (this.spnt().y() < this.epnt().y()) {
            min_y = this.spnt().y();
            max_y = this.epnt().y();
        } else {
            min_y = this.epnt().y();
            max_y = this.spnt().y();
        }
        return new JgclEnclosingBox2D(min_x, min_y, max_x, max_y);
    }

    JgclParameterDomain getParameterDomain() {
        return new JgclParameterDomain(false, 0.0, 1.0);
    }

    private double checkParameter(double param) {
        this.checkValidity(param);
        return this.parameterDomain().force(param);
    }

    public JgclBoundedLine2D reverse() {
        return new JgclBoundedLine2D(this.epnt(), this.spnt());
    }

    int type() {
        return 2;
    }

    protected synchronized JgclParametricCurve2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint2D tSpnt = this.spnt().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        JgclPoint2D tEpnt = this.epnt().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclBoundedLine2D(tSpnt, tEpnt);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tspnt");
        this.spnt.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tepnt");
        this.epnt.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

