/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclApproximationSurface3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineCurveEvaluation;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclBsplineSurfaceForm;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclConic3D;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclCylindricalSurface3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclFreeformSurfaceWithControlPoints3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclInterpolationSurface3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclIntsCrvBss3D;
import jp.go.ipa.jgcl.JgclIntsSrfBss3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclMesh3D;
import jp.go.ipa.jgcl.JgclOfst3D;
import jp.go.ipa.jgcl.JgclOpenSurfaceForUDirection;
import jp.go.ipa.jgcl.JgclOpenSurfaceForVDirection;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclSphericalSurface3D;
import jp.go.ipa.jgcl.JgclSurfaceDerivative3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclBsplineSurface3D
extends JgclFreeformSurfaceWithControlPoints3D {
    private final JgclBsplineKnot uKnotData;
    private final JgclBsplineKnot vKnotData;
    private int surfaceForm = 10;

    public JgclBsplineSurface3D(int uDegree, boolean uPeriodic, int[] uKnotMultiplicities, double[] uKnots, int vDegree, boolean vPeriodic, int[] vKnotMultiplicities, double[] vKnots, JgclPoint3D[][] controlPoints) {
        super(controlPoints);
        this.uKnotData = new JgclBsplineKnot(uDegree, 1, uPeriodic, uKnotMultiplicities, uKnots, controlPoints.length);
        this.vKnotData = new JgclBsplineKnot(vDegree, 1, vPeriodic, vKnotMultiplicities, vKnots, controlPoints[0].length);
    }

    public JgclBsplineSurface3D(int uDegree, boolean uPeriodic, int uKnotSpec, int vDegree, boolean vPeriodic, int vKnotSpec, JgclPoint3D[][] controlPoints) {
        super(controlPoints);
        this.uKnotData = new JgclBsplineKnot(uDegree, uKnotSpec, uPeriodic, null, null, controlPoints.length);
        this.vKnotData = new JgclBsplineKnot(vDegree, vKnotSpec, vPeriodic, null, null, controlPoints[0].length);
    }

    public JgclBsplineSurface3D(int uDegree, boolean uPeriodic, int[] uKnotMultiplicities, double[] uKnots, int vDegree, boolean vPeriodic, int[] vKnotMultiplicities, double[] vKnots, JgclPoint3D[][] controlPoints, double[][] weights) {
        super(controlPoints, weights);
        this.uKnotData = new JgclBsplineKnot(uDegree, 1, uPeriodic, uKnotMultiplicities, uKnots, controlPoints.length);
        this.vKnotData = new JgclBsplineKnot(vDegree, 1, vPeriodic, vKnotMultiplicities, vKnots, controlPoints[0].length);
    }

    public JgclBsplineSurface3D(int uDegree, boolean uPeriodic, int uKnotSpec, int vDegree, boolean vPeriodic, int vKnotSpec, JgclPoint3D[][] controlPoints, double[][] weights) {
        super(controlPoints, weights);
        this.uKnotData = new JgclBsplineKnot(uDegree, uKnotSpec, uPeriodic, null, null, controlPoints.length);
        this.vKnotData = new JgclBsplineKnot(vDegree, vKnotSpec, vPeriodic, null, null, controlPoints[0].length);
    }

    JgclBsplineSurface3D(JgclBsplineKnot uKnotData, JgclBsplineKnot vKnotData, double[][][] cpArray) {
        super(cpArray);
        if (uKnotData.nControlPoints() != this.uNControlPoints() || vKnotData.nControlPoints() != this.vNControlPoints()) {
            throw new JgclInvalidArgumentValue();
        }
        if (uKnotData.knotSpec() == 1 || vKnotData.knotSpec() == 1) {
            uKnotData = uKnotData.makeExplicit();
            vKnotData = vKnotData.makeExplicit();
        }
        this.uKnotData = uKnotData;
        this.vKnotData = vKnotData;
    }

    JgclBsplineSurface3D(JgclBsplineKnot uKnotData, JgclBsplineKnot vKnotData, JgclPoint3D[][] controlPoints, double[][] weights) {
        super(controlPoints, weights, false);
        if (uKnotData.knotSpec() == 1 || vKnotData.knotSpec() == 1) {
            uKnotData = uKnotData.makeExplicit();
            vKnotData = vKnotData.makeExplicit();
        }
        this.uKnotData = uKnotData;
        this.vKnotData = vKnotData;
    }

    public JgclBsplineSurface3D(JgclPoint3D[][] points, double[] uParams, double[] vParams, boolean uIsClosed, boolean vIsClosed) {
        JgclInterpolationSurface3D doObj = new JgclInterpolationSurface3D(points, uParams, vParams, uIsClosed, vIsClosed);
        this.controlPoints = doObj.controlPoints();
        this.uKnotData = doObj.uKnotData();
        this.vKnotData = doObj.vKnotData();
        this.weights = doObj.weights();
    }

    public JgclBsplineSurface3D(JgclPoint3D[][] points, double[] uParams, double[] vParams, boolean uIsClosed, boolean vIsClosed, JgclToleranceForDistance tol) {
        JgclApproximationSurface3D doObj = new JgclApproximationSurface3D(points, uParams, vParams, uIsClosed, vIsClosed);
        JgclBsplineSurface3D bss = doObj.getApproximationWithTolerance(tol);
        this.controlPoints = bss.controlPoints;
        this.uKnotData = bss.uKnotData;
        this.vKnotData = bss.vKnotData;
        this.weights = bss.weights;
    }

    public int uDegree() {
        return this.uKnotData.degree();
    }

    public int uKnotSpec() {
        return this.uKnotData.knotSpec();
    }

    public int uNKnotValues() {
        return this.uKnotData.nKnotValues();
    }

    public double uKnotValueAt(int n) {
        return this.uKnotData.knotValueAt(n);
    }

    int uNSegments() {
        return this.uKnotData.nSegments();
    }

    JgclBsplineKnot.ValidSegmentInfo uValidSegments() {
        return this.uKnotData.validSegments();
    }

    public JgclPoint3D controlPointAt(int i, int j) {
        int ncp;
        if (this.isUPeriodic()) {
            ncp = this.uNControlPoints();
            while (i < 0) {
                i += ncp;
            }
            while (i >= ncp) {
                i -= ncp;
            }
        }
        if (this.isVPeriodic()) {
            ncp = this.vNControlPoints();
            while (j < 0) {
                j += ncp;
            }
            while (j >= ncp) {
                j -= ncp;
            }
        }
        return this.controlPoints[i][j];
    }

    public int vDegree() {
        return this.vKnotData.degree();
    }

    public int vKnotSpec() {
        return this.vKnotData.knotSpec();
    }

    public int vNKnotValues() {
        return this.vKnotData.nKnotValues();
    }

    public double vKnotValueAt(int n) {
        return this.vKnotData.knotValueAt(n);
    }

    int vNSegments() {
        return this.vKnotData.nSegments();
    }

    JgclBsplineKnot.ValidSegmentInfo vValidSegments() {
        return this.vKnotData.validSegments();
    }

    public JgclPoint3D coordinates(double uParam, double vParam) {
        int j;
        boolean isPoly = this.isPolynomial();
        uParam = this.checkUParameter(uParam);
        vParam = this.checkVParameter(vParam);
        double[][][] cntlPnts = this.toDoubleArray(isPoly);
        int uUicp = cntlPnts.length;
        double[][] bsc = new double[uUicp][];
        int u_section = this.uKnotData.segmentIndex(uParam);
        if (u_section < 0) {
            throw new JgclFatal();
        }
        int i = j = u_section;
        while (i <= u_section + this.uDegree()) {
            if (!isPoly && j == this.uNControlPoints()) {
                j = 0;
            }
            bsc[j] = JgclBsplineCurveEvaluation.coordinates(this.vKnotData, cntlPnts[j], vParam);
            ++i;
            ++j;
        }
        double[] d0D = JgclBsplineCurveEvaluation.coordinates(this.uKnotData, bsc, uParam);
        if (!isPoly) {
            this.convRational0Deriv(d0D);
        }
        return new JgclCartesianPoint3D(d0D);
    }

    public JgclVector3D[] tangentVector(double uParam, double vParam) {
        int j;
        double[][] ld1D = new double[2][];
        JgclVector3D[] d1D = new JgclVector3D[2];
        boolean isPoly = this.isPolynomial();
        uParam = this.checkUParameter(uParam);
        vParam = this.checkVParameter(vParam);
        double[][][] cntlPnts = this.toDoubleArray(isPoly);
        int uUicp = cntlPnts.length;
        double[][] pp = new double[uUicp][4];
        double[][] tt = new double[uUicp][4];
        int u_section = this.uKnotData.segmentIndex(uParam);
        if (u_section < 0) {
            throw new JgclFatal();
        }
        int i = j = u_section;
        while (i <= u_section + this.uDegree()) {
            if (!isPoly && j == this.uNControlPoints()) {
                j = 0;
            }
            JgclBsplineCurveEvaluation.evaluation(this.vKnotData, cntlPnts[j], vParam, pp[j], tt[j], null, null);
            ++i;
            ++j;
        }
        ld1D[0] = new double[4];
        if (isPoly) {
            JgclBsplineCurveEvaluation.evaluation(this.uKnotData, pp, uParam, null, ld1D[0], null, null);
            ld1D[1] = JgclBsplineCurveEvaluation.coordinates(this.uKnotData, tt, uParam);
        } else {
            double[] ld0D = new double[4];
            JgclBsplineCurveEvaluation.evaluation(this.uKnotData, pp, uParam, ld0D, ld1D[0], null, null);
            ld1D[1] = JgclBsplineCurveEvaluation.coordinates(this.uKnotData, tt, uParam);
            this.convRational1Deriv(ld0D, ld1D[0], ld1D[1]);
        }
        i = 0;
        while (i < 2) {
            d1D[i] = new JgclLiteralVector3D(ld1D[i]);
            ++i;
        }
        return d1D;
    }

    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam) {
        int j;
        boolean isPoly = this.isPolynomial();
        uParam = this.checkUParameter(uParam);
        vParam = this.checkVParameter(vParam);
        double[][][] cntlPnts = this.toDoubleArray(isPoly);
        int uUicp = cntlPnts.length;
        double[][] pp = new double[uUicp][4];
        double[][] tt = new double[uUicp][4];
        double[][] dd = new double[uUicp][4];
        int u_section = this.uKnotData.segmentIndex(uParam);
        if (u_section < 0) {
            throw new JgclFatal();
        }
        int i = j = u_section;
        while (i <= u_section + this.uDegree()) {
            if (!isPoly && j == this.uNControlPoints()) {
                j = 0;
            }
            JgclBsplineCurveEvaluation.evaluation(this.vKnotData, cntlPnts[j], vParam, pp[j], tt[j], dd[j], null);
            ++i;
            ++j;
        }
        double[] ldv = new double[4];
        double[] lduv = new double[4];
        JgclBsplineCurveEvaluation.evaluation(this.uKnotData, tt, uParam, ldv, lduv, null, null);
        double[] ldvv = JgclBsplineCurveEvaluation.coordinates(this.uKnotData, dd, uParam);
        double[] ld0 = new double[4];
        double[] ldu = new double[4];
        double[] lduu = new double[4];
        JgclBsplineCurveEvaluation.evaluation(this.uKnotData, pp, uParam, ld0, ldu, lduu, null);
        if (!isPoly) {
            this.convRational2Deriv(ld0, ldu, ldv, lduu, lduv, ldvv);
        }
        JgclCartesianPoint3D d0 = new JgclCartesianPoint3D(ld0);
        JgclLiteralVector3D du = new JgclLiteralVector3D(ldu);
        JgclLiteralVector3D dv = new JgclLiteralVector3D(ldv);
        JgclLiteralVector3D duu = new JgclLiteralVector3D(lduu);
        JgclLiteralVector3D duv = new JgclLiteralVector3D(lduv);
        JgclLiteralVector3D dvv = new JgclLiteralVector3D(ldvv);
        return new JgclSurfaceDerivative3D(d0, du, dv, duu, duv, dvv);
    }

    private boolean twoPointsCoincide(JgclPointOnSurface3D pA, JgclPointOnSurface3D pB, JgclToleranceForDistance dTol) {
        if (pA.coordinates().distance2(pB.coordinates()) > dTol.squared()) {
            return false;
        }
        double uA = pA.uParameter();
        double vA = pA.vParameter();
        double uB = pB.uParameter();
        double vB = pB.vParameter();
        double pDiff = Math.abs(uA - uB);
        double pTol = dTol.toToleranceForParameterU(this, uA, vA).value();
        boolean coincide = false;
        if (pDiff < pTol) {
            coincide = true;
        } else if (this.isUPeriodic() && Math.abs(pDiff - this.uParameterDomain().section().absIncrease()) < pTol) {
            coincide = true;
        }
        if (!coincide) {
            return false;
        }
        pDiff = Math.abs(vA - vB);
        pTol = dTol.toToleranceForParameterV(this, uA, vA).value();
        coincide = false;
        if (pDiff < pTol) {
            coincide = true;
        } else if (this.isVPeriodic() && Math.abs(pDiff - this.vParameterDomain().section().absIncrease()) < pTol) {
            coincide = true;
        }
        return coincide;
    }

    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point) {
        Vector<JgclPointOnSurface3D> projectedPointList = new Vector<JgclPointOnSurface3D>();
        JgclBsplineKnot.ValidSegmentInfo uValidSegmentsInfo = this.uValidSegments();
        JgclBsplineKnot.ValidSegmentInfo vValidSegmentsInfo = this.vValidSegments();
        JgclPureBezierSurface3D[][] bzss = this.toPureBezierSurfaceArray();
        JgclToleranceForDistance dTol = this.getToleranceForDistanceAsObject();
        int ui = 0;
        while (ui < uValidSegmentsInfo.nSegments()) {
            int vi = 0;
            while (vi < vValidSegmentsInfo.nSegments()) {
                JgclPointOnSurface3D[] localProj = bzss[ui][vi].projectFrom(point);
                int i = 0;
                while (i < localProj.length) {
                    JgclPointOnSurface3D proj = new JgclPointOnSurface3D((JgclParametricSurface3D)this, uValidSegmentsInfo.l2Gp(ui, localProj[i].uParameter()), vValidSegmentsInfo.l2Gp(vi, localProj[i].vParameter()));
                    boolean isUnique = true;
                    Enumeration e = projectedPointList.elements();
                    while (e.hasMoreElements()) {
                        if (!this.twoPointsCoincide(proj, (JgclPointOnSurface3D)e.nextElement(), dTol)) continue;
                        isUnique = false;
                        break;
                    }
                    if (isUnique) {
                        projectedPointList.addElement(proj);
                    }
                    ++i;
                }
                ++vi;
            }
            ++ui;
        }
        Object[] results = new JgclPointOnSurface3D[projectedPointList.size()];
        projectedPointList.copyInto(results);
        return results;
    }

    public JgclBsplineSurface3D uShiftIfPeriodic(double newStartParam) throws JgclOpenSurfaceForUDirection {
        if (!this.isUPeriodic()) {
            throw new JgclOpenSurfaceForUDirection();
        }
        newStartParam = this.uParameterDomain().wrap(newStartParam);
        int newFirstSegment = this.uKnotData.getSegmentNumberThatStartIsEqualTo(newStartParam);
        if (newFirstSegment == -1) {
            return this.uInsertKnot(newStartParam).uShiftIfPeriodic(newStartParam);
        }
        JgclBsplineKnot newKnotData = this.uKnotData.shift(newFirstSegment);
        int uNNewControlPoints = newKnotData.nControlPoints();
        int vNNewControlPoints = this.vNControlPoints();
        JgclPoint3D[][] newControlPoints = new JgclPoint3D[uNNewControlPoints][vNNewControlPoints];
        int ui = 0;
        while (ui < uNNewControlPoints) {
            int vi = 0;
            while (vi < vNNewControlPoints) {
                newControlPoints[ui][vi] = this.controlPointAt((ui + newFirstSegment) % uNNewControlPoints, vi);
                ++vi;
            }
            ++ui;
        }
        double[][] newWeights = null;
        if (this.isRational()) {
            newWeights = new double[uNNewControlPoints][vNNewControlPoints];
            int ui2 = 0;
            while (ui2 < uNNewControlPoints) {
                int vi = 0;
                while (vi < vNNewControlPoints) {
                    newWeights[ui2][vi] = this.weightAt((ui2 + newFirstSegment) % uNNewControlPoints, vi);
                    ++vi;
                }
                ++ui2;
            }
        }
        return new JgclBsplineSurface3D(newKnotData, this.vKnotData, newControlPoints, newWeights);
    }

    public JgclBsplineSurface3D vShiftIfPeriodic(double newStartParam) throws JgclOpenSurfaceForVDirection {
        if (!this.isVPeriodic()) {
            throw new JgclOpenSurfaceForVDirection();
        }
        newStartParam = this.vParameterDomain().wrap(newStartParam);
        int newFirstSegment = this.vKnotData.getSegmentNumberThatStartIsEqualTo(newStartParam);
        if (newFirstSegment == -1) {
            return this.vInsertKnot(newStartParam).vShiftIfPeriodic(newStartParam);
        }
        JgclBsplineKnot newKnotData = this.vKnotData.shift(newFirstSegment);
        int uNNewControlPoints = this.uNControlPoints();
        int vNNewControlPoints = newKnotData.nControlPoints();
        JgclPoint3D[][] newControlPoints = new JgclPoint3D[uNNewControlPoints][vNNewControlPoints];
        int ui = 0;
        while (ui < uNNewControlPoints) {
            int vi = 0;
            while (vi < vNNewControlPoints) {
                newControlPoints[ui][vi] = this.controlPointAt(ui, (vi + newFirstSegment) % vNNewControlPoints);
                ++vi;
            }
            ++ui;
        }
        double[][] newWeights = null;
        if (this.isRational()) {
            newWeights = new double[uNNewControlPoints][vNNewControlPoints];
            int ui2 = 0;
            while (ui2 < uNNewControlPoints) {
                int vi = 0;
                while (vi < vNNewControlPoints) {
                    newWeights[ui2][vi] = this.weightAt(ui2, (vi + newFirstSegment) % vNNewControlPoints);
                    ++vi;
                }
                ++ui2;
            }
        }
        return new JgclBsplineSurface3D(this.uKnotData, newKnotData, newControlPoints, newWeights);
    }

    public JgclMesh3D toMesh(JgclParameterSection uPint, JgclParameterSection vPint, JgclToleranceForDistance tol) {
        boolean isUPeriodic = this.isUPeriodic();
        boolean isVPeriodic = this.isVPeriodic();
        JgclBsplineSurface3D t_bss = this.truncate(uPint, vPint);
        JgclMesh3D Mesh = t_bss.toMesh(tol);
        double uSp = uPint.start();
        double uIp = uPint.increase();
        double vSp = vPint.start();
        double vIp = vPint.increase();
        int u_npnts = Mesh.uNPoints();
        int v_npnts = Mesh.vNPoints();
        JgclPoint3D[][] mesh = Mesh.points();
        int i = 0;
        while (i < u_npnts) {
            int j = 0;
            while (j < v_npnts) {
                double uParam = isUPeriodic ? uSp + ((JgclPointOnSurface3D)mesh[i][j]).uParameter() : ((JgclPointOnSurface3D)mesh[i][j]).uParameter();
                double vParam = isVPeriodic ? vSp + ((JgclPointOnSurface3D)mesh[i][j]).vParameter() : ((JgclPointOnSurface3D)mesh[i][j]).vParameter();
                try {
                    mesh[i][j] = new JgclPointOnSurface3D(this, uParam, vParam, false);
                }
                catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                    throw new JgclFatal();
                }
                ++j;
            }
            ++i;
        }
        return new JgclMesh3D(mesh, false);
    }

    public JgclMesh3D toMesh(JgclToleranceForDistance tol) {
        double[] u_kp = new double[2];
        double[] v_kp = new double[2];
        JgclParameterDomain uDmn = this.uParameterDomain();
        JgclParameterDomain vDmn = this.vParameterDomain();
        JgclBsplineSurface3D obss = this.openBssIfClosed().truncate(uDmn.section(), vDmn.section());
        JgclFreeformSurfaceWithControlPoints3D.GpList u_gp_list = new JgclFreeformSurfaceWithControlPoints3D.GpList(this);
        JgclFreeformSurfaceWithControlPoints3D.GpList v_gp_list = new JgclFreeformSurfaceWithControlPoints3D.GpList(this);
        JgclBsplineSurface3D jgclBsplineSurface3D = this;
        jgclBsplineSurface3D.getClass();
        JgclBsplineSurface3D jgclBsplineSurface3D2 = this;
        jgclBsplineSurface3D2.getClass();
        JgclFreeformSurfaceWithControlPoints3D.MeshParam meshParam = new JgclFreeformSurfaceWithControlPoints3D.MeshParam(jgclBsplineSurface3D2, 0, 0, 1);
        JgclBsplineSurface3D jgclBsplineSurface3D3 = this;
        jgclBsplineSurface3D3.getClass();
        JgclFreeformSurfaceWithControlPoints3D.MeshParam meshParam2 = new JgclFreeformSurfaceWithControlPoints3D.MeshParam(jgclBsplineSurface3D3, 0, 1, 1);
        JgclBsplineSurface3D jgclBsplineSurface3D4 = this;
        jgclBsplineSurface3D4.getClass();
        JgclFreeformSurfaceWithControlPoints3D.MeshParam meshParam3 = new JgclFreeformSurfaceWithControlPoints3D.MeshParam(jgclBsplineSurface3D4, 0, 0, 1);
        JgclBsplineSurface3D jgclBsplineSurface3D5 = this;
        jgclBsplineSurface3D5.getClass();
        JgclFreeformSurfaceWithControlPoints3D.SegInfo seg_info = new JgclFreeformSurfaceWithControlPoints3D.SegInfo(jgclBsplineSurface3D, meshParam, meshParam2, meshParam3, new JgclFreeformSurfaceWithControlPoints3D.MeshParam(jgclBsplineSurface3D5, 0, 1, 1));
        obss.getSrfMesh(seg_info, tol, u_gp_list, v_gp_list);
        u_kp[0] = uDmn.section().start();
        u_kp[1] = uDmn.section().end();
        v_kp[0] = vDmn.section().start();
        v_kp[1] = vDmn.section().end();
        return obss.makeParamAndMesh(u_gp_list, v_gp_list, u_kp, v_kp);
    }

    private JgclBsplineSurface3D openBssIfClosed() {
        JgclParameterDomain uDmn = this.uParameterDomain();
        if (uDmn.isPeriodic()) {
            JgclBsplineSurface3D[] bsss;
            try {
                bsss = this.uDivide(uDmn.section().end());
            }
            catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
                throw new JgclFatal();
            }
            return bsss[0].openBssIfClosed();
        }
        JgclParameterDomain vDmn = this.vParameterDomain();
        if (vDmn.isPeriodic()) {
            JgclBsplineSurface3D[] bsss;
            try {
                bsss = this.vDivide(vDmn.section().end());
            }
            catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
                throw new JgclFatal();
            }
            return bsss[0];
        }
        return this;
    }

    JgclFreeformSurfaceWithControlPoints3D[] divideForMesh(JgclToleranceForDistance tol) {
        JgclFreeformSurfaceWithControlPoints3D[] bsss;
        JgclFreeformSurfaceWithControlPoints3D ru_bss;
        JgclFreeformSurfaceWithControlPoints3D lu_bss;
        JgclBsplineSurface3D rb_bss;
        JgclBsplineSurface3D lb_bss;
        if (this.isUPeriodic() || this.isVPeriodic()) {
            throw new JgclFatal();
        }
        double told = tol.value();
        boolean u_coln = JgclFreeformSurfaceWithControlPoints3D.uIsColinear(this.controlPoints, told);
        boolean v_coln = JgclFreeformSurfaceWithControlPoints3D.vIsColinear(this.controlPoints, told);
        JgclParameterDomain uDmn = this.uParameterDomain();
        JgclParameterDomain vDmn = this.vParameterDomain();
        double u_mid_param = (uDmn.section().start() + uDmn.section().end()) / 2.0;
        double v_mid_param = (vDmn.section().start() + vDmn.section().end()) / 2.0;
        try {
            if (u_coln && v_coln) {
                lb_bss = null;
                rb_bss = null;
                lu_bss = null;
                ru_bss = null;
            } else if (!u_coln && !v_coln) {
                bsss = this.vDivide(v_mid_param);
                JgclBsplineSurface3D vb_bss = bsss[0];
                JgclBsplineSurface3D vu_bss = bsss[1];
                bsss = vb_bss.uDivide(u_mid_param);
                lb_bss = bsss[0];
                rb_bss = bsss[1];
                bsss = vu_bss.uDivide(u_mid_param);
                lu_bss = bsss[0];
                ru_bss = bsss[1];
            } else if (u_coln) {
                bsss = this.vDivide(v_mid_param);
                lb_bss = bsss[0];
                lu_bss = bsss[1];
                rb_bss = null;
                ru_bss = null;
            } else {
                bsss = this.uDivide(u_mid_param);
                lb_bss = bsss[0];
                rb_bss = bsss[1];
                lu_bss = null;
                ru_bss = null;
            }
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        bsss = new JgclBsplineSurface3D[]{lb_bss, rb_bss, lu_bss, ru_bss};
        return bsss;
    }

    boolean isPlaner(JgclToleranceForDistance tol) {
        JgclPureBezierSurface3D bzs;
        try {
            bzs = new JgclPureBezierSurface3D(this.controlPoints);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        return bzs.isPlaner(tol);
    }

    public JgclPureBezierSurface3D[][] toPureBezierSurfaceArray() {
        boolean isPoly = this.isPolynomial();
        double[][][] cntlPnts = this.toDoubleArray(isPoly);
        double[][][][][] bzs_array = JgclBsplineCurveEvaluation.toBezierSurface(this.uKnotData, this.vKnotData, cntlPnts);
        JgclPureBezierSurface3D[][] bzss = new JgclPureBezierSurface3D[bzs_array.length][bzs_array[0].length];
        int i = 0;
        while (i < bzs_array.length) {
            int j = 0;
            while (j < bzs_array[0].length) {
                bzss[i][j] = new JgclPureBezierSurface3D(bzs_array[i][j]);
                ++j;
            }
            ++i;
        }
        return bzss;
    }

    public JgclBsplineSurface3D toBsplineSurface() {
        if (this.isRational()) {
            return this;
        }
        return new JgclBsplineSurface3D(this.uKnotData, this.vKnotData, this.controlPoints, this.makeUniformWeights());
    }

    public JgclBsplineSurface3D toBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint) {
        JgclBsplineSurface3D target = this;
        if (target.isUPeriodic()) {
            if (uPint.absIncrease() >= target.uParameterDomain().section().absIncrease()) {
                try {
                    target = target.uShiftIfPeriodic(uPint.start());
                }
                catch (JgclOpenSurfaceForUDirection jgclOpenSurfaceForUDirection) {}
                if (uPint.increase() < 0.0) {
                    target = target.reverse(true, false);
                }
            } else {
                target = target.uTruncate(uPint);
            }
        } else {
            target = target.uTruncate(uPint);
        }
        if (target.isVPeriodic()) {
            if (vPint.absIncrease() >= target.vParameterDomain().section().absIncrease()) {
                try {
                    target = target.vShiftIfPeriodic(vPint.start());
                }
                catch (JgclOpenSurfaceForVDirection jgclOpenSurfaceForVDirection) {}
                if (vPint.increase() < 0.0) {
                    target = target.reverse(false, true);
                }
            } else {
                target = target.vTruncate(vPint);
            }
        } else {
            target = target.vTruncate(vPint);
        }
        return target.toBsplineSurface();
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
        return JgclIntsCrvBss3D.intersection(mate, this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclConic3D mate, boolean doExchange) {
        return JgclIntsCrvBss3D.intersection(mate, this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
        return JgclIntsCrvBss3D.intersection(mate, this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
        return JgclIntsCrvBss3D.intersection(mate, this, !doExchange);
    }

    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate) {
        return mate.intersect(this, true);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate, boolean doExchange) {
        return JgclIntsSrfBss3D.intersection(mate, this, !doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate, boolean doExchange) {
        return JgclIntsSrfBss3D.intersection(mate, this, !doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate, boolean doExchange) {
        return JgclIntsSrfBss3D.intersection(mate, this, !doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate, boolean doExchange) {
        return JgclIntsSrfBss3D.intersection(mate, this, !doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) {
        return JgclIntsSrfBss3D.intersection(mate, this, !doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) {
        return JgclIntsSrfBss3D.intersection(mate, this, !doExchange);
    }

    public JgclBsplineSurface3D offsetByBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint, double magni, int side, JgclToleranceForDistance tol) {
        JgclOfst3D doObj = new JgclOfst3D(this, uPint, vPint, magni, side, tol);
        return doObj.offset();
    }

    public JgclParametricCurve3D uIsoParametricCurve(double uParam) {
        uParam = this.checkUParameter(uParam);
        boolean isPoly = this.isPolynomial();
        double[][][] cntlPnts = this.toDoubleArray(isPoly);
        int uUicp = this.uNControlPoints();
        int vUicp = this.vNControlPoints();
        double[][] tBsc = new double[uUicp][];
        double[][] bsc = new double[vUicp][];
        int i = 0;
        while (i < vUicp) {
            int j = 0;
            while (j < uUicp) {
                tBsc[j] = cntlPnts[j][i];
                ++j;
            }
            bsc[i] = JgclBsplineCurveEvaluation.coordinates(this.uKnotData, tBsc, uParam);
            ++i;
        }
        return new JgclBsplineCurve3D(this.vKnotData, bsc);
    }

    public JgclParametricCurve3D vIsoParametricCurve(double vParam) {
        vParam = this.checkVParameter(vParam);
        boolean isPoly = this.isPolynomial();
        double[][][] cntlPnts = this.toDoubleArray(isPoly);
        int uUicp = this.uNControlPoints();
        double[][] bsc = new double[uUicp][];
        int i = 0;
        while (i < uUicp) {
            bsc[i] = JgclBsplineCurveEvaluation.coordinates(this.vKnotData, cntlPnts[i], vParam);
            ++i;
        }
        return new JgclBsplineCurve3D(this.uKnotData, bsc);
    }

    public JgclBsplineSurface3D uInsertKnot(double uParam) {
        double[][][] bss_array = null;
        JgclBsplineKnot newUKd = null;
        int newUUicp = 0;
        int uUicp = this.uNControlPoints();
        int vUicp = this.vNControlPoints();
        boolean isPoly = this.isPolynomial();
        uParam = this.checkUParameter(uParam);
        double[][][] cntlPnts = this.toDoubleArray(isPoly);
        double[][] bsc = new double[uUicp][];
        int i = 0;
        while (i < vUicp) {
            int j = 0;
            while (j < uUicp) {
                bsc[j] = cntlPnts[j][i];
                ++j;
            }
            Object[] objs = JgclBsplineCurveEvaluation.insertKnot(this.uKnotData, bsc, uParam);
            if (i == 0) {
                newUKd = (JgclBsplineKnot)objs[0];
                newUUicp = newUKd.nControlPoints();
                bss_array = new double[newUUicp][vUicp][];
            }
            double[][] newUCp = (double[][])objs[1];
            j = 0;
            while (j < newUUicp) {
                bss_array[j][i] = newUCp[j];
                ++j;
            }
            ++i;
        }
        return new JgclBsplineSurface3D(newUKd, this.vKnotData, bss_array);
    }

    public JgclBsplineSurface3D vInsertKnot(double vParam) {
        JgclBsplineKnot newVKd = null;
        int uUicp = this.uNControlPoints();
        boolean isPoly = this.isPolynomial();
        vParam = this.checkVParameter(vParam);
        double[][][] cntlPnts = this.toDoubleArray(isPoly);
        double[][][] bss_array = new double[uUicp][][];
        int i = 0;
        while (i < uUicp) {
            Object[] objs = JgclBsplineCurveEvaluation.insertKnot(this.vKnotData, cntlPnts[i], vParam);
            if (i == 0) {
                newVKd = (JgclBsplineKnot)objs[0];
            }
            bss_array[i] = (double[][])objs[1];
            ++i;
        }
        return new JgclBsplineSurface3D(this.uKnotData, newVKd, bss_array);
    }

    public JgclBsplineSurface3D[] uDivide(double uParam) {
        double[][][][] bsss_array = new double[2][][][];
        JgclBsplineKnot[] newUKd = new JgclBsplineKnot[2];
        double[][][] newUCp = new double[2][][];
        int[] newUUicp = new int[2];
        int n_bsss = 0;
        int uUicp = this.uNControlPoints();
        int vUicp = this.vNControlPoints();
        boolean isPoly = this.isPolynomial();
        uParam = this.checkUParameter(uParam);
        double[][][] cntlPnts = this.toDoubleArray(isPoly);
        double[][] bsc = new double[uUicp][];
        int i = 0;
        while (i < vUicp) {
            int k;
            int j = 0;
            while (j < uUicp) {
                bsc[j] = cntlPnts[j][i];
                ++j;
            }
            JgclBsplineCurveEvaluation.divide(this.uKnotData, bsc, uParam, newUKd, newUCp);
            if (newUKd[0] == null) {
                throw new JgclFatal();
            }
            n_bsss = newUKd[1] == null ? 1 : 2;
            if (i == 0) {
                k = 0;
                while (k < n_bsss) {
                    newUUicp[k] = newUKd[k].nControlPoints();
                    bsss_array[k] = new double[newUUicp[k]][vUicp][];
                    ++k;
                }
            }
            k = 0;
            while (k < n_bsss) {
                j = 0;
                while (j < newUUicp[k]) {
                    bsss_array[k][j][i] = newUCp[k][j];
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        JgclBsplineSurface3D[] bsss = new JgclBsplineSurface3D[n_bsss];
        i = 0;
        while (i < n_bsss) {
            try {
                bsss[i] = new JgclBsplineSurface3D(newUKd[i], this.vKnotData, bsss_array[i]);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return bsss;
    }

    public JgclBsplineSurface3D[] vDivide(double vParam) {
        JgclBsplineKnot[] newVKd = new JgclBsplineKnot[2];
        double[][][] newVCp = new double[2][][];
        int uUicp = this.uNControlPoints();
        boolean isPoly = this.isPolynomial();
        vParam = this.checkVParameter(vParam);
        double[][][] cntlPnts = this.toDoubleArray(isPoly);
        double[][][][] bsss_array = new double[2][uUicp][][];
        int i = 0;
        while (i < uUicp) {
            JgclBsplineCurveEvaluation.divide(this.vKnotData, cntlPnts[i], vParam, newVKd, newVCp);
            bsss_array[0][i] = newVCp[0];
            if (newVKd[0] == null) {
                throw new JgclFatal();
            }
            if (newVKd[1] != null) {
                bsss_array[1][i] = newVCp[1];
            }
            ++i;
        }
        int n_bsss = newVKd[1] == null ? 1 : 2;
        JgclBsplineSurface3D[] bsss = new JgclBsplineSurface3D[n_bsss];
        i = 0;
        while (i < n_bsss) {
            try {
                bsss[i] = new JgclBsplineSurface3D(this.uKnotData, newVKd[i], bsss_array[i]);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return bsss;
    }

    public JgclBsplineSurface3D truncate(JgclParameterSection uSection, JgclParameterSection vSection) {
        JgclBsplineSurface3D t_bss = this.uTruncate(uSection);
        t_bss = t_bss.vTruncate(vSection);
        return t_bss;
    }

    private JgclBsplineSurface3D uTruncate(JgclParameterSection section) {
        JgclBsplineSurface3D t_bss;
        if (this.isUNonPeriodic()) {
            double start_par = this.checkUParameter(section.lower());
            double end_par = this.checkUParameter(section.upper());
            t_bss = this.uDivide(start_par)[1];
            t_bss = t_bss.uDivide(end_par)[0];
        } else {
            double srf_intvl = this.uParameterDomain().section().increase();
            double tol_p = JgclConditionOfOperation.getCondition().getToleranceForParameter();
            double start_par = this.checkUParameter(section.start());
            t_bss = this.uDivide(start_par)[0];
            if (Math.abs(section.increase()) < srf_intvl - tol_p) {
                if (section.increase() > 0.0) {
                    double end_par = section.increase();
                    t_bss = t_bss.uDivide(end_par)[0];
                } else {
                    double end_par = srf_intvl + section.increase();
                    t_bss = t_bss.uDivide(end_par)[1];
                }
            }
        }
        if (section.increase() < 0.0) {
            t_bss = t_bss.reverse(true, false);
        }
        return t_bss;
    }

    private JgclBsplineSurface3D vTruncate(JgclParameterSection section) {
        JgclBsplineSurface3D t_bss;
        if (this.isVNonPeriodic()) {
            double start_par = this.checkVParameter(section.lower());
            double end_par = this.checkVParameter(section.upper());
            t_bss = this.vDivide(start_par)[1];
            t_bss = t_bss.vDivide(end_par)[0];
        } else {
            double srf_intvl = this.vParameterDomain().section().increase();
            double tol_p = JgclConditionOfOperation.getCondition().getToleranceForParameter();
            double start_par = this.checkVParameter(section.start());
            t_bss = this.vDivide(start_par)[0];
            if (Math.abs(section.increase()) < srf_intvl - tol_p) {
                if (section.increase() > 0.0) {
                    double end_par = section.increase();
                    t_bss = t_bss.vDivide(end_par)[0];
                } else {
                    double end_par = srf_intvl + section.increase();
                    t_bss = t_bss.vDivide(end_par)[1];
                }
            }
        }
        if (section.increase() < 0.0) {
            t_bss = t_bss.reverse(false, true);
        }
        return t_bss;
    }

    private JgclBsplineSurface3D reverse(boolean isU, boolean isV) {
        JgclBsplineKnot rUKd;
        int j;
        boolean isRat = this.isRational();
        int uUicp = this.uNControlPoints();
        int vUicp = this.vNControlPoints();
        JgclPoint3D[][] rCp = new JgclPoint3D[uUicp][vUicp];
        double[][] rWt = null;
        if (!isU && !isV) {
            return this;
        }
        if (isRat) {
            rWt = new double[uUicp][vUicp];
        }
        if (isU) {
            j = uUicp - 1;
            rUKd = this.uKnotData.reverse();
        } else {
            j = 0;
            rUKd = this.uKnotData;
        }
        JgclBsplineKnot rVKd = isV ? this.vKnotData.reverse() : this.vKnotData;
        int i = 0;
        while (i < uUicp) {
            int l = isV ? vUicp - 1 : 0;
            int k = 0;
            while (k < vUicp) {
                rCp[i][k] = this.controlPointAt(j, l);
                if (isRat) {
                    rWt[i][k] = this.weightAt(j, l);
                }
                l = isV ? --l : ++l;
                ++k;
            }
            j = isU ? --j : ++j;
            ++i;
        }
        return new JgclBsplineSurface3D(rUKd, rVKd, rCp, rWt);
    }

    JgclParameterDomain getUParameterDomain() {
        return this.uKnotData.getParameterDomain();
    }

    JgclParameterDomain getVParameterDomain() {
        return this.vKnotData.getParameterDomain();
    }

    private double checkUParameter(double param) {
        this.checkUValidity(param);
        return this.uParameterDomain().force(this.uParameterDomain().wrap(param));
    }

    private double checkVParameter(double param) {
        this.checkVValidity(param);
        return this.vParameterDomain().force(this.vParameterDomain().wrap(param));
    }

    public JgclBsplineSurface3D uElevateOneDegree() {
        JgclBsplineKnot oldUKnotData = this.uKnotData;
        JgclBsplineKnot oldVKnotData = this.vKnotData;
        int oldUNCP = oldUKnotData.nControlPoints();
        int oldVNCP = oldVKnotData.nControlPoints();
        double[][][] oldControlPoints = this.toDoubleArray(this.isPolynomial());
        JgclBsplineKnot newUKnotData = JgclBsplineCurveEvaluation.getNewKnotDataAtDegreeElevation(oldUKnotData);
        JgclBsplineKnot newVKnotData = oldVKnotData;
        int newUNCP = newUKnotData.nControlPoints();
        int newVNCP = newVKnotData.nControlPoints();
        double[][][] newControlPoints = new double[newUNCP][newVNCP][];
        double[][] oldCurve = new double[oldUNCP][];
        int vi = 0;
        while (vi < oldVNCP) {
            int ui = 0;
            while (ui < oldUNCP) {
                oldCurve[ui] = oldControlPoints[ui][vi];
                ++ui;
            }
            double[][] newCurve = JgclBsplineCurveEvaluation.getNewControlPointsAtDegreeElevation(oldUKnotData, newUKnotData, oldCurve);
            int ui2 = 0;
            while (ui2 < newUNCP) {
                newControlPoints[ui2][vi] = newCurve[ui2];
                ++ui2;
            }
            ++vi;
        }
        return new JgclBsplineSurface3D(newUKnotData, newVKnotData, newControlPoints);
    }

    public JgclBsplineSurface3D vElevateOneDegree() {
        JgclBsplineKnot oldUKnotData = this.uKnotData;
        JgclBsplineKnot oldVKnotData = this.vKnotData;
        int oldUNCP = oldUKnotData.nControlPoints();
        int oldVNCP = oldVKnotData.nControlPoints();
        double[][][] oldControlPoints = this.toDoubleArray(this.isPolynomial());
        JgclBsplineKnot newUKnotData = oldUKnotData;
        JgclBsplineKnot newVKnotData = JgclBsplineCurveEvaluation.getNewKnotDataAtDegreeElevation(oldVKnotData);
        int newUNCP = newUKnotData.nControlPoints();
        int newVNCP = newVKnotData.nControlPoints();
        double[][][] newControlPoints = new double[newUNCP][][];
        int ui = 0;
        while (ui < oldUNCP) {
            newControlPoints[ui] = JgclBsplineCurveEvaluation.getNewControlPointsAtDegreeElevation(oldVKnotData, newVKnotData, oldControlPoints[ui]);
            ++ui;
        }
        return new JgclBsplineSurface3D(newUKnotData, newVKnotData, newControlPoints);
    }

    int type() {
        return 30;
    }

    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection, JgclParameterSection vParameterSection, double tolerance, double[] scalingFactor) {
        Vector<JgclPoint3D> result = new Vector<JgclPoint3D>();
        JgclMesh3D mesh = this.toMesh(uParameterSection, vParameterSection, new JgclToleranceForDistance(tolerance));
        int u = 0;
        while (u < mesh.uNPoints()) {
            int v = 0;
            while (v < mesh.vNPoints()) {
                result.addElement(mesh.pointAt(u, v));
                ++v;
            }
            ++u;
        }
        scalingFactor[0] = this.getMaxLengthOfUControlPolygons(this.uKnotData.isPeriodic());
        scalingFactor[1] = this.getMaxLengthOfVControlPolygons(this.vKnotData.isPeriodic());
        return result;
    }

    protected synchronized JgclParametricSurface3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint3D[][] tControlPoints = new JgclPoint3D[this.uNControlPoints()][];
        int i = 0;
        while (i < this.uNControlPoints()) {
            tControlPoints[i] = JgclPoint3D.transform(this.controlPoints[i], reverseTransform, transformationOperator, transformedGeometries);
            ++i;
        }
        return new JgclBsplineSurface3D(this.uKnotData, this.vKnotData, tControlPoints, this.weights);
    }

    protected void output(PrintWriter writer, int indent) {
        int j;
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        this.uKnotData.output(writer, indent, 1);
        this.vKnotData.output(writer, indent, 2);
        writer.println(String.valueOf(indent_tab) + "\tcontrolPoints");
        int i = 0;
        while (i < this.controlPoints.length) {
            j = 0;
            while (j < this.controlPoints[i].length) {
                this.controlPoints[i][j].output(writer, indent + 2);
                ++j;
            }
            ++i;
        }
        if (this.weights() != null) {
            writer.println(String.valueOf(indent_tab) + "\tweights ");
            j = 0;
            while (j < this.weights().length) {
                writer.print(String.valueOf(indent_tab) + "\t\t");
                int k = 0;
                while (k < this.weights()[j].length) {
                    writer.print(" " + this.weightAt(j, k));
                    ++k;
                }
                writer.println();
                ++j;
            }
        }
        writer.println(String.valueOf(indent_tab) + "\tsurfaceForm\t" + JgclBsplineSurfaceForm.toString(this.surfaceForm));
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

