/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator;
import jp.go.ipa.jgcl.JgclGeometrySchemaFunction;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclCartesianTransformationOperator3D
extends JgclCartesianTransformationOperator {
    private JgclVector3D axis1;
    private JgclVector3D axis2;
    private JgclVector3D axis3;
    private JgclPoint3D localOrigin;
    private JgclVector3D[] u;

    public JgclCartesianTransformationOperator3D(JgclVector3D axis1, JgclVector3D axis2, JgclVector3D axis3, JgclPoint3D localOrigin, double scale) {
        super(scale);
        this.setFields(axis1, axis2, axis3, localOrigin);
    }

    public JgclCartesianTransformationOperator3D(JgclAxis2Placement3D position, double scale) {
        super(scale);
        this.fromAxis2Placement(position);
    }

    public JgclCartesianTransformationOperator3D(JgclAxis2Placement3D position) {
        super(1.0);
        this.fromAxis2Placement(position);
    }

    private void setFields(JgclVector3D axis1, JgclVector3D axis2, JgclVector3D axis3, JgclPoint3D localOrigin) {
        if (localOrigin == null) {
            throw new JgclInvalidArgumentValue();
        }
        this.localOrigin = localOrigin;
        this.axis1 = axis1;
        this.axis2 = axis2;
        this.axis3 = axis3;
    }

    private void fromAxis2Placement(JgclAxis2Placement3D position) {
        if (position == null) {
            throw new JgclInvalidArgumentValue();
        }
        this.u = position.axes();
        this.localOrigin = position.location();
        this.axis1 = this.u1();
        this.axis2 = this.u2();
        this.axis3 = this.u3();
    }

    public int dimension() {
        return 3;
    }

    public JgclVector3D axis1() {
        return this.axis1;
    }

    public JgclVector3D axis2() {
        return this.axis2;
    }

    public JgclVector3D axis3() {
        return this.axis3;
    }

    public JgclPoint3D localOrigin() {
        return this.localOrigin;
    }

    public JgclVector3D u1() {
        if (this.u == null) {
            this.u();
        }
        return this.u[0];
    }

    public JgclVector3D u2() {
        if (this.u == null) {
            this.u();
        }
        return this.u[1];
    }

    public JgclVector3D u3() {
        if (this.u == null) {
            this.u();
        }
        return this.u[2];
    }

    public JgclVector3D[] u() {
        if (this.u == null) {
            this.u = JgclGeometrySchemaFunction.baseAxis(this.axis1, this.axis2, this.axis3);
        }
        return (JgclVector3D[])this.u.clone();
    }

    public JgclVector3D transform(JgclVector3D vector) {
        double x = this.scale() * (vector.x() * this.u1().x() + vector.y() * this.u2().x() + vector.z() * this.u3().x());
        double y = this.scale() * (vector.x() * this.u1().y() + vector.y() * this.u2().y() + vector.z() * this.u3().y());
        double z = this.scale() * (vector.x() * this.u1().z() + vector.y() * this.u2().z() + vector.z() * this.u3().z());
        return new JgclLiteralVector3D(x, y, z);
    }

    public JgclPoint3D transform(JgclPoint3D point) {
        double x = this.localOrigin.x() + this.scale() * (point.x() * this.u1().x() + point.y() * this.u2().x() + point.z() * this.u3().x());
        double y = this.localOrigin.y() + this.scale() * (point.x() * this.u1().y() + point.y() * this.u2().y() + point.z() * this.u3().y());
        double z = this.localOrigin.z() + this.scale() * (point.x() * this.u1().z() + point.y() * this.u2().z() + point.z() * this.u3().z());
        return new JgclCartesianPoint3D(x, y, z);
    }

    public JgclVector3D transform(JgclVector3D vector, Hashtable transformedGeometries) {
        return vector.transformBy(this, transformedGeometries);
    }

    public JgclPoint3D transform(JgclPoint3D point, Hashtable transformedGeometries) {
        return point.transformBy(this, transformedGeometries);
    }

    public JgclParametricCurve3D transform(JgclParametricCurve3D curve, Hashtable transformedGeometries) {
        return curve.transformBy(this, transformedGeometries);
    }

    public JgclParametricSurface3D transform(JgclParametricSurface3D surface, Hashtable transformedGeometries) {
        return surface.transformBy(this, transformedGeometries);
    }

    public JgclVector3D reverseTransform(JgclVector3D vector) {
        double x = (vector.x() * this.u1().x() + vector.y() * this.u1().y() + vector.z() * this.u1().z()) / this.scale();
        double y = (vector.x() * this.u2().x() + vector.y() * this.u2().y() + vector.z() * this.u2().z()) / this.scale();
        double z = (vector.x() * this.u3().x() + vector.y() * this.u3().y() + vector.z() * this.u3().z()) / this.scale();
        return new JgclLiteralVector3D(x, y, z);
    }

    public JgclPoint3D reverseTransform(JgclPoint3D point) {
        JgclVector3D wk = point.subtract(this.localOrigin);
        double x = (wk.x() * this.u1().x() + wk.y() * this.u1().y() + wk.z() * this.u1().z()) / this.scale();
        double y = (wk.x() * this.u2().x() + wk.y() * this.u2().y() + wk.z() * this.u2().z()) / this.scale();
        double z = (wk.x() * this.u3().x() + wk.y() * this.u3().y() + wk.z() * this.u3().z()) / this.scale();
        return new JgclCartesianPoint3D(x, y, z);
    }

    public JgclVector3D reverseTransform(JgclVector3D vector, Hashtable transformedGeometries) {
        return vector.reverseTransformBy(this, transformedGeometries);
    }

    public JgclPoint3D reverseTransform(JgclPoint3D point, Hashtable transformedGeometries) {
        return point.reverseTransformBy(this, transformedGeometries);
    }

    public JgclParametricCurve3D reverseTransform(JgclParametricCurve3D curve, Hashtable transformedGeometries) {
        return curve.reverseTransformBy(this, transformedGeometries);
    }

    public JgclParametricSurface3D reverseTransform(JgclParametricSurface3D surface, Hashtable transformedGeometries) {
        return surface.reverseTransformBy(this, transformedGeometries);
    }

    public JgclVector3D toEnclosed(JgclVector3D vector) {
        return this.transform(vector);
    }

    public JgclPoint3D toEnclosed(JgclPoint3D point) {
        return this.transform(point);
    }

    public JgclVector3D toEnclosed(JgclVector3D vector, Hashtable transformedGeometries) {
        return this.transform(vector, transformedGeometries);
    }

    public JgclPoint3D toEnclosed(JgclPoint3D point, Hashtable transformedGeometries) {
        return this.transform(point, transformedGeometries);
    }

    public JgclParametricCurve3D toEnclosed(JgclParametricCurve3D curve, Hashtable transformedGeometries) {
        return this.transform(curve, transformedGeometries);
    }

    public JgclParametricSurface3D toEnclosed(JgclParametricSurface3D surface, Hashtable transformedGeometries) {
        return this.transform(surface, transformedGeometries);
    }

    public JgclVector3D toLocal(JgclVector3D vector) {
        return this.reverseTransform(vector);
    }

    public JgclPoint3D toLocal(JgclPoint3D point) {
        return this.reverseTransform(point);
    }

    public JgclVector3D toLocal(JgclVector3D vector, Hashtable transformedGeometries) {
        return this.reverseTransform(vector, transformedGeometries);
    }

    public JgclPoint3D toLocal(JgclPoint3D point, Hashtable transformedGeometries) {
        return this.reverseTransform(point, transformedGeometries);
    }

    public JgclParametricCurve3D toLocal(JgclParametricCurve3D curve, Hashtable transformedGeometries) {
        return this.reverseTransform(curve, transformedGeometries);
    }

    public JgclParametricSurface3D toLocal(JgclParametricSurface3D surface, Hashtable transformedGeometries) {
        return this.reverseTransform(surface, transformedGeometries);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tscale\t" + this.scale());
        if (this.axis1 != null) {
            writer.println(String.valueOf(indent_tab) + "\taxis1");
            this.axis1.output(writer, indent + 2);
        }
        if (this.axis2 != null) {
            writer.println(String.valueOf(indent_tab) + "\taxis2");
            this.axis2.output(writer, indent + 2);
        }
        if (this.axis3 != null) {
            writer.println(String.valueOf(indent_tab) + "\taxis3");
            this.axis3.output(writer, indent + 2);
        }
        writer.println(String.valueOf(indent_tab) + "\tlocalOrigin");
        this.localOrigin.output(writer, indent + 2);
        writer.println("End");
    }
}

