/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclBoundedCurve2D;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCommonNormal2D;
import jp.go.ipa.jgcl.JgclCommonTangent2D;
import jp.go.ipa.jgcl.JgclCompositeCurve2D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment2D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclConic2D;
import jp.go.ipa.jgcl.JgclCurveCurvature2D;
import jp.go.ipa.jgcl.JgclCurveDerivative2D;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntsCirCnc2D;
import jp.go.ipa.jgcl.JgclIntsLinCnc2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclOfst2D;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclZeroLength;

public class JgclCircle2D
extends JgclConic2D {
    private double radius;

    private void setRadius(double radius) {
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        if (radius < dTol) {
            throw new JgclInvalidArgumentValue();
        }
        this.radius = radius;
    }

    public JgclCircle2D(JgclAxis2Placement2D position, double radius) {
        super(position);
        this.setRadius(radius);
    }

    public JgclCircle2D(JgclPoint2D center, double radius) {
        super(new JgclAxis2Placement2D(center, JgclVector2D.xUnitVector));
        this.setRadius(radius);
    }

    public JgclCircle2D(JgclPoint2D pnt1, JgclPoint2D pnt2, JgclPoint2D pnt3) {
        super(new JgclAxis2Placement2D(JgclPoint2D.center(pnt1, pnt2, pnt3), JgclVector2D.xUnitVector));
        this.setRadius(this.position().location().subtract(pnt1).length());
    }

    public double radius() {
        return this.radius;
    }

    public double length(JgclParameterSection pint) {
        return this.radius() * Math.abs(pint.increase());
    }

    public JgclPoint2D coordinates(double param) {
        param = this.parameterDomain().wrap(param);
        JgclPoint2D center = this.position().location();
        double ecos = Math.cos(param) * this.radius;
        double esin = Math.sin(param) * this.radius;
        JgclVector2D x = this.position().x().multiply(ecos);
        JgclVector2D y = this.position().y().multiply(esin);
        return center.add(x.add(y));
    }

    public JgclVector2D tangentVector(double param) {
        param = this.parameterDomain().wrap(param);
        double ecos = Math.cos(param) * this.radius;
        double esin = Math.sin(param) * this.radius;
        JgclVector2D x = this.position().x().multiply(-esin);
        JgclVector2D y = this.position().y().multiply(ecos);
        return x.add(y);
    }

    public JgclCurveCurvature2D curvature(double param) {
        param = this.parameterDomain().wrap(param);
        double ucos = Math.cos(param);
        double usin = Math.sin(param);
        JgclVector2D x = this.position().x().multiply(-ucos);
        JgclVector2D y = this.position().y().multiply(-usin);
        return new JgclCurveCurvature2D(1.0 / this.radius, x.add(y));
    }

    public JgclCurveDerivative2D evaluation(double param) {
        param = this.parameterDomain().wrap(param);
        double ecos = Math.cos(param) * this.radius;
        double esin = Math.sin(param) * this.radius;
        JgclPoint2D center = this.position().location();
        JgclVector2D xcos = this.position().x().multiply(ecos);
        JgclVector2D ysin = this.position().y().multiply(esin);
        JgclVector2D xsin = this.position().x().multiply(esin);
        JgclVector2D ycos = this.position().y().multiply(ecos);
        JgclPoint2D d0 = center.add(xcos.add(ysin));
        JgclVector2D d1 = ycos.add(xsin.multiply(-1.0));
        JgclVector2D d2 = xcos.add(ysin).multiply(-1.0);
        return new JgclCurveDerivative2D(d0, d1, d2);
    }

    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point) throws JgclIndefiniteSolution {
        double eangle2;
        JgclVector2D eduvec = point.subtract(this.position().location());
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        if (eduvec.length() < dTol) {
            JgclPointOnCurve2D p;
            try {
                p = new JgclPointOnCurve2D(this, 0.0, false);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            throw new JgclIndefiniteSolution(p);
        }
        eduvec = eduvec.unitized();
        JgclVector2D x_axis = this.position().x();
        double eangle = Math.acos(x_axis.dotProduct(eduvec));
        if (x_axis.zOfCrossProduct(eduvec) < 0.0) {
            eangle = Math.PI * 2 - eangle;
        }
        if ((eangle2 = eangle + Math.PI) >= Math.PI * 2) {
            eangle2 -= Math.PI * 2;
        }
        try {
            JgclPointOnCurve2D[] prj = new JgclPointOnCurve2D[]{new JgclPointOnCurve2D(this, eangle, false), new JgclPointOnCurve2D(this, eangle2, false)};
            return prj;
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    double getPeak(double left, double right) {
        throw new JgclFatal();
    }

    public JgclPolyline2D toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol) {
        double sa = this.parameterDomain().wrap(pint.start());
        double inc = pint.increase();
        int no_intvls = JgclCircle2D.toPolylineNDivision(this.radius(), inc, tol);
        double atheta = inc / (double)no_intvls;
        JgclPoint2D[] pnts = new JgclPoint2D[no_intvls + 1];
        int i = 0;
        while (i < no_intvls + 1) {
            pnts[i] = new JgclPointOnCurve2D(this, sa + atheta * (double)i, false);
            ++i;
        }
        if (no_intvls == 1 && pnts[0].identical(pnts[1])) {
            throw new JgclZeroLength();
        }
        return new JgclPolyline2D(pnts);
    }

    static int toPolylineNDivision(double radius, double increase, JgclToleranceForDistance tol) {
        double etheta = 2.0 * Math.acos((radius - Math.abs(tol.value())) / radius);
        return Math.round((float)Math.floor(Math.abs(increase) / etheta)) + 1;
    }

    private JgclPureBezierCurve2D[] toPolyBezierCurves(int nCurves, double increaseP, JgclParameterSection pint) {
        JgclPureBezierCurve2D[] bzcs = new JgclPureBezierCurve2D[nCurves];
        int i = 0;
        double startP = pint.start();
        while (i < nCurves) {
            JgclParameterSection pintl = new JgclParameterSection(startP, increaseP);
            JgclPoint2D[] controlPoints = this.getControlPointsOfBezierCurve(pintl);
            double[] weights = new double[]{1.0, 1.0, 1.0};
            double shoulderParam = (pintl.lower() + pintl.upper()) / 2.0;
            JgclPoint2D shoulderPoint = this.coordinates(shoulderParam);
            JgclPoint2D middlePoint = controlPoints[0].midPoint(controlPoints[2]);
            double vvv = Math.sqrt(shoulderPoint.subtract(middlePoint).norm() / controlPoints[1].subtract(middlePoint).norm());
            weights[1] = vvv / (1.0 - vvv);
            bzcs[i] = new JgclPureBezierCurve2D(controlPoints, weights);
            ++i;
            startP += increaseP;
        }
        return bzcs;
    }

    public JgclPureBezierCurve2D[] toPolyBezierCurves(JgclParameterSection pint) {
        double increaseP;
        int nCurves;
        double increase = pint.increase();
        if (Math.abs(increase) > Math.PI * 2) {
            nCurves = 3;
            increaseP = increase > 0.0 ? 2.0943951023931953 : -2.0943951023931953;
        } else if (Math.abs(increase) > 5.026548245743669) {
            nCurves = 3;
            increaseP = increase / 3.0;
        } else if (Math.abs(increase) > 2.5132741228718345) {
            nCurves = 2;
            increaseP = increase / 2.0;
        } else {
            nCurves = 1;
            increaseP = increase;
        }
        return this.toPolyBezierCurves(nCurves, increaseP, pint);
    }

    JgclPureBezierCurve2D[] toPolyBezierCurvesOfN(int nCurves, JgclParameterSection pint) {
        double increase = pint.increase();
        double increaseP = increase / (double)nCurves;
        switch (nCurves) {
            case 3: {
                if (!(Math.abs(increase) > Math.PI * 2)) break;
                increaseP = increase > 0.0 ? 2.0943951023931953 : -2.0943951023931953;
                break;
            }
            case 2: {
                if (!(Math.abs(increase) > 5.026548245743669)) break;
                throw new JgclFatal("Can not convert with given parameters");
            }
            case 1: {
                if (Math.abs(increase) > 2.5132741228718345) {
                    throw new JgclFatal("Can not convert with given parameters");
                }
                increaseP = increase;
                break;
            }
            default: {
                throw new JgclParameterOutOfRange("value of nCurves is out of range");
            }
        }
        return this.toPolyBezierCurves(nCurves, increaseP, pint);
    }

    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
        JgclPureBezierCurve2D[] bzcs = this.toPolyBezierCurves(pint);
        boolean closed = Math.abs(pint.increase()) >= Math.PI * 2;
        return JgclConic2D.convertPolyBezierCurvesToOneBsplineCurve(bzcs, closed);
    }

    JgclBsplineCurve2D toBsplineCurveOfNSegments(int nSegments, JgclParameterSection pint) {
        JgclPureBezierCurve2D[] bzcs = this.toPolyBezierCurvesOfN(nSegments, pint);
        boolean closed = Math.abs(pint.increase()) >= Math.PI * 2;
        return JgclConic2D.convertPolyBezierCurvesToOneBsplineCurve(bzcs, closed);
    }

    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
        JgclRealPolynomial xPoly = poly[0].multiply(poly[0]);
        JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
        double rad2 = this.radius() * this.radius();
        boolean isPoly = poly.length < 3;
        int degree = xPoly.degree();
        double[] coef = new double[degree + 1];
        if (isPoly) {
            int j = 0;
            while (j <= degree) {
                coef[j] = xPoly.coefficientAt(j) + yPoly.coefficientAt(j);
                ++j;
            }
            coef[0] = coef[0] - rad2;
        } else {
            JgclRealPolynomial wPoly = poly[2].multiply(poly[2]);
            int j = 0;
            while (j <= degree) {
                coef[j] = xPoly.coefficientAt(j) + yPoly.coefficientAt(j) - rad2 * wPoly.coefficientAt(j);
                ++j;
            }
        }
        return new JgclRealPolynomial(coef);
    }

    boolean checkSolution(JgclPoint2D point) {
        double dTol = this.getToleranceForDistance();
        return Math.abs(point.toVector2D().length() - this.radius()) < dTol;
    }

    double getParameter(JgclPoint2D point) {
        double cos = point.x() / this.radius();
        if (cos > 1.0) {
            cos = 1.0;
        }
        if (cos < -1.0) {
            cos = -1.0;
        }
        double acos = Math.acos(cos);
        if (point.y() < 0.0) {
            acos = Math.PI * 2 - acos;
        }
        return acos;
    }

    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
        JgclIntsLinCnc2D doObj = new JgclIntsLinCnc2D(mate, this);
        return doObj.intersection(mate, this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclPoint2D center1 = this.position().location();
        JgclPoint2D center2 = mate.position().location();
        JgclVector2D evec = center2.subtract(center1);
        double edist = evec.length();
        double egap1 = edist - (this.radius() + mate.radius());
        double egap2 = Math.abs(this.radius() - mate.radius()) - edist;
        double dTol = this.getToleranceForDistance();
        if (egap1 > dTol || egap2 > dTol) {
            return new JgclIntersectionPoint2D[0];
        }
        evec = evec.unitized();
        if (egap1 > -dTol) {
            JgclPoint2D pnt1 = center1.add(evec.multiply(this.radius()));
            JgclPoint2D pnt2 = center2.add(evec.multiply(-mate.radius()));
            pnt1 = pnt1.linearInterpolate(pnt2, 0.5);
            JgclIntersectionPoint2D[] pnts = new JgclIntersectionPoint2D[]{new JgclIntersectionPoint2D(this, this.pointToParameter(pnt1), mate, mate.pointToParameter(pnt1), false)};
            if (doExchange) {
                pnts[0] = pnts[0].exchange();
            }
            return pnts;
        }
        if (egap2 > -dTol) {
            egap2 = this.radius() - mate.radius();
            if (Math.abs(egap2) < dTol) {
                JgclIntersectionPoint2D ip = new JgclIntersectionPoint2D(this, 0.0, mate, 0.0, false);
                if (doExchange) {
                    ip = ip.exchange();
                }
                throw new JgclIndefiniteSolution(ip);
            }
            if (egap2 < 0.0) {
                evec = evec.multiply(-1.0);
            }
            JgclPoint2D pnt1 = center1.add(evec.multiply(this.radius()));
            JgclPoint2D pnt2 = center2.add(evec.multiply(mate.radius()));
            pnt1 = pnt1.linearInterpolate(pnt2, 0.5);
            JgclIntersectionPoint2D[] pnts = new JgclIntersectionPoint2D[]{new JgclIntersectionPoint2D(this, this.pointToParameter(pnt1), mate, mate.pointToParameter(pnt1), false)};
            if (doExchange) {
                pnts[0] = pnts[0].exchange();
            }
            return pnts;
        }
        double edfatl = (this.radius() * this.radius() - mate.radius() * mate.radius() + edist * edist) / (2.0 * edist);
        double e2dfatl = Math.sqrt(this.radius() * this.radius() - edfatl * edfatl);
        JgclPoint2D eill = center1.add(evec.multiply(edfatl));
        JgclVector2D elvec = evec.verticalVector();
        JgclPoint2D pnt1 = eill.add(elvec.multiply(e2dfatl));
        JgclPoint2D pnt2 = eill.add(elvec.multiply(-e2dfatl));
        JgclIntersectionPoint2D[] pnts = new JgclIntersectionPoint2D[]{new JgclIntersectionPoint2D(this, this.pointToParameter(pnt1), mate, mate.pointToParameter(pnt1), false), new JgclIntersectionPoint2D(this, this.pointToParameter(pnt2), mate, mate.pointToParameter(pnt2), false)};
        if (doExchange) {
            int i = 0;
            while (i < 2) {
                pnts[i] = pnts[i].exchange();
                ++i;
            }
        }
        return pnts;
    }

    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
        JgclIntsCirCnc2D doObj = new JgclIntsCirCnc2D();
        return doObj.intersection(this, mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
        JgclIntsCirCnc2D doObj = new JgclIntsCirCnc2D();
        return doObj.intersection(this, mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
        JgclIntsCirCnc2D doObj = new JgclIntsCirCnc2D();
        return doObj.intersection(this, mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclBsplineCurve2D offsetByBsplineCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        JgclOfst2D doObj = new JgclOfst2D(this, pint, magni, side, tol);
        return doObj.offset();
    }

    public JgclBoundedCurve2D offsetByBoundedCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        JgclCircle2D basisCircle;
        if (side == 1) {
            basisCircle = new JgclCircle2D(this.position(), this.radius() + magni);
        } else if (!(magni > this.radius)) {
            basisCircle = new JgclCircle2D(this.position(), this.radius() - magni);
        } else {
            basisCircle = new JgclCircle2D(this.position(), magni - this.radius());
            pint = new JgclParameterSection(this.parameterDomain().wrap(pint.start() + Math.PI), pint.increase());
        }
        return new JgclTrimmedCurve2D(basisCircle, pint);
    }

    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    public JgclCommonNormal2D[] commonNormal(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    JgclParameterDomain getParameterDomain() {
        try {
            return new JgclParameterDomain(true, 0.0, Math.PI * 2);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    boolean getClosedFlag() {
        return true;
    }

    int type() {
        return 10;
    }

    protected synchronized JgclParametricCurve2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        JgclAxis2Placement2D tPosition = this.position().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        double tRadius = !reverseTransform ? transformationOperator.transform(this.radius()) : transformationOperator.reverseTransform(this.radius());
        return new JgclCircle2D(tPosition, tRadius);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tposition");
        this.position().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tradius " + this.radius);
        writer.println(String.valueOf(indent_tab) + "End");
    }

    public static JgclTrimmedCurve2D makeTrimmedCurve(JgclPoint2D center, JgclPoint2D startPoint, JgclPoint2D endPoint) {
        JgclVector2D sVec = startPoint.subtract(center);
        JgclVector2D eVec = endPoint.subtract(center);
        double radius = (sVec.length() + eVec.length()) / 2.0;
        double iParam = (sVec = sVec.unitized()).angleWith(eVec = eVec.unitized());
        if (Math.abs(iParam) > Math.PI) {
            iParam -= Math.PI * 2;
        }
        return new JgclTrimmedCurve2D(new JgclCircle2D(new JgclAxis2Placement2D(center, sVec), radius), new JgclParameterSection(0.0, iParam));
    }
}

