/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclMachineEpsilon;
import jp.go.ipa.jgcl.JgclMath;

public class JgclComplex
implements Cloneable {
    private final double re;
    private final double im;

    public JgclComplex() {
        this.re = 0.0;
        this.im = 0.0;
    }

    public JgclComplex(double r, double i) {
        this.re = r;
        this.im = i;
    }

    public JgclComplex(double r) {
        this.re = r;
        this.im = 0.0;
    }

    public double real() {
        return this.re;
    }

    public double imag() {
        return this.im;
    }

    public JgclComplex copy() {
        return new JgclComplex(this.re, this.im);
    }

    public JgclComplex minus() {
        return new JgclComplex(-this.re, -this.im);
    }

    public JgclComplex add(JgclComplex mate) {
        return new JgclComplex(this.re + mate.re, this.im + mate.im);
    }

    public JgclComplex sub(JgclComplex mate) {
        return new JgclComplex(this.re - mate.re, this.im - mate.im);
    }

    public JgclComplex mul(JgclComplex mate) {
        return new JgclComplex(this.re * mate.re - this.im * mate.im, this.re * mate.im + this.im * mate.re);
    }

    public JgclComplex mul(double mate) {
        return new JgclComplex(this.re * mate, this.im * mate);
    }

    public JgclComplex div(JgclComplex mate) {
        double denom = mate.re * mate.re + mate.im * mate.im;
        return new JgclComplex((this.re * mate.re + this.im * mate.im) / denom, (this.im * mate.re - this.re * mate.im) / denom);
    }

    public JgclComplex div(double mate) {
        return new JgclComplex(this.re / mate, this.im / mate);
    }

    public double abs() {
        return Math.sqrt(this.re * this.re + this.im * this.im);
    }

    public double arg() {
        return Math.atan2(this.im, this.re);
    }

    public JgclComplex conj() {
        return new JgclComplex(this.re, -this.im);
    }

    public JgclComplex exp() {
        return new JgclComplex(Math.exp(this.re) * Math.cos(this.im), Math.exp(this.re) * Math.sin(this.im));
    }

    public JgclComplex sqrt() {
        double e = Math.sqrt(this.abs());
        double f = this.arg() / 2.0;
        return new JgclComplex(e * Math.cos(f), e * Math.sin(f));
    }

    public String toString() {
        return "(" + this.re + ", " + this.im + ")";
    }

    public final JgclComplex getEpsilon() {
        double meps = JgclMachineEpsilon.DOUBLE / Math.sqrt(2.0);
        return new JgclComplex(JgclMath.copySign(meps, this.re), JgclMath.copySign(meps, this.im));
    }
}

