/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBoundedCurve2D;
import jp.go.ipa.jgcl.JgclBoundedLine2D;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCommonNormal2D;
import jp.go.ipa.jgcl.JgclCommonTangent2D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment2D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCurveCurvature2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterferenceList;
import jp.go.ipa.jgcl.JgclCurveDerivative2D;
import jp.go.ipa.jgcl.JgclDivideCmcIntoSimpleLoops2D;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclFilletObject2D;
import jp.go.ipa.jgcl.JgclFilletObjectList;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclOpenCurve;
import jp.go.ipa.jgcl.JgclOverlapCurve2D;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPointOnGeometryList;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;
import jp.go.ipa.jgcl.JgclTwoGeomertiesAreNotContinuous;
import jp.go.ipa.jgcl.JgclUtil;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclZeroLength;

public class JgclCompositeCurve2D
extends JgclBoundedCurve2D {
    private JgclCompositeCurveSegment2D[] segments;
    private boolean periodic;
    private double[] localStartParams;
    private double[] globalStartParams;

    public JgclCompositeCurve2D(JgclCompositeCurveSegment2D[] segments, boolean periodic) {
        this.segments = new JgclCompositeCurveSegment2D[segments.length];
        this.periodic = periodic;
        this.localStartParams = new double[segments.length];
        this.globalStartParams = new double[segments.length + 1];
        this.globalStartParams[0] = 0.0;
        int i = 0;
        while (i < segments.length) {
            JgclCompositeCurveSegment2D seg = segments[i];
            JgclParameterSection sec = seg.parameterDomain().section();
            this.segments[i] = seg;
            this.localStartParams[i] = sec.start();
            this.globalStartParams[i + 1] = this.globalStartParams[i] + sec.increase();
            ++i;
        }
    }

    public JgclCompositeCurve2D(JgclBoundedCurve2D[] segments, boolean[] sense) {
        if (segments.length != sense.length) {
            throw new JgclInvalidArgumentValue();
        }
        double dTol = JgclConditionOfOperation.getCondition().getToleranceForDistance();
        this.segments = new JgclCompositeCurveSegment2D[segments.length];
        this.localStartParams = new double[segments.length];
        this.globalStartParams = new double[segments.length + 1];
        this.globalStartParams[0] = 0.0;
        int transition = 4;
        int i = 0;
        while (i < segments.length) {
            int j = i + 1 == segments.length ? 0 : i + 1;
            JgclBoundedCurve2D pseg = segments[i];
            JgclBoundedCurve2D nseg = segments[j];
            JgclParameterSection psec = pseg.parameterDomain().section();
            JgclParameterSection nsec = nseg.parameterDomain().section();
            double pp = sense[i] ? psec.end() : psec.start();
            double np = sense[j] ? nsec.start() : nsec.end();
            JgclCurveDerivative2D pder = pseg.evaluation(pp);
            JgclCurveDerivative2D nder = nseg.evaluation(np);
            double pcur = pseg.curvature(pp).curvature();
            double ncur = nseg.curvature(np).curvature();
            transition = !pder.d0D().identical(nder.d0D()) ? 0 : (!pder.d1D().identicalDirection(nder.d1D()) ? 1 : (Math.abs(pcur - ncur) >= dTol ? 1 : 1));
            if (j != 0 && transition == 0) {
                throw new JgclInvalidArgumentValue();
            }
            this.segments[i] = new JgclCompositeCurveSegment2D(transition, sense[i], pseg);
            this.localStartParams[i] = psec.start();
            this.globalStartParams[i + 1] = this.globalStartParams[i] + psec.increase();
            ++i;
        }
        this.periodic = transition != 0;
    }

    JgclCompositeCurveSegment2D[] segments() {
        return (JgclCompositeCurveSegment2D[])this.segments.clone();
    }

    JgclCompositeCurveSegment2D[] decomposeAsSegmentsRecursively() {
        Vector<JgclCompositeCurveSegment2D> resultList = new Vector<JgclCompositeCurveSegment2D>();
        int i = 0;
        while (i < this.nSegments()) {
            JgclCompositeCurveSegment2D segment = this.segmentAt(i);
            JgclBoundedCurve2D parent = segment.parentCurve();
            if (parent.type() == 24) {
                JgclCompositeCurveSegment2D revised;
                int j;
                JgclCompositeCurve2D parentCmc = (JgclCompositeCurve2D)parent;
                JgclCompositeCurveSegment2D[] parentSegments = parentCmc.decomposeAsSegmentsRecursively();
                if (segment.sameSense()) {
                    j = 0;
                    while (j < parentSegments.length - 1) {
                        resultList.addElement(parentSegments[j]);
                        ++j;
                    }
                    revised = parentSegments[j].makeCopyWithTransition(segment.transition());
                    resultList.addElement(revised);
                } else {
                    j = parentSegments.length - 1;
                    while (j > 0) {
                        revised = parentSegments[j].makeReverseWithTransition(parentSegments[j - 1].transition());
                        resultList.addElement(revised);
                        --j;
                    }
                    revised = parentSegments[j].makeReverseWithTransition(segment.transition());
                    resultList.addElement(revised);
                }
            } else {
                resultList.addElement(segment);
            }
            ++i;
        }
        Object[] result = new JgclCompositeCurveSegment2D[resultList.size()];
        resultList.copyInto(result);
        return result;
    }

    public boolean periodic() {
        return this.periodic;
    }

    public int nSegments() {
        return this.segments.length;
    }

    public JgclCompositeCurveSegment2D segmentAt(int ith) {
        return this.segments[ith];
    }

    private CompositeIndexParam getIndexParam(double param) {
        JgclParameterDomain domain = this.parameterDomain();
        CompositeIndexParam ip = new CompositeIndexParam();
        this.checkValidity(param);
        param = domain.wrap(param);
        ip.index = JgclUtil.bsearchDoubleArray(this.globalStartParams, 1, this.nSegments() - 1, param);
        ip.param = this.localStartParams[ip.index] + (param - this.globalStartParams[ip.index]);
        return ip;
    }

    private double getCompositeParam(int index, double param) {
        return this.globalStartParams[index] + (param - this.localStartParams[index]);
    }

    public JgclPoint2D startPoint() {
        if (this.isPeriodic()) {
            return null;
        }
        return this.segments[0].startPoint();
    }

    public JgclPoint2D endPoint() {
        if (this.isPeriodic()) {
            return null;
        }
        int n = this.nSegments();
        return this.segments[n - 1].endPoint();
    }

    public double length(JgclParameterSection pint) {
        LengthAccumulator acc = new LengthAccumulator();
        acc.accumulate(pint);
        return acc.extract();
    }

    public JgclPoint2D coordinates(double param) {
        CompositeIndexParam ip = this.getIndexParam(param);
        return this.segments[ip.index].coordinates(ip.param);
    }

    public JgclVector2D tangentVector(double param) {
        CompositeIndexParam ip = this.getIndexParam(param);
        return this.segments[ip.index].tangentVector(ip.param);
    }

    public JgclCurveCurvature2D curvature(double param) {
        CompositeIndexParam ip = this.getIndexParam(param);
        return this.segments[ip.index].curvature(ip.param);
    }

    public JgclCurveDerivative2D evaluation(double param) {
        CompositeIndexParam ip = this.getIndexParam(param);
        return this.segments[ip.index].evaluation(ip.param);
    }

    public JgclPointOnCurve2D[] singular() throws JgclIndefiniteSolution {
        SingularAccumulator acc = new SingularAccumulator(this);
        try {
            acc.accumulate(this.parameterDomain().section());
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        return acc.extract();
    }

    public JgclPointOnCurve2D[] inflexion() throws JgclIndefiniteSolution {
        InflexionAccumulator acc = new InflexionAccumulator(this);
        try {
            acc.accumulate(this.parameterDomain().section());
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        return acc.extract();
    }

    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point) throws JgclIndefiniteSolution {
        ProjectionAccumulator acc = new ProjectionAccumulator(point, this);
        try {
            acc.accumulate(this.parameterDomain().section());
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        return acc.extract();
    }

    public JgclPolyline2D toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol) {
        if (pint.increase() < 0.0) {
            return this.toPolyline(pint.reverse(), tol).reverse();
        }
        ToPolylineAccumulator accm = new ToPolylineAccumulator(tol, this);
        accm.accumulate(pint);
        return accm.extract();
    }

    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
        ToBsplineCurveAccumulator accm = new ToBsplineCurveAccumulator();
        accm.accumulate(pint.positiveIncrease());
        JgclBsplineCurve2D result = accm.extract();
        if (pint.increase() < 0.0) {
            result = result.reverse();
        }
        return result;
    }

    private JgclIntersectionPoint2D[] doIntersect(JgclParametricCurve2D mate, boolean doExchange) {
        IntersectionAccumulator acc = new IntersectionAccumulator(mate, this);
        acc.accumulate(this.parameterDomain().section());
        return acc.extract(doExchange);
    }

    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) {
        return this.doIntersect(mate, false);
    }

    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    public JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate) {
        return this.getInterference(mate, false);
    }

    private JgclCurveCurveInterference2D[] getInterference(JgclBoundedCurve2D mate, boolean doExchange) {
        JgclCurveCurveInterferenceList interferenceList = new JgclCurveCurveInterferenceList(this, mate);
        int i = 0;
        while (i < this.nSegments()) {
            JgclCurveCurveInterference2D[] localInterferences = this.segmentAt(i).interfere(mate, false);
            Vector intsList = JgclCurveCurveInterferenceList.extractIntersections(localInterferences);
            Enumeration e = intsList.elements();
            while (e.hasMoreElements()) {
                JgclIntersectionPoint2D ints = (JgclIntersectionPoint2D)e.nextElement();
                interferenceList.addAsIntersection(ints.coordinates(), ints.pointOnCurve1().parameter(), this.getCompositeParam(i, ints.pointOnCurve2().parameter()));
            }
            Vector ovlpList = JgclCurveCurveInterferenceList.extractOverlaps(localInterferences);
            Enumeration e2 = ovlpList.elements();
            while (e2.hasMoreElements()) {
                JgclOverlapCurve2D ovlp = (JgclOverlapCurve2D)e2.nextElement();
                interferenceList.addAsOverlap(ovlp.start1(), this.getCompositeParam(i, ovlp.start2()), ovlp.increase1(), ovlp.increase2());
            }
            ++i;
        }
        interferenceList.removeOverlapsContainedInOtherOverlap();
        interferenceList.removeIntersectionsContainedInOverlap();
        return interferenceList.toJgclCurveCurveInterference2DArray(doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclBoundedLine2D mate, boolean doExchange) {
        return this.getInterference(mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclPolyline2D mate, boolean doExchange) {
        return this.getInterference(mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclPureBezierCurve2D mate, boolean doExchange) {
        return this.getInterference(mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclBsplineCurve2D mate, boolean doExchange) {
        return this.getInterference(mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclTrimmedCurve2D mate, boolean doExchange) {
        return this.getInterference(mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return this.getInterference(mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurve2D mate, boolean doExchange) {
        return this.getInterference(mate, doExchange);
    }

    public JgclCompositeCurve2D offsetByCompositeCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        boolean offsettedIsPeriodic = false;
        if (this.isPeriodic() && this.parameterDomain().section().absIncrease() - pint.absIncrease() < this.getToleranceForParameter()) {
            offsettedIsPeriodic = true;
        }
        OffsetByCompositeCurveAccumulator accm = new OffsetByCompositeCurveAccumulator(magni, side, tol);
        accm.accumulate(pint);
        JgclBoundedCurve2D[] offsettedCurves = accm.extract();
        int nOffsettedCurves = offsettedCurves.length;
        JgclPoint2D[] vertices = accm.extract2();
        Object[] offsetted = new JgclCompositeCurveSegment2D[2 * nOffsettedCurves];
        JgclBoundedCurve2D prevOffsettedCurve = null;
        JgclBoundedCurve2D crntOffsettedCurve = null;
        JgclBoundedCurve2D firstOffsettedCurve = offsettedCurves[0];
        int i = 0;
        while (i <= nOffsettedCurves) {
            int transition;
            if (i < nOffsettedCurves) {
                crntOffsettedCurve = offsettedCurves[i];
                transition = 1;
                if (!offsettedIsPeriodic && i == nOffsettedCurves - 1) {
                    transition = 0;
                }
                offsetted[2 * i] = new JgclCompositeCurveSegment2D(transition, true, crntOffsettedCurve);
            } else {
                crntOffsettedCurve = offsettedCurves[0];
            }
            if (i != 0) {
                if (i == nOffsettedCurves && !offsettedIsPeriodic) {
                    offsetted[2 * i - 1] = null;
                } else if (prevOffsettedCurve.endPoint().identical(crntOffsettedCurve.startPoint())) {
                    offsetted[2 * i - 1] = null;
                } else {
                    JgclPoint2D center = i < nOffsettedCurves ? vertices[i] : vertices[0];
                    JgclTrimmedCurve2D offsettedCorner = JgclCircle2D.makeTrimmedCurve(center, prevOffsettedCurve.endPoint(), crntOffsettedCurve.startPoint());
                    transition = 1;
                    offsetted[2 * i - 1] = new JgclCompositeCurveSegment2D(transition, true, offsettedCorner);
                }
            }
            prevOffsettedCurve = crntOffsettedCurve;
            ++i;
        }
        Vector<Object> listOfOffsetted = new Vector<Object>();
        int i2 = 0;
        while (i2 < 2 * nOffsettedCurves) {
            if (offsetted[i2] != null) {
                listOfOffsetted.addElement(offsetted[i2]);
            }
            ++i2;
        }
        offsetted = new JgclCompositeCurveSegment2D[listOfOffsetted.size()];
        listOfOffsetted.copyInto(offsetted);
        return new JgclCompositeCurve2D((JgclCompositeCurveSegment2D[])offsetted, offsettedIsPeriodic);
    }

    public JgclBsplineCurve2D offsetByBsplineCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        JgclCompositeCurve2D cmc = this.offsetByCompositeCurve(pint, magni, side, tol);
        return cmc.toBsplineCurve();
    }

    public JgclBoundedCurve2D offsetByBoundedCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        return this.offsetByCompositeCurve(pint, magni, side, tol);
    }

    public JgclCompositeCurve2D[] divideIntoSimpleLoopsIfClosed(int cmcWise, int validSide) throws JgclOpenCurve {
        JgclDivideCmcIntoSimpleLoops2D proc = new JgclDivideCmcIntoSimpleLoops2D(this, cmcWise, validSide);
        return proc.doIt();
    }

    JgclFilletObject2D[] doFillet(JgclParameterSection pint1, int side1, JgclParametricCurve2D mate, JgclParameterSection pint2, int side2, double radius, boolean doExchange) throws JgclIndefiniteSolution {
        FilletAccumulator acc = new FilletAccumulator(mate, pint2, side2, this, side1, radius, doExchange);
        acc.accumulate(pint1);
        return acc.extract();
    }

    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    public JgclCommonNormal2D[] commonNormal(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    JgclParameterDomain getParameterDomain() {
        try {
            return new JgclParameterDomain(this.periodic, 0.0, this.globalStartParams[this.nSegments()]);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    int type() {
        return 24;
    }

    public boolean isFreeform() {
        return true;
    }

    protected synchronized JgclParametricCurve2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        JgclCompositeCurveSegment2D[] tSegments = new JgclCompositeCurveSegment2D[this.nSegments()];
        int i = 0;
        while (i < this.nSegments()) {
            tSegments[i] = (JgclCompositeCurveSegment2D)this.segmentAt(i).transformBy(reverseTransform, transformationOperator, transformedGeometries);
            ++i;
        }
        return new JgclCompositeCurve2D(tSegments, this.periodic());
    }

    protected boolean hasPolyline() {
        int i = 0;
        while (i < this.nSegments()) {
            if (this.segmentAt(i).hasPolyline()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isComposedOfOnlyPolylines() {
        int i = 0;
        while (i < this.nSegments()) {
            if (!this.segmentAt(i).isComposedOfOnlyPolylines()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tsegments");
        int i = 0;
        while (i < this.nSegments()) {
            this.segments[i].output(writer, indent + 2);
            ++i;
        }
        writer.println(String.valueOf(indent_tab) + "\tperiodic\t" + this.periodic);
        writer.println(String.valueOf(indent_tab) + "End");
    }

    class CompositeIndexParam {
        int index;
        double param;

        CompositeIndexParam() {
            JgclCompositeCurve2D.this = JgclCompositeCurve2D.this;
        }
    }

    private class LengthAccumulator
    extends SegmentAccumulator {
        double length;

        void allocate(int nsegs) {
            this.length = 0.0;
        }

        void doit(JgclCompositeCurveSegment2D seg, JgclParameterSection sec, int compIndex) {
            this.length += seg.length(sec);
        }

        double extract() {
            return this.length;
        }

        LengthAccumulator() {
            JgclCompositeCurve2D.this = JgclCompositeCurve2D.this;
        }
    }

    private class SingularAccumulator
    extends SegmentAccumulator {
        JgclCompositeCurve2D curve;
        Vector singularVec;
        JgclIndefiniteSolution inf;

        SingularAccumulator(JgclCompositeCurve2D curve) {
            JgclCompositeCurve2D.this = JgclCompositeCurve2D.this;
            this.curve = curve;
            this.inf = null;
        }

        void allocate(int nsegs) {
            this.singularVec = new Vector();
        }

        void doit(JgclCompositeCurveSegment2D seg, JgclParameterSection sec, int compIndex) {
            double param;
            JgclPointOnCurve2D[] singular;
            try {
                singular = seg.singular();
            }
            catch (JgclIndefiniteSolution e) {
                this.inf = e;
                return;
            }
            int i = 0;
            while (i < singular.length) {
                param = JgclCompositeCurve2D.this.getCompositeParam(compIndex, singular[i].parameter());
                this.singularVec.addElement(new JgclPointOnCurve2D(this.curve, param, false));
                ++i;
            }
            if (seg.transition() == 1) {
                param = JgclCompositeCurve2D.this.getCompositeParam(compIndex, sec.end());
                this.singularVec.addElement(new JgclPointOnCurve2D(this.curve, param, false));
            }
        }

        JgclPointOnCurve2D[] extract() throws JgclIndefiniteSolution {
            if (this.inf != null) {
                throw this.inf;
            }
            Object[] thisSingular = new JgclPointOnCurve2D[this.singularVec.size()];
            this.singularVec.copyInto(thisSingular);
            return thisSingular;
        }
    }

    private class InflexionAccumulator
    extends SegmentAccumulator {
        JgclCompositeCurve2D curve;
        Vector inflexionVec;
        JgclIndefiniteSolution inf;

        InflexionAccumulator(JgclCompositeCurve2D curve) {
            JgclCompositeCurve2D.this = JgclCompositeCurve2D.this;
            this.curve = curve;
            this.inf = null;
        }

        void allocate(int nsegs) {
            this.inflexionVec = new Vector();
        }

        void doit(JgclCompositeCurveSegment2D seg, JgclParameterSection sec, int compIndex) {
            double param;
            JgclPointOnCurve2D[] inflexion;
            try {
                inflexion = seg.inflexion();
            }
            catch (JgclIndefiniteSolution e) {
                this.inf = e;
                return;
            }
            int i = 0;
            while (i < inflexion.length) {
                param = JgclCompositeCurve2D.this.getCompositeParam(compIndex, inflexion[i].parameter());
                this.inflexionVec.addElement(new JgclPointOnCurve2D(this.curve, param, false));
                ++i;
            }
            if (seg.transition() == 2) {
                param = JgclCompositeCurve2D.this.getCompositeParam(compIndex, sec.end());
                this.inflexionVec.addElement(new JgclPointOnCurve2D(this.curve, param, false));
            }
        }

        JgclPointOnCurve2D[] extract() throws JgclIndefiniteSolution {
            if (this.inf != null) {
                throw this.inf;
            }
            Object[] thisInflexion = new JgclPointOnCurve2D[this.inflexionVec.size()];
            this.inflexionVec.copyInto(thisInflexion);
            return thisInflexion;
        }
    }

    private abstract class SegmentAccumulator {
        abstract void doit(JgclCompositeCurveSegment2D var1, JgclParameterSection var2, int var3);

        void doit(JgclCompositeCurveSegment2D seg, double sp, double ep, int compIndex) {
            this.doit(seg, new JgclParameterSection(sp, ep), compIndex);
        }

        abstract void allocate(int var1);

        void accumulate(JgclParameterSection pint) {
            boolean wraparound;
            CompositeIndexParam ex;
            CompositeIndexParam sx;
            JgclParameterDomain domain = JgclCompositeCurve2D.this.parameterDomain();
            if (domain.isPeriodic()) {
                double sp = domain.wrap(pint.start());
                double ep = sp + pint.increase();
                sx = JgclCompositeCurve2D.this.getIndexParam(sp);
                ex = JgclCompositeCurve2D.this.getIndexParam(ep);
                wraparound = domain.section().increase() < ep;
            } else {
                sx = JgclCompositeCurve2D.this.getIndexParam(pint.lower());
                ex = JgclCompositeCurve2D.this.getIndexParam(pint.upper());
                wraparound = false;
            }
            int nsegs = wraparound ? JgclCompositeCurve2D.this.segments.length + ex.index - sx.index + 1 : ex.index - sx.index + 1;
            this.allocate(nsegs);
            if (nsegs == 1) {
                this.doit(JgclCompositeCurve2D.this.segments[sx.index], sx.param, ex.param, sx.index);
            } else if (wraparound) {
                JgclCompositeCurveSegment2D seg = JgclCompositeCurve2D.this.segments[sx.index];
                this.doit(seg, sx.param, seg.eParameter(), sx.index);
                int i = sx.index + 1;
                while (i < JgclCompositeCurve2D.this.segments.length) {
                    seg = JgclCompositeCurve2D.this.segments[i];
                    this.doit(seg, seg.sParameter(), seg.eParameter(), i);
                    ++i;
                }
                i = 0;
                while (i < ex.index) {
                    seg = JgclCompositeCurve2D.this.segments[i];
                    this.doit(seg, seg.sParameter(), seg.eParameter(), i);
                    ++i;
                }
                seg = JgclCompositeCurve2D.this.segments[ex.index];
                this.doit(seg, seg.sParameter(), ex.param, ex.index);
            } else {
                JgclCompositeCurveSegment2D seg = JgclCompositeCurve2D.this.segments[sx.index];
                this.doit(seg, sx.param, seg.eParameter(), sx.index);
                int i = sx.index + 1;
                while (i < ex.index) {
                    seg = JgclCompositeCurve2D.this.segments[i];
                    this.doit(seg, seg.sParameter(), seg.eParameter(), i);
                    ++i;
                }
                seg = JgclCompositeCurve2D.this.segments[ex.index];
                this.doit(seg, seg.sParameter(), ex.param, ex.index);
            }
        }

        SegmentAccumulator() {
            JgclCompositeCurve2D.this = JgclCompositeCurve2D.this;
        }
    }

    private class ProjectionAccumulator
    extends SegmentAccumulator {
        JgclPoint2D point;
        JgclCompositeCurve2D curve;
        JgclPointOnGeometryList projList;
        JgclIndefiniteSolution inf;

        ProjectionAccumulator(JgclPoint2D point, JgclCompositeCurve2D curve) {
            JgclCompositeCurve2D.this = JgclCompositeCurve2D.this;
            this.curve = curve;
            this.point = point;
            this.inf = null;
        }

        void allocate(int nsegs) {
            this.projList = new JgclPointOnGeometryList();
        }

        void doit(JgclCompositeCurveSegment2D seg, JgclParameterSection sec, int compIndex) {
            JgclPointOnCurve2D[] proj;
            try {
                proj = seg.projectFrom(this.point);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            catch (JgclIndefiniteSolution e) {
                this.inf = e;
                return;
            }
            int i = 0;
            while (i < proj.length) {
                double param = JgclCompositeCurve2D.this.getCompositeParam(compIndex, proj[i].parameter());
                this.projList.addPoint(this.curve, param);
                ++i;
            }
        }

        JgclPointOnCurve2D[] extract() throws JgclIndefiniteSolution {
            if (this.inf != null) {
                throw this.inf;
            }
            return this.projList.toJgclPointOnCurve2DArray();
        }
    }

    private class ToPolylineAccumulator
    extends SegmentAccumulator {
        JgclToleranceForDistance tol;
        JgclPolyline2D[] pls;
        JgclCompositeCurveSegment2D[] segs;
        int[] compIndex;
        JgclCompositeCurve2D curve;
        int segIndex;

        ToPolylineAccumulator(JgclToleranceForDistance tol, JgclCompositeCurve2D curve) {
            JgclCompositeCurve2D.this = JgclCompositeCurve2D.this;
            this.tol = tol;
            this.curve = curve;
            this.segIndex = 0;
        }

        void allocate(int nsegs) {
            this.pls = new JgclPolyline2D[nsegs];
            this.segs = new JgclCompositeCurveSegment2D[nsegs];
            this.compIndex = new int[nsegs];
        }

        void doit(JgclCompositeCurveSegment2D seg, JgclParameterSection sec, int compIndex) {
            this.segs[this.segIndex] = seg;
            this.compIndex[this.segIndex] = compIndex;
            try {
                this.pls[this.segIndex] = seg.toPolyline(sec, this.tol);
            }
            catch (JgclZeroLength jgclZeroLength) {
                this.pls[this.segIndex] = null;
            }
            ++this.segIndex;
        }

        JgclPolyline2D extract() {
            int npnts = 1;
            int i = 0;
            while (i < this.pls.length) {
                if (this.pls[i] != null) {
                    npnts += this.pls[i].nPoints() - 1;
                }
                ++i;
            }
            if (npnts < 2) {
                throw new JgclZeroLength();
            }
            JgclPoint2D[] points = new JgclPointOnCurve2D[npnts];
            int k = 0;
            i = 0;
            while (i < this.pls.length) {
                if (this.pls[i] != null) {
                    int j = 0;
                    while (j < this.pls[i].nPoints()) {
                        JgclPointOnCurve2D pnts = (JgclPointOnCurve2D)this.pls[i].pointAt(j);
                        double param = JgclCompositeCurve2D.this.getCompositeParam(this.compIndex[i], pnts.parameter());
                        if (i == 0 || j != 0) {
                            try {
                                points[k++] = new JgclPointOnCurve2D(this.curve, param, false);
                            }
                            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                                throw new JgclFatal();
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return new JgclPolyline2D(points);
        }
    }

    private class ToBsplineCurveAccumulator
    extends SegmentAccumulator {
        JgclBsplineCurve2D result;

        ToBsplineCurveAccumulator() {
            JgclCompositeCurve2D.this = JgclCompositeCurve2D.this;
        }

        void allocate(int nsegs) {
            this.result = null;
        }

        void doit(JgclCompositeCurveSegment2D seg, JgclParameterSection sec, int compIndex) {
            try {
                JgclBsplineCurve2D bsc = seg.toBsplineCurve(sec);
                this.result = this.result == null ? bsc : this.result.mergeIfContinuous(bsc);
            }
            catch (JgclTwoGeomertiesAreNotContinuous jgclTwoGeomertiesAreNotContinuous) {
                throw new JgclFatal();
            }
        }

        JgclBsplineCurve2D extract() {
            return this.result;
        }
    }

    private class IntersectionAccumulator
    extends SegmentAccumulator {
        JgclParametricCurve2D mate;
        JgclCompositeCurve2D curve;
        Vector intsvec;

        IntersectionAccumulator(JgclParametricCurve2D mate, JgclCompositeCurve2D curve) {
            JgclCompositeCurve2D.this = JgclCompositeCurve2D.this;
            this.curve = curve;
            this.mate = mate;
        }

        void allocate(int nsegs) {
            this.intsvec = new Vector();
        }

        void doit(JgclCompositeCurveSegment2D seg, JgclParameterSection sec, int compIndex) {
            JgclIntersectionPoint2D[] ints = seg.intersect(this.mate);
            int i = 0;
            while (i < ints.length) {
                double cparam = ints[i].pointOnCurve1().parameter();
                double sparam = JgclCompositeCurve2D.this.getCompositeParam(compIndex, cparam);
                JgclPointOnCurve2D thisPnts = new JgclPointOnCurve2D(this.curve, sparam, false);
                JgclIntersectionPoint2D thisInts = new JgclIntersectionPoint2D(thisPnts, ints[i].pointOnCurve2(), false);
                this.intsvec.addElement(thisInts);
                ++i;
            }
        }

        JgclIntersectionPoint2D[] extract(boolean doExchange) {
            Object[] ints = new JgclIntersectionPoint2D[this.intsvec.size()];
            this.intsvec.copyInto(ints);
            if (doExchange) {
                int i = 0;
                while (i < ints.length) {
                    ints[i] = ((JgclIntersectionPoint2D)ints[i]).exchange();
                    ++i;
                }
            }
            return ints;
        }
    }

    private class OffsetByCompositeCurveAccumulator
    extends SegmentAccumulator {
        double magni;
        int side;
        JgclToleranceForDistance tol;
        int offsettedCurveIndex;
        JgclBoundedCurve2D[] offsettedCurves;
        JgclPoint2D[] vertices;

        OffsetByCompositeCurveAccumulator(double magni, int side, JgclToleranceForDistance tol) {
            JgclCompositeCurve2D.this = JgclCompositeCurve2D.this;
            this.magni = magni;
            this.side = side;
            this.tol = tol;
        }

        void allocate(int nsegs) {
            this.offsettedCurveIndex = 0;
            this.offsettedCurves = new JgclBoundedCurve2D[nsegs];
            this.vertices = new JgclPoint2D[nsegs];
        }

        void doit(JgclCompositeCurveSegment2D seg, JgclParameterSection sec, int compIndex) {
            this.offsettedCurves[this.offsettedCurveIndex] = seg.offsetByBoundedCurve(sec, this.magni, this.side, this.tol);
            this.vertices[this.offsettedCurveIndex] = seg.coordinates(sec.start());
            ++this.offsettedCurveIndex;
        }

        JgclBoundedCurve2D[] extract() {
            return this.offsettedCurves;
        }

        JgclPoint2D[] extract2() {
            return this.vertices;
        }
    }

    private class FilletAccumulator
    extends SegmentAccumulator {
        JgclParametricCurve2D mate;
        JgclCompositeCurve2D curve;
        JgclParameterSection mateSec;
        int mateSide;
        int mySide;
        double radius;
        boolean doExchange;
        JgclFilletObjectList fltList;

        FilletAccumulator(JgclParametricCurve2D mate, JgclParameterSection mateSec, int mateSide, JgclCompositeCurve2D curve, int mySide, double radius, boolean doExchange) {
            JgclCompositeCurve2D.this = JgclCompositeCurve2D.this;
            this.curve = curve;
            this.mate = mate;
            this.mateSec = mateSec;
            this.mateSide = mateSide;
            this.mySide = mySide;
            this.radius = radius;
            this.doExchange = doExchange;
        }

        void allocate(int nsegs) {
            this.fltList = new JgclFilletObjectList();
        }

        void doit(JgclCompositeCurveSegment2D seg, JgclParameterSection sec, int compIndex) {
            JgclFilletObject2D[] flts;
            try {
                flts = seg.fillet(sec, this.mySide, this.mate, this.mateSec, this.mateSide, this.radius);
            }
            catch (JgclIndefiniteSolution e) {
                flts = new JgclFilletObject2D[]{(JgclFilletObject2D)e.suitable()};
            }
            int i = 0;
            while (i < flts.length) {
                double cparam = flts[i].pointOnCurve1().parameter();
                double sparam = JgclCompositeCurve2D.this.getCompositeParam(compIndex, cparam);
                JgclPointOnCurve2D thisPnt = new JgclPointOnCurve2D(this.curve, sparam, false);
                JgclFilletObject2D thisFlt = !this.doExchange ? new JgclFilletObject2D(this.radius, flts[i].center(), thisPnt, flts[i].pointOnCurve2()) : new JgclFilletObject2D(this.radius, flts[i].center(), flts[i].pointOnCurve2(), thisPnt);
                this.fltList.addFillet(thisFlt);
                ++i;
            }
        }

        JgclFilletObject2D[] extract() {
            return this.fltList.toJgclFilletObject2DArray(false);
        }
    }
}

