/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBoundedCurve3D;
import jp.go.ipa.jgcl.JgclBoundedLine3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclCompositeCurve3D;
import jp.go.ipa.jgcl.JgclCurveCurvature3D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference3D;
import jp.go.ipa.jgcl.JgclCurveDerivative3D;
import jp.go.ipa.jgcl.JgclCurveSurfaceInterferenceList;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclHyperbola3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclParabola3D;
import jp.go.ipa.jgcl.JgclParameterConversion3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTransitionCode;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclCompositeCurveSegment3D
extends JgclBoundedCurve3D {
    private int transition;
    private boolean sameSense;
    private JgclBoundedCurve3D parentCurve;

    public JgclCompositeCurveSegment3D(int transition, boolean sameSense, JgclBoundedCurve3D parentCurve) {
        if (parentCurve.isPeriodic() || parentCurve.isInfinite()) {
            throw new JgclInvalidArgumentValue();
        }
        this.transition = transition;
        this.sameSense = sameSense;
        this.parentCurve = parentCurve;
    }

    public int transition() {
        return this.transition;
    }

    public boolean sameSense() {
        return this.sameSense;
    }

    public JgclBoundedCurve3D parentCurve() {
        return this.parentCurve;
    }

    public JgclPoint3D startPoint() {
        if (this.sameSense) {
            return this.parentCurve.startPoint();
        }
        return this.parentCurve.endPoint();
    }

    public JgclPoint3D endPoint() {
        if (this.sameSense) {
            return this.parentCurve.endPoint();
        }
        return this.parentCurve.startPoint();
    }

    double sParameter() {
        return this.parameterDomain().section().start();
    }

    double eParameter() {
        return this.parameterDomain().section().end();
    }

    private double toBasisParameter(double param) {
        this.checkValidity(param);
        if (this.sameSense) {
            return param;
        }
        JgclParameterSection sec = this.parameterDomain().section();
        return sec.end() - (param - sec.start());
    }

    public JgclParameterSection toBasisParameter(JgclParameterSection pint) {
        double start = this.toBasisParameter(pint.start());
        double end = this.toBasisParameter(pint.end());
        return new JgclParameterSection(start, end - start);
    }

    private double toOwnParameter(double param) {
        double result;
        if (this.sameSense) {
            result = param;
        } else {
            JgclParameterSection sec = this.parameterDomain().section();
            result = sec.start() - (param - sec.end());
        }
        return result;
    }

    public double length(JgclParameterSection pint) {
        return this.parentCurve.length(this.toBasisParameter(pint));
    }

    public JgclPoint3D coordinates(double param) {
        return this.parentCurve.coordinates(this.toBasisParameter(param));
    }

    public JgclVector3D tangentVector(double param) {
        JgclVector3D tang = this.parentCurve.tangentVector(this.toBasisParameter(param));
        if (this.sameSense) {
            return tang;
        }
        return tang.multiply(-1.0);
    }

    public JgclCurveCurvature3D curvature(double param) {
        return this.parentCurve.curvature(this.toBasisParameter(param));
    }

    public double torsion(double param) {
        return this.parentCurve.torsion(this.toBasisParameter(param));
    }

    public JgclCurveDerivative3D evaluation(double param) {
        JgclCurveDerivative3D curv = this.parentCurve.evaluation(this.toBasisParameter(param));
        if (this.sameSense) {
            return curv;
        }
        JgclCurveDerivative3D rcurv = new JgclCurveDerivative3D(curv.d0D(), curv.d1D().multiply(-1.0), curv.d2D(), curv.d3D().multiply(-1.0));
        return rcurv;
    }

    public JgclPointOnCurve3D[] singular() throws JgclIndefiniteSolution {
        JgclPointOnCurve3D[] singular = this.parentCurve.singular();
        JgclPointOnCurve3D[] thisSingular = new JgclPointOnCurve3D[singular.length];
        int i = 0;
        while (i < singular.length) {
            try {
                thisSingular[i] = new JgclPointOnCurve3D(this, this.toOwnParameter(singular[i].parameter()));
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return thisSingular;
    }

    public JgclPointOnCurve3D[] inflexion() throws JgclIndefiniteSolution {
        JgclPointOnCurve3D[] inflexion = this.parentCurve.inflexion();
        JgclPointOnCurve3D[] thisInflexion = new JgclPointOnCurve3D[inflexion.length];
        int i = 0;
        while (i < inflexion.length) {
            try {
                thisInflexion[i] = new JgclPointOnCurve3D(this, this.toOwnParameter(inflexion[i].parameter()));
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return thisInflexion;
    }

    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D point) throws JgclIndefiniteSolution {
        JgclPointOnCurve3D[] proj = this.parentCurve.projectFrom(point);
        JgclPointOnCurve3D[] proj2 = new JgclPointOnCurve3D[proj.length];
        int i = 0;
        while (i < proj.length) {
            try {
                proj2[i] = new JgclPointOnCurve3D(this, this.toOwnParameter(proj[i].parameter()));
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return proj2;
    }

    public JgclPolyline3D toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol) {
        JgclPolyline3D pl = this.parentCurve.toPolyline(this.toBasisParameter(pint), tol);
        JgclPoint3D[] pnts = new JgclPoint3D[pl.nPoints()];
        int i = 0;
        while (i < pnts.length) {
            JgclPointOnCurve3D p = (JgclPointOnCurve3D)pl.pointAt(i);
            pnts[i] = new JgclPointOnCurve3D(this, this.toOwnParameter(p.parameter()), false);
            ++i;
        }
        return new JgclPolyline3D(pnts);
    }

    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
        return this.parentCurve.toBsplineCurve(this.toBasisParameter(pint));
    }

    private JgclIntersectionPoint3D[] doIntersect(JgclParametricCurve3D mate, boolean doExchange) {
        JgclIntersectionPoint3D[] ints;
        try {
            ints = this.parentCurve.intersect(mate);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            return new JgclIntersectionPoint3D[0];
        }
        JgclIntersectionPoint3D[] thisInts = new JgclIntersectionPoint3D[ints.length];
        int i = 0;
        while (i < ints.length) {
            double param = this.toOwnParameter(ints[i].pointOnCurve1().parameter());
            JgclPointOnCurve3D thisPnts = new JgclPointOnCurve3D(this, param, false);
            thisInts[i] = !doExchange ? new JgclIntersectionPoint3D(thisPnts, ints[i].pointOnGeometry2(), false) : new JgclIntersectionPoint3D(ints[i].pointOnGeometry2(), thisPnts, false);
            ++i;
        }
        return thisInts;
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) {
        return this.doIntersect(mate, false);
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] doIntersect(JgclParametricSurface3D mate, boolean doExchange) {
        JgclIntersectionPoint3D[] intp;
        try {
            intp = this.parentCurve.intersect(mate);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            return new JgclIntersectionPoint3D[0];
        }
        JgclCurveSurfaceInterferenceList intfList = new JgclCurveSurfaceInterferenceList(this, mate);
        int i = 0;
        while (i < intp.length) {
            JgclPointOnCurve3D crvPnt = (JgclPointOnCurve3D)intp[i].pointOnGeometry1();
            double crvParam = this.toOwnParameter(crvPnt.parameter());
            JgclPointOnSurface3D srfPnt = (JgclPointOnSurface3D)intp[i].pointOnGeometry2();
            intfList.addAsIntersection(intp[i].coordinates(), crvParam, srfPnt.uParameter(), srfPnt.vParameter());
            ++i;
        }
        return intfList.toJgclIntersectionPoint3DArray(doExchange);
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate) {
        return this.doIntersect(mate, false);
    }

    JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    public JgclCurveCurveInterference3D[] interfere(JgclBoundedCurve3D mate) {
        return this.interfere(mate, false);
    }

    JgclCurveCurveInterference3D[] interfere(JgclBoundedCurve3D mate, boolean doExchange) {
        ToSegmentConversion conv = new ToSegmentConversion();
        JgclParameterSection sec = this.parameterDomain().section();
        JgclCurveCurveInterference3D[] intf = !doExchange ? this.parentCurve.interfere(mate) : mate.interfere(this.parentCurve);
        Vector<JgclCurveCurveInterference3D> vec = new Vector<JgclCurveCurveInterference3D>();
        int i = 0;
        while (i < intf.length) {
            JgclCurveCurveInterference3D trimintf = !doExchange ? intf[i].trim1(sec, conv) : intf[i].trim2(sec, conv);
            if (trimintf != null) {
                vec.addElement(trimintf);
            }
            ++i;
        }
        Object[] interf = new JgclCurveCurveInterference3D[vec.size()];
        vec.copyInto(interf);
        return interf;
    }

    JgclCurveCurveInterference3D[] interfere(JgclBoundedLine3D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve3D)mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclPolyline3D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve3D)mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclPureBezierCurve3D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve3D)mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclBsplineCurve3D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve3D)mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclTrimmedCurve3D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve3D)mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurve3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
        JgclBoundedCurve3D newParent = (JgclBoundedCurve3D)this.parentCurve.parallelTranslate(moveVec);
        return new JgclCompositeCurveSegment3D(this.transition, this.sameSense, newParent);
    }

    JgclParameterDomain getParameterDomain() {
        return this.parentCurve.parameterDomain();
    }

    int type() {
        return 25;
    }

    public boolean isFreeform() {
        return this.parentCurve.isFreeform();
    }

    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns, double rCos, double rSin) {
        JgclBoundedCurve3D r_bnd = (JgclBoundedCurve3D)this.parentCurve().rotateZ(trns, rCos, rSin);
        return new JgclCompositeCurveSegment3D(this.transition(), this.sameSense(), r_bnd);
    }

    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
        JgclParameterSection pint = this.parameterDomain().section();
        JgclBsplineCurve3D b_spline = this.toBsplineCurve(pint);
        return b_spline.getPointNotOnLine(line);
    }

    JgclCompositeCurveSegment3D makeCopyWithTransition(int transition) {
        return new JgclCompositeCurveSegment3D(transition, this.sameSense, this.parentCurve);
    }

    JgclCompositeCurveSegment3D makeReverseWithTransition(int transition) {
        return new JgclCompositeCurveSegment3D(transition, !this.sameSense, this.parentCurve);
    }

    JgclCompositeCurveSegment3D truncate(JgclParameterSection section, int transition) {
        JgclTrimmedCurve3D newParent;
        JgclParameterSection parentSection = this.toBasisParameter(section);
        if (this.parentCurve.type() == 23) {
            JgclTrimmedCurve3D trc = (JgclTrimmedCurve3D)this.parentCurve;
            newParent = new JgclTrimmedCurve3D(trc.basisCurve(), parentSection);
        } else {
            newParent = new JgclTrimmedCurve3D(this.parentCurve, parentSection);
        }
        return new JgclCompositeCurveSegment3D(transition, true, newParent);
    }

    protected synchronized JgclParametricCurve3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclBoundedCurve3D tParentCurve = (JgclBoundedCurve3D)this.parentCurve().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclCompositeCurveSegment3D(this.transition(), this.sameSense(), tParentCurve);
    }

    protected boolean hasPolyline() {
        return this.parentCurve.hasPolyline();
    }

    protected boolean isComposedOfOnlyPolylines() {
        return this.parentCurve.isComposedOfOnlyPolylines();
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\ttransition\t" + JgclTransitionCode.toString(this.transition));
        writer.println(String.valueOf(indent_tab) + "\tsameSense\t" + this.sameSense);
        writer.println(String.valueOf(indent_tab) + "\tparentCurve");
        this.parentCurve.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "End");
    }

    class ToSegmentConversion
    extends JgclParameterConversion3D {
        ToSegmentConversion() {
            JgclCompositeCurveSegment3D.this = JgclCompositeCurveSegment3D.this;
        }

        double convParameter(double param) {
            return JgclCompositeCurveSegment3D.this.toOwnParameter(param);
        }

        JgclParametricCurve3D convCurve(double param) {
            return JgclCompositeCurveSegment3D.this;
        }
    }
}

