/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Hashtable;
import java.util.Stack;
import jp.go.ipa.jgcl.JgclTolerance;
import jp.go.ipa.jgcl.JgclToleranceForAngle;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclToleranceForParameter;

public class JgclConditionOfOperation {
    private final JgclToleranceForDistance dTol;
    private final JgclToleranceForAngle aTol;
    private final JgclToleranceForParameter pTol;
    private final JgclTolerance rTol;
    private static final Hashtable threadTable;
    private static JgclConditionOfOperation defaultCondition;

    public JgclConditionOfOperation() {
        this.dTol = new JgclToleranceForDistance(1.0E-4);
        this.aTol = new JgclToleranceForAngle(0.0017453292519943296);
        this.pTol = new JgclToleranceForParameter(1.0E-8);
        this.rTol = new JgclTolerance(1.0E-8);
    }

    public JgclConditionOfOperation(JgclToleranceForDistance dTol, JgclToleranceForAngle aTol, JgclToleranceForParameter pTol, JgclTolerance rTol) {
        this.dTol = dTol;
        this.aTol = aTol;
        this.pTol = pTol;
        this.rTol = rTol;
    }

    public JgclConditionOfOperation makeCopy(JgclToleranceForDistance dTol) {
        return new JgclConditionOfOperation(dTol, this.aTol, this.pTol, this.rTol);
    }

    public JgclConditionOfOperation makeCopyWithToleranceForDistance(double value) {
        JgclToleranceForDistance dTol = new JgclToleranceForDistance(value);
        return this.makeCopy(dTol);
    }

    public JgclConditionOfOperation makeCopy(JgclToleranceForAngle aTol) {
        return new JgclConditionOfOperation(this.dTol, aTol, this.pTol, this.rTol);
    }

    public JgclConditionOfOperation makeCopyWithToleranceForAngle(double value) {
        JgclToleranceForAngle aTol = new JgclToleranceForAngle(value);
        return this.makeCopy(aTol);
    }

    public JgclConditionOfOperation makeCopy(JgclToleranceForParameter pTol) {
        return new JgclConditionOfOperation(this.dTol, this.aTol, pTol, this.rTol);
    }

    public JgclConditionOfOperation makeCopyWithToleranceForParameter(double value) {
        JgclToleranceForParameter pTol = new JgclToleranceForParameter(value);
        return this.makeCopy(pTol);
    }

    public JgclConditionOfOperation makeCopy(JgclTolerance rTol) {
        return new JgclConditionOfOperation(this.dTol, this.aTol, this.pTol, rTol);
    }

    public JgclConditionOfOperation makeCopyWithToleranceForRealNumber(double value) {
        JgclTolerance rTol = new JgclTolerance(value);
        return this.makeCopy(rTol);
    }

    public double getToleranceForDistance() {
        return this.dTol.value();
    }

    public JgclToleranceForDistance getToleranceForDistanceAsObject() {
        return this.dTol;
    }

    public double getToleranceForDistance2() {
        return this.dTol.value2();
    }

    public double getToleranceForAngle() {
        return this.aTol.value();
    }

    public JgclToleranceForAngle getToleranceForAngleAsObject() {
        return this.aTol;
    }

    public double getToleranceForParameter() {
        return this.pTol.value();
    }

    public JgclToleranceForParameter getToleranceForParameterAsObject() {
        return this.pTol;
    }

    public double getToleranceForRealNumber() {
        return this.rTol.value();
    }

    public JgclTolerance getToleranceForRealNumberAsObject() {
        return this.rTol;
    }

    public static JgclConditionOfOperation getDefaultCondition() {
        return defaultCondition;
    }

    public static synchronized void setDefaultCondition(JgclConditionOfOperation cond) {
        defaultCondition = cond;
    }

    private static Stack getStack(Thread theThread) {
        Stack stack;
        Object obj = threadTable.get(theThread);
        if (obj == null) {
            stack = new Stack();
            threadTable.put(theThread, stack);
        } else {
            stack = (Stack)obj;
        }
        return stack;
    }

    public static JgclConditionOfOperation getCondition() {
        JgclConditionOfOperation cond = JgclConditionOfOperation.peek();
        if (cond == null) {
            cond = defaultCondition;
        }
        return cond;
    }

    public static boolean empty() {
        Stack stack = JgclConditionOfOperation.getStack(Thread.currentThread());
        return stack.empty();
    }

    public static JgclConditionOfOperation peek() {
        Stack stack = JgclConditionOfOperation.getStack(Thread.currentThread());
        if (stack.empty()) {
            return null;
        }
        return (JgclConditionOfOperation)stack.peek();
    }

    public static void push(JgclConditionOfOperation condition) {
        Stack stack = JgclConditionOfOperation.getStack(Thread.currentThread());
        stack.push(condition);
    }

    public static JgclConditionOfOperation pop() {
        Stack stack = JgclConditionOfOperation.getStack(Thread.currentThread());
        if (stack.empty()) {
            return null;
        }
        JgclConditionOfOperation cond = (JgclConditionOfOperation)stack.peek();
        stack.pop();
        return cond;
    }

    public synchronized void setDefault() {
        JgclConditionOfOperation.setDefaultCondition(this);
    }

    public void push() {
        JgclConditionOfOperation.push(this);
    }

    static {
        defaultCondition = new JgclConditionOfOperation();
        threadTable = new Hashtable();
    }
}

