/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclUtil;

public abstract class JgclCurveCurvature {
    private final double curvature;

    protected JgclCurveCurvature(double curvature) {
        this.curvature = curvature;
    }

    public double curvature() {
        return this.curvature;
    }

    static boolean identical(double a, double b) {
        if (JgclUtil.isReciprocatable(a)) {
            if (!JgclUtil.isReciprocatable(b)) {
                return false;
            }
            double a_rad = 1.0 / a;
            double b_rad = 1.0 / b;
            double tol_d = JgclConditionOfOperation.getCondition().getToleranceForDistance();
            if (Math.abs(a_rad - b_rad) > tol_d) {
                return false;
            }
        } else if (JgclUtil.isReciprocatable(b)) {
            return false;
        }
        return true;
    }
}

