/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Enumeration;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCurveCurveInterference2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference3D;
import jp.go.ipa.jgcl.JgclDimensionsMismatch;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclNullArgument;
import jp.go.ipa.jgcl.JgclOverlapCurve2D;
import jp.go.ipa.jgcl.JgclOverlapCurve3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParametricCurve;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclPoint;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;

class JgclCurveCurveInterferenceList {
    int dimension;
    JgclParametricCurve curveA;
    JgclParameterDomain parameterDomainA;
    JgclParametricCurve curveB;
    JgclParameterDomain parameterDomainB;
    JgclToleranceForDistance dTol;
    Vector listOfIntersections;
    Vector listOfOverlaps;
    private static final int PARAMETERS_NOT_IDENTICAL = 0;
    private static final int PARAMETERS_IDENTICAL = 1;
    private static final int PARAMETERS_CROSSBOUNDARY_A = 2;
    private static final int PARAMETERS_CROSSBOUNDARY_B = 4;

    JgclCurveCurveInterferenceList(JgclParametricCurve curveA, JgclParametricCurve curveB) {
        if (curveA == null || curveB == null) {
            throw new JgclNullArgument();
        }
        this.dimension = curveA.dimension();
        if (this.dimension != curveB.dimension()) {
            throw new JgclDimensionsMismatch();
        }
        this.curveA = curveA;
        this.parameterDomainA = curveA.parameterDomain();
        this.curveB = curveB;
        this.parameterDomainB = curveB.parameterDomain();
        JgclConditionOfOperation cond = JgclConditionOfOperation.getCondition();
        this.dTol = cond.getToleranceForDistanceAsObject();
        this.listOfIntersections = new Vector();
        this.listOfOverlaps = new Vector();
    }

    private double getToleranceForParameter(JgclParametricCurve curve, double param) {
        if (this.dimension == 2) {
            return this.dTol.toToleranceForParameter((JgclParametricCurve2D)curve, param).value();
        }
        return this.dTol.toToleranceForParameter((JgclParametricCurve3D)curve, param).value();
    }

    void addIntersection(IntersectionInfo theIntersection) {
        Enumeration e = this.listOfIntersections.elements();
        while (e.hasMoreElements()) {
            if (!theIntersection.isIdenticalWith((IntersectionInfo)e.nextElement())) continue;
            return;
        }
        this.listOfIntersections.addElement(theIntersection);
    }

    void addAsIntersection(JgclPoint coord, double paramA, double paramB) {
        this.addIntersection(new IntersectionInfo(coord, paramA, paramB));
    }

    void addAsIntersection(JgclPoint coord, double paramA, double paramB, double pTolA, double pTolB) {
        this.addIntersection(new IntersectionInfo(coord, paramA, paramB, pTolA, pTolB));
    }

    void removeIntersectionsContainedInOverlap() {
        Vector clonedList = (Vector)this.listOfIntersections.clone();
        this.listOfIntersections.removeAllElements();
        Enumeration e1 = clonedList.elements();
        while (e1.hasMoreElements()) {
            IntersectionInfo intersection = (IntersectionInfo)e1.nextElement();
            boolean contained = false;
            Enumeration e2 = this.listOfOverlaps.elements();
            while (e2.hasMoreElements()) {
                if (!intersection.isContainedIn((OverlapInfo)e2.nextElement())) continue;
                contained = true;
                break;
            }
            if (contained) continue;
            this.listOfIntersections.addElement(intersection);
        }
    }

    void addOverlap(OverlapInfo theOverlap) {
        while (true) {
            OverlapInfo mergedMate = null;
            Enumeration e = this.listOfOverlaps.elements();
            while (e.hasMoreElements()) {
                OverlapInfo mate = (OverlapInfo)e.nextElement();
                if (!theOverlap.mergeIfConnectWith(mate)) continue;
                mergedMate = mate;
                break;
            }
            if (mergedMate == null) break;
            this.listOfOverlaps.removeElement(mergedMate);
        }
        this.listOfOverlaps.addElement(theOverlap);
    }

    void addAsOverlap(double headParamA, double headParamB, double increaseParamA, double increaseParamB) {
        this.addOverlap(new OverlapInfo(headParamA, headParamB, increaseParamA, increaseParamB));
    }

    void addAsOverlap(double headParamA, double headParamB, double increaseParamA, double increaseParamB, double headPTolA, double headPTolB, double tailPTolA, double tailPTolB) {
        this.addOverlap(new OverlapInfo(headParamA, headParamB, increaseParamA, increaseParamB, headPTolA, headPTolB, tailPTolA, tailPTolB));
    }

    void removeOverlapsContainedInOtherOverlap() {
        Vector clonedList = (Vector)this.listOfOverlaps.clone();
        this.listOfOverlaps.removeAllElements();
        Enumeration e1 = clonedList.elements();
        while (e1.hasMoreElements()) {
            OverlapInfo overlap = (OverlapInfo)e1.nextElement();
            boolean contained = false;
            Enumeration e2 = clonedList.elements();
            while (e2.hasMoreElements()) {
                if (!overlap.isContainedIn((OverlapInfo)e2.nextElement())) continue;
                contained = true;
                break;
            }
            if (contained) continue;
            this.listOfOverlaps.addElement(overlap);
        }
    }

    JgclCurveCurveInterference2D[] toJgclCurveCurveInterference2DArray(boolean doExchange) {
        if (this.dimension != 2) {
            throw new JgclDimensionsMismatch();
        }
        int totalSize = this.listOfIntersections.size() + this.listOfOverlaps.size();
        JgclCurveCurveInterference2D[] result = new JgclCurveCurveInterference2D[totalSize];
        int i = 0;
        Enumeration e = this.listOfIntersections.elements();
        while (e.hasMoreElements()) {
            IntersectionInfo ints = (IntersectionInfo)e.nextElement();
            if (!doExchange) {
                result[i++] = ints.coord == null ? new JgclIntersectionPoint2D((JgclParametricCurve2D)this.curveA, ints.paramA, (JgclParametricCurve2D)this.curveB, ints.paramB, false) : new JgclIntersectionPoint2D((JgclPoint2D)ints.coord, (JgclParametricCurve2D)this.curveA, ints.paramA, (JgclParametricCurve2D)this.curveB, ints.paramB, false);
                continue;
            }
            JgclCurveCurveInterference2D jgclCurveCurveInterference2D = result[i++] = ints.coord == null ? new JgclIntersectionPoint2D((JgclParametricCurve2D)this.curveB, ints.paramB, (JgclParametricCurve2D)this.curveA, ints.paramA, false) : new JgclIntersectionPoint2D((JgclPoint2D)ints.coord, (JgclParametricCurve2D)this.curveB, ints.paramB, (JgclParametricCurve2D)this.curveA, ints.paramA, false);
        }
        Enumeration e2 = this.listOfOverlaps.elements();
        while (e2.hasMoreElements()) {
            OverlapInfo ovlp = (OverlapInfo)e2.nextElement();
            result[i++] = !doExchange ? new JgclOverlapCurve2D((JgclParametricCurve2D)this.curveA, ovlp.headPoint.paramA, ovlp.computeIncreaseA(), (JgclParametricCurve2D)this.curveB, ovlp.headPoint.paramB, ovlp.computeIncreaseB(), false) : new JgclOverlapCurve2D((JgclParametricCurve2D)this.curveB, ovlp.headPoint.paramB, ovlp.computeIncreaseB(), (JgclParametricCurve2D)this.curveA, ovlp.headPoint.paramA, ovlp.computeIncreaseA(), false);
        }
        return result;
    }

    JgclIntersectionPoint2D[] toJgclIntersectionPoint2DArray(boolean doExchange) {
        if (this.dimension != 2) {
            throw new JgclDimensionsMismatch();
        }
        int totalSize = this.listOfIntersections.size() + this.listOfOverlaps.size() * 2;
        JgclIntersectionPoint2D[] result = new JgclIntersectionPoint2D[totalSize];
        int i = 0;
        Enumeration e = this.listOfIntersections.elements();
        while (e.hasMoreElements()) {
            IntersectionInfo ints = (IntersectionInfo)e.nextElement();
            if (!doExchange) {
                result[i++] = ints.coord == null ? new JgclIntersectionPoint2D((JgclParametricCurve2D)this.curveA, ints.paramA, (JgclParametricCurve2D)this.curveB, ints.paramB, false) : new JgclIntersectionPoint2D((JgclPoint2D)ints.coord, (JgclParametricCurve2D)this.curveA, ints.paramA, (JgclParametricCurve2D)this.curveB, ints.paramB, false);
                continue;
            }
            JgclIntersectionPoint2D jgclIntersectionPoint2D = result[i++] = ints.coord == null ? new JgclIntersectionPoint2D((JgclParametricCurve2D)this.curveB, ints.paramB, (JgclParametricCurve2D)this.curveA, ints.paramA, false) : new JgclIntersectionPoint2D((JgclPoint2D)ints.coord, (JgclParametricCurve2D)this.curveB, ints.paramB, (JgclParametricCurve2D)this.curveA, ints.paramA, false);
        }
        Enumeration e2 = this.listOfOverlaps.elements();
        while (e2.hasMoreElements()) {
            OverlapInfo ovlp = (OverlapInfo)e2.nextElement();
            if (!doExchange) {
                result[i++] = new JgclIntersectionPoint2D((JgclParametricCurve2D)this.curveA, ovlp.headPoint.paramA, (JgclParametricCurve2D)this.curveB, ovlp.headPoint.paramB, false);
                result[i++] = new JgclIntersectionPoint2D((JgclParametricCurve2D)this.curveA, ovlp.tailPoint.paramA, (JgclParametricCurve2D)this.curveB, ovlp.tailPoint.paramB, false);
                continue;
            }
            result[i++] = new JgclIntersectionPoint2D((JgclParametricCurve2D)this.curveB, ovlp.headPoint.paramB, (JgclParametricCurve2D)this.curveA, ovlp.headPoint.paramA, false);
            result[i++] = new JgclIntersectionPoint2D((JgclParametricCurve2D)this.curveB, ovlp.tailPoint.paramB, (JgclParametricCurve2D)this.curveA, ovlp.tailPoint.paramA, false);
        }
        return result;
    }

    JgclCurveCurveInterference3D[] toJgclCurveCurveInterference3DArray(boolean doExchange) {
        if (this.dimension != 3) {
            throw new JgclDimensionsMismatch();
        }
        int totalSize = this.listOfIntersections.size() + this.listOfOverlaps.size();
        JgclCurveCurveInterference3D[] result = new JgclCurveCurveInterference3D[totalSize];
        int i = 0;
        Enumeration e = this.listOfIntersections.elements();
        while (e.hasMoreElements()) {
            IntersectionInfo ints = (IntersectionInfo)e.nextElement();
            if (!doExchange) {
                result[i++] = ints.coord == null ? new JgclIntersectionPoint3D((JgclParametricCurve3D)this.curveA, ints.paramA, (JgclParametricCurve3D)this.curveB, ints.paramB, false) : new JgclIntersectionPoint3D((JgclPoint3D)ints.coord, (JgclParametricCurve3D)this.curveA, ints.paramA, (JgclParametricCurve3D)this.curveB, ints.paramB, false);
                continue;
            }
            JgclCurveCurveInterference3D jgclCurveCurveInterference3D = result[i++] = ints.coord == null ? new JgclIntersectionPoint3D((JgclParametricCurve3D)this.curveB, ints.paramB, (JgclParametricCurve3D)this.curveA, ints.paramA, false) : new JgclIntersectionPoint3D((JgclPoint3D)ints.coord, (JgclParametricCurve3D)this.curveB, ints.paramB, (JgclParametricCurve3D)this.curveA, ints.paramA, false);
        }
        Enumeration e2 = this.listOfOverlaps.elements();
        while (e2.hasMoreElements()) {
            OverlapInfo ovlp = (OverlapInfo)e2.nextElement();
            result[i++] = !doExchange ? new JgclOverlapCurve3D((JgclParametricCurve3D)this.curveA, ovlp.headPoint.paramA, ovlp.computeIncreaseA(), (JgclParametricCurve3D)this.curveB, ovlp.headPoint.paramB, ovlp.computeIncreaseB(), false) : new JgclOverlapCurve3D((JgclParametricCurve3D)this.curveB, ovlp.headPoint.paramB, ovlp.computeIncreaseB(), (JgclParametricCurve3D)this.curveA, ovlp.headPoint.paramA, ovlp.computeIncreaseA(), false);
        }
        return result;
    }

    JgclIntersectionPoint3D[] toJgclIntersectionPoint3DArray(boolean doExchange) {
        if (this.dimension != 3) {
            throw new JgclDimensionsMismatch();
        }
        int totalSize = this.listOfIntersections.size() + this.listOfOverlaps.size() * 2;
        JgclIntersectionPoint3D[] result = new JgclIntersectionPoint3D[totalSize];
        int i = 0;
        Enumeration e = this.listOfIntersections.elements();
        while (e.hasMoreElements()) {
            IntersectionInfo ints = (IntersectionInfo)e.nextElement();
            if (!doExchange) {
                result[i++] = ints.coord == null ? new JgclIntersectionPoint3D((JgclParametricCurve3D)this.curveA, ints.paramA, (JgclParametricCurve3D)this.curveB, ints.paramB, false) : new JgclIntersectionPoint3D((JgclPoint3D)ints.coord, (JgclParametricCurve3D)this.curveA, ints.paramA, (JgclParametricCurve3D)this.curveB, ints.paramB, false);
                continue;
            }
            JgclIntersectionPoint3D jgclIntersectionPoint3D = result[i++] = ints.coord == null ? new JgclIntersectionPoint3D((JgclParametricCurve3D)this.curveB, ints.paramB, (JgclParametricCurve3D)this.curveA, ints.paramA, false) : new JgclIntersectionPoint3D((JgclPoint3D)ints.coord, (JgclParametricCurve3D)this.curveB, ints.paramB, (JgclParametricCurve3D)this.curveA, ints.paramA, false);
        }
        Enumeration e2 = this.listOfOverlaps.elements();
        while (e2.hasMoreElements()) {
            OverlapInfo ovlp = (OverlapInfo)e2.nextElement();
            if (!doExchange) {
                result[i++] = new JgclIntersectionPoint3D((JgclParametricCurve3D)this.curveA, ovlp.headPoint.paramA, (JgclParametricCurve3D)this.curveB, ovlp.headPoint.paramB, false);
                result[i++] = new JgclIntersectionPoint3D((JgclParametricCurve3D)this.curveA, ovlp.tailPoint.paramA, (JgclParametricCurve3D)this.curveB, ovlp.tailPoint.paramB, false);
                continue;
            }
            result[i++] = new JgclIntersectionPoint3D((JgclParametricCurve3D)this.curveB, ovlp.headPoint.paramB, (JgclParametricCurve3D)this.curveA, ovlp.headPoint.paramA, false);
            result[i++] = new JgclIntersectionPoint3D((JgclParametricCurve3D)this.curveB, ovlp.tailPoint.paramB, (JgclParametricCurve3D)this.curveA, ovlp.tailPoint.paramA, false);
        }
        return result;
    }

    static Vector extractIntersections(JgclCurveCurveInterference2D[] array) {
        Vector<JgclCurveCurveInterference2D> result = new Vector<JgclCurveCurveInterference2D>();
        int i = 0;
        while (i < array.length) {
            if (array[i].isIntersectionPoint()) {
                result.addElement(array[i]);
            }
            ++i;
        }
        return result;
    }

    static Vector extractOverlaps(JgclCurveCurveInterference2D[] array) {
        Vector<JgclCurveCurveInterference2D> result = new Vector<JgclCurveCurveInterference2D>();
        int i = 0;
        while (i < array.length) {
            if (array[i].isOverlapCurve()) {
                result.addElement(array[i]);
            }
            ++i;
        }
        return result;
    }

    static Vector extractIntersections(JgclCurveCurveInterference3D[] array) {
        Vector<JgclCurveCurveInterference3D> result = new Vector<JgclCurveCurveInterference3D>();
        int i = 0;
        while (i < array.length) {
            if (array[i].isIntersectionPoint()) {
                result.addElement(array[i]);
            }
            ++i;
        }
        return result;
    }

    static Vector extractOverlaps(JgclCurveCurveInterference3D[] array) {
        Vector<JgclCurveCurveInterference3D> result = new Vector<JgclCurveCurveInterference3D>();
        int i = 0;
        while (i < array.length) {
            if (array[i].isOverlapCurve()) {
                result.addElement(array[i]);
            }
            ++i;
        }
        return result;
    }

    static /* synthetic */ int access$1() {
        return 0;
    }

    static /* synthetic */ int access$2() {
        return 1;
    }

    static /* synthetic */ int access$3() {
        return 2;
    }

    static /* synthetic */ int access$4() {
        return 4;
    }

    class ParametricalIdentityOfTwoIntersections {
        private int value;

        ParametricalIdentityOfTwoIntersections() {
            JgclCurveCurveInterferenceList.this = JgclCurveCurveInterferenceList.this;
            this.setNonIdentical();
        }

        private void setNonIdentical() {
            this.value = JgclCurveCurveInterferenceList.access$1();
        }

        private void setIdentical() {
            this.value |= JgclCurveCurveInterferenceList.access$2();
        }

        private void setCrossBoundaryOfA() {
            this.value |= JgclCurveCurveInterferenceList.access$3();
        }

        private void setCrossBoundaryOfB() {
            this.value |= JgclCurveCurveInterferenceList.access$4();
        }

        private boolean isIdentical() {
            return (this.value & JgclCurveCurveInterferenceList.access$2()) != 0;
        }

        private boolean isCrossBoundaryOfA() {
            return (this.value & JgclCurveCurveInterferenceList.access$3()) != 0;
        }

        private boolean isCrossBoundaryOfB() {
            return (this.value & JgclCurveCurveInterferenceList.access$4()) != 0;
        }
    }

    class IntersectionInfo {
        JgclPoint coord;
        double paramA;
        double paramB;
        double pTolA;
        double pTolB;

        IntersectionInfo(JgclPoint coord, double paramA, double paramB) {
            JgclCurveCurveInterferenceList.this = JgclCurveCurveInterferenceList.this;
            this.coord = coord;
            this.paramA = paramA;
            this.paramB = paramB;
            this.pTolA = JgclCurveCurveInterferenceList.this.getToleranceForParameter(JgclCurveCurveInterferenceList.this.curveA, paramA);
            this.pTolB = JgclCurveCurveInterferenceList.this.getToleranceForParameter(JgclCurveCurveInterferenceList.this.curveB, paramB);
        }

        IntersectionInfo(JgclPoint coord, double paramA, double paramB, double pTolA, double pTolB) {
            JgclCurveCurveInterferenceList.this = JgclCurveCurveInterferenceList.this;
            this.coord = coord;
            this.paramA = paramA;
            this.paramB = paramB;
            this.pTolA = pTolA;
            this.pTolB = pTolB;
        }

        private ParametricalIdentityOfTwoIntersections getParametricalIdentityWith(IntersectionInfo mate) {
            ParametricalIdentityOfTwoIntersections result = new ParametricalIdentityOfTwoIntersections();
            if (this == mate) {
                result.setIdentical();
                return result;
            }
            double diffA = Math.abs(this.paramA - mate.paramA);
            double diffB = Math.abs(this.paramB - mate.paramB);
            double pTolA = Math.max(this.pTolA, mate.pTolA);
            double pTolB = Math.max(this.pTolB, mate.pTolB);
            if (JgclCurveCurveInterferenceList.this.parameterDomainA.isPeriodic() && Math.abs(diffA - JgclCurveCurveInterferenceList.this.parameterDomainA.section().absIncrease()) < pTolA) {
                result.setCrossBoundaryOfA();
            }
            if (JgclCurveCurveInterferenceList.this.parameterDomainB.isPeriodic() && Math.abs(diffB - JgclCurveCurveInterferenceList.this.parameterDomainB.section().absIncrease()) < pTolB) {
                result.setCrossBoundaryOfB();
            }
            if ((result.isCrossBoundaryOfA() || diffA < pTolA) && (result.isCrossBoundaryOfB() || diffB < pTolB)) {
                result.setIdentical();
            }
            return result;
        }

        private boolean isIdenticalWith(IntersectionInfo mate) {
            if (this.coord != null && mate.coord != null && (JgclCurveCurveInterferenceList.this.dimension == 2 ? !((JgclPoint2D)this.coord).identical((JgclPoint2D)mate.coord) : !((JgclPoint3D)this.coord).identical((JgclPoint3D)mate.coord))) {
                return false;
            }
            return this.getParametricalIdentityWith(mate).isIdentical();
        }

        boolean isContainedIn(OverlapInfo ovlp) {
            if (this.isIdenticalWith(ovlp.headPoint)) {
                return true;
            }
            if (this.isIdenticalWith(ovlp.tailPoint)) {
                return true;
            }
            int i = 0;
            while (i < 2) {
                double ovlpUpper;
                double ovlpLower;
                double ovlpTailPTol;
                double ovlpHeadPTol;
                double ovlpTail;
                double ovlpHead;
                boolean ovlpCrossBoundary;
                double thisParam;
                if (i == 0) {
                    thisParam = this.paramA;
                    ovlpCrossBoundary = ovlp.crossBoundaryA;
                    ovlpHead = ovlp.headPoint.paramA;
                    ovlpTail = ovlp.tailPoint.paramA;
                    ovlpHeadPTol = ovlp.headPoint.pTolA;
                    ovlpTailPTol = ovlp.tailPoint.pTolA;
                } else {
                    thisParam = this.paramB;
                    ovlpCrossBoundary = ovlp.crossBoundaryB;
                    ovlpHead = ovlp.headPoint.paramB;
                    ovlpTail = ovlp.tailPoint.paramB;
                    ovlpHeadPTol = ovlp.headPoint.pTolB;
                    ovlpTailPTol = ovlp.tailPoint.pTolB;
                }
                if (ovlpHead < ovlpTail) {
                    ovlpLower = ovlpHead - ovlpHeadPTol;
                    ovlpUpper = ovlpTail + ovlpTailPTol;
                } else {
                    ovlpLower = ovlpTail - ovlpTailPTol;
                    ovlpUpper = ovlpHead + ovlpHeadPTol;
                }
                if (ovlpCrossBoundary) {
                    double swap = ovlpLower;
                    ovlpLower = ovlpUpper;
                    ovlpUpper = swap;
                }
                if (thisParam < ovlpLower && ovlpUpper < thisParam) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    class OverlapInfo {
        IntersectionInfo headPoint;
        IntersectionInfo tailPoint;
        private boolean crossBoundaryA;
        private boolean crossBoundaryB;

        OverlapInfo(double headParamA, double headParamB, double increaseParamA, double increaseParamB) {
            JgclCurveCurveInterferenceList.this = JgclCurveCurveInterferenceList.this;
            headParamA = JgclCurveCurveInterferenceList.this.parameterDomainA.wrap(headParamA);
            headParamB = JgclCurveCurveInterferenceList.this.parameterDomainB.wrap(headParamB);
            double tailParamA = JgclCurveCurveInterferenceList.this.parameterDomainA.wrap(headParamA + increaseParamA);
            double tailParamB = JgclCurveCurveInterferenceList.this.parameterDomainB.wrap(headParamB + increaseParamB);
            JgclCurveCurveInterferenceList jgclCurveCurveInterferenceList = JgclCurveCurveInterferenceList.this;
            jgclCurveCurveInterferenceList.getClass();
            this.headPoint = jgclCurveCurveInterferenceList.new IntersectionInfo(null, headParamA, headParamB);
            JgclCurveCurveInterferenceList jgclCurveCurveInterferenceList2 = JgclCurveCurveInterferenceList.this;
            jgclCurveCurveInterferenceList2.getClass();
            this.tailPoint = jgclCurveCurveInterferenceList2.new IntersectionInfo(null, tailParamA, tailParamB);
            this.crossBoundaryA = headParamA > tailParamA && increaseParamA > 0.0 || headParamA < tailParamA && increaseParamA < 0.0;
            this.crossBoundaryB = headParamB > tailParamB && increaseParamB > 0.0 || headParamB < tailParamB && increaseParamB < 0.0;
        }

        OverlapInfo(double headParamA, double headParamB, double increaseParamA, double increaseParamB, double headPTolA, double headPTolB, double tailPTolA, double tailPTolB) {
            JgclCurveCurveInterferenceList.this = JgclCurveCurveInterferenceList.this;
            headParamA = JgclCurveCurveInterferenceList.this.parameterDomainA.wrap(headParamA);
            headParamB = JgclCurveCurveInterferenceList.this.parameterDomainB.wrap(headParamB);
            double tailParamA = JgclCurveCurveInterferenceList.this.parameterDomainA.wrap(headParamA + increaseParamA);
            double tailParamB = JgclCurveCurveInterferenceList.this.parameterDomainB.wrap(headParamB + increaseParamB);
            JgclCurveCurveInterferenceList jgclCurveCurveInterferenceList = JgclCurveCurveInterferenceList.this;
            jgclCurveCurveInterferenceList.getClass();
            this.headPoint = jgclCurveCurveInterferenceList.new IntersectionInfo(null, headParamA, headParamB, headPTolA, headPTolB);
            JgclCurveCurveInterferenceList jgclCurveCurveInterferenceList2 = JgclCurveCurveInterferenceList.this;
            jgclCurveCurveInterferenceList2.getClass();
            this.tailPoint = jgclCurveCurveInterferenceList2.new IntersectionInfo(null, tailParamA, tailParamB, tailPTolA, tailPTolB);
            this.crossBoundaryA = headParamA > tailParamA && increaseParamA > 0.0 || headParamA < tailParamA && increaseParamA < 0.0;
            this.crossBoundaryB = headParamB > tailParamB && increaseParamB > 0.0 || headParamB < tailParamB && increaseParamB < 0.0;
        }

        private void setCrossBoundaryFlags(OverlapInfo mate, ParametricalIdentityOfTwoIntersections identity) {
            if (mate.crossBoundaryA || identity.isCrossBoundaryOfA()) {
                this.crossBoundaryA = true;
            }
            if (mate.crossBoundaryB || identity.isCrossBoundaryOfB()) {
                this.crossBoundaryB = true;
            }
        }

        private double computeIncreaseA() {
            double increase = this.tailPoint.paramA - this.headPoint.paramA;
            if (JgclCurveCurveInterferenceList.this.parameterDomainA.isPeriodic() && this.crossBoundaryA) {
                increase = increase > 0.0 ? (increase -= JgclCurveCurveInterferenceList.this.parameterDomainA.section().absIncrease()) : (increase += JgclCurveCurveInterferenceList.this.parameterDomainA.section().absIncrease());
            }
            return increase;
        }

        private double computeIncreaseB() {
            double increase = this.tailPoint.paramB - this.headPoint.paramB;
            if (JgclCurveCurveInterferenceList.this.parameterDomainB.isPeriodic() && this.crossBoundaryB) {
                increase = increase > 0.0 ? (increase -= JgclCurveCurveInterferenceList.this.parameterDomainB.section().absIncrease()) : (increase += JgclCurveCurveInterferenceList.this.parameterDomainB.section().absIncrease());
            }
            return increase;
        }

        boolean mergeIfConnectWith(OverlapInfo mate) {
            if (this == mate) {
                return false;
            }
            ParametricalIdentityOfTwoIntersections identity = this.headPoint.getParametricalIdentityWith(mate.headPoint);
            if (identity.isIdentical()) {
                this.headPoint = mate.tailPoint;
                this.setCrossBoundaryFlags(mate, identity);
                return true;
            }
            identity = this.headPoint.getParametricalIdentityWith(mate.tailPoint);
            if (identity.isIdentical()) {
                this.headPoint = mate.headPoint;
                this.setCrossBoundaryFlags(mate, identity);
                return true;
            }
            identity = this.tailPoint.getParametricalIdentityWith(mate.headPoint);
            if (identity.isIdentical()) {
                this.tailPoint = mate.tailPoint;
                this.setCrossBoundaryFlags(mate, identity);
                return true;
            }
            identity = this.tailPoint.getParametricalIdentityWith(mate.tailPoint);
            if (identity.isIdentical()) {
                this.tailPoint = mate.headPoint;
                this.setCrossBoundaryFlags(mate, identity);
                return true;
            }
            return false;
        }

        boolean isContainedIn(OverlapInfo mate) {
            if (mate == this) {
                return false;
            }
            int i = 0;
            while (i < 2) {
                double mateUpper;
                double mateLower;
                double mateTailPTol;
                double mateHeadPTol;
                double mateTail;
                double mateHead;
                boolean mateCrossBoundary;
                double thisTail;
                double thisHead;
                boolean thisCrossBoundary;
                if (i == 0) {
                    thisCrossBoundary = this.crossBoundaryA;
                    thisHead = this.headPoint.paramA;
                    thisTail = this.tailPoint.paramA;
                    mateCrossBoundary = mate.crossBoundaryA;
                    mateHead = mate.headPoint.paramA;
                    mateTail = mate.tailPoint.paramA;
                    mateHeadPTol = mate.headPoint.pTolA;
                    mateTailPTol = mate.tailPoint.pTolA;
                } else {
                    thisCrossBoundary = this.crossBoundaryB;
                    thisHead = this.headPoint.paramB;
                    thisTail = this.tailPoint.paramB;
                    mateCrossBoundary = mate.crossBoundaryB;
                    mateHead = mate.headPoint.paramB;
                    mateTail = mate.tailPoint.paramB;
                    mateHeadPTol = mate.headPoint.pTolB;
                    mateTailPTol = mate.tailPoint.pTolB;
                }
                if (!mateCrossBoundary) {
                    if (thisCrossBoundary) {
                        return false;
                    }
                    if (mateHead < mateTail) {
                        mateLower = mateHead - mateHeadPTol;
                        mateUpper = mateTail + mateTailPTol;
                    } else {
                        mateLower = mateTail - mateTailPTol;
                        mateUpper = mateHead + mateHeadPTol;
                    }
                    if (thisHead < mateLower || mateUpper < thisHead || thisTail < mateLower || mateUpper < thisTail) {
                        return false;
                    }
                } else {
                    if (mateHead < mateTail) {
                        mateLower = mateTail - mateTailPTol;
                        mateUpper = mateHead + mateHeadPTol;
                    } else {
                        mateLower = mateHead - mateHeadPTol;
                        mateUpper = mateTail + mateTailPTol;
                    }
                    if (mateUpper < thisHead && thisHead < mateLower || mateUpper < thisTail && thisTail < mateLower) {
                        return false;
                    }
                    if (!thisCrossBoundary && (mateUpper < thisHead || mateUpper < thisTail) && (thisHead < mateLower || thisTail < mateLower)) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
    }
}

