/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Enumeration;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCurveBoundedSurface3D;
import jp.go.ipa.jgcl.JgclDimensionsMismatch;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclNullArgument;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParametricCurve;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;

class JgclCurveSurfaceInterferenceList {
    JgclParametricCurve curveA;
    JgclParameterDomain parameterDomainA;
    JgclParametricSurface surfaceB;
    JgclParameterDomain uParameterDomainB;
    JgclParameterDomain vParameterDomainB;
    JgclToleranceForDistance dTol;
    Vector listOfIntersections;
    private static final int PARAMETERS_NOT_IDENTICAL = 0;
    private static final int PARAMETERS_IDENTICAL = 1;
    private static final int PARAMETERS_CROSSBOUNDARY_A = 2;
    private static final int PARAMETERS_CROSSBOUNDARY_U_B = 4;
    private static final int PARAMETERS_CROSSBOUNDARY_V_B = 8;

    JgclCurveSurfaceInterferenceList(JgclParametricCurve curveA, JgclParametricSurface surfaceB) {
        if (curveA == null || surfaceB == null) {
            throw new JgclNullArgument();
        }
        if (curveA.dimension() != surfaceB.dimension()) {
            throw new JgclDimensionsMismatch();
        }
        this.curveA = curveA;
        this.parameterDomainA = curveA.parameterDomain();
        this.surfaceB = surfaceB;
        if (((JgclParametricSurface3D)surfaceB).type() != 33) {
            this.uParameterDomainB = surfaceB.uParameterDomain();
            this.vParameterDomainB = surfaceB.vParameterDomain();
        } else {
            JgclParametricSurface3D basisSurface = ((JgclCurveBoundedSurface3D)surfaceB).basisSurface();
            this.uParameterDomainB = basisSurface.uParameterDomain();
            this.vParameterDomainB = basisSurface.vParameterDomain();
        }
        JgclConditionOfOperation cond = JgclConditionOfOperation.getCondition();
        this.dTol = cond.getToleranceForDistanceAsObject();
        this.listOfIntersections = new Vector();
    }

    private double getToleranceForParameter(JgclParametricCurve curve, double param) {
        return this.dTol.toToleranceForParameter((JgclParametricCurve3D)curve, param).value();
    }

    private double getToleranceForParameterU(JgclParametricSurface surface, double uParam, double vParam) {
        return this.dTol.toToleranceForParameterU((JgclParametricSurface3D)surface, uParam, vParam).value();
    }

    private double getToleranceForParameterV(JgclParametricSurface surface, double uParam, double vParam) {
        return this.dTol.toToleranceForParameterV((JgclParametricSurface3D)surface, uParam, vParam).value();
    }

    void addIntersection(IntersectionInfo theIntersection) {
        Enumeration e = this.listOfIntersections.elements();
        while (e.hasMoreElements()) {
            if (!theIntersection.isIdenticalWith((IntersectionInfo)e.nextElement())) continue;
            return;
        }
        this.listOfIntersections.addElement(theIntersection);
    }

    void addAsIntersection(JgclPoint coord, double paramA, double uParamB, double vParamB) {
        this.addIntersection(new IntersectionInfo(coord, paramA, uParamB, vParamB));
    }

    void addAsIntersection(JgclPoint coord, double paramA, double uParamB, double vParamB, double pTolA, double pTolBu, double pTolBv) {
        this.addIntersection(new IntersectionInfo(coord, paramA, uParamB, vParamB, pTolA, pTolBu, pTolBv));
    }

    JgclIntersectionPoint3D[] toJgclIntersectionPoint3DArray(boolean doExchange) {
        int totalSize = this.listOfIntersections.size();
        JgclIntersectionPoint3D[] result = new JgclIntersectionPoint3D[totalSize];
        int i = 0;
        Enumeration e = this.listOfIntersections.elements();
        while (e.hasMoreElements()) {
            IntersectionInfo ints = (IntersectionInfo)e.nextElement();
            if (!doExchange) {
                result[i++] = ints.coord == null ? new JgclIntersectionPoint3D((JgclParametricCurve3D)this.curveA, ints.paramA, (JgclParametricSurface3D)this.surfaceB, ints.uParamB, ints.vParamB, false) : new JgclIntersectionPoint3D((JgclPoint3D)ints.coord, (JgclParametricCurve3D)this.curveA, ints.paramA, (JgclParametricSurface3D)this.surfaceB, ints.uParamB, ints.vParamB, false);
                continue;
            }
            JgclIntersectionPoint3D jgclIntersectionPoint3D = result[i++] = ints.coord == null ? new JgclIntersectionPoint3D((JgclParametricSurface3D)this.surfaceB, ints.uParamB, ints.vParamB, (JgclParametricCurve3D)this.curveA, ints.paramA, false) : new JgclIntersectionPoint3D((JgclPoint3D)ints.coord, (JgclParametricSurface3D)this.surfaceB, ints.uParamB, ints.vParamB, (JgclParametricCurve3D)this.curveA, ints.paramA, false);
        }
        return result;
    }

    static /* synthetic */ int access$3() {
        return 0;
    }

    static /* synthetic */ int access$4() {
        return 1;
    }

    static /* synthetic */ int access$5() {
        return 2;
    }

    static /* synthetic */ int access$6() {
        return 4;
    }

    static /* synthetic */ int access$7() {
        return 8;
    }

    class ParametricalIdentityOfTwoIntersections {
        private int value;

        ParametricalIdentityOfTwoIntersections() {
            JgclCurveSurfaceInterferenceList.this = JgclCurveSurfaceInterferenceList.this;
            this.setNonIdentical();
        }

        private void setNonIdentical() {
            this.value = JgclCurveSurfaceInterferenceList.access$3();
        }

        private void setIdentical() {
            this.value |= JgclCurveSurfaceInterferenceList.access$4();
        }

        private void setCrossBoundaryOfA() {
            this.value |= JgclCurveSurfaceInterferenceList.access$5();
        }

        private void setCrossBoundaryOfBu() {
            this.value |= JgclCurveSurfaceInterferenceList.access$6();
        }

        private void setCrossBoundaryOfBv() {
            this.value |= JgclCurveSurfaceInterferenceList.access$7();
        }

        private boolean isIdentical() {
            return (this.value & JgclCurveSurfaceInterferenceList.access$4()) != 0;
        }

        private boolean isCrossBoundaryOfA() {
            return (this.value & JgclCurveSurfaceInterferenceList.access$5()) != 0;
        }

        private boolean isCrossBoundaryOfBu() {
            return (this.value & JgclCurveSurfaceInterferenceList.access$6()) != 0;
        }

        private boolean isCrossBoundaryOfBv() {
            return (this.value & JgclCurveSurfaceInterferenceList.access$7()) != 0;
        }
    }

    class IntersectionInfo {
        JgclPoint coord;
        double paramA;
        double uParamB;
        double vParamB;
        double pTolA;
        double pTolBu;
        double pTolBv;

        IntersectionInfo(JgclPoint coord, double paramA, double uParamB, double vParamB) {
            JgclCurveSurfaceInterferenceList.this = JgclCurveSurfaceInterferenceList.this;
            this.coord = coord;
            this.paramA = paramA;
            this.uParamB = uParamB;
            this.vParamB = vParamB;
            this.pTolA = JgclCurveSurfaceInterferenceList.this.getToleranceForParameter(JgclCurveSurfaceInterferenceList.this.curveA, paramA);
            this.pTolBu = JgclCurveSurfaceInterferenceList.this.getToleranceForParameterU(JgclCurveSurfaceInterferenceList.this.surfaceB, uParamB, vParamB);
            this.pTolBv = JgclCurveSurfaceInterferenceList.this.getToleranceForParameterV(JgclCurveSurfaceInterferenceList.this.surfaceB, uParamB, vParamB);
        }

        IntersectionInfo(JgclPoint coord, double paramA, double uParamB, double vParamB, double pTolA, double pTolBu, double pTolBv) {
            JgclCurveSurfaceInterferenceList.this = JgclCurveSurfaceInterferenceList.this;
            this.coord = coord;
            this.paramA = paramA;
            this.uParamB = uParamB;
            this.vParamB = vParamB;
            this.pTolA = pTolA;
            this.pTolBu = pTolBu;
            this.pTolBv = pTolBv;
        }

        private ParametricalIdentityOfTwoIntersections getParametricalIdentityWith(IntersectionInfo mate) {
            ParametricalIdentityOfTwoIntersections result = new ParametricalIdentityOfTwoIntersections();
            if (this == mate) {
                result.setIdentical();
                return result;
            }
            double diffA = Math.abs(this.paramA - mate.paramA);
            double diffBu = Math.abs(this.uParamB - mate.uParamB);
            double diffBv = Math.abs(this.vParamB - mate.vParamB);
            double pTolA = Math.max(this.pTolA, mate.pTolA);
            double pTolBu = Math.max(this.pTolBu, mate.pTolBu);
            double pTolBv = Math.max(this.pTolBv, mate.pTolBv);
            if (JgclCurveSurfaceInterferenceList.this.parameterDomainA.isPeriodic() && Math.abs(diffA - JgclCurveSurfaceInterferenceList.this.parameterDomainA.section().absIncrease()) < pTolA) {
                result.setCrossBoundaryOfA();
            }
            if (JgclCurveSurfaceInterferenceList.this.uParameterDomainB.isPeriodic() && Math.abs(diffBu - JgclCurveSurfaceInterferenceList.this.uParameterDomainB.section().absIncrease()) < pTolBu) {
                result.setCrossBoundaryOfBu();
            }
            if (JgclCurveSurfaceInterferenceList.this.vParameterDomainB.isPeriodic() && Math.abs(diffBv - JgclCurveSurfaceInterferenceList.this.vParameterDomainB.section().absIncrease()) < pTolBv) {
                result.setCrossBoundaryOfBv();
            }
            if ((result.isCrossBoundaryOfA() || diffA < pTolA) && (result.isCrossBoundaryOfBu() || diffBu < pTolBu) && (result.isCrossBoundaryOfBv() || diffBv < pTolBv)) {
                result.setIdentical();
            }
            return result;
        }

        private boolean isIdenticalWith(IntersectionInfo mate) {
            if (this.coord != null && mate.coord != null && !((JgclPoint3D)this.coord).identical((JgclPoint3D)mate.coord)) {
                return false;
            }
            return this.getParametricalIdentityWith(mate).isIdentical();
        }
    }
}

