/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Enumeration;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclDulaunayDiagram2D;
import jp.go.ipa.jgcl.JgclEmbeddedGraph;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclVoronoiDiagram2D;

public class JgclDulaunayDiagram2D {
    private JgclEmbeddedGraph graph;
    private DVertex[] vertices;
    private Vector coincidingVertices;

    public JgclDulaunayDiagram2D(JgclEmbeddedGraph seed, JgclVoronoiDiagram2D voronoiDiagram) {
        JgclEmbeddedGraph voronoiGraph = voronoiDiagram.getGraph();
        int nFaces = voronoiGraph.getNumberOfFaces();
        int nCcfs = voronoiDiagram.getNumberOfPairsOfCoincidingRegions();
        this.graph = voronoiGraph.dualCopy(seed);
        this.vertices = new DVertex[nFaces + nCcfs];
        this.coincidingVertices = new Vector();
        Enumeration e = this.graph.vertexElements();
        while (e.hasMoreElements()) {
            JgclEmbeddedGraph.Vertex vrtx = (JgclEmbeddedGraph.Vertex)e.nextElement();
            JgclVoronoiDiagram2D.VRegion rgn = (JgclVoronoiDiagram2D.VRegion)vrtx.getUserData();
            if (rgn != null) {
                int index = rgn.getIndex();
                DVertex dvrtx = this.vertices[index] = new DVertex(index, rgn.getCoordinates());
                dvrtx.setVertex(vrtx);
                dvrtx.setUserData(rgn.getUserData());
                vrtx.setUserData(dvrtx);
                continue;
            }
            vrtx.setUserData(null);
        }
        Enumeration e2 = this.graph.faceElements();
        while (e2.hasMoreElements()) {
            JgclEmbeddedGraph.Face face = (JgclEmbeddedGraph.Face)e2.nextElement();
            JgclVoronoiDiagram2D.VPoint pnt = (JgclVoronoiDiagram2D.VPoint)face.getUserData();
            DFace dface = new DFace(true);
            dface.setUserData(pnt.getUserData());
            face.setUserData(dface);
        }
        Vector<JgclEmbeddedGraph.Edge> uselessEdges = new Vector<JgclEmbeddedGraph.Edge>();
        Enumeration e3 = this.graph.edgeElements();
        while (e3.hasMoreElements()) {
            JgclEmbeddedGraph.Edge edge = (JgclEmbeddedGraph.Edge)e3.nextElement();
            JgclEmbeddedGraph.Vertex[] vrtcs = edge.getVertices();
            if (vrtcs[0].getUserData() != null && vrtcs[1].getUserData() != null) continue;
            uselessEdges.addElement(edge);
        }
        int n_edges = uselessEdges.size();
        int i = 0;
        while (i < n_edges) {
            JgclEmbeddedGraph.Edge edge = (JgclEmbeddedGraph.Edge)uselessEdges.elementAt(i);
            JgclEmbeddedGraph.Face rightFace = edge.getRightFace();
            if (i != n_edges - 1) {
                this.graph.killEdgeFace(edge, rightFace);
            } else {
                this.graph.killEdgeVertex(edge);
                DFace dface = (DFace)rightFace.getUserData();
                dface.setInner(false);
            }
            ++i;
        }
        Enumeration e4 = voronoiDiagram.coincidingRegionElements();
        while (e4.hasMoreElements()) {
            JgclVoronoiDiagram2D.VRegion rgn = (JgclVoronoiDiagram2D.VRegion)e4.nextElement();
            JgclVoronoiDiagram2D.VRegion mate = (JgclVoronoiDiagram2D.VRegion)rgn.getFace().getUserData();
            int index = rgn.getIndex();
            DVertex dvrtx = this.vertices[index] = new DVertex(index, rgn.getCoordinates());
            dvrtx.setVertex(this.vertices[mate.getIndex()].getVertex());
            dvrtx.setUserData(rgn.getUserData());
            this.coincidingVertices.addElement(dvrtx);
        }
    }

    public JgclEmbeddedGraph getGraph() {
        return this.graph;
    }

    public int getNumberOfPairsOfCoincidingVertices() {
        return this.coincidingVertices.size();
    }

    public Enumeration getCoincidingVertexElements() {
        return this.coincidingVertices.elements();
    }

    public Enumeration vertexElements() {
        return new 2(this);
    }

    public Enumeration faceElements() {
        return new 3(this);
    }

    public JgclEmbeddedGraph stripGeometries() {
        Enumeration e = this.graph.vertexElements();
        while (e.hasMoreElements()) {
            JgclEmbeddedGraph.Vertex vrtx = (JgclEmbeddedGraph.Vertex)e.nextElement();
            DVertex dvrtx = (DVertex)vrtx.getUserData();
            if (dvrtx == null) continue;
            vrtx.setUserData(dvrtx.getUserData());
        }
        Enumeration e2 = this.graph.faceElements();
        while (e2.hasMoreElements()) {
            JgclEmbeddedGraph.Face face = (JgclEmbeddedGraph.Face)e2.nextElement();
            DFace dface = (DFace)face.getUserData();
            if (dface == null) continue;
            face.setUserData(dface.getUserData());
        }
        this.vertices = null;
        this.coincidingVertices = null;
        return this.graph;
    }

    public static void main(String[] args) {
        Vector<JgclCartesianPoint2D> points = new Vector<JgclCartesianPoint2D>();
        points.addElement(new JgclCartesianPoint2D(0.0, 0.0));
        points.addElement(new JgclCartesianPoint2D(1.0, 0.0));
        points.addElement(new JgclCartesianPoint2D(1.0, 1.0));
        points.addElement(new JgclCartesianPoint2D(0.0, 1.0));
        JgclVoronoiDiagram2D voronoi = new JgclVoronoiDiagram2D(new JgclEmbeddedGraph(), points.elements());
        JgclDulaunayDiagram2D dulaunay = new JgclDulaunayDiagram2D(new JgclEmbeddedGraph(), voronoi);
        System.out.println("# Vertices");
        Enumeration e = dulaunay.vertexElements();
        while (e.hasMoreElements()) {
            DVertex dvrtx = (DVertex)e.nextElement();
            int idx = dvrtx.getIndex();
            JgclPoint2D crd = dvrtx.getCoordinates();
            System.out.println("# [" + idx + "] " + crd.x() + ", " + crd.y());
            Enumeration e1 = dvrtx.getDFaceCycleInCCW();
            while (e1.hasMoreElements()) {
                DFace dface = (DFace)e1.nextElement();
                if (dface.isInner()) {
                    System.out.println("#\tface");
                    continue;
                }
                System.out.println("#\tnull");
            }
        }
        System.out.println("# Faces");
        int j = 0;
        Enumeration e2 = dulaunay.faceElements();
        while (e2.hasMoreElements()) {
            DFace dface = (DFace)e2.nextElement();
            System.out.println("# [" + j + "] ");
            ++j;
        }
        JgclEmbeddedGraph graph = dulaunay.getGraph();
        int i = 0;
        Enumeration e3 = graph.edgeElements();
        while (e3.hasMoreElements()) {
            JgclEmbeddedGraph.Edge edge = (JgclEmbeddedGraph.Edge)e3.nextElement();
            JgclEmbeddedGraph.Vertex[] vrtcs = edge.getVertices();
            DVertex vpnt0 = (DVertex)vrtcs[0].getUserData();
            DVertex vpnt1 = (DVertex)vrtcs[1].getUserData();
            JgclPoint2D pnt0 = vpnt0.getCoordinates();
            JgclPoint2D pnt1 = vpnt1.getCoordinates();
            System.out.println("JgclLine2D\tlin" + i);
            System.out.println("\tpnt\t" + pnt0.x() + " " + pnt0.y());
            System.out.println("\tpnt\t" + pnt1.x() + " " + pnt1.y());
            System.out.println("End");
            ++i;
        }
    }

    public class DVertex {
        private int index;
        private JgclPoint2D coordinates;
        private JgclEmbeddedGraph.Vertex vrtx;
        private Object userData;

        DVertex(int index, JgclPoint2D coordinates) {
            JgclDulaunayDiagram2D.this = JgclDulaunayDiagram2D.this;
            this.index = index;
            this.coordinates = coordinates;
            this.vrtx = null;
            this.userData = null;
        }

        public int getIndex() {
            return this.index;
        }

        public JgclPoint2D getCoordinates() {
            return this.coordinates;
        }

        void setVertex(JgclEmbeddedGraph.Vertex vrtx) {
            this.vrtx = vrtx;
        }

        public JgclEmbeddedGraph.Vertex getVertex() {
            return this.vrtx;
        }

        public void setUserData(Object userData) {
            this.userData = userData;
        }

        public Object getUserData() {
            return this.userData;
        }

        public Enumeration getDFaceCycleInCCW() {
            return new 1(this);
        }

        static /* synthetic */ JgclEmbeddedGraph.Vertex access$0(DVertex $0) {
            return $0.vrtx;
        }
    }

    public class DFace {
        private boolean inner;
        private Object userData;

        DFace(boolean inner) {
            JgclDulaunayDiagram2D.this = JgclDulaunayDiagram2D.this;
            this.inner = inner;
            this.userData = null;
        }

        public void setInner(boolean inner) {
            this.inner = inner;
        }

        public boolean isInner() {
            return this.inner;
        }

        public void setUserData(Object userData) {
            this.userData = userData;
        }

        public Object getUserData() {
            return this.userData;
        }
    }

    private final class 2
    implements Enumeration {
        Enumeration e;

        public boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        public Object nextElement() {
            return ((JgclEmbeddedGraph.Vertex)this.e.nextElement()).getUserData();
        }

        /* synthetic */ 2(JgclDulaunayDiagram2D this$0) {
            this.e = this$0.graph.vertexElements();
        }
    }

    private final class 3
    implements Enumeration {
        Enumeration e;
        Object nextNonOuterFace;

        public boolean hasMoreElements() {
            if (this.nextNonOuterFace != null) {
                return true;
            }
            if (!this.e.hasMoreElements()) {
                return false;
            }
            Object obj = this.e.nextElement();
            DFace dface = (DFace)((JgclEmbeddedGraph.Face)obj).getUserData();
            if (dface.isInner()) {
                this.nextNonOuterFace = obj;
                return true;
            }
            this.nextNonOuterFace = null;
            return this.e.hasMoreElements();
        }

        public Object nextElement() {
            if (this.nextNonOuterFace != null) {
                Object obj = this.nextNonOuterFace;
                this.nextNonOuterFace = null;
                return ((JgclEmbeddedGraph.Face)obj).getUserData();
            }
            Object obj = this.e.nextElement();
            DFace dface = (DFace)((JgclEmbeddedGraph.Face)obj).getUserData();
            if (dface.isInner()) {
                return ((JgclEmbeddedGraph.Face)obj).getUserData();
            }
            return ((JgclEmbeddedGraph.Face)this.e.nextElement()).getUserData();
        }

        /* synthetic */ 3(JgclDulaunayDiagram2D this$0) {
            this.e = this$0.graph.faceElements();
        }
    }
}

