/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Enumeration;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;

public class JgclEmbeddedGraph
implements Cloneable {
    private GraphItemMaker graphItemMaker;
    private Vector vrtxList;
    private Vector edgeList;
    private Vector faceList;

    protected void setGraphItemMaker(GraphItemMaker maker) {
        this.graphItemMaker = maker;
    }

    public synchronized int getNumberOfVertices() {
        return this.vrtxList.size();
    }

    public synchronized int getNumberOfEdges() {
        return this.edgeList.size();
    }

    public synchronized int getNumberOfFaces() {
        return this.faceList.size();
    }

    public synchronized Enumeration vertexElements() {
        return this.vrtxList.elements();
    }

    public synchronized Enumeration edgeElements() {
        return new 1(this);
    }

    public synchronized Enumeration faceElements() {
        return this.faceList.elements();
    }

    private Vertex addVertex() {
        Vertex vrtx = this.graphItemMaker.newVertex();
        this.vrtxList.addElement(vrtx);
        return vrtx;
    }

    private Face addFace() {
        Face face = this.graphItemMaker.newFace();
        this.faceList.addElement(face);
        return face;
    }

    private Edge addEdge() {
        EdgeContainer edgeContainer = new EdgeContainer();
        this.edgeList.addElement(edgeContainer);
        return edgeContainer.getHalfA();
    }

    private void removeVertex(Vertex vrtx) {
        this.vrtxList.removeElement(vrtx);
    }

    private void removeFace(Face face) {
        this.faceList.removeElement(face);
    }

    private void removeEdge(Edge edge) {
        this.edgeList.removeElement(edge.getContainer());
    }

    public boolean contains(Vertex vrtx) {
        if (!(vrtx != null && vrtx.getGraph() == this)) {
            return false;
        }
        return this.vrtxList.contains(vrtx);
    }

    public boolean contains(Face face) {
        if (!(face != null && face.getGraph() == this)) {
            return false;
        }
        return this.faceList.contains(face);
    }

    public boolean contains(Edge edge) {
        if (!(edge != null && edge.getGraph() == this)) {
            return false;
        }
        return this.edgeList.contains(edge.getContainer());
    }

    public JgclEmbeddedGraph() {
        this.graphItemMaker = new 2();
        this.vrtxList = new Vector();
        this.edgeList = new Vector();
        this.faceList = new Vector();
    }

    public JgclEmbeddedGraph(GraphItemMaker maker) {
        this.graphItemMaker = maker;
        this.vrtxList = new Vector();
        this.edgeList = new Vector();
        this.faceList = new Vector();
    }

    public synchronized Result makeVertexFace() {
        if (this.vrtxList.size() != 0 || this.edgeList.size() != 0 || this.faceList.size() != 0) {
            throw new JgclFatal("The graph is not empty.");
        }
        Vertex newV = this.addVertex();
        Face newF = this.addFace();
        newV.setFirstEdge(null);
        newF.setFirstEdge(null);
        return new Result(newV, null, newF);
    }

    public synchronized void killVertexFace() {
        if (this.vrtxList.size() != 1 || this.edgeList.size() != 0 || this.faceList.size() != 1) {
            throw new JgclFatal("The graph does not have only 1 vertex & 1 face.");
        }
        this.removeVertex((Vertex)this.vrtxList.elementAt(0));
        this.removeFace((Face)this.faceList.elementAt(0));
    }

    public synchronized Result makeEdgeVertex(Face face, Vertex vrtx) {
        Edge firstE;
        if (!this.contains(face)) {
            throw new JgclInvalidArgumentValue("Given face is not in the graph.");
        }
        if (!this.contains(vrtx)) {
            throw new JgclInvalidArgumentValue("Given vertex is not in the graph.");
        }
        Edge nextE = firstE = face.getFirstEdge();
        Edge prevE = null;
        if (nextE != null) {
            while (nextE.getVertex() != vrtx) {
                if ((nextE = nextE.getNextEdge()) != firstE) continue;
                throw new JgclInvalidArgumentValue("Given vertex is not in given face.");
            }
            prevE = nextE.getPrevEdge();
        }
        Vertex newV = this.addVertex();
        Edge newE = this.addEdge();
        Edge newM = newE.getMate();
        newV.setFirstEdge(newM);
        newE.setVertex(vrtx);
        newE.setFace(face);
        newE.setPrevEdge(prevE != null ? prevE : newM);
        newE.setNextEdge(newM);
        newM.setVertex(newV);
        newM.setFace(face);
        newM.setPrevEdge(newE);
        newM.setNextEdge(nextE != null ? nextE : newE);
        if (nextE != null) {
            prevE.setNextEdge(newE);
            nextE.setPrevEdge(newM);
        } else {
            face.setFirstEdge(newE);
            vrtx.setFirstEdge(newE);
        }
        return new Result(newV, newE, null);
    }

    public synchronized void killEdgeVertex(Edge edge) {
        if (!this.contains(edge)) {
            throw new JgclInvalidArgumentValue("Given edge is not in the graph.");
        }
        Edge mate = edge.getMate();
        if (edge.getFace() != mate.getFace()) {
            throw new JgclInvalidArgumentValue("Given edge is not dangling.");
        }
        if (edge.getNextEdge() != mate || mate.getPrevEdge() != edge) {
            if (edge.getPrevEdge() == mate && mate.getNextEdge() == edge) {
                edge = mate;
                mate = edge.getMate();
            } else {
                throw new JgclInvalidArgumentValue("Given edge is not dangling.");
            }
        }
        Face relatedF = edge.getFace();
        Vertex remainedV = edge.getVertex();
        Vertex removedV = mate.getVertex();
        Edge prevE = edge.getPrevEdge();
        Edge nextE = mate.getNextEdge();
        prevE.setNextEdge(nextE);
        nextE.setPrevEdge(prevE);
        if (!edge.isIdentWith(nextE)) {
            if (edge.isIdentWith(remainedV.getFirstEdge())) {
                remainedV.setFirstEdge(nextE);
            }
            if (edge.isIdentWith(relatedF.getFirstEdge())) {
                relatedF.setFirstEdge(nextE);
            }
        } else {
            remainedV.setFirstEdge(null);
            relatedF.setFirstEdge(null);
        }
        this.removeVertex(removedV);
        this.removeEdge(edge);
    }

    public synchronized Result makeVertexEdge(Edge edge) {
        if (!this.contains(edge)) {
            throw new JgclInvalidArgumentValue("Given edge is not in the graph.");
        }
        Vertex newV = this.addVertex();
        Edge newE = this.addEdge();
        Edge newM = newE.getMate();
        Edge mate = edge.getMate();
        Edge nextE = edge.getNextEdge();
        Edge prevE = mate.getPrevEdge();
        newE.setVertex(newV);
        newE.setFace(edge.getFace());
        newE.setPrevEdge(edge);
        newE.setNextEdge(nextE);
        newM.setVertex(mate.getVertex());
        newM.setFace(mate.getFace());
        newM.setPrevEdge(prevE);
        newM.setNextEdge(mate);
        edge.setNextEdge(newE);
        mate.setVertex(newV);
        mate.setPrevEdge(newM);
        nextE.setPrevEdge(newE);
        prevE.setNextEdge(newM);
        newV.setFirstEdge(newE);
        newM.getVertex().setFirstEdge(newM);
        return new Result(newV, newE, null);
    }

    public synchronized void killVertexEdge(Vertex vrtx, Edge edge) {
        Edge mate2;
        Edge edge1;
        if (!this.contains(vrtx)) {
            throw new JgclInvalidArgumentValue("Given vertex is not in the graph.");
        }
        if (!this.contains(edge)) {
            throw new JgclInvalidArgumentValue("Given edge is not in the graph.");
        }
        Edge firstE = vrtx.getFirstEdge();
        if (firstE == null) {
            throw new JgclInvalidArgumentValue("No edge is attached to given vertex.");
        }
        Edge secondE = vrtx.getNextEdgeInCCW(firstE);
        if (secondE == null) {
            throw new JgclInvalidArgumentValue("Only 1 edge is attached to given vertex.");
        }
        Edge thirdE = vrtx.getNextEdgeInCCW(secondE);
        if (!thirdE.isIdentWith(firstE)) {
            throw new JgclInvalidArgumentValue("3 or more edges are attached to given vertex.");
        }
        if (edge.isIdentWith(firstE)) {
            edge1 = firstE;
            mate2 = secondE;
        } else if (edge.isIdentWith(secondE)) {
            edge1 = secondE;
            mate2 = firstE;
        } else {
            throw new JgclInvalidArgumentValue("Given edge is not attached to given vertex.");
        }
        Edge mate1 = edge1.getMate();
        Edge edge2 = mate2.getMate();
        Edge nextE = edge1.getNextEdge();
        Edge prevE = mate1.getPrevEdge();
        Vertex vrtx1 = vrtx;
        Vertex vrtx2 = mate1.getVertex();
        if (nextE != mate1) {
            edge2.setNextEdge(nextE);
            nextE.setPrevEdge(edge2);
        } else {
            edge2.setNextEdge(mate2);
        }
        if (prevE != edge1) {
            mate2.setPrevEdge(prevE);
            prevE.setNextEdge(mate2);
        } else {
            mate2.setPrevEdge(edge2);
        }
        mate2.setVertex(vrtx2);
        if (edge1.isIdentWith(vrtx2.getFirstEdge())) {
            vrtx2.setFirstEdge(mate2);
        }
        this.removeVertex(vrtx1);
        this.removeEdge(edge1);
    }

    private Result makeEdgeFace(Face face, Vertex headVrtx, Edge nextHead, Edge prevHead, Vertex tailVrtx, Edge nextTail, Edge prevTail) {
        Face newF = this.addFace();
        Edge newE = this.addEdge();
        Edge newM = newE.getMate();
        face.setFirstEdge(newE);
        newF.setFirstEdge(newM);
        newE.setVertex(headVrtx);
        newE.setFace(face);
        newE.setPrevEdge(prevHead);
        newE.setNextEdge(nextTail);
        newM.setVertex(tailVrtx);
        newM.setFace(newF);
        newM.setPrevEdge(prevTail);
        newM.setNextEdge(nextHead);
        prevHead.setNextEdge(newE);
        prevTail.setNextEdge(newM);
        nextHead.setPrevEdge(newM);
        nextTail.setPrevEdge(newE);
        Edge edge = nextHead;
        while (edge != newM) {
            edge.setFace(newF);
            edge = edge.getNextEdge();
        }
        return new Result(null, newE, newF);
    }

    public synchronized Result makeEdgeFace(Face face, Vertex headVrtx, Vertex tailVrtx) {
        Edge prevTail;
        Edge prevHead;
        Edge nextTail;
        Edge nextHead;
        block7: {
            Edge firstE;
            if (!this.contains(face)) {
                throw new JgclInvalidArgumentValue("Given face is not in the graph.");
            }
            if (!this.contains(headVrtx) || !this.contains(tailVrtx)) {
                throw new JgclInvalidArgumentValue("Given vertex is not in the graph.");
            }
            if (headVrtx.isIdentWith(tailVrtx)) {
                throw new JgclInvalidArgumentValue("Given vertices are ideitical.");
            }
            Edge edge = firstE = face.getFirstEdge();
            if (firstE == null) {
                throw new JgclInvalidArgumentValue("Given face can not be divided.");
            }
            nextHead = null;
            nextTail = null;
            prevHead = null;
            prevTail = null;
            do {
                if (headVrtx.isIdentWith(edge.getVertex()) && nextHead == null) {
                    nextHead = edge;
                    prevHead = nextHead.getPrevEdge();
                }
                if (tailVrtx.isIdentWith(edge.getVertex()) && nextTail == null) {
                    nextTail = edge;
                    prevTail = nextTail.getPrevEdge();
                }
                if (nextHead != null && nextTail != null) break block7;
            } while ((edge = edge.getNextEdge()) != firstE);
            throw new JgclInvalidArgumentValue("Given vertices are not in given face.");
        }
        return this.makeEdgeFace(face, headVrtx, nextHead, prevHead, tailVrtx, nextTail, prevTail);
    }

    public synchronized Result makeEdgeFace(Face face, Vertex headVrtx, Vertex tailVrtx, Edge headEdge, Edge tailEdge) {
        if (!this.contains(face)) {
            throw new JgclInvalidArgumentValue("Given face is not in the graph.");
        }
        if (!this.contains(headVrtx) || !this.contains(tailVrtx)) {
            throw new JgclInvalidArgumentValue("Given vertex is not in the graph.");
        }
        if (!this.contains(headEdge) || !this.contains(tailEdge)) {
            throw new JgclInvalidArgumentValue("Given edge is not in the graph.");
        }
        if (headVrtx.isIdentWith(tailVrtx)) {
            throw new JgclInvalidArgumentValue("Given vertices are ideitical.");
        }
        Edge nextHead = null;
        Edge prevHead = null;
        if (headVrtx.isIdentWith(headEdge.getVertex())) {
            nextHead = headEdge;
        } else if (headVrtx.isIdentWith(headEdge.getMate().getVertex())) {
            nextHead = headEdge.getMate();
        } else {
            throw new JgclInvalidArgumentValue("Given edge is not attached to given vertex.");
        }
        prevHead = nextHead.getPrevEdge();
        if (!face.isIdentWith(nextHead.getFace()) || !face.isIdentWith(prevHead.getFace())) {
            throw new JgclInvalidArgumentValue("Given edge is not attached to given face.");
        }
        Edge nextTail = null;
        Edge prevTail = null;
        if (tailVrtx.isIdentWith(tailEdge.getVertex())) {
            nextTail = tailEdge;
        } else if (tailVrtx.isIdentWith(tailEdge.getMate().getVertex())) {
            nextTail = tailEdge.getMate();
        } else {
            throw new JgclInvalidArgumentValue("Given edge is not attached to given vertex.");
        }
        prevTail = nextTail.getPrevEdge();
        if (!face.isIdentWith(nextTail.getFace()) || !face.isIdentWith(prevTail.getFace())) {
            throw new JgclInvalidArgumentValue("Given edge is not attached to given face.");
        }
        return this.makeEdgeFace(face, headVrtx, nextHead, prevHead, tailVrtx, nextTail, prevTail);
    }

    public synchronized void killEdgeFace(Edge edge, Face face) {
        Edge firstE;
        if (!this.contains(edge)) {
            throw new JgclInvalidArgumentValue("Given edge is not in the graph.");
        }
        if (!this.contains(face)) {
            throw new JgclInvalidArgumentValue("Given face is not in the graph.");
        }
        Edge mate = edge.getMate();
        if (edge.getFace().isIdentWith(mate.getFace())) {
            throw new JgclInvalidArgumentValue("Given edge is dangling.");
        }
        if (face.isIdentWith(edge.getFace())) {
            edge = mate;
            mate = edge.getMate();
        } else if (!face.isIdentWith(mate.getFace())) {
            throw new JgclInvalidArgumentValue("Given edge is not in given face.");
        }
        Face remainedF = edge.getFace();
        if (edge.isIdentWith(remainedF.getFirstEdge())) {
            remainedF.setFirstEdge(edge.getPrevEdge());
        }
        int i = 0;
        while (i < 2) {
            Edge prevE = edge.getPrevEdge();
            Edge nextE = mate.getNextEdge();
            prevE.setNextEdge(nextE);
            nextE.setPrevEdge(prevE);
            if (edge.isIdentWith(edge.getVertex().getFirstEdge())) {
                edge.getVertex().setFirstEdge(nextE);
            }
            edge = mate;
            mate = edge.getMate();
            ++i;
        }
        this.removeFace(face);
        this.removeEdge(edge);
        edge = firstE = remainedF.getFirstEdge();
        do {
            edge.setFace(remainedF);
        } while ((edge = edge.getNextEdge()) != firstE);
    }

    protected Object clone() {
        return this.copy();
    }

    public synchronized JgclEmbeddedGraph copy() {
        return this.copy(new JgclEmbeddedGraph());
    }

    public synchronized JgclEmbeddedGraph copy(JgclEmbeddedGraph seed) {
        GraphItem dst;
        GraphItem src;
        JgclEmbeddedGraph replica = seed;
        Enumeration e = this.vrtxList.elements();
        while (e.hasMoreElements()) {
            src = (Vertex)e.nextElement();
            dst = replica.addVertex();
            src.setReplica(dst);
        }
        e = this.faceList.elements();
        while (e.hasMoreElements()) {
            src = (Face)e.nextElement();
            dst = replica.addFace();
            src.setReplica(dst);
        }
        e = this.edgeList.elements();
        while (e.hasMoreElements()) {
            src = (EdgeContainer)e.nextElement();
            dst = replica.addEdge().getContainer();
            src.setReplica(dst);
        }
        e = this.vrtxList.elements();
        while (e.hasMoreElements()) {
            src = (Vertex)e.nextElement();
            ((Vertex)src).fillFieldsOfReplica();
        }
        e = this.faceList.elements();
        while (e.hasMoreElements()) {
            src = (Face)e.nextElement();
            ((Face)src).fillFieldsOfReplica();
        }
        e = this.edgeList.elements();
        while (e.hasMoreElements()) {
            src = (EdgeContainer)e.nextElement();
            ((EdgeContainer)src).fillFieldsOfReplica();
        }
        e = this.vrtxList.elements();
        while (e.hasMoreElements()) {
            src = (Vertex)e.nextElement();
            src.setReplica(null);
        }
        e = this.faceList.elements();
        while (e.hasMoreElements()) {
            src = (Face)e.nextElement();
            src.setReplica(null);
        }
        e = this.edgeList.elements();
        while (e.hasMoreElements()) {
            src = (EdgeContainer)e.nextElement();
            src.setReplica(null);
        }
        return replica;
    }

    public synchronized JgclEmbeddedGraph dualCopy() {
        return this.dualCopy(new JgclEmbeddedGraph());
    }

    public synchronized JgclEmbeddedGraph dualCopy(JgclEmbeddedGraph seed) {
        GraphItem dst;
        GraphItem src;
        JgclEmbeddedGraph replica = seed;
        Enumeration e = this.vrtxList.elements();
        while (e.hasMoreElements()) {
            src = (Vertex)e.nextElement();
            dst = replica.addFace();
            src.setReplica(dst);
        }
        e = this.faceList.elements();
        while (e.hasMoreElements()) {
            src = (Face)e.nextElement();
            dst = replica.addVertex();
            src.setReplica(dst);
        }
        e = this.edgeList.elements();
        while (e.hasMoreElements()) {
            src = (EdgeContainer)e.nextElement();
            dst = replica.addEdge().getContainer();
            src.setReplica(dst);
        }
        e = this.vrtxList.elements();
        while (e.hasMoreElements()) {
            src = (Vertex)e.nextElement();
            ((Vertex)src).fillFieldsOfDualReplica();
        }
        e = this.faceList.elements();
        while (e.hasMoreElements()) {
            src = (Face)e.nextElement();
            ((Face)src).fillFieldsOfDualReplica();
        }
        e = this.edgeList.elements();
        while (e.hasMoreElements()) {
            src = (EdgeContainer)e.nextElement();
            ((EdgeContainer)src).fillFieldsOfDualReplica();
        }
        e = this.vrtxList.elements();
        while (e.hasMoreElements()) {
            Edge firstReplicaEdge;
            Edge firstE;
            Vertex vrtx = (Vertex)e.nextElement();
            Edge edge = firstE = vrtx.getFirstEdge();
            if (firstE == null) continue;
            Edge prevReplicaEdge = firstReplicaEdge = edge.getMate().getReplica();
            Edge crntReplicaEdge = null;
            edge = vrtx.getNextEdgeInCCW(edge);
            while (!edge.isIdentWith(firstE)) {
                crntReplicaEdge = edge.getMate().getReplica();
                prevReplicaEdge.setNextEdge(crntReplicaEdge);
                crntReplicaEdge.setPrevEdge(prevReplicaEdge);
                prevReplicaEdge = crntReplicaEdge;
                edge = vrtx.getNextEdgeInCCW(edge);
            }
            crntReplicaEdge = firstReplicaEdge;
            prevReplicaEdge.setNextEdge(crntReplicaEdge);
            crntReplicaEdge.setPrevEdge(prevReplicaEdge);
        }
        e = this.vrtxList.elements();
        while (e.hasMoreElements()) {
            src = (Vertex)e.nextElement();
            src.setReplica(null);
        }
        e = this.faceList.elements();
        while (e.hasMoreElements()) {
            src = (Face)e.nextElement();
            src.setReplica(null);
        }
        e = this.edgeList.elements();
        while (e.hasMoreElements()) {
            src = (EdgeContainer)e.nextElement();
            src.setReplica(null);
        }
        return replica;
    }

    protected abstract class GraphItem {
        private Object userData;
        private GraphItem replica;

        GraphItem() {
            JgclEmbeddedGraph.this = JgclEmbeddedGraph.this;
        }

        public synchronized void setUserData(Object object) {
            this.userData = object;
        }

        public synchronized Object getUserData() {
            return this.userData;
        }

        protected synchronized void setReplica(GraphItem itemAsReplica) {
            this.replica = itemAsReplica;
            if (this.replica != null) {
                this.replica.userData = this.userData;
            }
        }

        protected synchronized GraphItem getReplica() {
            return this.replica;
        }
    }

    public class Vertex
    extends GraphItem {
        private Edge firstEdge;

        protected Vertex() {
            JgclEmbeddedGraph.this = JgclEmbeddedGraph.this;
        }

        public JgclEmbeddedGraph getGraph() {
            return JgclEmbeddedGraph.this;
        }

        private void setFirstEdge(Edge edge) {
            this.firstEdge = edge;
        }

        private Edge getFirstEdge() {
            Edge edge = this.firstEdge;
            if (edge != null && edge.getVertex() != this) {
                edge = edge.getMate();
            }
            return edge;
        }

        private Edge getPrevEdgeInCCW(Edge edge) {
            if (!this.isIdentWith((edge = edge.getMate().getNextEdge()).getVertex())) {
                edge = edge.getMate();
            }
            return edge;
        }

        private Edge getNextEdgeInCCW(Edge edge) {
            if (!this.isIdentWith((edge = edge.getPrevEdge()).getVertex())) {
                edge = edge.getMate();
            }
            return edge;
        }

        public boolean isIdentWith(Vertex vrtx) {
            return this == vrtx;
        }

        public synchronized Vector getEdgeCycleInCCW() {
            Vector<Edge> result = new Vector<Edge>();
            Edge firstE = this.getFirstEdge();
            Edge edge = firstE;
            if (edge == null) {
                return result;
            }
            do {
                result.addElement(edge);
            } while (!(edge = this.getNextEdgeInCCW(edge)).isIdentWith(firstE));
            return result;
        }

        public synchronized Vector getFaceCycleInCCW() {
            Vector result = new Vector();
            Edge firstE = this.getFirstEdge();
            Edge edge = firstE;
            if (edge == null) {
                result.addElement(JgclEmbeddedGraph.this.faceList.elementAt(0));
                return result;
            }
            do {
                if (result.contains(edge.getFace())) continue;
                result.addElement(edge.getFace());
            } while (!(edge = this.getNextEdgeInCCW(edge)).isIdentWith(firstE));
            return result;
        }

        protected void fillFieldsOfReplica() {
            if (this.firstEdge != null) {
                Vertex replica = (Vertex)this.getReplica();
                replica.firstEdge = this.firstEdge.getReplica();
            }
        }

        protected void fillFieldsOfDualReplica() {
            if (this.firstEdge != null) {
                Face replica = (Face)this.getReplica();
                replica.firstEdge = this.firstEdge.getReplica().getMate();
            }
        }

        static /* synthetic */ Edge access$3(Vertex $0) {
            return $0.firstEdge;
        }
    }

    public class Face
    extends GraphItem {
        private Edge firstEdge;

        protected Face() {
            JgclEmbeddedGraph.this = JgclEmbeddedGraph.this;
        }

        public JgclEmbeddedGraph getGraph() {
            return JgclEmbeddedGraph.this;
        }

        private void setFirstEdge(Edge edge) {
            this.firstEdge = edge;
        }

        private Edge getFirstEdge() {
            Edge edge = this.firstEdge;
            if (edge != null && edge.getFace() != this) {
                edge = edge.getMate();
            }
            return edge;
        }

        public boolean isIdentWith(Face face) {
            return this == face;
        }

        public synchronized Vector getEdgeCycleInCCW() {
            Vector<Edge> result = new Vector<Edge>();
            Edge firstE = this.getFirstEdge();
            Edge edge = firstE;
            if (edge == null) {
                return result;
            }
            do {
                result.addElement(edge);
            } while ((edge = edge.getNextEdge()) != firstE);
            return result;
        }

        public synchronized Vector getVertexCycleInCCW() {
            Vector result = new Vector();
            Edge firstE = this.getFirstEdge();
            Edge edge = firstE;
            if (edge == null) {
                result.addElement(JgclEmbeddedGraph.this.vrtxList.elementAt(0));
                return result;
            }
            do {
                result.addElement(edge.getVertex());
            } while ((edge = edge.getNextEdge()) != firstE);
            return result;
        }

        protected void fillFieldsOfReplica() {
            if (this.firstEdge != null) {
                Face replica = (Face)this.getReplica();
                replica.firstEdge = this.firstEdge.getReplica();
            }
        }

        protected void fillFieldsOfDualReplica() {
            if (this.firstEdge != null) {
                Vertex replica = (Vertex)this.getReplica();
                replica.firstEdge = this.firstEdge.getReplica();
            }
        }

        static /* synthetic */ Edge access$2(Face $0) {
            return $0.firstEdge;
        }
    }

    public class Edge {
        private Vertex vertex;
        private Face face;
        private Edge prevEdge;
        private Edge nextEdge;
        private Edge mate;
        private EdgeContainer container;

        protected Edge() {
            JgclEmbeddedGraph.this = JgclEmbeddedGraph.this;
        }

        public JgclEmbeddedGraph getGraph() {
            return JgclEmbeddedGraph.this;
        }

        private void setVertex(Vertex vertex) {
            this.vertex = vertex;
        }

        private Vertex getVertex() {
            return this.vertex;
        }

        private void setFace(Face face) {
            this.face = face;
        }

        private Face getFace() {
            return this.face;
        }

        private void setPrevEdge(Edge edge) {
            this.prevEdge = edge;
        }

        private Edge getPrevEdge() {
            Edge prev = this.prevEdge;
            if (prev.vertex == this.vertex) {
                prev = prev.mate;
            }
            return prev;
        }

        private void setNextEdge(Edge edge) {
            this.nextEdge = edge;
        }

        private Edge getNextEdge() {
            Edge next = this.nextEdge;
            if (next.vertex != this.mate.vertex) {
                next = next.mate;
            }
            return next;
        }

        private void setMate(Edge edge) {
            this.mate = edge;
        }

        public Edge getMate() {
            return this.mate;
        }

        private void setContainer(EdgeContainer container) {
            this.container = container;
        }

        private EdgeContainer getContainer() {
            return this.container;
        }

        public boolean isIdentWith(Edge edge) {
            return this.container == edge.container;
        }

        public synchronized Vertex[] getVertices() {
            Vertex[] result = new Vertex[]{this.getVertex(), this.getMate().getVertex()};
            return result;
        }

        public synchronized Vertex getStartingVertex() {
            return this.getVertex();
        }

        public synchronized Vertex getTerminalVertex() {
            return this.getMate().getVertex();
        }

        public synchronized Face[] getFaces() {
            Face[] result = new Face[]{this.getFace(), this.getMate().getFace()};
            return result;
        }

        public synchronized Face getLeftFace() {
            return this.getFace();
        }

        public synchronized Face getRightFace() {
            return this.getMate().getFace();
        }

        public synchronized void setUserData(Object object) {
            this.container.setUserData(object);
        }

        public synchronized Object getUserData() {
            return this.container.getUserData();
        }

        private boolean isHalfA() {
            return this == this.container.getHalfA();
        }

        protected Edge getReplica() {
            EdgeContainer replica = (EdgeContainer)this.container.getReplica();
            if (replica == null) {
                return null;
            }
            return this.isHalfA() ? replica.getHalfA() : replica.getHalfZ();
        }

        protected void fillFieldsOfReplica() {
            Edge replica = this.getReplica();
            replica.vertex = (Vertex)this.vertex.getReplica();
            replica.face = (Face)this.face.getReplica();
            replica.prevEdge = this.prevEdge.getReplica();
            replica.nextEdge = this.nextEdge.getReplica();
        }

        protected void fillFieldsOfDualReplica() {
            Edge replica = this.getReplica();
            replica.vertex = (Vertex)this.face.getReplica();
            replica.face = (Face)this.mate.vertex.getReplica();
        }
    }

    private class EdgeContainer
    extends GraphItem {
        private Edge halfA;
        private Edge halfZ;

        private EdgeContainer() {
            JgclEmbeddedGraph.this = JgclEmbeddedGraph.this;
            this.halfA = JgclEmbeddedGraph.this.graphItemMaker.newEdge();
            this.halfZ = JgclEmbeddedGraph.this.graphItemMaker.newEdge();
            this.halfA.setMate(this.halfZ);
            this.halfA.setContainer(this);
            this.halfZ.setMate(this.halfA);
            this.halfZ.setContainer(this);
        }

        private Edge getHalfA() {
            return this.halfA;
        }

        private Edge getHalfZ() {
            return this.halfZ;
        }

        private void fillFieldsOfReplica() {
            this.halfA.fillFieldsOfReplica();
            this.halfZ.fillFieldsOfReplica();
        }

        private void fillFieldsOfDualReplica() {
            this.halfA.fillFieldsOfDualReplica();
            this.halfZ.fillFieldsOfDualReplica();
        }
    }

    public interface GraphItemMaker {
        public Vertex newVertex();

        public Face newFace();

        public Edge newEdge();
    }

    private final class 1
    implements Enumeration {
        Enumeration e;

        public boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        public Object nextElement() {
            EdgeContainer edgeContainer = (EdgeContainer)this.e.nextElement();
            return edgeContainer.getHalfA();
        }

        /* synthetic */ 1(JgclEmbeddedGraph this$0) {
            this.e = this$0.edgeList.elements();
        }
    }

    private final class 2
    implements GraphItemMaker {
        public Vertex newVertex() {
            return new Vertex();
        }

        public Face newFace() {
            return new Face();
        }

        public Edge newEdge() {
            return new Edge();
        }

        /* synthetic */ 2() {
        }
    }

    public class Result {
        public Vertex vrtx;
        public Edge edge;
        public Face face;

        private Result(Vertex vrtx, Edge edge, Face face) {
            JgclEmbeddedGraph.this = JgclEmbeddedGraph.this;
            this.vrtx = vrtx;
            this.edge = edge;
            this.face = face;
        }
    }
}

