/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclPoint3D;

public class JgclEnclosingBox3D {
    private final JgclPoint3D min;
    private final JgclPoint3D max;

    public JgclEnclosingBox3D(JgclPoint3D min, JgclPoint3D max) {
        if (min.x() > max.x() || min.y() > max.y() || min.z() > max.z()) {
            throw new JgclInvalidArgumentValue();
        }
        this.min = min;
        this.max = max;
    }

    public JgclEnclosingBox3D(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (minX > maxX || minY > maxY || minZ > maxZ) {
            throw new JgclInvalidArgumentValue();
        }
        this.min = new JgclCartesianPoint3D(minX, minY, minZ);
        this.max = new JgclCartesianPoint3D(maxX, maxY, maxZ);
    }

    public JgclEnclosingBox3D(JgclPoint3D[] points) {
        double max_z;
        double max_y;
        double max_x;
        double min_x = max_x = points[0].x();
        double min_y = max_y = points[0].y();
        double min_z = max_z = points[0].z();
        int i = 1;
        while (i < points.length) {
            if (max_x < points[i].x()) {
                max_x = points[i].x();
            }
            if (max_y < points[i].y()) {
                max_y = points[i].y();
            }
            if (max_z < points[i].z()) {
                max_z = points[i].z();
            }
            if (min_x > points[i].x()) {
                min_x = points[i].x();
            }
            if (min_y > points[i].y()) {
                min_y = points[i].y();
            }
            if (min_z > points[i].z()) {
                min_z = points[i].z();
            }
            ++i;
        }
        this.min = new JgclCartesianPoint3D(min_x, min_y, min_z);
        this.max = new JgclCartesianPoint3D(max_x, max_y, max_z);
    }

    public JgclPoint3D min() {
        return this.min;
    }

    public JgclPoint3D max() {
        return this.max;
    }

    public JgclPoint3D[] toArray() {
        JgclPoint3D[] array = new JgclPoint3D[]{this.min, this.max};
        return array;
    }

    public boolean hasIntersection(JgclEnclosingBox3D mate) {
        double d_tol = JgclConditionOfOperation.getCondition().getToleranceForDistance();
        return !(this.min().x() > mate.max().x() + d_tol || this.min().y() > mate.max().y() + d_tol || this.min().z() > mate.max().z() + d_tol || mate.min().x() > this.max().x() + d_tol || mate.min().y() > this.max().y() + d_tol) && !(mate.min().z() > this.max().z() + d_tol);
    }
}

