/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclGeometrySchemaFunction {
    public static final JgclVector2D defaultRefDirection2D = JgclVector2D.xUnitVector;
    public static final JgclVector3D defaultAxis3D = JgclVector3D.zUnitVector;
    public static final JgclVector3D defaultRefDirection3D = JgclVector3D.xUnitVector;

    private JgclGeometrySchemaFunction() {
    }

    public static JgclVector2D[] baseAxis(JgclVector2D axis1, JgclVector2D axis2) {
        JgclVector2D[] u = new JgclVector2D[2];
        if (axis1 != null) {
            u[0] = axis1.unitized();
            u[1] = JgclGeometrySchemaFunction.orthogonalComplement(u[0]);
            if (axis2 != null && axis2.dotProduct(u[1]) < 0.0) {
                u[1] = u[1].reverse();
            }
        } else if (axis2 != null) {
            u[1] = axis2.unitized();
            u[0] = JgclGeometrySchemaFunction.orthogonalComplement(u[1]).reverse();
        } else {
            u[0] = JgclVector2D.xUnitVector;
            u[1] = JgclVector2D.yUnitVector;
        }
        return u;
    }

    public static JgclVector3D[] baseAxis(JgclVector3D axis1, JgclVector3D axis2, JgclVector3D axis3) {
        JgclVector3D[] u = new JgclVector3D[3];
        u[2] = axis3 != null ? axis3.unitized() : JgclVector3D.zUnitVector;
        u[0] = JgclGeometrySchemaFunction.firstProjAxis(u[2], axis1);
        u[1] = JgclGeometrySchemaFunction.secondProjAxis(u[2], u[0], axis2);
        return u;
    }

    public static JgclVector2D[] build2Axes(JgclVector2D refDirection) {
        JgclVector2D[] axes;
        axes = new JgclVector2D[]{refDirection == null ? defaultRefDirection2D : refDirection.unitized(), JgclGeometrySchemaFunction.orthogonalComplement(axes[0])};
        return axes;
    }

    public static JgclVector3D[] buildAxes(JgclVector3D axis, JgclVector3D refDirection) {
        JgclVector3D[] axes = new JgclVector3D[3];
        axes[2] = axis == null ? defaultAxis3D : axis.unitized();
        axes[0] = refDirection == null ? JgclGeometrySchemaFunction.firstProjAxis(axes[2], defaultRefDirection3D) : JgclGeometrySchemaFunction.firstProjAxis(axes[2], refDirection);
        axes[1] = axes[2].crossProduct(axes[0]).unitized();
        return axes;
    }

    public static JgclVector2D orthogonalComplement(JgclVector2D vec) {
        return new JgclLiteralVector2D(-vec.y(), vec.x());
    }

    public static JgclVector3D firstProjAxis(JgclVector3D zAxis, JgclVector3D arg) {
        JgclVector3D v;
        if (zAxis == null) {
            throw new JgclFatal();
        }
        JgclVector3D z = zAxis.unitized();
        if (arg == null) {
            v = JgclVector3D.xUnitVector;
            if (z.identicalDirection(v)) {
                v = JgclVector3D.yUnitVector;
            }
        } else {
            JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
            if (arg.crossProduct(z).norm() <= condition.getToleranceForDistance2()) {
                throw new JgclFatal();
            }
            v = arg.unitized();
        }
        return v.subtract(z.multiply(v.dotProduct(z))).unitized();
    }

    public static JgclVector3D secondProjAxis(JgclVector3D zAxis, JgclVector3D xAxis, JgclVector3D arg) {
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        if (zAxis == null || xAxis == null) {
            throw new JgclFatal();
        }
        JgclVector3D z = zAxis.unitized();
        JgclVector3D x = xAxis.unitized();
        JgclVector3D v = arg == null ? JgclVector3D.yUnitVector : arg.unitized();
        v = v.subtract(z.multiply(v.dotProduct(z))).unitized();
        return v.subtract(x.multiply(v.dotProduct(x))).unitized();
    }
}

