/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclPoint2D;

public class JgclHomogeneousPoint2D
extends JgclPoint2D {
    private double wx;
    private double wy;
    private double w;

    private void setArgs(double wx, double wy, double w) {
        this.wx = wx;
        this.wy = wy;
        this.w = w;
    }

    public JgclHomogeneousPoint2D(double wx, double wy, double w) {
        this.setArgs(wx, wy, w);
    }

    public JgclHomogeneousPoint2D(double[] c) {
        this.setArgs(c[0], c[1], c[2]);
    }

    public double x() {
        return this.wx / this.w;
    }

    public double y() {
        return this.wy / this.w;
    }

    public double wx() {
        return this.wx;
    }

    public double wy() {
        return this.wy;
    }

    public double w() {
        return this.w;
    }

    protected synchronized JgclPoint2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint2D crd = !reverseTransform ? transformationOperator.transform(this) : transformationOperator.reverseTransform(this);
        return new JgclHomogeneousPoint2D(this.w * crd.x(), this.w * crd.y(), this.w);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName() + " " + this.wx() + " " + this.wy() + " " + this.w() + " End");
    }
}

