/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclVector2D;

public class JgclHomogeneousVector2D
extends JgclVector2D {
    private double wx;
    private double wy;
    private double w;

    private void setArgs(double wx, double wy, double w) {
        this.wx = wx;
        this.wy = wy;
        this.w = w;
    }

    public JgclHomogeneousVector2D(double wx, double wy, double w) {
        this.setArgs(wx, wy, w);
    }

    public JgclHomogeneousVector2D(double[] c) {
        this.setArgs(c[0], c[1], c[2]);
    }

    JgclHomogeneousVector2D(double wx, double wy, double w, boolean confirmedAsUnitized) {
        super(confirmedAsUnitized);
        this.setArgs(wx, wy, w);
    }

    JgclHomogeneousVector2D(double[] c, boolean confirmedAsUnitized) {
        super(confirmedAsUnitized);
        this.setArgs(c[0], c[1], c[2]);
    }

    public double x() {
        return this.wx / this.w;
    }

    public double y() {
        return this.wy / this.w;
    }

    public double wx() {
        return this.wx;
    }

    public double wy() {
        return this.wy;
    }

    public double w() {
        return this.w;
    }

    protected synchronized JgclVector2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        JgclVector2D vec = !reverseTransform ? transformationOperator.transform(this) : transformationOperator.reverseTransform(this);
        return new JgclHomogeneousVector2D(this.w * vec.x(), this.w * vec.y(), this.w);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName() + " " + this.wx() + " " + this.wy() + " " + this.w() + " End");
    }
}

