/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclInterpolation;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclVector3D;

class JgclInterpolation3D {
    private JgclInterpolation info;
    private JgclPoint3D[] points;
    private JgclVector3D[] endvecs;

    JgclInterpolation3D(JgclPoint3D[] points, double[] params) {
        this.info = new JgclInterpolation(params, false);
        this.points = points;
        this.endvecs = JgclInterpolation3D.besselPoints(points, params);
    }

    JgclInterpolation3D(JgclPoint3D[] points, double[] params, JgclVector3D[] endvecs) {
        this.info = new JgclInterpolation(params, false);
        this.points = points;
        this.endvecs = endvecs;
    }

    JgclInterpolation3D(JgclPoint3D[] points, double[] params, JgclVector3D[] endvecs, boolean isClosed) {
        this.info = new JgclInterpolation(params, isClosed);
        this.points = points;
        if (!this.info.isClosed) {
            this.endvecs = endvecs != null ? endvecs : JgclInterpolation3D.besselPoints(points, params);
        }
    }

    private JgclInterpolation3D(JgclInterpolation info, JgclPoint3D[] points, JgclVector3D[] endvecs) {
        this.info = info;
        this.points = points;
        if (!info.isClosed) {
            this.endvecs = endvecs != null ? endvecs : JgclInterpolation3D.besselPoints(points, info.params);
        }
    }

    static JgclVector3D[] besselPoints(JgclPoint3D[] points, double[] params) {
        int uip = points.length;
        JgclVector3D[] endvecs = new JgclVector3D[2];
        double delta = params[1] - params[0];
        if (uip == 2) {
            endvecs[0] = points[1].subtract(points[0]);
            endvecs[0] = endvecs[0].divide(delta);
            endvecs[1] = endvecs[0];
            return endvecs;
        }
        double t = delta / (params[2] - params[0]);
        double t1 = 1.0 - t;
        double b0 = t1 * t1;
        double b1 = 2.0 * t * t1;
        double b2 = t * t;
        JgclPoint3D mPoint = points[1].subtract(points[0].multiply(b0)).toPoint3D().subtract(points[2].multiply(b2)).toPoint3D().divide(b1);
        endvecs[0] = mPoint.subtract(points[0]).multiply(t * 2.0 / delta);
        int index = uip - 3;
        t = (params[index + 1] - params[index]) / (params[index + 2] - params[index]);
        t1 = 1.0 - t;
        b0 = t1 * t1;
        b1 = 2.0 * t * t1;
        b2 = t * t;
        mPoint = points[index + 1].subtract(points[index].multiply(b0)).toPoint3D().subtract(points[index + 2].multiply(b2)).toPoint3D().divide(b1);
        delta = params[index + 2] - params[index + 1];
        endvecs[1] = points[index + 2].subtract(mPoint).multiply(t1 * 2.0 / delta);
        return endvecs;
    }

    private JgclPoint3D[] solveLS(JgclPoint3D[] cp) {
        JgclPoint3D[] newCp = new JgclPoint3D[this.info.uip];
        int i = 0;
        while (i < this.info.uip) {
            newCp[i] = cp[i];
            ++i;
        }
        int i2 = 1;
        while (i2 < this.info.uip) {
            newCp[i2] = newCp[i2].subtract(newCp[i2 - 1].multiply(this.info.matrix.getElementAt(i2, 0))).toPoint3D();
            ++i2;
        }
        int i3 = this.info.uip - 2;
        while (i3 >= 0) {
            newCp[i3] = newCp[i3].subtract(newCp[i3 + 1].multiply(this.info.matrix.getElementAt(i3, 2))).toPoint3D();
            --i3;
        }
        int i4 = 0;
        while (i4 < this.info.uip) {
            newCp[i4] = newCp[i4].divide(this.info.matrix.getElementAt(i4, 1));
            ++i4;
        }
        return newCp;
    }

    private JgclPoint3D[] solveLSClosed(JgclPoint3D[] cp) {
        double[] wX = new double[this.info.uip];
        double[] wY = new double[this.info.uip];
        double[] wZ = new double[this.info.uip];
        JgclPoint3D[] newCp = new JgclPoint3D[this.info.uip];
        int i = 0;
        while (i < this.info.uip) {
            wX[i] = cp[i].x();
            ++i;
        }
        wX = this.info.matrix.solveSimultaneousLinearEquations(wX);
        int i2 = 0;
        while (i2 < this.info.uip) {
            wY[i2] = cp[i2].y();
            ++i2;
        }
        wY = this.info.matrix.solveSimultaneousLinearEquations(wY);
        int i3 = 0;
        while (i3 < this.info.uip) {
            wZ[i3] = cp[i3].z();
            ++i3;
        }
        wZ = this.info.matrix.solveSimultaneousLinearEquations(wZ);
        int i4 = 1;
        while (i4 < this.info.uip) {
            newCp[i4] = new JgclCartesianPoint3D(wX[i4 - 1], wY[i4 - 1], wZ[i4 - 1]);
            ++i4;
        }
        newCp[0] = new JgclCartesianPoint3D(wX[i4 - 1], wY[i4 - 1], wZ[i4 - 1]);
        return newCp;
    }

    private JgclPoint3D[] solveLinearSystem() {
        JgclPoint3D[] cp = new JgclPoint3D[this.info.uip];
        cp[0] = this.points[0].add(this.endvecs[0].multiply(this.info.pInt(0) / 3.0));
        int i = 1;
        while (i < this.info.uip - 1) {
            double ework = this.info.pInt(i - 1) + this.info.pInt(i);
            cp[i] = this.points[i].multiply(ework);
            ++i;
        }
        cp[i] = this.points[i].subtract(this.endvecs[1].multiply(this.info.pInt(this.info.uip - 2) / 3.0));
        cp = this.solveLS(cp);
        JgclPoint3D[] newCp = new JgclPoint3D[this.info.uip + 2];
        newCp[0] = this.points[0];
        i = 0;
        while (i < this.info.uip) {
            newCp[i + 1] = cp[i];
            ++i;
        }
        newCp[this.info.uip + 1] = this.points[this.info.uip - 1];
        return newCp;
    }

    private JgclPoint3D[] solveLinearSystemClosed() {
        JgclPoint3D[] cp = new JgclPoint3D[this.info.uip];
        int i = 0;
        while (i < this.info.uip) {
            double ework = this.info.pInt(i - 1) + this.info.pInt(i);
            cp[i] = this.points[i].multiply(ework);
            ++i;
        }
        cp = this.solveLSClosed(cp);
        return cp;
    }

    JgclBsplineKnot knotData() {
        return this.info.knotData();
    }

    JgclPoint3D[] controlPoints() {
        if (!this.info.isClosed) {
            return this.solveLinearSystem();
        }
        return this.solveLinearSystemClosed();
    }

    static JgclPoint3D[] controlPoints(JgclInterpolation info, JgclPoint3D[] points, JgclVector3D[] endvecs) {
        JgclInterpolation3D doObj = new JgclInterpolation3D(info, points, endvecs);
        return doObj.controlPoints();
    }

    double[] weights() {
        return null;
    }

    public static void main(String[] argv) {
        JgclCartesianPoint3D p0 = new JgclCartesianPoint3D(0.0, 0.0, 0.0);
        JgclCartesianPoint3D p1 = new JgclCartesianPoint3D(1.0, 1.0, 0.0);
        JgclCartesianPoint3D p2 = new JgclCartesianPoint3D(2.0, 0.0, 0.0);
        JgclCartesianPoint3D p3 = new JgclCartesianPoint3D(1.0, -1.0, 0.0);
        JgclLiteralVector3D v = new JgclLiteralVector3D(0.0, -1.0, 0.0);
        JgclPoint3D[] points = new JgclCartesianPoint3D[]{p0, p1, p2};
        double[] dArray = new double[3];
        dArray[1] = 0.5;
        dArray[2] = 1.0;
        double[] params = dArray;
        JgclVector3D[] vectors = new JgclLiteralVector3D[]{v, v};
        JgclPoint3D[] pointsClosed = new JgclCartesianPoint3D[]{p0, p1, p2, p3};
        double[] dArray2 = new double[5];
        dArray2[1] = 0.25;
        dArray2[2] = 0.5;
        dArray2[3] = 0.75;
        dArray2[4] = 1.0;
        double[] paramsClosed = dArray2;
        System.out.println("\n\n<for open case.>\n");
        JgclInterpolation3D open = new JgclInterpolation3D(points, params, vectors);
        JgclPoint3D[] cp = open.controlPoints();
        System.out.println("\n\n[interpolated points]\n");
        int i = 0;
        while (i < cp.length) {
            System.out.println("cp[" + i + "] = (" + cp[i].x() + ", " + cp[i].y() + ", " + cp[i].z() + ")");
            ++i;
        }
        System.out.println("\n\n<for closed case.>\n");
        JgclInterpolation3D closed = new JgclInterpolation3D(pointsClosed, paramsClosed, null, true);
        JgclPoint3D[] cpClosed = closed.controlPoints();
        System.out.println("\n[interpolated points]\n");
        int i2 = 0;
        while (i2 < cpClosed.length) {
            System.out.println("cp[" + i2 + "] = (" + cpClosed[i2].x() + ", " + cpClosed[i2].y() + ", " + cpClosed[i2].z() + ")");
            ++i2;
        }
    }
}

