/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCurveSurfaceInterferenceList;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;

final class JgclIntsCrvBss3D {
    static final boolean debug = false;

    private static JgclCurveSurfaceInterferenceList getInterference(JgclParametricCurve3D crvA, JgclBsplineSurface3D bssB) {
        JgclBsplineKnot.ValidSegmentInfo vldsBu = bssB.uValidSegments();
        JgclBsplineKnot.ValidSegmentInfo vldsBv = bssB.vValidSegments();
        JgclPureBezierSurface3D[][] bzssB = bssB.toPureBezierSurfaceArray();
        JgclCurveSurfaceInterferenceList interferenceList = new JgclCurveSurfaceInterferenceList(crvA, bssB);
        int iBu = 0;
        while (iBu < bzssB.length) {
            int iBv = 0;
            while (iBv < bzssB[iBu].length) {
                JgclIntersectionPoint3D[] ints;
                try {
                    ints = crvA.intersect(bzssB[iBu][iBv]);
                }
                catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                    throw new JgclFatal();
                }
                int i = 0;
                while (i < ints.length) {
                    interferenceList.addAsIntersection(ints[i].coordinates(), ints[i].pointOnCurve1().parameter(), vldsBu.l2Gp(iBu, ints[i].pointOnSurface2().uParameter()), vldsBv.l2Gp(iBv, ints[i].pointOnSurface2().vParameter()));
                    ++i;
                }
                ++iBv;
            }
            ++iBu;
        }
        return interferenceList;
    }

    static JgclIntersectionPoint3D[] intersection(JgclParametricCurve3D crvA, JgclBsplineSurface3D bssB, boolean doExchange) {
        return JgclIntsCrvBss3D.getInterference(crvA, bssB).toJgclIntersectionPoint3DArray(doExchange);
    }

    JgclIntsCrvBss3D() {
    }
}

