/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclHyperbola3D;
import jp.go.ipa.jgcl.JgclIntersectionCurve3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclParabola3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclVector3D;

class JgclIntsPlnCon3D {
    private JgclPlane3D dA;
    private JgclConicalSurface3D dB;
    private JgclPoint3D Bv;
    private JgclPoint3D pBv2A;
    private JgclVector3D eB2A;
    private JgclVector3D pBz2A;
    private double edot;
    private double eBdot;
    private JgclVector3D ecrs;
    private double sinBsa;
    private double tanBsa;
    private double a_tol;

    private void setupParams(JgclPlane3D dA, JgclConicalSurface3D dB) {
        this.dA = dA;
        this.dB = dB;
        this.sinBsa = Math.sin(dB.semiAngle());
        this.tanBsa = Math.tan(dB.semiAngle());
        this.a_tol = dA.getToleranceForAngle();
        double ework = dB.radius() / this.tanBsa;
        this.Bv = dB.position().location().subtract(dB.position().z().multiply(ework));
        JgclVector3D evec = dA.position().location().subtract(this.Bv);
        ework = dA.position().z().dotProduct(evec);
        this.eB2A = dA.position().z().multiply(ework);
        this.pBv2A = this.Bv.add(this.eB2A);
        this.edot = dA.position().z().dotProduct(dB.position().z());
        if (Math.abs(this.edot) < Math.cos(this.a_tol)) {
            this.pBz2A = dB.position().z().subtract(dA.position().z().multiply(this.edot)).unitized();
            this.eBdot = dB.position().z().dotProduct(this.pBz2A);
        } else {
            this.pBz2A = JgclVector3D.zeroVector;
            this.eBdot = 0.0;
        }
        this.ecrs = dA.position().z().crossProduct(dB.position().z());
    }

    JgclIntsPlnCon3D(JgclPlane3D dA, JgclConicalSurface3D dB) {
        this.setupParams(dA, dB);
    }

    private JgclSurfaceSurfaceInterference3D[] oneLine(boolean doExchange) {
        JgclLine3D res = new JgclLine3D(this.Bv, this.pBz2A);
        JgclIntersectionCurve3D ints = this.dA.curveToIntersectionCurve(res, this.dB, doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints};
        return sol;
    }

    private JgclSurfaceSurfaceInterference3D[] twoLines(boolean doExchange) {
        double ework = Math.sqrt(1.0 + this.tanBsa * this.tanBsa - 1.0 / (this.eBdot * this.eBdot));
        JgclVector3D ecrs2 = this.ecrs.unitized().multiply(ework);
        JgclLine3D res1 = new JgclLine3D(this.Bv, this.pBz2A.divide(this.eBdot).add(ecrs2).unitized());
        JgclLine3D res2 = new JgclLine3D(this.Bv, this.pBz2A.divide(this.eBdot).subtract(ecrs2).unitized());
        JgclIntersectionCurve3D ints1 = this.dA.curveToIntersectionCurve(res1, this.dB, doExchange);
        JgclIntersectionCurve3D ints2 = this.dA.curveToIntersectionCurve(res2, this.dB, doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints1, ints2};
        return sol;
    }

    private JgclSurfaceSurfaceInterference3D[] onePoint(boolean doExchange) {
        JgclPoint3D res = this.Bv;
        JgclIntersectionPoint3D intsPnt = this.dA.pointToIntersectionPoint(res, this.dB, doExchange);
        JgclSurfaceSurfaceInterference3D[] intf = new JgclSurfaceSurfaceInterference3D[]{intsPnt};
        return intf;
    }

    private JgclSurfaceSurfaceInterference3D[] oneCircle(boolean doExchange) {
        double ework = this.eB2A.dotProduct(this.dB.position().z());
        JgclAxis2Placement3D axis = new JgclAxis2Placement3D(this.Bv.add(this.dB.position().z().multiply(ework)), this.dA.position().z(), this.dA.position().x());
        JgclCircle3D res = new JgclCircle3D(axis, Math.abs(ework) * this.tanBsa);
        JgclIntersectionCurve3D ints = this.dA.curveToIntersectionCurve(res, this.dB, doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints};
        return sol;
    }

    private JgclSurfaceSurfaceInterference3D[] oneParabola(boolean doExchange) {
        JgclPoint3D loc = this.pBv2A;
        JgclVector3D Bz = this.dB.position().z();
        JgclVector3D pBz2A2 = this.pBz2A;
        if (this.eB2A.dotProduct(Bz) < 0.0) {
            Bz = Bz.reverse();
            pBz2A2 = pBz2A2.reverse();
        }
        double ework = this.eB2A.length();
        if (Math.abs(this.dB.semiAngle() - 0.7853981633974483) > this.a_tol) {
            double ework2 = ework / Math.tan(2.0 * this.dB.semiAngle());
            loc = loc.add(pBz2A2.multiply(ework2));
        }
        JgclAxis2Placement3D axis = new JgclAxis2Placement3D(loc, this.dA.position().z(), Bz);
        JgclParabola3D res = new JgclParabola3D(axis, ework * this.tanBsa / 2.0);
        JgclIntersectionCurve3D ints = this.dA.curveToIntersectionCurve(res, this.dB, doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints};
        return sol;
    }

    private JgclHyperbola3D oneHyperbola() {
        JgclPoint3D loc = this.pBv2A;
        double ecos = this.edot;
        double esin = Math.sqrt(1.0 - ecos * ecos);
        double ework = this.eB2A.length();
        double ework2 = Math.abs(esin * esin * this.tanBsa * this.tanBsa - ecos * ecos);
        double ework3 = Math.abs(ecos * esin * ework * (1.0 + this.tanBsa * this.tanBsa) / ework2);
        loc = this.eB2A.dotProduct(this.dB.position().z()) > 0.0 ? loc.subtract(this.pBz2A.multiply(ework3)) : loc.add(this.pBz2A.multiply(ework3));
        JgclAxis2Placement3D axis = new JgclAxis2Placement3D(loc, this.dA.position().z(), this.dB.position().z());
        return new JgclHyperbola3D(axis, ework * this.tanBsa / ework2, ework * this.tanBsa / Math.sqrt(ework2));
    }

    private JgclSurfaceSurfaceInterference3D[] hyperbola(boolean doExchange) {
        JgclHyperbola3D res1 = this.oneHyperbola();
        JgclPoint3D loc = this.dB.position().location();
        JgclVector3D vec = this.Bv.subtract(loc).multiply(2.0);
        loc = loc.add(vec);
        JgclAxis2Placement3D axis2 = new JgclAxis2Placement3D(loc, this.dB.position().z().reverse(), this.dB.position().x().reverse());
        JgclConicalSurface3D saved_dB = this.dB;
        JgclConicalSurface3D dB2 = new JgclConicalSurface3D(axis2, this.dB.radius(), this.dB.semiAngle());
        this.setupParams(this.dA, dB2);
        JgclHyperbola3D res2 = this.oneHyperbola();
        this.setupParams(this.dA, saved_dB);
        JgclIntersectionCurve3D ints1 = this.dA.curveToIntersectionCurve(res1, this.dB, doExchange);
        JgclIntersectionCurve3D ints2 = this.dA.curveToIntersectionCurve(res2, this.dB, doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints1, ints2};
        return sol;
    }

    private JgclSurfaceSurfaceInterference3D[] oneEllipse(boolean doExchange) {
        double ecos = this.edot;
        double esin = Math.sqrt(1.0 - ecos * ecos);
        double ework = this.eB2A.length();
        double ework2 = Math.abs(esin * esin * this.tanBsa * this.tanBsa - ecos * ecos);
        double ework3 = Math.abs(ecos * esin * ework * (1.0 + this.tanBsa * this.tanBsa) / ework2);
        if (this.eB2A.dotProduct(this.dB.position().z()) < 0.0) {
            ework3 = -ework3;
        }
        JgclAxis2Placement3D axis = new JgclAxis2Placement3D(this.pBv2A.add(this.pBz2A.multiply(ework3)), this.dA.position().z(), this.dB.position().z());
        JgclEllipse3D res = new JgclEllipse3D(axis, ework * this.tanBsa / ework2, ework * this.tanBsa / Math.sqrt(ework2));
        JgclIntersectionCurve3D ints = this.dA.curveToIntersectionCurve(res, this.dB, doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints};
        return sol;
    }

    JgclSurfaceSurfaceInterference3D[] getInterference(boolean doExchange) {
        if (this.eB2A.length() < this.dA.getToleranceForDistance()) {
            if (Math.abs(Math.acos(this.eBdot) - this.dB.semiAngle()) < this.a_tol) {
                return this.oneLine(doExchange);
            }
            if (Math.acos(this.eBdot) < this.dB.semiAngle()) {
                return this.twoLines(doExchange);
            }
            return this.onePoint(doExchange);
        }
        if (this.ecrs.length() < Math.sin(this.a_tol)) {
            return this.oneCircle(doExchange);
        }
        if (Math.abs(Math.acos(this.eBdot) - this.dB.semiAngle()) < this.a_tol) {
            return this.oneParabola(doExchange);
        }
        if (Math.acos(this.eBdot) < this.dB.semiAngle()) {
            return this.hyperbola(doExchange);
        }
        return this.oneEllipse(doExchange);
    }
}

