/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBooleanFunctionWithRealVariables;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclConic2D;
import jp.go.ipa.jgcl.JgclConic3D;
import jp.go.ipa.jgcl.JgclCursor;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclEnclosingBox3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionCurve3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclMachineEpsilon;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclObjectVector;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclQuadTree;
import jp.go.ipa.jgcl.JgclRealFunction;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterferenceList;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclVector3D;
import jp.go.ipa.jgcl.JgclZeroLength;

final class JgclIntsQrdBzs3D {
    static final boolean USE_SURFACE_SURFACE_INTERFERENCE_LIST = true;
    JgclSurfaceSurfaceInterferenceList interfList;
    int debugFlag;
    static final int DEBUG_DIVIDE = 1;
    static final int DEBUG_INTERSEC = 2;
    static final int DEBUG_LINESEG = 4;
    static final int DEBUG_SAMESEG = 8;
    static final int DEBUG_CONNECT = 16;
    static final int DEBUG_REFINE = 32;
    static final int DEBUG_ALL = 63;
    boolean exchange;
    static final double pTolMax = 0.1;
    static final double TORELANCE_OVERRIDE_IN_INTERSECTION = 0.01;
    JgclElementarySurface3D dA;
    JgclPureBezierSurface3D dB;
    JgclQuadTree Btree;
    Vector solutionCurves;
    JgclObjectVector solutionSegs;
    double dTol;
    double dTol2;
    double pTol;
    static final int Wp_No = 0;
    static final int Wp_Au = 1;
    static final int Wp_Av = 2;
    static final int Wp_Bu = 3;
    static final int Wp_Bv = 4;
    static final int Wp_START = 1;
    static final int Wp_END = 5;
    private static final int UNKNOWN = 0;
    private static final int BEZIER = 1;
    private static final int PLANER = 2;
    private static final int RECTANGULAR = 3;
    private static final int LINE = 4;
    private static final int POINT = 5;
    static final int ONPLANE = 0;
    static final int FORESIDE = 1;
    static final int BACKSIDE = 2;
    static final int START = 0;
    static final int END = 1;
    static final int PNT1 = 1;
    static final int PNT2 = 2;
    static final int SS = 0;
    static final int EE = 1;
    static final int ES = 2;
    static final int SE = 3;
    static final int LOWER = 0;
    static final int UPPER = 1;
    static final int Wside_START = 0;
    static final int Wside_END = 2;
    RefineInfo ri;

    int sidePointPlane(JgclPoint3D pnt, JgclPoint3D org, JgclVector3D zax) {
        JgclVector3D vec = pnt.subtract(org);
        double zval = vec.dotProduct(zax);
        if (zval > this.dTol) {
            return 1;
        }
        if (zval < -this.dTol) {
            return 2;
        }
        return 0;
    }

    boolean checkInterfere(BezierInfo dA, BezierInfo dB) {
        JgclPureBezierSurface3D bzs;
        PlaneBezier pb;
        if (dA.box.min().x() > dB.box.max().x() + this.dTol || dA.box.min().y() > dB.box.max().y() + this.dTol || dA.box.min().z() > dB.box.max().z() + this.dTol || dB.box.min().x() > dA.box.max().x() + this.dTol || dB.box.min().y() > dA.box.max().y() + this.dTol || dB.box.min().z() > dA.box.max().z() + this.dTol) {
            return false;
        }
        if (dB.pb == null && dA.pb != null) {
            pb = dA.pb;
            bzs = dB.bzs;
        } else if (dA.pb == null && dB.pb != null) {
            pb = dB.pb;
            bzs = dA.bzs;
        } else {
            return true;
        }
        JgclPoint3D org = pb.origin();
        JgclVector3D zax = pb.zaxis();
        int k = 0;
        int pside = 0;
        int j = 0;
        while (j < bzs.vNControlPoints()) {
            int i = 0;
            while (i < bzs.uNControlPoints()) {
                int cside = this.sidePointPlane(bzs.controlPointAt(i, j), org, zax);
                if (k++ == 0 ? (pside = cside) == 0 : pside != cside) {
                    return true;
                }
                ++i;
            }
            ++j;
        }
        return false;
    }

    int getDiag(BezierInfo bi, JgclPoint3D[] pnts) {
        return 0;
    }

    TriangleInfo[] makeTriangles(BezierInfo bi) {
        int edgeCount = bi.pb.edgeCount;
        if (edgeCount == 4) {
            JgclPoint3D[] pnts = new JgclPoint3D[4];
            int i = 0;
            while (i < 4) {
                pnts[i] = bi.pb.boundaryCurves[i].controlPointAt(0);
                ++i;
            }
            int n = this.getDiag(bi, pnts);
            TriangleInfo[] tri = new TriangleInfo[2];
            if (n == 0) {
                tri[0] = new TriangleInfo(bi, pnts, 0, 1, 2);
                tri[1] = new TriangleInfo(bi, pnts, 2, 3, 0);
            } else {
                tri[0] = new TriangleInfo(bi, pnts, 0, 1, 3);
                tri[1] = new TriangleInfo(bi, pnts, 1, 2, 3);
            }
            return tri;
        }
        if (edgeCount == 3) {
            JgclPoint3D[] pnts = new JgclPoint3D[4];
            int i = 0;
            while (i < 4) {
                pnts[i] = bi.pb.boundaryCurves[i].controlPointAt(0);
                ++i;
            }
            TriangleInfo[] tri = new TriangleInfo[1];
            i = 0;
            while (i < 4) {
                if (bi.pb.shapeInfo[i] == 0) break;
                ++i;
            }
            tri[0] = new TriangleInfo(bi, pnts, i);
            return tri;
        }
        return null;
    }

    void addLineseg(LineSegmentInfo li) {
        JgclCursor e = this.solutionSegs.cursor();
        while (e.hasMoreElements()) {
            LineSegmentInfo li2 = (LineSegmentInfo)e.nextElement();
            if (li2.isSameLineseg(li)) break;
        }
        this.solutionSegs.addElement(li);
    }

    void intersectRectangle(BezierInfo dB) {
        if (dB.tri == null) {
            dB.tri = this.makeTriangles(dB);
        }
        int j = 0;
        while (j < dB.tri.length) {
            dB.tri[j].intersectQuadratic();
            ++j;
        }
    }

    void getIntersections(BezierInfo currentBI, int level) {
        double half_point = 0.5;
        if ((this.debugFlag & 1) != 0) {
            System.out.println("getIntersections: level = " + level);
            currentBI.output();
        }
        currentBI.whatTypeIsBezier();
        if (currentBI.crnt_type == 3) {
            this.intersectRectangle(currentBI);
            return;
        }
        double ug_half = (currentBI.u_sp + currentBI.u_ep) / 2.0;
        double vg_half = (currentBI.v_sp + currentBI.v_ep) / 2.0;
        JgclPureBezierSurface3D[] bzsx = currentBI.bzs.vDivide(half_point);
        JgclPureBezierSurface3D[] bzs0 = bzsx[0].uDivide(half_point);
        JgclPureBezierSurface3D[] bzs1 = bzsx[1].uDivide(half_point);
        BezierInfo bi00 = new BezierInfo(currentBI.root, bzs0[0], currentBI.u_sp, ug_half, currentBI.v_sp, vg_half);
        BezierInfo bi10 = new BezierInfo(currentBI.root, bzs1[0], currentBI.u_sp, ug_half, vg_half, currentBI.v_ep);
        BezierInfo bi11 = new BezierInfo(currentBI.root, bzs1[1], ug_half, currentBI.u_ep, vg_half, currentBI.v_ep);
        BezierInfo bi01 = new BezierInfo(currentBI.root, bzs0[1], ug_half, currentBI.u_ep, currentBI.v_sp, vg_half);
        this.getIntersections(bi00, level + 1);
        this.getIntersections(bi01, level + 1);
        this.getIntersections(bi11, level + 1);
        this.getIntersections(bi10, level + 1);
    }

    boolean isCompleteCurve(PointList plist, boolean addToSolutionCurves) {
        if (plist.is_closed()) {
            if (addToSolutionCurves) {
                this.solutionCurves.addElement(plist);
            }
            return true;
        }
        BoundaryInfo bis = new BoundaryInfo(0, plist.first());
        bis.adjust();
        BoundaryInfo bie = new BoundaryInfo(0, plist.last());
        bie.adjust();
        if (bis.is_boundary && bie.is_boundary) {
            if (addToSolutionCurves) {
                this.solutionCurves.addElement(plist);
            }
            return true;
        }
        if (plist.no > 3 && addToSolutionCurves) {
            if (!bis.is_boundary) {
                BoundaryInfo bis2 = new BoundaryInfo(0, plist.first(1));
                bis2.adjust();
                if (bis2.is_boundary) {
                    plist.removeFirst();
                    bis = bis2;
                }
            }
            if (!bie.is_boundary) {
                BoundaryInfo bie2 = new BoundaryInfo(0, plist.last(1));
                bie2.adjust();
                if (bie2.is_boundary) {
                    plist.removeLast();
                    bie = bie2;
                }
            }
            if (bis.is_boundary && bie.is_boundary) {
                if (addToSolutionCurves) {
                    this.solutionCurves.addElement(plist);
                }
                return true;
            }
        }
        return false;
    }

    boolean isSemiCompleteCurve(PointList plist, NListInfo nli) {
        BoundaryInfo bi = new BoundaryInfo(0, plist.first());
        if (bi.param != 0) {
            nli.plist_open_side = 1;
            return true;
        }
        bi = new BoundaryInfo(0, plist.last());
        if (bi.param != 0) {
            nli.plist_open_side = 0;
            return true;
        }
        return false;
    }

    void compareNListDist(PointList clist, PointList plist, NListInfo nli) {
        double cedist2;
        double csdist2;
        PointInfo cspnt = clist.first();
        PointInfo cepnt = clist.last();
        if (clist == plist) {
            return;
        }
        PointInfo popnt = nli.plist_open_side == 0 ? plist.first() : plist.last();
        BoundaryInfo bi = new BoundaryInfo(0, cspnt);
        if (bi.param == 0 && (csdist2 = popnt.pnt.distance2(cspnt.pnt)) < nli.nlist_dist2) {
            nli.nlist_dist2 = csdist2;
            nli.nlist = clist;
            nli.nlist_connect_side = 0;
        }
        bi = new BoundaryInfo(0, cepnt);
        if (bi.param == 0 && (cedist2 = popnt.pnt.distance2(cepnt.pnt)) < nli.nlist_dist2) {
            nli.nlist_dist2 = cedist2;
            nli.nlist = clist;
            nli.nlist_connect_side = 1;
        }
    }

    boolean moveToSolutionCurves(PointList plist) {
        PointInfo pspnt = plist.first();
        PointInfo pepnt = plist.last();
        if (plist.is_closed()) {
            this.solutionCurves.addElement(plist);
            return true;
        }
        BoundaryInfo bi = new BoundaryInfo(0, pspnt);
        bi.adjust();
        if (!bi.is_boundary) {
            return false;
        }
        bi = new BoundaryInfo(0, pepnt);
        bi.adjust();
        if (!bi.is_boundary) {
            return false;
        }
        this.solutionCurves.addElement(plist);
        return true;
    }

    void compareMListLength(PointList plist, MListInfo mi) {
        if (plist.no > mi.mlist_no) {
            mi.mlist_no = plist.no;
            mi.list = plist;
        }
    }

    void moveMListToSolutionCurves(PointList plist, MListInfo mi) {
        PointInfo pspnt = plist.first();
        PointInfo pepnt = plist.last();
        if (plist.is_closed()) {
            this.solutionCurves.addElement(plist);
            return;
        }
        BoundaryInfo bi = new BoundaryInfo(0, pspnt);
        bi.adjust();
        bi = new BoundaryInfo(0, pepnt);
        bi.adjust();
        this.solutionCurves.addElement(plist);
    }

    void getFirstNode(LineSegmentInfo ls_info, CLInfo c_info) {
        c_info.p1 = ls_info.p1;
        c_info.p2 = ls_info.p2;
        c_info.found = true;
    }

    boolean areConnected(PointInfo pi1, PointInfo pi2, GapInfo gi) {
        double Aupara_gap = pi1.Aupara - pi2.Aupara;
        double Avpara_gap = pi1.Avpara - pi2.Avpara;
        double Bupara_gap = pi1.Bupara - pi2.Bupara;
        double Bvpara_gap = pi1.Bvpara - pi2.Bvpara;
        double Apara_gap = Aupara_gap * Aupara_gap + Avpara_gap * Avpara_gap;
        double Bpara_gap = Bupara_gap * Bupara_gap + Bvpara_gap * Bvpara_gap;
        double para_gap = Apara_gap + Bpara_gap;
        double AuPTol = (pi1.AuPTol + pi2.AuPTol) / 2.0;
        double AvPTol = (pi1.AvPTol + pi2.AvPTol) / 2.0;
        double BuPTol = (pi1.BuPTol + pi2.BuPTol) / 2.0;
        double BvPTol = (pi1.BvPTol + pi2.BvPTol) / 2.0;
        double APTol = AuPTol * AuPTol + AvPTol * AvPTol;
        double BPTol = BuPTol * BuPTol + BvPTol * BvPTol;
        if (!gi.gap_rev || gi.gap > para_gap) {
            gi.gap_rev = true;
            gi.gap = para_gap;
            gi.gap_Au = Aupara_gap;
            gi.gap_Av = Avpara_gap;
            gi.gap_Bu = Bupara_gap;
            gi.gap_Bv = Bvpara_gap;
            gi.gap_pi1 = pi1;
            gi.gap_pi2 = pi2;
        }
        gi.dist2 = pi1.pnt.distance2(pi2.pnt);
        if (Apara_gap > APTol || Bpara_gap > BPTol) {
            return false;
        }
        return !(gi.dist2 > this.dTol2);
    }

    boolean are_min_para_gap_points(PointInfo pi1, PointInfo pi2, GapInfo gi) {
        if (pi1 == gi.gap_pi1 && pi2 == gi.gap_pi2) {
            gi.dist2 = pi1.pnt.distance2(pi2.pnt);
            return true;
        }
        return false;
    }

    boolean getNextNode1(LineSegmentInfo ls_info, CLInfo c_info) {
        GapInfo gi = c_info.gi;
        if (this.areConnected(c_info.ps, ls_info.p1, c_info.gi)) {
            c_info.dir = 0;
            c_info.cpnt = 1;
            double dist2 = gi.dist2;
            if (this.areConnected(c_info.ps, ls_info.p2, c_info.gi) && gi.dist2 < dist2) {
                c_info.cpnt = 2;
            }
            c_info.found = true;
            return true;
        }
        if (this.areConnected(c_info.ps, ls_info.p2, c_info.gi)) {
            c_info.dir = 0;
            c_info.cpnt = 2;
            c_info.found = true;
            return true;
        }
        if (this.areConnected(c_info.pe, ls_info.p1, c_info.gi)) {
            c_info.dir = 1;
            c_info.cpnt = 1;
            double dist2 = gi.dist2;
            if (this.areConnected(c_info.pe, ls_info.p2, c_info.gi) && gi.dist2 < dist2) {
                c_info.cpnt = 2;
            }
            c_info.found = true;
            return true;
        }
        if (this.areConnected(c_info.pe, ls_info.p2, c_info.gi)) {
            c_info.dir = 1;
            c_info.cpnt = 2;
            c_info.found = true;
            return true;
        }
        return false;
    }

    boolean getNextNode(LineSegmentInfo ls_info, CLInfo c_info) {
        if (!this.getNextNode1(ls_info, c_info) && !c_info.found) {
            return false;
        }
        c_info.p1 = ls_info.p1;
        c_info.p2 = ls_info.p2;
        c_info.leng2 = ls_info.leng2;
        return true;
    }

    boolean retryGetNextNode1(LineSegmentInfo ls_info, CLInfo c_info) {
        if (this.are_min_para_gap_points(c_info.ps, ls_info.p1, c_info.gi)) {
            c_info.dir = 0;
            c_info.cpnt = 1;
            c_info.found = true;
            return true;
        }
        if (this.are_min_para_gap_points(c_info.ps, ls_info.p2, c_info.gi)) {
            c_info.dir = 0;
            c_info.cpnt = 2;
            c_info.found = true;
            return true;
        }
        if (this.are_min_para_gap_points(c_info.pe, ls_info.p1, c_info.gi)) {
            c_info.dir = 1;
            c_info.cpnt = 1;
            c_info.found = true;
            return true;
        }
        if (this.are_min_para_gap_points(c_info.pe, ls_info.p2, c_info.gi)) {
            c_info.dir = 1;
            c_info.cpnt = 2;
            c_info.found = true;
            return true;
        }
        return false;
    }

    boolean retryGetNextNode(LineSegmentInfo ls_info, CLInfo c_info) {
        double[] p_gap = new double[4];
        if (!this.retryGetNextNode1(ls_info, c_info) && !c_info.found) {
            return false;
        }
        p_gap[0] = Math.abs(c_info.gi.gap_Au);
        p_gap[1] = Math.abs(c_info.gi.gap_Av);
        p_gap[2] = Math.abs(c_info.gi.gap_Bu);
        p_gap[3] = Math.abs(c_info.gi.gap_Bv);
        if (!c_info.severe_retry_criterion && p_gap[0] > this.pTol && p_gap[1] > this.pTol && p_gap[2] > this.pTol && p_gap[3] > this.pTol) {
            c_info.found = false;
            return false;
        }
        c_info.p1 = ls_info.p1;
        c_info.p2 = ls_info.p2;
        c_info.leng2 = ls_info.leng2;
        return true;
    }

    void searchNext(CLInfo c_info, int level) {
        boolean found = false;
        JgclCursor e = this.solutionSegs.cursor();
        while (e.hasMoreElements()) {
            LineSegmentInfo ls_info = (LineSegmentInfo)e.nextElement();
            switch (level) {
                case 0: {
                    found = this.getNextNode(ls_info, c_info);
                    break;
                }
                case 1: {
                    c_info.severe_retry_criterion = true;
                    found = this.retryGetNextNode(ls_info, c_info);
                    break;
                }
                case 2: {
                    c_info.severe_retry_criterion = false;
                    found = this.retryGetNextNode(ls_info, c_info);
                    break;
                }
            }
            if (!found) continue;
            e.removePrevElement();
            return;
        }
    }

    final PointInfo furtherPoint(CLInfo c) {
        return c.cpnt == 1 ? c.p2 : c.p1;
    }

    boolean shouldRetry(PointList plist, GapInfo gi) {
        if (gi.gap_rev) {
            if (gi.gap < this.pTol && !plist.is_closed()) {
                return true;
            }
            if (!this.isCompleteCurve(plist, false)) {
                return true;
            }
        }
        return false;
    }

    boolean is_min_para_gap_pi1_bound(GapInfo gi) {
        BoundaryInfo bi = new BoundaryInfo(0, gi.gap_pi1);
        return bi.param != 0;
    }

    /*
     * Unable to fully structure code
     */
    void connectIntersections() {
        pre_solutionCurves = new JgclObjectVector();
        c_info = new CLInfo();
        gi = c_info.gi = new GapInfo();
        if ((this.debugFlag & 16) != 0) {
            System.out.println("solutionSegs");
            i = 0;
            se = this.solutionSegs.cursor();
            while (se.hasMoreElements()) {
                li = (LineSegmentInfo)se.nextElement();
                System.out.println("LineSegmentInfo[" + i + "]");
                li.p1.pnt.literal().output(System.out);
                li.p2.pnt.literal().output(System.out);
                if (li.is_main_line) {
                    System.out.println("main_line");
                }
                ++i;
            }
        }
        block1: while (true) {
            block38: {
                c_info.found = false;
                c_info.leng2 = 0.0;
                if (this.solutionSegs.size() > 1) {
                    se = this.solutionSegs.cursor();
                    while (se.hasMoreElements()) {
                        ls_info = (LineSegmentInfo)se.nextElement();
                        if (!(ls_info.leng2 >= this.dTol2)) continue;
                        c_info.leng2 = ls_info.leng2;
                        this.getFirstNode(ls_info, c_info);
                        se.removePrevElement();
                        break;
                    }
                }
                if (c_info.found) break block38;
                if (this.solutionSegs.size() == 0) ** GOTO lbl127
                ls_info = (LineSegmentInfo)this.solutionSegs.elementAt(0);
                this.solutionSegs.removeElementAt(0);
                this.getFirstNode(ls_info, c_info);
            }
            c_info.ps = c_info.p1;
            c_info.pe = c_info.p2;
            if ((this.debugFlag & 16) != 0) {
                System.out.println("getFirstNode:");
                c_info.output();
            }
            plist = new PointList(c_info);
            while (true) {
                c_info.found = false;
                gi.gap_rev = false;
                this.searchNext(c_info, 0);
                if (!c_info.found) {
                    if ((this.debugFlag & 16) != 0) {
                        System.out.println("not found:");
                        c_info.output();
                        System.out.println("gap = " + c_info.gi.gap);
                        System.out.println("dist = " + Math.sqrt(c_info.gi.dist2));
                    }
                    pspnt = c_info.ps;
                    pepnt = c_info.pe;
                    if (this.shouldRetry(plist, gi)) {
                        if ((this.debugFlag & 16) != 0) {
                            System.out.println("retry:");
                        }
                        this.searchNext(c_info, 1);
                        if (!c_info.found && !this.is_min_para_gap_pi1_bound(gi)) {
                            this.searchNext(c_info, 2);
                        }
                    }
                    if (!c_info.found && !this.isCompleteCurve(plist, false)) {
                        this.searchNext(c_info, 0);
                        if (!c_info.found && this.shouldRetry(plist, gi)) {
                            this.searchNext(c_info, 1);
                            if (!c_info.found && !this.is_min_para_gap_pi1_bound(gi)) {
                                this.searchNext(c_info, 2);
                            }
                        }
                    }
                    if (!c_info.found) {
                        if ((this.debugFlag & 16) != 0) {
                            System.out.println("no more:");
                            c_info.output();
                        }
                        pre_solutionCurves.addElement(plist);
                        continue block1;
                    }
                }
                if ((this.debugFlag & 16) != 0) {
                    System.out.println("searchNext:");
                    c_info.output();
                }
                if (c_info.dir == 0) {
                    pspnt = c_info.ps = this.furtherPoint(c_info);
                    plist.prepend(pspnt, c_info.leng2);
                    continue;
                }
                pepnt = c_info.pe = this.furtherPoint(c_info);
                plist.append(pepnt, c_info.leng2);
            }
            break;
        }
lbl-1000:
        // 1 sources

        {
            se = pre_solutionCurves.cursor();
            while (se.hasMoreElements()) {
                plist = (PointList)se.nextElement();
                if (!this.isCompleteCurve(plist, true)) continue;
                se.removePrevElement();
            }
            if (pre_solutionCurves.size() <= 1) break;
            nli = new NListInfo();
            plist = null;
            se = pre_solutionCurves.cursor();
            while (se.hasMoreElements()) {
                plist = (PointList)se.nextElement();
                if (this.isSemiCompleteCurve(plist, nli)) break;
            }
            if (plist == null) break;
            nli.nlist_dist2 = 1.0f / JgclMachineEpsilon.SINGLE;
            se = pre_solutionCurves.cursor();
            while (se.hasMoreElements()) {
                clist = (PointList)se.nextElement();
                this.compareNListDist(clist, plist, nli);
            }
            if (nli.plist_open_side == 1) {
                pspnt = plist.last();
                plist.removeLast();
                if (nli.nlist_connect_side == 0) {
                    pepnt = nli.nlist.first();
                    plist.connect(nli.nlist, false, false);
                } else {
                    pepnt = nli.nlist.last();
                    plist.connect(nli.nlist, false, true);
                }
            } else {
                pspnt = plist.first();
                plist.removeFirst();
                if (nli.nlist_connect_side == 0) {
                    pepnt = nli.nlist.first();
                    plist.connect(nli.nlist, true, true);
                } else {
                    pepnt = nli.nlist.last();
                    plist.connect(nli.nlist, true, false);
                }
            }
            pepnt.interpolate(pspnt);
            se = pre_solutionCurves.cursor();
            while (se.hasMoreElements()) {
                plist = (PointList)se.nextElement();
                if (plist != nli.nlist) continue;
                se.removePrevElement();
            }
lbl127:
            // 2 sources

            ** while (pre_solutionCurves.size() > 1)
        }
lbl128:
        // 3 sources

        if (pre_solutionCurves.size() > 0) {
            se = pre_solutionCurves.cursor();
            while (se.hasMoreElements()) {
                plist = (PointList)se.nextElement();
                if (!this.isCompleteCurve(plist, true)) continue;
                se.removePrevElement();
            }
        }
        if (pre_solutionCurves.size() > 0) {
            se = pre_solutionCurves.cursor();
            while (se.hasMoreElements()) {
                plist = (PointList)se.nextElement();
                if (!this.moveToSolutionCurves(plist)) continue;
                se.removePrevElement();
            }
        }
        if (pre_solutionCurves.size() > 0 && this.solutionCurves.size() == 0) {
            mi = new MListInfo();
            se = pre_solutionCurves.cursor();
            while (se.hasMoreElements()) {
                plist = (PointList)se.nextElement();
                this.compareMListLength(plist, mi);
            }
            this.moveMListToSolutionCurves(mi.list, mi);
            se = pre_solutionCurves.cursor();
            while (se.hasMoreElements()) {
                plist = (PointList)se.nextElement();
                if (plist != mi.list) continue;
                se.removePrevElement();
            }
        }
    }

    double[] setupParams(PointInfo pi, PointInfo b_pi) {
        BoundaryInfo bi = this.ri.bi = new BoundaryInfo(0, pi);
        if (bi.param == 0) {
            double Au_gap = Math.abs(pi.Aupara - b_pi.Aupara);
            double Av_gap = Math.abs(pi.Avpara - b_pi.Avpara);
            double Bu_gap = Math.abs(pi.Bupara - b_pi.Bupara);
            double Bv_gap = Math.abs(pi.Bvpara - b_pi.Bvpara);
            double c_gap = Au_gap;
            bi.param = 1;
            if (c_gap < Av_gap) {
                c_gap = Av_gap;
                bi.param = 2;
            }
            if (c_gap < Bu_gap) {
                c_gap = Bu_gap;
                bi.param = 3;
            }
            if (c_gap < Bv_gap) {
                c_gap = Bv_gap;
                bi.param = 4;
            }
        } else {
            BoundaryInfo b_bi = new BoundaryInfo(0, b_pi);
            if (b_bi.param == bi.param && b_bi.wend == bi.wend || b_bi.param == 0) {
                switch (bi.param) {
                    case 1: {
                        if (!(Math.abs(pi.Aupara - b_pi.Aupara) < this.pTol) || !(Math.abs(pi.Avpara - b_pi.Avpara) > this.pTol)) break;
                        bi.param = 2;
                        break;
                    }
                    case 2: {
                        if (!(Math.abs(pi.Avpara - b_pi.Avpara) < this.pTol) || !(Math.abs(pi.Aupara - b_pi.Aupara) > this.pTol)) break;
                        bi.param = 1;
                        break;
                    }
                    case 3: {
                        if (!(Math.abs(pi.Bupara - b_pi.Bupara) < this.pTol) || !(Math.abs(pi.Bvpara - b_pi.Bvpara) > this.pTol)) break;
                        bi.param = 4;
                        break;
                    }
                    case 4: {
                        if (!(Math.abs(pi.Bvpara - b_pi.Bvpara) < this.pTol) || !(Math.abs(pi.Bupara - b_pi.Bupara) > this.pTol)) break;
                        bi.param = 3;
                        break;
                    }
                }
            }
        }
        return this.ri.setupParams(pi);
    }

    double[] reSetupParams(PointInfo pi) {
        BoundaryInfo bi = this.ri.bi;
        BoundaryInfo nbi = new BoundaryInfo(bi.param, pi);
        if (nbi.param == bi.param) {
            switch (nbi.param) {
                case 1: {
                    nbi.param = 2;
                    break;
                }
                case 2: {
                    nbi.param = 1;
                    break;
                }
                case 3: {
                    nbi.param = 4;
                    break;
                }
                case 4: {
                    nbi.param = 3;
                    break;
                }
            }
        }
        this.ri.bi = nbi;
        return this.ri.setupParams(pi);
    }

    private void clipParam(int n, double[] param) {
        if (param[n] < 0.0) {
            param[n] = 0.0;
        }
        if (param[n] > 1.0) {
            param[n] = 1.0;
        }
    }

    boolean setbackParams(PointInfo pi, double[] param, PointInfo b_pi, PointInfo a_pi) {
        double[] A_param = new double[2];
        double[] B_param = new double[2];
        switch (this.ri.bi.param) {
            case 1: {
                this.clipParam(1, param);
                this.clipParam(2, param);
                A_param[0] = pi.Aupara;
                A_param[1] = param[0];
                B_param[0] = param[1];
                B_param[1] = param[2];
                break;
            }
            case 2: {
                this.clipParam(1, param);
                this.clipParam(2, param);
                A_param[0] = param[0];
                A_param[1] = pi.Avpara;
                B_param[0] = param[1];
                B_param[1] = param[2];
                break;
            }
            case 3: {
                this.clipParam(2, param);
                A_param[0] = param[0];
                A_param[1] = param[1];
                B_param[0] = pi.Bupara;
                B_param[1] = param[2];
                break;
            }
            case 4: {
                this.clipParam(2, param);
                A_param[0] = param[0];
                A_param[1] = param[1];
                B_param[0] = param[2];
                B_param[1] = pi.Bvpara;
                break;
            }
        }
        JgclLiteralVector2D evec1 = new JgclLiteralVector2D(A_param[0] - b_pi.Aupara, A_param[1] - b_pi.Avpara);
        JgclLiteralVector2D evec2 = new JgclLiteralVector2D(pi.Aupara - b_pi.Aupara, pi.Avpara - b_pi.Avpara);
        if (evec1.dotProduct(evec2) < 0.0) {
            return false;
        }
        evec1 = new JgclLiteralVector2D(A_param[0] - a_pi.Aupara, A_param[1] - a_pi.Avpara);
        evec2 = new JgclLiteralVector2D(pi.Aupara - a_pi.Aupara, pi.Avpara - a_pi.Avpara);
        if (evec1.dotProduct(evec2) < 0.0) {
            return false;
        }
        evec1 = new JgclLiteralVector2D(B_param[0] - b_pi.Bupara, B_param[1] - b_pi.Bvpara);
        evec2 = new JgclLiteralVector2D(pi.Bupara - b_pi.Bupara, pi.Bvpara - b_pi.Bvpara);
        if (evec1.dotProduct(evec2) < 0.0) {
            return false;
        }
        evec1 = new JgclLiteralVector2D(B_param[0] - a_pi.Bupara, B_param[1] - a_pi.Bvpara);
        evec2 = new JgclLiteralVector2D(pi.Bupara - a_pi.Bupara, pi.Bvpara - a_pi.Bvpara);
        if (evec1.dotProduct(evec2) < 0.0) {
            return false;
        }
        pi.Aupara = A_param[0];
        pi.Avpara = A_param[1];
        pi.Bupara = B_param[0];
        pi.Bvpara = B_param[1];
        return true;
    }

    boolean refinePointInfo(PointInfo pinfo, PointInfo b_pinfo, PointInfo a_pinfo, boolean do_retry) {
        this.ri = new RefineInfo();
        nlFunc nl_func = new nlFunc();
        JgclRealFunction[] dnl_func = new JgclRealFunction[]{new dnlFunc(0), new dnlFunc(1), new dnlFunc(2)};
        cnvFunc cnv_func = new cnvFunc();
        if ((this.debugFlag & 0x20) != 0) {
            System.out.println("refine:");
            pinfo.pnt.literal().output(System.out);
            System.out.println("(" + pinfo.Aupara + "," + pinfo.Avpara + "), (" + pinfo.Bupara + "," + pinfo.Bvpara + ")");
        }
        double[] param = this.setupParams(pinfo, b_pinfo);
        if ((param = JgclMath.solveSimultaneousEquations(nl_func, dnl_func, cnv_func, param)) == null && do_retry) {
            if ((this.debugFlag & 0x20) != 0) {
                System.out.println("refine retry:");
            }
            param = this.reSetupParams(pinfo);
            param = JgclMath.solveSimultaneousEquations(nl_func, dnl_func, cnv_func, param);
        }
        if (param == null) {
            if ((this.debugFlag & 0x20) != 0) {
                System.out.println("refine fail:");
            }
            return false;
        }
        if (!this.setbackParams(pinfo, param, b_pinfo, a_pinfo)) {
            if ((this.debugFlag & 0x20) != 0) {
                System.out.println("setback fail:");
            }
            return false;
        }
        return true;
    }

    JgclIntersectionPoint3D makeIntersectionPoint(JgclParametricSurface3D s1, JgclPoint2D p1, JgclParametricSurface3D s2, JgclPoint2D p2) {
        if (this.exchange) {
            return new JgclIntersectionPoint3D(s2, p2.x(), p2.y(), s1, p1.x(), p1.y(), false);
        }
        return new JgclIntersectionPoint3D(s1, p1.x(), p1.y(), s2, p2.x(), p2.y(), false);
    }

    JgclSurfaceSurfaceInterference3D fillArray(PointList plist, JgclElementarySurface3D dA, JgclPureBezierSurface3D dB) {
        Vector<JgclCartesianPoint2D> vecA = new Vector<JgclCartesianPoint2D>();
        Vector<JgclCartesianPoint2D> vecB = new Vector<JgclCartesianPoint2D>();
        Vector<JgclPoint3D> vecP = new Vector<JgclPoint3D>();
        boolean closed = plist.is_closed();
        int i = closed ? 1 : 0;
        while (i < plist.no) {
            PointInfo a_pinfo;
            PointInfo b_pinfo;
            PointInfo pinfo = plist.first(i);
            if (this.refinePointInfo(pinfo, b_pinfo = i == 0 ? plist.first() : plist.first(i - 1), a_pinfo = i < plist.no - 1 ? plist.first(i + 1) : plist.last(), true)) {
                JgclPoint3D pnt;
                JgclPointOnSurface3D p1 = new JgclPointOnSurface3D(dA, pinfo.Aupara, pinfo.Avpara, false);
                JgclPointOnSurface3D p2 = new JgclPointOnSurface3D(dB, pinfo.Bupara, pinfo.Bvpara, false);
                pinfo.pnt = p1.linearInterpolate(p2, 0.5);
                if (dA.type() != 1 && vecA.size() > 0) {
                    double lastAparaX = ((JgclPoint2D)vecA.lastElement()).x();
                    while (pinfo.Aupara < lastAparaX - Math.PI) {
                        pinfo.Aupara += Math.PI * 2;
                    }
                    while (pinfo.Aupara > lastAparaX + Math.PI) {
                        pinfo.Aupara -= Math.PI * 2;
                    }
                }
                JgclCartesianPoint2D Apara = new JgclCartesianPoint2D(pinfo.Aupara, pinfo.Avpara);
                JgclCartesianPoint2D Bpara = new JgclCartesianPoint2D(pinfo.Bupara, pinfo.Bvpara);
                if (vecP.size() > 0 && (pnt = (JgclPoint3D)vecP.lastElement()).distance2(pinfo.pnt) < this.dTol2) {
                    if (i == plist.no - 1) {
                        int last = vecP.size() - 1;
                        if (last == 0) {
                            return this.makeIntersectionPoint(dA, Apara.linearInterpolate((JgclPoint2D)vecA.firstElement(), 0.5), dB, Bpara.linearInterpolate((JgclPoint2D)vecB.firstElement(), 0.5));
                        }
                        vecA.setElementAt(Apara, last);
                        vecB.setElementAt(Bpara, last);
                        vecP.setElementAt(pinfo.pnt, last);
                    }
                } else {
                    vecA.addElement(Apara);
                    vecB.addElement(Bpara);
                    vecP.addElement(pinfo.pnt);
                }
            }
            ++i;
        }
        if (vecP.size() < 1) {
            return null;
        }
        if (vecP.size() == 1) {
            return this.makeIntersectionPoint(dA, (JgclPoint2D)vecA.firstElement(), dB, (JgclPoint2D)vecB.firstElement());
        }
        Object[] Apnts = new JgclCartesianPoint2D[vecP.size()];
        vecA.copyInto(Apnts);
        JgclPolyline2D curve2d1 = new JgclPolyline2D((JgclPoint2D[])Apnts, closed);
        Object[] Bpnts = new JgclCartesianPoint2D[vecP.size()];
        vecB.copyInto(Bpnts);
        JgclPolyline2D curve2d2 = new JgclPolyline2D((JgclPoint2D[])Bpnts, closed);
        Object[] pnts = new JgclPoint3D[vecP.size()];
        vecP.copyInto(pnts);
        JgclPolyline3D curve3d = new JgclPolyline3D((JgclPoint3D[])pnts, closed);
        if (this.exchange) {
            return new JgclIntersectionCurve3D(curve3d, dB, curve2d2, dA, curve2d1, 1);
        }
        return new JgclIntersectionCurve3D(curve3d, dA, curve2d1, dB, curve2d2, 1);
    }

    JgclSurfaceSurfaceInterference3D[] intsQrdBzs() {
        JgclConditionOfOperation cond = JgclConditionOfOperation.getCondition();
        cond = cond.makeCopyWithToleranceForDistance(0.01);
        cond.push();
        try {
            this.dTol2 = cond.getToleranceForDistance2();
            this.dTol = cond.getToleranceForDistance();
            this.pTol = cond.getToleranceForParameter();
            this.interfList = new JgclSurfaceSurfaceInterferenceList(this.dA, this.dB);
            BezierInfo dBRoot = new BezierInfo(this.dB, this.dB, 0.0, 1.0, 0.0, 1.0);
            this.Btree = new JgclQuadTree(dBRoot);
            JgclQuadTree.Node dBRootNode = this.Btree.rootNode();
            this.solutionSegs = new JgclObjectVector();
            this.getIntersections(dBRoot, 0);
            this.interfList.connectIntersectionCurves();
        }
        finally {
            Object var6_4 = null;
            JgclConditionOfOperation.pop();
        }
        this.interfList.refine();
        return this.interfList.toJgclSurfaceSurfaceInterference3DArray(this.exchange);
    }

    JgclIntsQrdBzs3D(JgclElementarySurface3D elm, JgclPureBezierSurface3D bzs, boolean exchange) {
        this.dA = elm;
        this.dB = bzs;
        this.exchange = exchange;
        this.debugFlag = 0;
    }

    JgclIntsQrdBzs3D(JgclElementarySurface3D elm, JgclPureBezierSurface3D bzs, boolean exchange, boolean debug) {
        this(elm, bzs, exchange);
        this.debugFlag = 0;
        if (debug) {
            this.debugFlag = 2;
        }
    }

    static JgclSurfaceSurfaceInterference3D[] intersection(JgclElementarySurface3D elm, JgclPureBezierSurface3D bzs, boolean exchange) {
        JgclIntsQrdBzs3D doObj = new JgclIntsQrdBzs3D(elm, bzs, exchange, false);
        return doObj.intsQrdBzs();
    }

    static JgclSurfaceSurfaceInterference3D[] intersection(JgclElementarySurface3D elm, JgclPureBezierSurface3D bzs, boolean exchange, boolean debug) {
        JgclIntsQrdBzs3D doObj = new JgclIntsQrdBzs3D(elm, bzs, exchange, debug);
        return doObj.intsQrdBzs();
    }

    static JgclPoint3D[][] toPnt(double[][][] array) {
        JgclPoint3D[][] pnts = new JgclPoint3D[4][4];
        int j = 0;
        while (j < 4) {
            int i = 0;
            while (i < 4) {
                pnts[i][j] = new JgclCartesianPoint3D(array[i][j]);
                ++i;
            }
            ++j;
        }
        return pnts;
    }

    public static void main(String[] args) {
        double[][][] dArrayArray = new double[4][][];
        double[][] dArrayArray2 = new double[4][];
        dArrayArray2[0] = new double[3];
        double[] dArray = new double[3];
        dArray[0] = 1.0;
        dArrayArray2[1] = dArray;
        double[] dArray2 = new double[3];
        dArray2[0] = 2.0;
        dArrayArray2[2] = dArray2;
        double[] dArray3 = new double[3];
        dArray3[0] = 3.0;
        dArrayArray2[3] = dArray3;
        dArrayArray[0] = dArrayArray2;
        double[][] dArrayArray3 = new double[4][];
        double[] dArray4 = new double[3];
        dArray4[1] = 1.0;
        dArrayArray3[0] = dArray4;
        dArrayArray3[1] = new double[]{1.0, 1.0, 4.0};
        dArrayArray3[2] = new double[]{2.0, 1.0, 4.0};
        double[] dArray5 = new double[3];
        dArray5[0] = 3.0;
        dArray5[1] = 1.0;
        dArrayArray3[3] = dArray5;
        dArrayArray[1] = dArrayArray3;
        double[][] dArrayArray4 = new double[4][];
        double[] dArray6 = new double[3];
        dArray6[1] = 2.0;
        dArrayArray4[0] = dArray6;
        dArrayArray4[1] = new double[]{1.0, 2.0, 4.0};
        dArrayArray4[2] = new double[]{2.0, 2.0, 4.0};
        double[] dArray7 = new double[3];
        dArray7[0] = 3.0;
        dArray7[1] = 2.0;
        dArrayArray4[3] = dArray7;
        dArrayArray[2] = dArrayArray4;
        double[][] dArrayArray5 = new double[4][];
        double[] dArray8 = new double[3];
        dArray8[1] = 3.0;
        dArrayArray5[0] = dArray8;
        double[] dArray9 = new double[3];
        dArray9[0] = 1.0;
        dArray9[1] = 3.0;
        dArrayArray5[1] = dArray9;
        double[] dArray10 = new double[3];
        dArray10[0] = 2.0;
        dArray10[1] = 3.0;
        dArrayArray5[2] = dArray10;
        double[] dArray11 = new double[3];
        dArray11[0] = 3.0;
        dArray11[1] = 3.0;
        dArrayArray5[3] = dArray11;
        dArrayArray[3] = dArrayArray5;
        double[][][] surf3 = dArrayArray;
        JgclPlane3D dA = new JgclPlane3D(JgclPoint3D.origin, JgclVector3D.zUnitVector);
        JgclPureBezierSurface3D dB = new JgclPureBezierSurface3D(JgclIntsQrdBzs3D.toPnt(surf3));
        JgclSurfaceSurfaceInterference3D[] ints = JgclIntsQrdBzs3D.intersection(dA, dB, false, true);
        int i = 0;
        while (i < ints.length) {
            if (ints[i].isIntersectionCurve()) {
                ints[i].toIntersectionCurve().output(System.out);
            } else if (ints[i].isIntersectionPoint()) {
                ints[i].toIntersectionPoint().output(System.out);
            }
            ++i;
        }
    }

    static /* synthetic */ int access$0() {
        return 0;
    }

    static /* synthetic */ int access$1() {
        return 5;
    }

    static /* synthetic */ int access$2() {
        return 1;
    }

    static /* synthetic */ int access$3() {
        return 4;
    }

    static /* synthetic */ int access$4() {
        return 3;
    }

    static /* synthetic */ int access$5() {
        return 2;
    }

    final class PointInfo {
        JgclPoint3D pnt;
        double Aupara;
        double Avpara;
        double Bupara;
        double Bvpara;
        double AuPTol;
        double AvPTol;
        double BuPTol;
        double BvPTol;

        private double tangentToPTol(JgclVector3D tangent) {
            double pt = JgclIntsQrdBzs3D.this.dTol / tangent.length();
            return Math.min(pt, 0.1);
        }

        private void setupPTol() {
            JgclVector3D[] tang = JgclIntsQrdBzs3D.this.dA.tangentVector(this.Aupara, this.Avpara);
            this.AuPTol = this.tangentToPTol(tang[0]);
            this.AvPTol = this.tangentToPTol(tang[1]);
            tang = JgclIntsQrdBzs3D.this.dB.tangentVector(this.Bupara, this.Bvpara);
            this.BuPTol = this.tangentToPTol(tang[0]);
            this.BvPTol = this.tangentToPTol(tang[1]);
        }

        PointInfo(JgclPoint3D pnt, double Au, double Av, double Bu, double Bv) {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
            this.pnt = pnt;
            this.Aupara = Au;
            this.Avpara = Av;
            this.Bupara = Bu;
            this.Bvpara = Bv;
            this.setupPTol();
            if (!JgclIntsQrdBzs3D.this.dA.coordinates(Au, Av).identical(pnt)) {
                throw new JgclFatal();
            }
            if (!JgclIntsQrdBzs3D.this.dB.coordinates(Bu, Bv).identical(pnt)) {
                throw new JgclFatal();
            }
        }

        PointInfo(JgclPoint3D pnt, JgclPointOnSurface3D iA, JgclPointOnSurface3D iB) {
            this(pnt, iA.uParameter(), iA.vParameter(), iB.uParameter(), iB.vParameter());
        }

        void interpolate(PointInfo pb) {
            this.pnt = this.pnt.linearInterpolate(pb.pnt, 0.5);
            this.Aupara = (this.Aupara + pb.Aupara) / 2.0;
            this.Avpara = (this.Avpara + pb.Avpara) / 2.0;
            this.Bupara = (this.Bupara + pb.Bupara) / 2.0;
            this.Bvpara = (this.Bvpara + pb.Bvpara) / 2.0;
            this.setupPTol();
        }

        double getBoundaryGap(int which, int side) {
            double para;
            switch (which) {
                default: {
                    throw new JgclFatal();
                }
                case 1: {
                    para = this.Aupara;
                    break;
                }
                case 2: {
                    para = this.Avpara;
                    break;
                }
                case 3: {
                    para = this.Bupara;
                    break;
                }
                case 4: {
                    para = this.Bvpara;
                }
            }
            if (side == 1) {
                return Math.abs(1.0 - para);
            }
            return Math.abs(para);
        }
    }

    final class IntersectPoint {
        JgclIntersectionPoint2D ip;
        double curveParam;
        double segParam;
        JgclPointOnSurface3D startP;
        JgclPointOnSurface3D endP;
        JgclPointOnSurface3D segPoint;
        JgclPureBezierSurface3D bzs;

        void setup(JgclPureBezierSurface3D root, JgclIntersectionPoint2D ip, JgclPointOnSurface3D sp, JgclPointOnSurface3D ep) {
            this.ip = ip;
            this.segParam = ip.pointOnCurve1().parameter();
            this.curveParam = ip.pointOnCurve2().parameter();
            this.bzs = root;
            this.startP = sp;
            this.endP = ep;
            double uparam = (1.0 - this.segParam) * sp.uParameter() + this.segParam * ep.uParameter();
            double vparam = (1.0 - this.segParam) * sp.vParameter() + this.segParam * ep.vParameter();
            this.segPoint = new JgclPointOnSurface3D(root, uparam, vparam, false);
        }

        IntersectPoint(JgclPureBezierSurface3D root, JgclIntersectionPoint2D ip, JgclPointOnSurface3D sp, JgclPointOnSurface3D ep) {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
            this.setup(root, ip, sp, ep);
        }

        IntersectPoint(JgclPureBezierSurface3D root, JgclLine2D seg, double param, JgclLine2D line, JgclPointOnSurface3D sp, JgclPointOnSurface3D ep) {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
            JgclPointOnCurve2D poc1 = new JgclPointOnCurve2D(seg, param, false);
            JgclPointOnCurve2D poc2 = line.project1From(poc1);
            this.setup(root, new JgclIntersectionPoint2D(poc1, poc2, false), sp, ep);
        }

        double curveParam() {
            return this.curveParam;
        }

        double segParam() {
            return this.segParam;
        }

        JgclPointOnSurface3D segPoint() {
            return this.segPoint;
        }

        JgclPointOnSurface3D interpPoint(IntersectPoint sp, IntersectPoint ep) {
            double vparam;
            double uparam;
            JgclPointOnSurface3D ssp = sp.segPoint();
            JgclPointOnSurface3D esp = ep.segPoint();
            if (sp.bzs != ep.bzs) {
                throw new JgclFatal();
            }
            if (sp.ip.identical(ep.ip)) {
                uparam = (ssp.uParameter() + esp.uParameter()) / 2.0;
                vparam = (ssp.vParameter() + esp.vParameter()) / 2.0;
            } else {
                double param = (this.curveParam - sp.curveParam) / (ep.curveParam - sp.curveParam);
                uparam = (1.0 - param) * ssp.uParameter() + param * esp.uParameter();
                vparam = (1.0 - param) * ssp.vParameter() + param * esp.vParameter();
            }
            JgclPointOnSurface3D pos = new JgclPointOnSurface3D(sp.bzs, uparam, vparam, false);
            return pos;
        }
    }

    final class TriangleInfo {
        JgclPointOnSurface3D[] bp;
        JgclLine2D[] seg2;
        JgclAxis2Placement3D axis;
        JgclPlane3D plane;
        JgclCartesianTransformationOperator3D trans;
        BezierInfo bi;

        void output(OutputStream out) {
            PrintWriter writer = new PrintWriter(out, true);
            writer.println("[[");
            int i = 0;
            while (i < 3) {
                this.bp[i].literal().output(out);
                ++i;
            }
            writer.println("xaxis = ");
            this.axis.x().output(out);
            writer.println("zaxis = ");
            this.axis.z().output(out);
            writer.println("]]");
        }

        JgclPointOnSurface3D makePointOnSurface(JgclPoint3D pnt, double lUpara, double lVpara) {
            double upar = (1.0 - lUpara) * this.bi.u_sp + lUpara * this.bi.u_ep;
            double vpar = (1.0 - lVpara) * this.bi.v_sp + lVpara * this.bi.v_ep;
            JgclPointOnSurface3D pos = new JgclPointOnSurface3D(pnt, this.bi.root, upar, vpar, false);
            return pos;
        }

        JgclPointOnSurface3D makePointOnSurface(JgclPoint3D pnt, JgclPoint2D pnt2d) {
            JgclIntersectionPoint2D cross;
            if (this.seg2[0].pnt().identical(pnt2d)) {
                JgclPointOnSurface3D pos = new JgclPointOnSurface3D(this.bi.root, this.bp[0].uParameter(), this.bp[0].vParameter(), false);
                return pos;
            }
            JgclLine2D line = new JgclLine2D(this.seg2[0].pnt(), pnt2d);
            try {
                cross = this.seg2[1].intersect1Line(line);
            }
            catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                throw new JgclFatal();
            }
            double param1 = cross.pointOnCurve1().parameter();
            double uu = (1.0 - param1) * this.bp[1].uParameter() + param1 * this.bp[2].uParameter();
            double vv = (1.0 - param1) * this.bp[1].vParameter() + param1 * this.bp[2].vParameter();
            double param2 = cross.pointOnCurve2().parameter();
            double upar = (uu + this.bp[0].uParameter() * (param2 - 1.0)) / param2;
            double vpar = (vv + this.bp[0].vParameter() * (param2 - 1.0)) / param2;
            upar = this.bi.root.uParameterDomain().force(upar);
            vpar = this.bi.root.vParameterDomain().force(vpar);
            JgclPointOnSurface3D pos = new JgclPointOnSurface3D(this.bi.root, upar, vpar, false);
            if (!pos.identical(pnt)) {
                pos = JgclIntsQrdBzs3D.this.dB.nearestProjectFrom(pnt);
            }
            return pos;
        }

        void output_line(JgclLine2D line) {
            System.out.println("line");
            line.pnt().literal().output(System.out);
            line.dir().output(System.out);
        }

        private final double uparam(int idx) {
            switch (idx) {
                default: {
                    return 0.0;
                }
                case 1: 
                case 2: 
            }
            return 1.0;
        }

        private final double vparam(int idx) {
            switch (idx) {
                default: {
                    return 0.0;
                }
                case 2: 
                case 3: 
            }
            return 1.0;
        }

        private void setupTriangle(JgclPointOnSurface3D[] tmpbp) {
            JgclVector3D xaxis = tmpbp[1].subtract(tmpbp[0]).unitized();
            JgclVector3D zaxis = tmpbp[2].subtract(tmpbp[0]).crossProduct(xaxis).unitized();
            this.axis = new JgclAxis2Placement3D(tmpbp[0], zaxis, xaxis);
            this.trans = new JgclCartesianTransformationOperator3D(this.axis, 1.0);
            this.plane = new JgclPlane3D(this.axis);
            int maxdist = -1;
            double maxnorm = 0.0;
            int i = 0;
            while (i < 3) {
                double norm = tmpbp[(i + 1) % 3].distance2(tmpbp[i]);
                if (maxnorm <= norm) {
                    maxdist = i;
                    maxnorm = norm;
                }
                ++i;
            }
            this.bp = new JgclPointOnSurface3D[4];
            this.seg2 = new JgclLine2D[3];
            i = maxdist;
            while (i < maxdist + 3) {
                this.bp[i - maxdist] = tmpbp[i % 3];
                this.seg2[i - maxdist] = tmpbp[i % 3].identical(tmpbp[(i + 1) % 3]) ? null : new JgclLine2D(tmpbp[i % 3].to2D(this.trans), tmpbp[(i + 1) % 3].to2D(this.trans));
                ++i;
            }
            this.bp[3] = this.bp[0];
        }

        TriangleInfo(BezierInfo bi, JgclPoint3D[] pnts, int idx1, int idx2, int idx3) {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
            JgclPointOnSurface3D[] tmpbp = new JgclPointOnSurface3D[3];
            int[] jx = new int[]{idx1, idx2, idx3};
            this.bi = bi;
            int i = 0;
            while (i < 3) {
                int j = jx[i];
                tmpbp[i] = this.makePointOnSurface(pnts[j], this.uparam(j), this.vparam(j));
                ++i;
            }
            this.setupTriangle(tmpbp);
        }

        TriangleInfo(BezierInfo bi, JgclPoint3D[] pnts, int idx) {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
            JgclPointOnSurface3D[] tmpbp = new JgclPointOnSurface3D[3];
            boolean j = false;
            this.bi = bi;
            int i = 0;
            while (i < 4) {
                if (i < idx) {
                    tmpbp[i] = this.makePointOnSurface(pnts[i], this.uparam(i), this.vparam(i));
                } else if (idx == i) {
                    JgclPoint3D p = pnts[i].linearInterpolate(pnts[i + 1], 0.5);
                    tmpbp[i] = this.makePointOnSurface(p, (this.uparam(i) + this.uparam(i + 1)) / 2.0, (this.vparam(i) + this.vparam(i + 1)) / 2.0);
                    ++i;
                } else {
                    tmpbp[i - 1] = this.makePointOnSurface(pnts[i], this.uparam(i), this.vparam(i));
                }
                ++i;
            }
            this.setupTriangle(tmpbp);
        }

        JgclIntersectionPoint2D[] intersectSeg(JgclLine2D seg, JgclLine2D line) {
            double o;
            if ((JgclIntsQrdBzs3D.this.debugFlag & 2) != 0) {
                System.out.println("intersectSeg:enter");
                this.output_line(seg);
                this.output_line(line);
            }
            JgclPoint2D s1 = seg.coordinates(0.0);
            JgclPoint2D s2 = seg.coordinates(1.0);
            JgclPointOnCurve2D p1 = line.project1From(s1);
            JgclPointOnCurve2D p2 = line.project1From(s2);
            if (s1.distance2(p1) < JgclIntsQrdBzs3D.this.dTol2 && s2.distance2(p2) < JgclIntsQrdBzs3D.this.dTol2) {
                if ((JgclIntsQrdBzs3D.this.debugFlag & 2) != 0) {
                    System.out.println("intersectSeg: dual");
                }
                JgclIntersectionPoint2D[] ip = new JgclIntersectionPoint2D[]{new JgclIntersectionPoint2D(seg, 0.0, line, p1.parameter(), false), new JgclIntersectionPoint2D(seg, 1.0, line, p2.parameter(), false)};
                return ip;
            }
            JgclVector2D p = line.pnt().subtract(seg.pnt());
            double pa = p.zOfCrossProduct(seg.dir());
            double pb = p.zOfCrossProduct(line.dir());
            double param = pb / (o = seg.dir().zOfCrossProduct(line.dir()));
            if (param < 0.0 || param > 1.0) {
                if ((JgclIntsQrdBzs3D.this.debugFlag & 2) != 0) {
                    System.out.println("intersectSeg: null");
                }
                return null;
            }
            JgclIntersectionPoint2D[] ip = new JgclIntersectionPoint2D[]{new JgclIntersectionPoint2D(seg, param, line, pa / o, false)};
            if ((JgclIntsQrdBzs3D.this.debugFlag & 2) != 0) {
                System.out.println("intersectSeg: param = " + param);
            }
            return ip;
        }

        IntersectPoint[] intersect(JgclLine2D line) {
            IntersectPoint[] rval = new IntersectPoint[2];
            JgclIntersectionPoint2D[] ip = null;
            int ints_cnt = 0;
            int i = 0;
            while (i < 3) {
                if (this.seg2[i] != null && (ip = this.intersectSeg(this.seg2[i], line)) != null) {
                    if (ip.length == 2) {
                        rval[0] = new IntersectPoint(this.bi.root, this.seg2[i], 0.0, line, this.bp[i], this.bp[i + 1]);
                        rval[1] = new IntersectPoint(this.bi.root, this.seg2[i], 1.0, line, this.bp[i], this.bp[i + 1]);
                        if ((JgclIntsQrdBzs3D.this.debugFlag & 2) != 0) {
                            System.out.println("Infinite");
                        }
                        return rval;
                    }
                    if (ints_cnt < 2) {
                        rval[ints_cnt] = new IntersectPoint(this.bi.root, ip[0], this.bp[i], this.bp[i + 1]);
                    }
                    ++ints_cnt;
                }
                ++i;
            }
            if ((JgclIntsQrdBzs3D.this.debugFlag & 2) != 0) {
                System.out.println("ints_cnt = " + ints_cnt);
            }
            switch (ints_cnt) {
                case 3: {
                    if (rval[0].ip.identical(rval[1].ip)) {
                        rval[1] = new IntersectPoint(this.bi.root, ip[0], this.bp[2], this.bp[3]);
                    }
                }
                case 2: {
                    return rval;
                }
            }
            return new IntersectPoint[0];
        }

        void sortIntersect(IntersectPoint[] p) {
            int j = 0;
            while (j < p.length) {
                int i = p.length - 1;
                while (i > j) {
                    if (p[i - 1].curveParam() > p[i].curveParam()) {
                        IntersectPoint tmp = p[i - 1];
                        p[i - 1] = p[i];
                        p[i] = tmp;
                    }
                    --i;
                }
                ++j;
            }
        }

        IntersectPoint[] intersect(JgclConic2D curve2d) {
            Vector<IntersectPoint> vec = new Vector<IntersectPoint>();
            int i = 0;
            while (i < 3) {
                JgclIntersectionPoint2D[] ips;
                try {
                    ips = this.seg2[i].intersect(curve2d);
                }
                catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                    throw new JgclFatal();
                }
                int j = 0;
                while (j < ips.length) {
                    JgclIntersectionPoint2D ip = ips[j];
                    double param = ip.pointOnCurve1().parameter();
                    if (!(param < 0.0) && !(param > 1.0)) {
                        IntersectPoint p = new IntersectPoint(this.bi.root, ip, this.bp[i], this.bp[i + 1]);
                        vec.addElement(p);
                    }
                    ++j;
                }
                ++i;
            }
            Object[] r = new IntersectPoint[vec.size()];
            vec.copyInto(r);
            return r;
        }

        private boolean isPointIn2D(JgclPoint2D p) {
            int sign = 0;
            int i = 0;
            while (i < 3) {
                double val2;
                int csign;
                int j = (i + 2) % 3;
                JgclPoint2D o = this.seg2[i].pnt();
                JgclVector2D dir = this.seg2[i].dir();
                JgclVector2D v1 = this.seg2[j].pnt().subtract(o);
                JgclVector2D v2 = p.subtract(o);
                double val1 = dir.zOfCrossProduct(v1);
                int n = csign = val1 * (val2 = dir.zOfCrossProduct(v2)) > 0.0 ? 1 : -1;
                if (sign == 0) {
                    sign = csign;
                } else if (sign != csign) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean isCurveIn2D(JgclConic2D curve2d) {
            JgclPoint2D center = curve2d.position().location();
            JgclPoint2D start = curve2d.coordinates(0.0);
            return this.isPointIn2D(center) && this.isPointIn2D(start);
        }

        private int getStartIndex(JgclConic2D curve2d, IntersectPoint[] ips) {
            if (curve2d instanceof JgclParabola2D || curve2d instanceof JgclHyperbola2D) {
                return 0;
            }
            if (ips.length >= 2) {
                double param = (ips[0].curveParam() + ips[1].curveParam()) / 2.0;
                JgclPointOnCurve2D p = new JgclPointOnCurve2D(curve2d, param, false);
                return this.isPointIn2D(p) ? 0 : 1;
            }
            return -1;
        }

        void intersectQuadratic() {
            JgclSurfaceSurfaceInterference3D[] intsCurves;
            try {
                intsCurves = JgclIntsQrdBzs3D.this.dA.intersect(this.plane, false);
            }
            catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                return;
            }
            int n = 0;
            while (n < intsCurves.length) {
                int startIdx;
                IntersectPoint[] lA;
                JgclParametricCurve2D ints2d;
                JgclIntersectionCurve3D intsCurve = intsCurves[n].toIntersectionCurve();
                JgclParametricCurve3D ints3d = intsCurve.curve3d();
                if (ints3d instanceof JgclLine3D) {
                    ints2d = ((JgclLine3D)ints3d).toLocal2D(this.trans);
                    lA = this.intersect((JgclLine2D)ints2d);
                    this.sortIntersect(lA);
                    startIdx = 0;
                } else {
                    ints2d = ((JgclConic3D)ints3d).toLocal2D(this.trans);
                    JgclConic2D curve2d = (JgclConic2D)ints2d;
                    lA = this.intersect(curve2d);
                    this.sortIntersect(lA);
                    startIdx = this.getStartIndex(curve2d, lA);
                    if (startIdx < 0 && this.isCurveIn2D(curve2d)) {
                        throw new JgclFatal();
                    }
                }
                if (lA != null && lA.length > 0) {
                    if ((JgclIntsQrdBzs3D.this.debugFlag & 2) != 0) {
                        int i = 0;
                        while (i < lA.length) {
                            System.out.println("lA[" + i + "]");
                            lA[i].ip.literal().output(System.out);
                            System.out.println("segParam = " + lA[i].segParam);
                            System.out.println("curveParam = " + lA[i].curveParam);
                            ++i;
                        }
                    }
                    int i = startIdx;
                    while (i < lA.length) {
                        JgclPolyline2D poly;
                        int j = i + 1 >= lA.length ? 0 : i + 1;
                        double param1 = lA[i].curveParam();
                        double param2 = lA[j].curveParam();
                        if (j == 0) {
                            JgclParameterDomain domain = ints2d.parameterDomain();
                            param2 += domain.section().increase();
                        }
                        JgclParameterSection sect = new JgclParameterSection(param1, param2 - param1);
                        JgclToleranceForDistance tol = new JgclToleranceForDistance(JgclIntsQrdBzs3D.this.dTol);
                        try {
                            poly = ints2d.toPolyline(sect, tol);
                        }
                        catch (JgclZeroLength jgclZeroLength) {
                            JgclPoint2D[] points = new JgclPoint2D[]{new JgclPointOnCurve2D(ints2d, sect.start(), false), new JgclPointOnCurve2D(ints2d, sect.end(), false)};
                            poly = new JgclPolyline2D(points);
                        }
                        PointInfo[] pis = new PointInfo[poly.nPoints()];
                        int k = 0;
                        while (k < poly.nPoints()) {
                            JgclPoint2D pnt2d = poly.pointAt(k);
                            JgclPoint3D pnt = this.trans.toEnclosed(pnt2d.to3D());
                            JgclPointOnSurface3D iA = JgclIntsQrdBzs3D.this.dA.nearestProjectFrom(pnt);
                            JgclPointOnSurface3D iB = this.makePointOnSurface(pnt, pnt2d);
                            pis[k] = new PointInfo(pnt, iA, iB);
                            ++k;
                        }
                        JgclPoint2D[] pA = new JgclPoint2D[poly.nPoints()];
                        JgclPoint2D[] pB = new JgclPoint2D[poly.nPoints()];
                        JgclPoint3D[] pp = new JgclPoint3D[poly.nPoints()];
                        int k2 = 0;
                        while (k2 < pis.length) {
                            pA[k2] = new JgclCartesianPoint2D(pis[k2].Aupara, pis[k2].Avpara);
                            pB[k2] = new JgclCartesianPoint2D(pis[k2].Bupara, pis[k2].Bvpara);
                            pp[k2] = pis[k2].pnt;
                            ++k2;
                        }
                        JgclPolyline2D pol2A = new JgclPolyline2D(pA);
                        JgclPolyline2D pol2B = new JgclPolyline2D(pB);
                        JgclPolyline3D pol = new JgclPolyline3D(pp);
                        JgclIntsQrdBzs3D.this.interfList.addAsIntersectionCurve(pol, pol2A, pol2B);
                        i += 2;
                    }
                }
                ++n;
            }
        }
    }

    final class LineSegmentInfo {
        PointInfo p1;
        PointInfo p2;
        JgclEnclosingBox3D box;
        double leng2;
        double leng;
        boolean is_main_line;

        LineSegmentInfo(PointInfo p1, PointInfo p2) {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
            this.p1 = p1;
            this.p2 = p2;
            this.leng2 = p1.pnt.distance2(p2.pnt);
            this.leng = Math.sqrt(this.leng2);
            JgclPoint3D pnt1 = p1.pnt;
            JgclPoint3D pnt2 = p2.pnt;
            this.box = new JgclEnclosingBox3D(Math.min(pnt1.x(), pnt2.x()), Math.min(pnt1.y(), pnt2.y()), Math.min(pnt1.z(), pnt2.z()), Math.max(pnt1.x(), pnt2.x()), Math.max(pnt1.y(), pnt2.y()), Math.max(pnt1.z(), pnt2.z()));
            this.is_main_line = true;
            if ((JgclIntsQrdBzs3D.this.debugFlag & 4) != 0) {
                System.out.println("LineSegmentInfo:");
                pnt1.literal().output(System.out);
                pnt2.literal().output(System.out);
            }
        }

        boolean isPointOnLineseg(PointInfo pi) {
            double edot;
            JgclPoint3D tgt = pi.pnt;
            JgclPoint3D bsp = this.p1.pnt;
            JgclPoint3D bep = this.p2.pnt;
            JgclVector3D bln = bep.subtract(bsp);
            JgclVector3D dir = tgt.subtract(bsp);
            double bleng = bln.length();
            if ((JgclIntsQrdBzs3D.this.debugFlag & 4) != 0) {
                System.out.println("isPointOnLineseg:");
            }
            if (bleng < (double)JgclMachineEpsilon.SINGLE) {
                edot = 0.0;
            } else {
                edot = bln.divide(bleng).dotProduct(dir);
                if (edot < 0.0 || bleng < edot) {
                    return false;
                }
            }
            double esin2 = dir.norm() - edot * edot;
            if (esin2 > JgclIntsQrdBzs3D.this.dTol2) {
                return false;
            }
            JgclLiteralVector2D bln2 = new JgclLiteralVector2D(this.p2.Aupara - this.p1.Aupara, this.p2.Avpara - this.p1.Avpara);
            JgclLiteralVector2D dir2 = new JgclLiteralVector2D(pi.Aupara - this.p1.Aupara, pi.Avpara - this.p1.Avpara);
            bleng = bln2.length();
            if (bleng < (double)JgclMachineEpsilon.SINGLE) {
                edot = 0.0;
            } else {
                edot = bln2.divide(bleng).dotProduct(dir2);
                if (edot < 0.0 || bleng < edot) {
                    return false;
                }
            }
            esin2 = dir2.norm() - edot * edot;
            if (esin2 > JgclIntsQrdBzs3D.this.dTol2) {
                return false;
            }
            bln2 = new JgclLiteralVector2D(this.p2.Bupara - this.p1.Bupara, this.p2.Bvpara - this.p1.Bvpara);
            dir2 = new JgclLiteralVector2D(pi.Bupara - this.p1.Bupara, pi.Bvpara - this.p1.Bvpara);
            bleng = bln2.length();
            if (bleng < (double)JgclMachineEpsilon.SINGLE) {
                edot = 0.0;
            } else {
                edot = bln2.divide(bleng).dotProduct(dir2);
                if (edot < 0.0 || bleng < edot) {
                    return false;
                }
            }
            esin2 = dir2.norm() - edot * edot;
            if (esin2 > JgclIntsQrdBzs3D.this.dTol2) {
                return false;
            }
            if (Math.abs(this.p1.Aupara - this.p2.Aupara) > Math.abs(this.p1.Avpara - this.p2.Avpara) ? (this.p1.Aupara > this.p2.Aupara ? pi.Aupara > this.p1.Aupara + this.p1.AuPTol || pi.Aupara < this.p2.Aupara - this.p2.AuPTol : pi.Aupara < this.p1.Aupara - this.p1.AuPTol || pi.Aupara > this.p2.Aupara + this.p2.AuPTol) : (this.p1.Avpara > this.p2.Avpara ? pi.Avpara > this.p1.Avpara + this.p1.AvPTol || pi.Avpara < this.p2.Avpara - this.p2.AvPTol : pi.Avpara < this.p1.Avpara - this.p1.AvPTol || pi.Avpara > this.p2.Avpara + this.p2.AvPTol)) {
                return false;
            }
            if (Math.abs(this.p1.Bupara - this.p2.Bupara) > Math.abs(this.p1.Bvpara - this.p2.Bvpara) ? (this.p1.Bupara > this.p2.Bupara ? pi.Bupara > this.p1.Bupara + this.p1.BuPTol || pi.Bupara < this.p2.Bupara - this.p2.BuPTol : pi.Bupara < this.p1.Bupara - this.p1.BuPTol || pi.Bupara > this.p2.Bupara + this.p2.BuPTol) : (this.p1.Bvpara > this.p2.Bvpara ? pi.Bvpara > this.p1.Bvpara + this.p1.BvPTol || pi.Bvpara < this.p2.Bvpara - this.p2.BvPTol : pi.Bvpara < this.p1.Bvpara - this.p1.BvPTol || pi.Bvpara > this.p2.Bvpara + this.p2.BvPTol)) {
                return false;
            }
            if ((JgclIntsQrdBzs3D.this.debugFlag & 4) != 0) {
                System.out.println("isPointOnLineseg: true");
            }
            return true;
        }

        boolean assignSameLineseg(LineSegmentInfo l2, boolean two_cc) {
            if ((JgclIntsQrdBzs3D.this.debugFlag & 8) != 0) {
                System.out.println("assignSameLineseg:");
            }
            if (two_cc) {
                if ((this.leng + JgclIntsQrdBzs3D.this.dTol) * (this.leng + JgclIntsQrdBzs3D.this.dTol) < l2.leng2) {
                    this.is_main_line = false;
                    return false;
                }
                l2.is_main_line = false;
                return true;
            }
            if (this.leng2 < l2.leng2) {
                this.is_main_line = false;
                return false;
            }
            l2.is_main_line = false;
            return true;
        }

        boolean isSamePoint(LineSegmentInfo l2, double[] dist2, int pair) {
            PointInfo l1p = null;
            PointInfo l2p = null;
            if ((JgclIntsQrdBzs3D.this.debugFlag & 4) != 0) {
                System.out.println("isSamePoint:");
            }
            if (JgclIntsQrdBzs3D.this.dTol2 < dist2[pair]) {
                return false;
            }
            switch (pair) {
                case 0: {
                    if (dist2[0] > dist2[2] || dist2[0] > dist2[3]) {
                        return false;
                    }
                    l1p = this.p1;
                    l2p = l2.p1;
                    break;
                }
                case 1: {
                    if (dist2[1] > dist2[2] || dist2[1] > dist2[3]) {
                        return false;
                    }
                    l1p = this.p2;
                    l2p = l2.p2;
                    break;
                }
                case 2: {
                    if (dist2[2] > dist2[0] || dist2[2] > dist2[1]) {
                        return false;
                    }
                    l1p = this.p2;
                    l2p = l2.p1;
                    break;
                }
                case 3: {
                    if (dist2[3] > dist2[0] || dist2[3] > dist2[1]) {
                        return false;
                    }
                    l1p = this.p1;
                    l2p = l2.p2;
                    break;
                }
            }
            if (Math.abs(l1p.Aupara - l2p.Aupara) > l1p.AuPTol + l2p.AuPTol) {
                return false;
            }
            if (Math.abs(l1p.Avpara - l2p.Avpara) > l1p.AvPTol + l2p.AvPTol) {
                return false;
            }
            if (Math.abs(l1p.Bupara - l2p.Bupara) > l1p.BuPTol + l2p.BuPTol) {
                return false;
            }
            if (Math.abs(l1p.Bvpara - l2p.Bvpara) > l1p.BvPTol + l2p.BvPTol) {
                return false;
            }
            if ((JgclIntsQrdBzs3D.this.debugFlag & 4) != 0) {
                System.out.println("isSamePoint: true");
            }
            return true;
        }

        boolean isSameLineseg(LineSegmentInfo l2) {
            double[] dist2 = new double[4];
            boolean[] is_same = new boolean[4];
            if (!this.is_main_line) {
                return false;
            }
            if (this.box.max().x() + JgclIntsQrdBzs3D.this.dTol < l2.box.min().x() || this.box.max().y() + JgclIntsQrdBzs3D.this.dTol < l2.box.min().y() || this.box.max().z() + JgclIntsQrdBzs3D.this.dTol < l2.box.min().z() || l2.box.max().x() + JgclIntsQrdBzs3D.this.dTol < this.box.min().x() || l2.box.max().y() + JgclIntsQrdBzs3D.this.dTol < this.box.min().y() || l2.box.max().z() + JgclIntsQrdBzs3D.this.dTol < this.box.min().z()) {
                return false;
            }
            if ((JgclIntsQrdBzs3D.this.debugFlag & 8) != 0) {
                System.out.println("isSameLineseg1:");
                this.p1.pnt.literal().output(System.out);
                this.p2.pnt.literal().output(System.out);
                l2.p1.pnt.literal().output(System.out);
                l2.p2.pnt.literal().output(System.out);
            }
            dist2[0] = this.p1.pnt.distance2(l2.p1.pnt);
            dist2[1] = this.p2.pnt.distance2(l2.p2.pnt);
            dist2[2] = this.p2.pnt.distance2(l2.p1.pnt);
            dist2[3] = this.p1.pnt.distance2(l2.p2.pnt);
            if ((JgclIntsQrdBzs3D.this.debugFlag & 8) != 0) {
                System.out.println(String.valueOf(dist2[0]) + " " + dist2[1] + " " + dist2[2] + " " + dist2[3]);
            }
            int is_on_cnt = 0;
            is_same[0] = this.isSamePoint(l2, dist2, 0);
            if (is_same[0]) {
                ++is_on_cnt;
            }
            is_same[1] = this.isSamePoint(l2, dist2, 1);
            if (is_same[1] && ++is_on_cnt == 2) {
                return this.assignSameLineseg(l2, true);
            }
            is_same[2] = this.isSamePoint(l2, dist2, 2);
            if (is_same[2] && ++is_on_cnt == 2) {
                return this.assignSameLineseg(l2, true);
            }
            is_same[3] = this.isSamePoint(l2, dist2, 3);
            if (is_same[3] && ++is_on_cnt == 2) {
                return this.assignSameLineseg(l2, true);
            }
            if ((JgclIntsQrdBzs3D.this.debugFlag & 8) != 0) {
                System.out.println("isSameLineseg2:");
            }
            boolean check_is_on = false;
            if (is_same[0]) {
                if (l2.isPointOnLineseg(this.p2) || this.isPointOnLineseg(l2.p2)) {
                    return this.assignSameLineseg(l2, false);
                }
                check_is_on = true;
            } else if (is_same[1]) {
                if (l2.isPointOnLineseg(this.p1) || this.isPointOnLineseg(l2.p1)) {
                    return this.assignSameLineseg(l2, false);
                }
                check_is_on = true;
            } else if (is_same[2]) {
                if (l2.isPointOnLineseg(this.p1) || this.isPointOnLineseg(l2.p2)) {
                    return this.assignSameLineseg(l2, false);
                }
                check_is_on = true;
            } else if (is_same[3]) {
                if (l2.isPointOnLineseg(this.p2) || this.isPointOnLineseg(l2.p1)) {
                    return this.assignSameLineseg(l2, false);
                }
                check_is_on = true;
            }
            if ((JgclIntsQrdBzs3D.this.debugFlag & 8) != 0) {
                System.out.println("isSameLineseg3:");
            }
            if (!check_is_on) {
                is_on_cnt = 0;
                is_on_cnt += l2.isPointOnLineseg(this.p1) ? 1 : 0;
                is_on_cnt += l2.isPointOnLineseg(this.p2) ? 1 : 0;
                is_on_cnt += this.isPointOnLineseg(l2.p1) ? 1 : 0;
                if ((is_on_cnt += this.isPointOnLineseg(l2.p2) ? 1 : 0) > 1) {
                    return this.assignSameLineseg(l2, false);
                }
            }
            if ((JgclIntsQrdBzs3D.this.debugFlag & 8) != 0) {
                System.out.println("isSameLineseg4:");
            }
            return false;
        }
    }

    final class PlaneBezier {
        JgclAxis2Placement3D axis;
        JgclPureBezierCurve3D[] boundaryCurves;
        boolean[] boundaryCurveIsLine;
        int edgeCount;
        int[] shapeInfo;

        PlaneBezier(JgclPureBezierSurface3D bzs) {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
            int u_uicp = bzs.uNControlPoints();
            int v_uicp = bzs.vNControlPoints();
            boolean retrying = false;
            JgclVector3D udir = null;
            JgclVector3D vdir = null;
            this.shapeInfo = new int[4];
            this.boundaryCurveIsLine = new boolean[4];
            this.boundaryCurves = new JgclPureBezierCurve3D[4];
            JgclPoint3D c00 = bzs.controlPointAt(0, 0);
            JgclPoint3D c10 = bzs.controlPointAt(u_uicp - 1, 0);
            JgclPoint3D c01 = bzs.controlPointAt(0, v_uicp - 1);
            JgclPoint3D c11 = bzs.controlPointAt(u_uicp - 1, v_uicp - 1);
            JgclVector3D u0dir = c10.subtract(c00);
            JgclVector3D v1dir = c11.subtract(c10);
            JgclVector3D u1dir = c01.subtract(c11);
            JgclVector3D v0dir = c00.subtract(c01);
            double u0norm = u0dir.norm();
            int iu0dir = u0norm > JgclIntsQrdBzs3D.this.dTol2 ? 1 : 0;
            double v0norm = v0dir.norm();
            int iv0dir = v0norm > JgclIntsQrdBzs3D.this.dTol2 ? 1 : 0;
            double u1norm = u1dir.norm();
            int iu1dir = u1norm > JgclIntsQrdBzs3D.this.dTol2 ? 1 : 0;
            double v1norm = v1dir.norm();
            int iv1dir = v1norm > JgclIntsQrdBzs3D.this.dTol2 ? 1 : 0;
            this.edgeCount = iu0dir + iv0dir + iu1dir + iv1dir;
            this.shapeInfo[0] = iu0dir;
            this.shapeInfo[3] = iv0dir;
            this.shapeInfo[2] = iu1dir;
            this.shapeInfo[1] = iv1dir;
            switch (this.edgeCount) {
                case 4: {
                    udir = u0dir;
                    vdir = v0dir;
                    break;
                }
                case 3: {
                    if (iu0dir == 0) {
                        udir = v1dir.multiply(-1.0);
                        vdir = v0dir;
                        break;
                    }
                    if (iv0dir == 0) {
                        udir = u0dir;
                        vdir = u1dir.multiply(-1.0);
                        break;
                    }
                    udir = u0dir;
                    vdir = v0dir;
                    break;
                }
                case 2: {
                    vdir = null;
                    udir = null;
                    if (iu0dir == 1) {
                        udir = bzs.controlPointAt(1, 0).subtract(bzs.controlPointAt(0, 0));
                    }
                    if (iv0dir == 1) {
                        if (udir == null) {
                            udir = bzs.controlPointAt(0, 1).subtract(bzs.controlPointAt(0, 0));
                        } else {
                            vdir = bzs.controlPointAt(0, 1).subtract(bzs.controlPointAt(0, 0));
                            break;
                        }
                    }
                    if (iu1dir == 1) {
                        if (udir == null) {
                            udir = bzs.controlPointAt(u_uicp - 2, v_uicp - 1).subtract(bzs.controlPointAt(u_uicp - 1, v_uicp - 1));
                            break;
                        }
                        if (iu0dir == 1) {
                            vdir = bzs.controlPointAt(1, v_uicp - 1).subtract(bzs.controlPointAt(0, v_uicp - 1));
                            break;
                        }
                        vdir = bzs.controlPointAt(u_uicp - 2, v_uicp - 1).subtract(bzs.controlPointAt(u_uicp - 1, v_uicp - 1));
                        break;
                    }
                    if (iv0dir == 1) {
                        vdir = bzs.controlPointAt(u_uicp - 1, 1).subtract(bzs.controlPointAt(u_uicp - 1, 0));
                        break;
                    }
                    vdir = bzs.controlPointAt(u_uicp - 1, v_uicp - 2).subtract(bzs.controlPointAt(u_uicp - 1, v_uicp - 1));
                    break;
                }
                default: {
                    if (retrying) {
                        return;
                    }
                    retrying = true;
                    u0dir = bzs.controlPointAt(1, 0).subtract(bzs.controlPointAt(0, 0));
                    v0dir = bzs.controlPointAt(0, 1).subtract(bzs.controlPointAt(0, 0));
                    u1dir = bzs.controlPointAt(u_uicp - 2, v_uicp - 1).subtract(bzs.controlPointAt(u_uicp - 1, v_uicp - 1));
                    v1dir = bzs.controlPointAt(u_uicp - 1, v_uicp - 2).subtract(bzs.controlPointAt(u_uicp - 1, v_uicp - 1));
                    break;
                }
            }
            udir = udir.unitized();
            vdir = vdir.unitized();
            this.axis = new JgclAxis2Placement3D(c00, udir.crossProduct(vdir), udir);
        }

        JgclPoint3D origin() {
            return this.axis.location();
        }

        JgclVector3D zaxis() {
            return this.axis.z();
        }
    }

    private final class BezierInfo {
        private JgclPureBezierSurface3D bzs;
        private JgclPureBezierSurface3D root;
        private double u_sp;
        private double u_ep;
        private double v_sp;
        private double v_ep;
        private JgclEnclosingBox3D box;
        PlaneBezier pb;
        int crnt_type;
        TriangleInfo[] tri;

        void output() {
            System.out.println("BezierInfo: min = ");
            this.box.min().literal().output(System.out);
            System.out.println("BezierInfo: max = ");
            this.box.max().literal().output(System.out);
            System.out.println("BezierInfo: (" + this.u_sp + ", " + this.u_ep + "), (" + this.v_sp + ", " + this.v_ep + ")");
        }

        private BezierInfo(JgclPureBezierSurface3D root, JgclPureBezierSurface3D bzs, double u_sp, double u_ep, double v_sp, double v_ep) {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
            this.root = root;
            this.bzs = bzs;
            this.u_sp = u_sp;
            this.u_ep = u_ep;
            this.v_sp = v_sp;
            this.v_ep = v_ep;
            this.box = bzs.approximateEnclosingBox();
            this.crnt_type = JgclIntsQrdBzs3D.access$0();
            this.pb = null;
            this.tri = null;
        }

        int whatTypeIsBezierCurve(JgclPureBezierCurve3D bzc) {
            int uicp = bzc.nControlPoints();
            JgclVector3D s2e = bzc.controlPointAt(uicp - 1).subtract(bzc.controlPointAt(0));
            double norm_s2e = s2e.norm();
            double leng_s2e = Math.sqrt(norm_s2e);
            if (norm_s2e < JgclIntsQrdBzs3D.this.dTol2) {
                int i = 1;
                while (i < uicp - 1) {
                    JgclVector3D s2c = bzc.controlPointAt(i).subtract(bzc.controlPointAt(0));
                    if (!(s2c.norm() < JgclIntsQrdBzs3D.this.dTol2)) break;
                    ++i;
                }
                if (i == uicp - 1) {
                    return JgclIntsQrdBzs3D.access$1();
                }
                return JgclIntsQrdBzs3D.access$2();
            }
            JgclVector3D unit_s2e = s2e.divide(Math.sqrt(norm_s2e));
            int i = 1;
            while (i < uicp - 1) {
                JgclVector3D s2c = bzc.controlPointAt(i).subtract(bzc.controlPointAt(0));
                JgclVector3D crsv = unit_s2e.crossProduct(s2c);
                if (crsv.norm() > JgclIntsQrdBzs3D.this.dTol2) {
                    return JgclIntsQrdBzs3D.access$2();
                }
                double leng = unit_s2e.dotProduct(s2c);
                if (leng < 0.0 - JgclIntsQrdBzs3D.this.dTol || leng > leng_s2e + JgclIntsQrdBzs3D.this.dTol) {
                    return JgclIntsQrdBzs3D.access$2();
                }
                ++i;
            }
            return JgclIntsQrdBzs3D.access$3();
        }

        int whatTypeIsBezier() {
            int i;
            PlaneBezier pb;
            if (this.crnt_type != JgclIntsQrdBzs3D.access$0()) {
                return this.crnt_type;
            }
            int u_uicp = this.bzs.uNControlPoints();
            int v_uicp = this.bzs.vNControlPoints();
            this.crnt_type = JgclIntsQrdBzs3D.access$2();
            if (this.u_ep - this.u_sp > 0.5 || this.v_ep - this.v_sp > 0.5) {
                return this.crnt_type;
            }
            this.pb = pb = new PlaneBezier(this.bzs);
            JgclPoint3D org = pb.origin();
            JgclVector3D zaxis = pb.zaxis();
            int j = 0;
            while (j < v_uicp) {
                i = 0;
                while (i < u_uicp) {
                    JgclVector3D evec = this.bzs.controlPointAt(i, j).subtract(org);
                    if (Math.abs(evec.dotProduct(zaxis)) > JgclIntsQrdBzs3D.this.dTol) {
                        return this.crnt_type;
                    }
                    ++i;
                }
                ++j;
            }
            this.crnt_type = JgclIntsQrdBzs3D.access$1();
            i = 0;
            while (i < 4) {
                if (pb.shapeInfo[i] == 0) {
                    pb.boundaryCurves[i] = null;
                } else {
                    if (this.crnt_type == JgclIntsQrdBzs3D.access$1()) {
                        this.crnt_type = JgclIntsQrdBzs3D.access$4();
                    }
                    pb.boundaryCurves[i] = this.bzs.getBoundaryCurve(i);
                    int type = this.whatTypeIsBezierCurve(pb.boundaryCurves[i]);
                    if (type == JgclIntsQrdBzs3D.access$3()) {
                        pb.boundaryCurveIsLine[i] = true;
                    } else {
                        pb.boundaryCurveIsLine[i] = false;
                        this.crnt_type = JgclIntsQrdBzs3D.access$5();
                    }
                }
                ++i;
            }
            return this.crnt_type;
        }
    }

    final class PointList {
        int no = 2;
        Vector list = new Vector();
        double leng2;

        PointList(CLInfo cl) {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
            this.list.addElement(cl.ps);
            this.list.addElement(cl.pe);
            this.leng2 = cl.leng2;
        }

        PointInfo first() {
            return (PointInfo)this.list.elementAt(0);
        }

        PointInfo last() {
            return (PointInfo)this.list.lastElement();
        }

        PointInfo first(int n) {
            return (PointInfo)this.list.elementAt(n);
        }

        PointInfo last(int n) {
            int size = this.list.size();
            return (PointInfo)this.list.elementAt(size - 1 - n);
        }

        void prepend(PointInfo p, double leng2) {
            this.list.insertElementAt(p, 0);
            this.leng2 += leng2;
            ++this.no;
        }

        void append(PointInfo p, double leng2) {
            this.list.addElement(p);
            this.leng2 += leng2;
            ++this.no;
        }

        void removeFirst() {
            this.list.removeElementAt(0);
            --this.no;
        }

        void removeLast() {
            int size = this.list.size();
            this.list.removeElementAt(size - 1);
            --this.no;
        }

        void connect(PointList pl, boolean front, boolean rev) {
            int i;
            this.no += pl.no - 1;
            this.leng2 += pl.leng2;
            Vector olist = this.list;
            if (front) {
                this.list = new Vector();
            }
            if (rev) {
                i = pl.list.size() - 1;
                while (i >= 0) {
                    this.list.addElement(pl.list.elementAt(i));
                    --i;
                }
            } else {
                i = 0;
                while (i < pl.list.size() - 1) {
                    this.list.addElement(pl.list.elementAt(i));
                    ++i;
                }
            }
            if (front) {
                i = 0;
                while (i < olist.size()) {
                    this.list.addElement(olist.elementAt(i));
                    ++i;
                }
            }
        }

        boolean is_closed() {
            if (this.no <= 3) {
                return false;
            }
            if (this.leng2 < JgclIntsQrdBzs3D.this.dTol2) {
                return false;
            }
            PointInfo pspnt = (PointInfo)this.list.firstElement();
            PointInfo pepnt = (PointInfo)this.list.lastElement();
            double upara_gap = pspnt.Aupara - pepnt.Aupara;
            double vpara_gap = pspnt.Avpara - pepnt.Avpara;
            double Apara_gap = upara_gap * upara_gap + vpara_gap * vpara_gap;
            double AuPTol = (pspnt.AuPTol + pepnt.AuPTol) / 2.0;
            double AvPTol = (pspnt.AvPTol + pepnt.AvPTol) / 2.0;
            double pTol2 = AuPTol * AuPTol + AvPTol * AvPTol;
            if (Apara_gap > pTol2) {
                return false;
            }
            upara_gap = pspnt.Bupara - pepnt.Bupara;
            vpara_gap = pspnt.Bvpara - pepnt.Bvpara;
            double Bpara_gap = upara_gap * upara_gap + vpara_gap * vpara_gap;
            double BuPTol = (pspnt.BuPTol + pepnt.BuPTol) / 2.0;
            double BvPTol = (pspnt.BvPTol + pepnt.BvPTol) / 2.0;
            pTol2 = BuPTol * BuPTol + BvPTol * BvPTol;
            if (Bpara_gap > pTol2) {
                return false;
            }
            if (pspnt.pnt.distance2(pepnt.pnt) > JgclIntsQrdBzs3D.this.dTol2) {
                return false;
            }
            if ((JgclIntsQrdBzs3D.this.debugFlag & 0x10) != 0) {
                System.out.println("closed:");
            }
            return true;
        }
    }

    final class CLInfo {
        PointInfo p1;
        PointInfo p2;
        PointInfo ps;
        PointInfo pe;
        int dir;
        int cpnt;
        boolean found;
        boolean is_consistent;
        double leng2;
        GapInfo gi;
        boolean severe_retry_criterion;

        void output() {
            System.out.println("CLInfo: primary");
            this.p1.pnt.literal().output(System.out);
            this.p2.pnt.literal().output(System.out);
            System.out.println("CLInfo: total");
            this.ps.pnt.literal().output(System.out);
            this.pe.pnt.literal().output(System.out);
        }

        CLInfo() {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
        }
    }

    final class BoundaryInfo {
        int wend;
        int param;
        boolean is_boundary;
        PointInfo pi;

        void setBoundaryInfo(double gap) {
            int i = 1;
            while (i < 5) {
                int j = 0;
                while (j < 2) {
                    double g = this.pi.getBoundaryGap(i, j);
                    if (g < gap && this.param != i) {
                        gap = g;
                        this.param = i;
                        this.wend = j;
                    }
                    ++j;
                }
                ++i;
            }
        }

        BoundaryInfo(int ref_param, PointInfo pi) {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
            this.param = ref_param;
            this.is_boundary = true;
            this.pi = pi;
            this.setBoundaryInfo(JgclIntsQrdBzs3D.this.pTol);
        }

        void adjust() {
            switch (this.param) {
                case 1: {
                    this.pi.Aupara = this.wend == 0 ? 0.0 : 1.0;
                    break;
                }
                case 2: {
                    this.pi.Avpara = this.wend == 0 ? 0.0 : 1.0;
                    break;
                }
                case 3: {
                    this.pi.Bupara = this.wend == 0 ? 0.0 : 1.0;
                    break;
                }
                case 4: {
                    this.pi.Bvpara = this.wend == 0 ? 0.0 : 1.0;
                    break;
                }
                default: {
                    this.is_boundary = false;
                }
            }
        }
    }

    final class NListInfo {
        int plist_open_side;
        double nlist_dist2;
        PointList nlist;
        int nlist_connect_side;

        NListInfo() {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
        }
    }

    final class MListInfo {
        int mlist_no = 0;
        PointList list;

        MListInfo() {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
        }
    }

    final class GapInfo {
        boolean gap_rev;
        double gap;
        double gap_Au;
        double gap_Av;
        double gap_Bu;
        double gap_Bv;
        PointInfo gap_pi1;
        PointInfo gap_pi2;
        double dist2;

        GapInfo() {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
        }
    }

    final class RefineInfo {
        JgclPoint3D sA_pnt;
        JgclPoint3D sB_pnt;
        JgclVector3D[] Atang;
        JgclVector3D[] Btang;
        double fx_param;
        BoundaryInfo bi;

        RefineInfo() {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
        }

        double[] setupParams(PointInfo pi) {
            double[] param = new double[3];
            if ((JgclIntsQrdBzs3D.this.debugFlag & 0x20) != 0) {
                System.out.println("setupParams: " + this.bi.param);
            }
            switch (this.bi.param) {
                case 1: {
                    this.fx_param = pi.Aupara;
                    param[0] = pi.Avpara;
                    param[1] = pi.Bupara;
                    param[2] = pi.Bvpara;
                    break;
                }
                case 2: {
                    param[0] = pi.Aupara;
                    this.fx_param = pi.Avpara;
                    param[1] = pi.Bupara;
                    param[2] = pi.Bvpara;
                    break;
                }
                case 3: {
                    param[0] = pi.Aupara;
                    param[1] = pi.Avpara;
                    this.fx_param = pi.Bupara;
                    param[2] = pi.Bvpara;
                    break;
                }
                case 4: {
                    param[0] = pi.Aupara;
                    param[1] = pi.Avpara;
                    param[2] = pi.Bupara;
                    this.fx_param = pi.Bvpara;
                    break;
                }
            }
            return param;
        }

        void fillParam(double[] param) {
            double[] A = new double[2];
            double[] B = new double[2];
            switch (this.bi.param) {
                case 1: {
                    A[0] = this.fx_param;
                    A[1] = param[0];
                    B[0] = param[1];
                    B[1] = param[2];
                    break;
                }
                case 2: {
                    A[0] = param[0];
                    A[1] = this.fx_param;
                    B[0] = param[1];
                    B[1] = param[2];
                    break;
                }
                case 3: {
                    A[0] = param[0];
                    A[1] = param[1];
                    B[0] = this.fx_param;
                    B[1] = param[2];
                    break;
                }
                case 4: {
                    A[0] = param[0];
                    A[1] = param[1];
                    B[0] = param[2];
                    B[1] = this.fx_param;
                    break;
                }
            }
            A[0] = JgclIntsQrdBzs3D.this.dA.uParameterDomain().force(A[0]);
            A[1] = JgclIntsQrdBzs3D.this.dA.vParameterDomain().force(A[1]);
            B[0] = JgclIntsQrdBzs3D.this.dB.uParameterDomain().force(B[0]);
            B[1] = JgclIntsQrdBzs3D.this.dB.vParameterDomain().force(B[1]);
            this.sA_pnt = JgclIntsQrdBzs3D.this.dA.coordinates(A[0], A[1]);
            this.sB_pnt = JgclIntsQrdBzs3D.this.dB.coordinates(B[0], B[1]);
            this.Atang = JgclIntsQrdBzs3D.this.dA.tangentVector(A[0], A[1]);
            this.Btang = JgclIntsQrdBzs3D.this.dB.tangentVector(B[0], B[1]);
            this.Btang[0] = this.Btang[0].multiply(-1.0);
            this.Btang[1] = this.Btang[1].multiply(-1.0);
        }

        JgclVector3D[] getVectors() {
            JgclVector3D[] vecs = null;
            switch (this.bi.param) {
                case 1: {
                    JgclVector3D[] v;
                    vecs = v = new JgclVector3D[]{this.Atang[1], this.Btang[0], this.Btang[1]};
                    break;
                }
                case 2: {
                    JgclVector3D[] v = new JgclVector3D[]{this.Atang[0], this.Btang[0], this.Btang[1]};
                    vecs = v;
                    break;
                }
                case 3: {
                    JgclVector3D[] v = new JgclVector3D[]{this.Atang[0], this.Atang[1], this.Btang[1]};
                    vecs = v;
                    break;
                }
                case 4: {
                    JgclVector3D[] v = new JgclVector3D[]{this.Atang[0], this.Atang[1], this.Btang[0]};
                    vecs = v;
                    break;
                }
            }
            return vecs;
        }
    }

    private class nlFunc
    implements JgclRealFunction {
        private nlFunc() {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
        }

        public double[] evaluate(double[] parameter) {
            double[] vctr = new double[3];
            JgclVector3D evec = JgclIntsQrdBzs3D.this.ri.sA_pnt.subtract(JgclIntsQrdBzs3D.this.ri.sB_pnt);
            vctr[0] = evec.x();
            vctr[1] = evec.y();
            vctr[2] = evec.z();
            return vctr;
        }
    }

    private class dnlFunc
    implements JgclRealFunction {
        int idx;

        private dnlFunc(int idx) {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
            this.idx = idx;
        }

        public double[] evaluate(double[] parameter) {
            JgclVector3D[] vecs = JgclIntsQrdBzs3D.this.ri.getVectors();
            double[] mtrx = new double[3];
            int i = 0;
            while (i < 3) {
                switch (this.idx) {
                    default: {
                        mtrx[i] = vecs[i].x();
                        break;
                    }
                    case 1: {
                        mtrx[i] = vecs[i].y();
                        break;
                    }
                    case 2: {
                        mtrx[i] = vecs[i].z();
                        break;
                    }
                }
                ++i;
            }
            return mtrx;
        }
    }

    private class cnvFunc
    implements JgclBooleanFunctionWithRealVariables {
        private cnvFunc() {
            JgclIntsQrdBzs3D.this = JgclIntsQrdBzs3D.this;
        }

        public boolean evaluate(double[] parameter) {
            JgclIntsQrdBzs3D.this.ri.fillParam(parameter);
            return JgclIntsQrdBzs3D.this.ri.sA_pnt.identical(JgclIntsQrdBzs3D.this.ri.sB_pnt);
        }
    }
}

