/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclVector3D;

class JgclLoftSurface3D {
    private final JgclBsplineCurve3D basisCurve;
    private final JgclVector3D axisVector;
    private final double length;

    JgclLoftSurface3D(JgclBsplineCurve3D basisCurve, JgclVector3D axisVector, double length) {
        this.basisCurve = basisCurve;
        this.axisVector = axisVector;
        this.length = length;
    }

    JgclBsplineSurface3D getSurface() {
        JgclVector3D moveVector = this.axisVector.unitized().multiply(this.length);
        int uNControlPoints = 2;
        int vNControlPoints = this.basisCurve.nControlPoints();
        JgclPoint3D[][] controlPoints = new JgclPoint3D[uNControlPoints][vNControlPoints];
        int j = 0;
        while (j < vNControlPoints) {
            controlPoints[0][j] = this.basisCurve.controlPointAt(j);
            controlPoints[1][j] = controlPoints[0][j].add(moveVector);
            ++j;
        }
        double[][] weights = null;
        if (this.basisCurve.isRational()) {
            weights = new double[uNControlPoints][vNControlPoints];
            int j2 = 0;
            while (j2 < vNControlPoints) {
                double d = this.basisCurve.weightAt(j2);
                weights[1][j2] = d;
                weights[0][j2] = d;
                ++j2;
            }
        }
        int uDegree = 1;
        double[] uKnots = new double[]{0.0, this.length};
        int[] uKnotMulti = new int[2];
        uKnotMulti[1] = 2;
        uKnotMulti[0] = 2;
        JgclBsplineKnot uKnotData = new JgclBsplineKnot(uDegree, 1, false, uKnotMulti, uKnots, uNControlPoints);
        return new JgclBsplineSurface3D(uKnotData, this.basisCurve.knotData(), controlPoints, weights);
    }
}

