/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBooleanFunctionWithRealVariables;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclMatrix;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclRealFunction;
import jp.go.ipa.jgcl.JgclRealFunctionWithOneVariable;
import jp.go.ipa.jgcl.JgclRealPolynomial;

public class JgclMath {
    static final double PI2 = Math.PI * 2;
    private static final int maxNumberOfDividing = 608;
    private static final int powerNumber = 6;
    private static final double minimumTolerance = 1.0E-32;
    private static final double zeroDividePoint = 0.0;
    private static final double zeroWeight = 1.5707963267948966;
    private static final double[] minusDividePoints = new double[608];
    private static final double[] plusDividePoints = new double[608];
    private static final double[] weights = new double[608];
    private static boolean alreadyPrepared;
    private static double[] pascal01;
    private static double[] pascal02;
    private static double[] pascal03;
    private static double[] pascal04;
    private static double[] pascal05;
    private static double[] pascal06;
    private static double[] pascal07;
    private static double[] pascal08;
    private static double[] pascal09;
    private static double[] pascal10;
    private static double[] pascal11;
    private static double[][] predefPascal;
    private static double[] lastPredefPascal;

    private JgclMath() {
    }

    private static void prepareDefiniteIntegralConstants() {
        if (alreadyPrepared) {
            return;
        }
        alreadyPrepared = true;
        double almostOne = 0.9999999999999999;
        double halfPi = 1.5707963267948966;
        double eeh = Math.exp(1.0 / Math.pow(2.0, 7.0));
        double een = 1.0;
        int i = 0;
        while (i < 608) {
            double eenI = 1.0 / (een *= eeh);
            double esh = (een - eenI) / 2.0;
            double ech = (een + eenI) / 2.0;
            double exs = Math.exp(halfPi * esh);
            double exsI = 1.0 / exs;
            double echsi = 2.0 / (exs + exsI);
            JgclMath.plusDividePoints[i] = (exs - exsI) / 2.0 * echsi;
            if (plusDividePoints[i] >= almostOne) {
                JgclMath.plusDividePoints[i] = almostOne;
            }
            JgclMath.minusDividePoints[i] = -plusDividePoints[i];
            JgclMath.weights[i] = halfPi * ech * Math.pow(echsi, 2.0);
            ++i;
        }
    }

    public static double getDefiniteIntegral(JgclRealFunctionWithOneVariable func, JgclParameterSection parameterSection, double tolerance) {
        int startIndex;
        JgclMath.prepareDefiniteIntegralConstants();
        tolerance = Math.abs(tolerance) > 1.0E-32 ? Math.abs(tolerance) : 1.0E-32;
        double iterationTol = 0.2 * Math.sqrt(tolerance);
        double halfDiff = (parameterSection.upper() - parameterSection.lower()) / 2.0;
        double midParam = (parameterSection.upper() + parameterSection.lower()) / 2.0;
        double meshSize = 0.5;
        int indexInterval = startIndex = (int)Math.pow(2.0, 6.0);
        int minusCutoffNumber = 0;
        int plusCutoffNumber = 0;
        int minusCutoffFlag = 0;
        int plusCutoffFlag = 0;
        double currentIntegral = func.evaluate(0.0 * halfDiff + midParam) * 1.5707963267948966;
        int i = startIndex - 1;
        while (i < 608) {
            if (minusCutoffFlag < 2) {
                double minusCutoff = func.evaluate(minusDividePoints[i] * halfDiff + midParam) * weights[i];
                currentIntegral += minusCutoff;
                if (Math.abs(minusCutoff) <= tolerance) {
                    if (++minusCutoffFlag >= 2) {
                        minusCutoffNumber = i + 1 - indexInterval;
                    }
                } else {
                    minusCutoffFlag = 0;
                }
            }
            if (plusCutoffFlag < 2) {
                double plusCutoff = func.evaluate(plusDividePoints[i] * halfDiff + midParam) * weights[i];
                currentIntegral += plusCutoff;
                if (Math.abs(plusCutoff) <= tolerance) {
                    if (++plusCutoffFlag >= 2) {
                        plusCutoffNumber = i + 1 - indexInterval;
                    }
                } else {
                    plusCutoffFlag = 0;
                }
            }
            if (minusCutoffFlag == 2 && plusCutoffFlag == 2) break;
            i += indexInterval;
        }
        if (minusCutoffNumber == 0) {
            minusCutoffNumber = 608;
        }
        if (plusCutoffNumber == 0) {
            plusCutoffNumber = 608;
        }
        double lastIntegral = meshSize * halfDiff * currentIntegral;
        int commonCutoffNumber = minusCutoffNumber < plusCutoffNumber ? minusCutoffNumber : plusCutoffNumber;
        i = 0;
        while (i < 6) {
            currentIntegral = 0.0;
            indexInterval = startIndex;
            int j = (startIndex /= 2) - 1;
            while (j < commonCutoffNumber) {
                currentIntegral += (func.evaluate(minusDividePoints[j] * halfDiff + midParam) + func.evaluate(plusDividePoints[j] * halfDiff + midParam)) * weights[j];
                j += indexInterval;
            }
            if (minusCutoffNumber > commonCutoffNumber) {
                j = commonCutoffNumber + indexInterval - 1;
                while (j < minusCutoffNumber) {
                    currentIntegral += func.evaluate(minusDividePoints[j] * halfDiff + midParam) * weights[j];
                    j += indexInterval;
                }
            }
            if (plusCutoffNumber > commonCutoffNumber) {
                j = commonCutoffNumber + indexInterval - 1;
                while (j < plusCutoffNumber) {
                    currentIntegral += func.evaluate(plusDividePoints[j] * halfDiff + midParam) * weights[j];
                    j += indexInterval;
                }
            }
            if (Math.abs((currentIntegral = (lastIntegral + meshSize * halfDiff * currentIntegral) / 2.0) - lastIntegral) < iterationTol) {
                return currentIntegral;
            }
            meshSize /= 2.0;
            lastIntegral = currentIntegral;
            ++i;
        }
        return currentIntegral;
    }

    public static double maxOf3(double a, double b, double c) {
        return Math.max(Math.max(a, b), c);
    }

    public static double midOf3(double a, double b, double c) {
        if (b > a) {
            if (c > b) {
                return b;
            }
            if (a > c) {
                return a;
            }
            return c;
        }
        if (c > a) {
            return a;
        }
        if (b > c) {
            return b;
        }
        return c;
    }

    public static double minOf3(double a, double b, double c) {
        return Math.min(Math.min(a, b), c);
    }

    public static double copySign(double a, double b) {
        a = Math.abs(a);
        return b < 0.0 ? -a : a;
    }

    public static int GCD(int a, int b) {
        while (b != 0) {
            int c = a % b;
            a = b;
            b = c;
        }
        return a;
    }

    public static int LCM(int a, int b) {
        int c = JgclMath.GCD(a, b);
        if (c == 0) {
            return 0;
        }
        if (a > b) {
            return a / c * b;
        }
        return b / c * a;
    }

    public static double cosh(double p) {
        return (Math.exp(p) + Math.exp(-p)) / 2.0;
    }

    public static double sinh(double p) {
        return (Math.exp(p) - Math.exp(-p)) / 2.0;
    }

    public static double atanh(double p) {
        return Math.log(1.0 + 2.0 * p / (1.0 - p)) / 2.0;
    }

    public static double asinh(double p) {
        if (p > 0.0) {
            return Math.log(Math.abs(p) + Math.sqrt(p * p + 1.0));
        }
        return -Math.log(Math.abs(p) + Math.sqrt(p * p + 1.0));
    }

    public static double[] solveSimultaneousEquations(JgclRealFunction func, JgclRealFunction[] derivatives, JgclBooleanFunctionWithRealVariables convergence, double[] initialGuesses) {
        return JgclMath.solveSimultaneousEquationsWithCorrection(func, derivatives, convergence, null, initialGuesses);
    }

    public static double[] solveSimultaneousEquationsWithCorrection(JgclRealFunction func, JgclRealFunction[] derivatives, JgclBooleanFunctionWithRealVariables convergence, JgclRealFunction correct, double[] initialGuesses) {
        int nX = initialGuesses.length;
        double[] X = (double[])initialGuesses.clone();
        double[][] dF = new double[nX][];
        int maxIteration = 50;
        if (convergence.evaluate(X)) {
            return X;
        }
        int i = 0;
        while (i < maxIteration) {
            double[] F = func.evaluate(X);
            if (F == null) {
                return null;
            }
            int j = 0;
            while (j < nX) {
                dF[j] = derivatives[j].evaluate(X);
                if (dF[j] == null) {
                    return null;
                }
                ++j;
            }
            double[] delta = new JgclMatrix(dF).solveSimultaneousLinearEquations(F);
            if (delta == null) {
                return null;
            }
            int j2 = 0;
            while (j2 < nX) {
                int n = j2;
                X[n] = X[n] - delta[j2];
                ++j2;
            }
            if (correct != null) {
                X = correct.evaluate(X);
            }
            if (convergence.evaluate(X)) {
                return X;
            }
            ++i;
        }
        return null;
    }

    public static double[] pascalTriangle(int n) {
        if (n <= 0) {
            return predefPascal[0];
        }
        if (n < predefPascal.length) {
            return predefPascal[n];
        }
        double[] pascal = new double[n];
        int i = 0;
        while (i < lastPredefPascal.length) {
            pascal[i] = lastPredefPascal[i];
            ++i;
        }
        int i2 = lastPredefPascal.length;
        while (i2 < n) {
            pascal[i2] = 1.0;
            int j = i2 - 1;
            while (j > 0) {
                pascal[j] = pascal[j - 1] + pascal[j];
                --j;
            }
            ++i2;
        }
        return pascal;
    }

    public static double normalizeAngle(double angle) {
        double eangle = angle;
        while (eangle < 0.0) {
            eangle += Math.PI * 2;
        }
        while (eangle > Math.PI * 2) {
            eangle -= Math.PI * 2;
        }
        return eangle;
    }

    private static void debugGetDefiniteIntegral(String[] argv) {
        try {
            double[] coef = new double[argv.length - 1];
            int i = 0;
            while (i < argv.length - 1) {
                coef[i] = Double.valueOf(argv[i]);
                ++i;
            }
            JgclRealPolynomial poly = new JgclRealPolynomial(coef);
            JgclParameterSection param = new JgclParameterSection(0.0, 1.0);
            double result = JgclMath.getDefiniteIntegral(poly, param, Double.valueOf(argv[argv.length - 1]));
            System.out.println("result : " + result);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {}
    }

    public static void main(String[] argv) {
        JgclMath.debugGetDefiniteIntegral(argv);
    }

    static {
        pascal01 = new double[]{1.0};
        pascal02 = new double[]{1.0, 1.0};
        pascal03 = new double[]{1.0, 2.0, 1.0};
        pascal04 = new double[]{1.0, 3.0, 3.0, 1.0};
        pascal05 = new double[]{1.0, 4.0, 6.0, 4.0, 1.0};
        pascal06 = new double[]{1.0, 5.0, 10.0, 10.0, 5.0, 1.0};
        pascal07 = new double[]{1.0, 6.0, 15.0, 20.0, 15.0, 6.0, 1.0};
        pascal08 = new double[]{1.0, 7.0, 21.0, 35.0, 35.0, 21.0, 7.0, 1.0};
        pascal09 = new double[]{1.0, 8.0, 28.0, 56.0, 70.0, 56.0, 28.0, 8.0, 1.0};
        pascal10 = new double[]{1.0, 9.0, 36.0, 84.0, 126.0, 126.0, 84.0, 36.0, 9.0, 1.0};
        pascal11 = new double[]{1.0, 10.0, 45.0, 120.0, 210.0, 252.0, 210.0, 120.0, 45.0, 10.0, 1.0};
        predefPascal = new double[][]{null, pascal01, pascal02, pascal03, pascal04, pascal05, pascal06, pascal07, pascal08, pascal09, pascal10, pascal11};
        lastPredefPascal = pascal11;
    }
}

