/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclCylindricalSurface3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint1D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnPoint1D;
import jp.go.ipa.jgcl.JgclPointOnPoint2D;
import jp.go.ipa.jgcl.JgclPointOnPoint3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclPackageTest {
    private void resultPrint(boolean result) {
        if (result) {
            System.out.println("OK.");
        } else {
            System.out.println("NG.");
        }
    }

    public JgclPoint1D coordinatesPointOnPoint1D(JgclPointOnPoint1D point) {
        return point.coordinates();
    }

    public void test2_2_59to60(JgclPoint2D point) {
        JgclPoint2D orig = point;
        System.out.print("// Test 2.2.59 : ");
        JgclPoint3D p1 = orig.to3D();
        JgclPoint3D p2 = orig.to3D(0.0);
        JgclPoint3D p3 = orig.to3D(100.0);
        this.resultPrint(p1 instanceof JgclPoint3D && p2 instanceof JgclPoint3D && p3 instanceof JgclPoint3D && orig.x() == p1.x() && orig.x() == p2.x() && orig.x() == p3.x() && orig.y() == p1.y() && orig.y() == p2.y() && orig.y() == p3.y() && p1.z() == 0.0 && p2.z() == 0.0 && p3.z() == 100.0);
        System.out.print("// Test 2.2.60 : ");
        this.resultPrint(orig.literal() instanceof JgclCartesianPoint2D);
    }

    public JgclPoint2D coordinatesPointOnPoint2D(JgclPointOnPoint2D point) {
        return point.coordinates();
    }

    public JgclPoint2D coordinatesPointOnCurve2D(JgclPointOnCurve2D point) {
        return point.coordinates();
    }

    public JgclPoint2D[] intersectionPoint2DCreateTestNormal() {
        JgclLine2D[] line = new JgclLine2D[2];
        JgclPointOnCurve2D[] pocs = new JgclPointOnCurve2D[2];
        JgclPoint2D[] points = new JgclIntersectionPoint2D[5];
        JgclCartesianPoint2D coord = JgclPoint2D.of(1.0, 2.0);
        line[0] = new JgclLine2D((JgclPoint2D)JgclPoint2D.of(0.0, 2.0), JgclVector2D.of(1.0, 0.0));
        line[1] = new JgclLine2D((JgclPoint2D)JgclPoint2D.of(1.0, 0.0), JgclVector2D.of(0.0, 1.0));
        pocs[0] = new JgclPointOnCurve2D(line[0], 1.0);
        pocs[1] = new JgclPointOnCurve2D(line[1], 2.0);
        points[0] = new JgclIntersectionPoint2D(coord, pocs[0], pocs[1], true);
        points[2] = new JgclIntersectionPoint2D(pocs[0], pocs[1], true);
        points[3] = new JgclIntersectionPoint2D(coord, line[0], 1.0, line[1], 2.0, true);
        points[4] = new JgclIntersectionPoint2D(line[0], 1.0, line[1], 2.0, true);
        coord = JgclPoint2D.of(100.0, 100.0);
        pocs[0] = new JgclPointOnCurve2D(new JgclCircle2D(JgclPoint2D.of(0.0, 100.0), 100.0), 0.0);
        pocs[1] = new JgclPointOnCurve2D(new JgclCircle2D(JgclPoint2D.of(90.0, 100.0), 10.0), 0.0);
        points[1] = new JgclIntersectionPoint2D(coord, pocs[0], pocs[1], true);
        return points;
    }

    public boolean intersectionPoint2DCreateTestError() {
        JgclIntersectionPoint2D point;
        JgclLine2D[] line = new JgclLine2D[2];
        JgclPointOnCurve2D[] pocs = new JgclPointOnCurve2D[2];
        JgclIntersectionPoint2D[] points = new JgclIntersectionPoint2D[5];
        JgclCartesianPoint2D coord = JgclPoint2D.of(1.0, 2.0);
        line[0] = new JgclLine2D((JgclPoint2D)JgclPoint2D.of(0.0, 2.0), JgclVector2D.of(1.0, 0.0));
        line[1] = new JgclLine2D((JgclPoint2D)JgclPoint2D.of(1.0, 0.0), JgclVector2D.of(0.0, 1.0));
        pocs[0] = new JgclPointOnCurve2D(line[0], 1.0);
        pocs[1] = new JgclPointOnCurve2D(line[1], 2.0);
        boolean flag = true;
        coord = new JgclCartesianPoint2D(2.0, 3.0);
        try {
            point = new JgclIntersectionPoint2D(coord, pocs[0], pocs[1], true);
            flag &= false;
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            flag &= true;
        }
        double tol = coord.getToleranceForDistance();
        coord = new JgclCartesianPoint2D(1.0 + tol * 2.0, 2.0);
        try {
            point = new JgclIntersectionPoint2D(coord, pocs[0], pocs[1], true);
            flag &= false;
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            flag &= true;
        }
        try {
            point = new JgclIntersectionPoint2D(null, pocs[0], pocs[1], true);
            flag &= false;
        }
        catch (NullPointerException nullPointerException) {
            flag &= true;
        }
        coord = new JgclCartesianPoint2D(1.0, 2.0);
        try {
            point = new JgclIntersectionPoint2D(coord, null, pocs[1], true);
            flag &= false;
        }
        catch (NullPointerException nullPointerException) {
            flag &= true;
        }
        try {
            point = new JgclIntersectionPoint2D(coord, pocs[0], null, true);
            flag &= false;
        }
        catch (NullPointerException nullPointerException) {
            flag &= true;
        }
        return flag;
    }

    private void test2_3_57(JgclPoint3D point) {
        JgclAxis2Placement3D axis = new JgclAxis2Placement3D(JgclPoint3D.origin, JgclVector3D.zUnitVector, JgclVector3D.xUnitVector);
        JgclCartesianTransformationOperator3D trans = new JgclCartesianTransformationOperator3D(axis, 1.0);
        System.out.print("// Test 2.2.57 : ");
        this.resultPrint(point.rotateZ(trans, 0.0, 1.0).identical(JgclPoint3D.of(-2.0, 1.0, 3.0)));
        System.out.println();
    }

    private void test2_3_58(JgclPoint3D point) {
        System.out.print("// Test 2.2.58 : ");
        JgclPoint2D p1 = point.to2D();
        JgclPoint2D p2 = point.to2D();
        this.resultPrint(p1 instanceof JgclPoint2D && p2 instanceof JgclPoint2D && point.x() == p1.x() && point.x() == p2.x() && point.y() == p1.y() && point.y() == p2.y());
    }

    private void test2_3_59(JgclPoint3D point) {
        System.out.print("// Test 2.2.59 : ");
        this.resultPrint(point.literal() instanceof JgclCartesianPoint3D);
    }

    public void test2_3_57to59(JgclPoint3D point) {
        this.test2_3_57(point);
        this.test2_3_58(point);
        this.test2_3_59(point);
    }

    public JgclPoint3D coordinatesPointOnPoint3D(JgclPointOnPoint3D point) {
        return point.coordinates();
    }

    public JgclPoint3D coordinatesPointOnCurve3D(JgclPointOnCurve3D point) {
        return point.coordinates();
    }

    public JgclPoint3D coordinatesPointOnSurface3D(JgclPointOnSurface3D point) {
        return point.coordinates();
    }

    public static JgclPoint3D[] intersectionPoint3DCreateTestNormal() {
        JgclLine3D[] line = new JgclLine3D[2];
        JgclPointOnCurve3D[] pocs = new JgclPointOnCurve3D[2];
        JgclPoint3D[] points = new JgclIntersectionPoint3D[11];
        JgclCartesianPoint3D coord = JgclPoint3D.of(1.0, 2.0, 3.0);
        line[0] = new JgclLine3D((JgclPoint3D)JgclPoint3D.of(0.0, 2.0, 3.0), JgclVector3D.of(1.0, 0.0, 0.0));
        line[1] = new JgclLine3D((JgclPoint3D)JgclPoint3D.of(1.0, 0.0, 3.0), JgclVector3D.of(0.0, 1.0, 0.0));
        pocs[0] = new JgclPointOnCurve3D(line[0], 1.0);
        pocs[1] = new JgclPointOnCurve3D(line[1], 2.0);
        points[0] = new JgclIntersectionPoint3D(coord, pocs[0], pocs[1], true);
        System.out.println("//\t [case 1: geometry vs geometry, coordinates]");
        System.out.println("//\t points[0] = ");
        points[0].output(System.out);
        points[2] = new JgclIntersectionPoint3D(pocs[0], pocs[1], true);
        System.out.println("//\t [case 2: geometry vs geometry, no coordinates]");
        System.out.println("//\t points[2] = ");
        points[2].output(System.out);
        points[3] = new JgclIntersectionPoint3D(coord, line[0], 1.0, (JgclParametricCurve3D)line[1], 2.0, true);
        System.out.println("//\t [case 3: line vs line, coordinates]");
        System.out.println("//\t points[3] = ");
        points[3].output(System.out);
        points[4] = new JgclIntersectionPoint3D(line[0], 1.0, line[1], 2.0, true);
        System.out.println("//\t [case 4: line vs line, no coordinates]");
        System.out.println("//\t points[4] = ");
        points[4].output(System.out);
        JgclPlane3D plane = new JgclPlane3D(JgclPoint3D.origin, JgclVector3D.xUnitVector);
        coord = JgclPoint3D.of(0.0, 2.0, 3.0);
        points[5] = new JgclIntersectionPoint3D((JgclPoint3D)coord, line[0], 0.0, (JgclParametricSurface3D)plane, 3.0, -2.0, true);
        System.out.println("//\t [case 5: line vs surface, coordinates]");
        System.out.println("//\t points[5] = ");
        points[5].output(System.out);
        points[6] = new JgclIntersectionPoint3D(line[0], 0.0, plane, 3.0, -2.0, true);
        System.out.println("//\t [case 6: line vs surface, no coordinates]");
        System.out.println("//\t points[6] = ");
        points[6].output(System.out);
        points[7] = new JgclIntersectionPoint3D((JgclPoint3D)coord, plane, 3.0, -2.0, line[0], 0.0, true);
        System.out.println("//\t [case 7: surface vs line, coordinates]");
        System.out.println("//\t points[7] = ");
        points[7].output(System.out);
        points[8] = new JgclIntersectionPoint3D(plane, 3.0, -2.0, (JgclParametricCurve3D)line[0], 0.0, true);
        System.out.println("//\t [case 8: surface vs line, no coordinates]");
        System.out.println("//\t points[8] = ");
        points[8].output(System.out);
        JgclPlane3D plane2 = new JgclPlane3D(JgclPoint3D.origin, JgclVector3D.yUnitVector);
        points[9] = new JgclIntersectionPoint3D(JgclPoint3D.origin, plane, 0.0, 0.0, plane2, 0.0, 0.0, true);
        System.out.println("//\t [case 9: surface vs surface, coordinates]");
        System.out.println("//\t points[9] = ");
        points[9].output(System.out);
        points[10] = new JgclIntersectionPoint3D(plane, 0.0, 0.0, (JgclParametricSurface3D)plane2, 0.0, 0.0, true);
        System.out.println("//\t [case 10: surface vs surface, no coordinates]");
        System.out.println("//\t points[10] = ");
        points[10].output(System.out);
        JgclCircle3D circle1 = new JgclCircle3D(new JgclAxis2Placement3D(JgclPoint3D.of(0.0, 100.0, 100.0), JgclVector3D.zUnitVector, JgclVector3D.xUnitVector), 100.0);
        JgclCircle3D circle2 = new JgclCircle3D(new JgclAxis2Placement3D(JgclPoint3D.of(90.0, 100.0, 100.0), JgclVector3D.zUnitVector, JgclVector3D.xUnitVector), 10.0);
        pocs[0] = new JgclPointOnCurve3D(circle1, 0.0);
        pocs[1] = new JgclPointOnCurve3D(circle2, 0.0);
        points[1] = new JgclIntersectionPoint3D(JgclPoint3D.of(100.0, 100.0, 100.0), pocs[0], pocs[1], true);
        return points;
    }

    public static boolean intersectionPoint3DCreateTestError() {
        JgclIntersectionPoint3D point;
        JgclLine3D[] line = new JgclLine3D[2];
        JgclPointOnCurve3D[] pocs = new JgclPointOnCurve3D[2];
        JgclCartesianPoint3D coord = JgclPoint3D.of(1.0, 2.0, 3.0);
        line[0] = new JgclLine3D((JgclPoint3D)JgclPoint3D.of(0.0, 2.0, 3.0), JgclVector3D.of(1.0, 0.0, 0.0));
        line[1] = new JgclLine3D((JgclPoint3D)JgclPoint3D.of(1.0, 0.0, 3.0), JgclVector3D.of(0.0, 1.0, 0.0));
        pocs[0] = new JgclPointOnCurve3D(line[0], 1.0);
        pocs[1] = new JgclPointOnCurve3D(line[1], 2.0);
        boolean flag = true;
        coord = new JgclCartesianPoint3D(2.0, 3.0, 3.0);
        try {
            point = new JgclIntersectionPoint3D(coord, pocs[0], pocs[1], true);
            flag &= false;
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            flag &= true;
        }
        double tol = coord.getToleranceForDistance();
        coord = new JgclCartesianPoint3D(1.0 + tol * 2.0, 2.0, 3.0);
        try {
            point = new JgclIntersectionPoint3D(coord, pocs[0], pocs[1], true);
            flag &= false;
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            flag &= true;
        }
        try {
            point = new JgclIntersectionPoint3D(null, pocs[0], pocs[1], true);
            flag &= false;
        }
        catch (NullPointerException nullPointerException) {
            flag &= true;
        }
        coord = new JgclCartesianPoint3D(1.0, 2.0, 3.0);
        try {
            point = new JgclIntersectionPoint3D(coord, null, pocs[1], true);
            flag &= false;
        }
        catch (NullPointerException nullPointerException) {
            flag &= true;
        }
        try {
            point = new JgclIntersectionPoint3D(coord, pocs[0], null, true);
            flag &= false;
        }
        catch (NullPointerException nullPointerException) {
            flag &= true;
        }
        return flag;
    }

    public int type(JgclParametricSurface3D surface) {
        return surface.type();
    }

    public void cylinderTest() {
        JgclCylindricalSurface3D cylA = new JgclCylindricalSurface3D(JgclPoint3D.origin, JgclVector3D.zUnitVector, 1.0);
        JgclCylindricalSurface3D cylB = new JgclCylindricalSurface3D(JgclPoint3D.origin, JgclVector3D.xUnitVector, 2.0);
        System.out.print("// Test 5.1.57.1 : ");
        this.resultPrint(cylA.equals(cylA) && !cylA.equals(cylB));
        System.out.print("// Test 5.1.57.2 : ");
        this.resultPrint(JgclPoint3D.origin.isOn(cylA.getAxis()) && cylA.getAxis().dir().identicalDirection(JgclVector3D.zUnitVector));
    }

    public void coneTest() {
        JgclConicalSurface3D cone = new JgclConicalSurface3D(JgclPoint3D.of(0.0, 0.0, 1.0), JgclVector3D.zUnitVector, 1.0, 0.7853981633974483);
        System.out.print("// Test 5.1.58.1 : ");
        this.resultPrint(cone.apex().identical(JgclPoint3D.origin));
        System.out.print("// Test 5.1.58.2 : ");
        this.resultPrint(JgclPoint3D.of(0.0, 0.0, 1.0).isOn(cone.getAxis()) && cone.getAxis().dir().identicalDirection(JgclVector3D.zUnitVector));
    }
}

