/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclBoundedCurve3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclCompositeCurve3D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCurveBoundedSurface3D;
import jp.go.ipa.jgcl.JgclCurveCurvature3D;
import jp.go.ipa.jgcl.JgclCurveDerivative3D;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclHyperbola3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclMachineEpsilon;
import jp.go.ipa.jgcl.JgclParabola3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclRectangularTrimmedSurface3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector3D;

public abstract class JgclParametricCurve3D
extends JgclParametricCurve {
    static final int LINE_3D = 1;
    static final int BOUNDED_LINE_3D = 2;
    static final int CIRCLE_3D = 10;
    static final int ELLIPSE_3D = 11;
    static final int HYPERBOLA_3D = 12;
    static final int PARABOLA_3D = 13;
    static final int POLYLINE_3D = 20;
    static final int BSPLINE_CURVE_3D = 21;
    static final int PURE_BEZIER_CURVE_3D = 22;
    static final int TRIMMED_CURVE_3D = 23;
    static final int COMPOSITE_CURVE_3D = 24;
    static final int COMPOSITE_CURVE_SEGMENT_3D = 25;
    static final int SURFACE_CURVE_3D = 26;
    static final int INTERSECTION_CURVE_3D = 27;
    static final int POLYNOMIAL_CURVE_3D = 30;

    protected JgclParametricCurve3D() {
    }

    public abstract JgclPoint3D coordinates(double var1);

    public abstract JgclVector3D tangentVector(double var1);

    public abstract JgclCurveCurvature3D curvature(double var1);

    public abstract double torsion(double var1);

    public abstract JgclCurveDerivative3D evaluation(double var1);

    public abstract JgclPointOnCurve3D[] singular() throws JgclIndefiniteSolution;

    public abstract JgclPointOnCurve3D[] inflexion() throws JgclIndefiniteSolution;

    protected JgclPointOnCurve3D checkProjection(double Bparam, JgclPoint3D p, double dTol2) {
        JgclCurveCurvature3D Bcurv;
        double norm_from_Bnrml;
        Object result = null;
        if (!this.isValid(Bparam)) {
            return null;
        }
        JgclPoint3D Bpnt = this.coordinates(Bparam);
        JgclVector3D Bpnt2A = p.subtract(Bpnt);
        double norm = Bpnt2A.norm();
        if (norm > dTol2 && (norm_from_Bnrml = Bpnt2A.crossProduct((Bcurv = this.curvature(Bparam)).normal()).norm()) > dTol2) {
            return null;
        }
        try {
            return new JgclPointOnCurve3D(Bpnt, this, Bparam, false);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean identicalParameter(double own_prm1, double own_prm2) {
        boolean bl;
        block9: {
            boolean bl2;
            block8: {
                boolean bl3;
                block7: {
                    boolean bl4;
                    block6: {
                        this.checkValidity(own_prm1);
                        this.checkValidity(own_prm2);
                        JgclPoint3D o1_crd = this.coordinates(own_prm1);
                        JgclPoint3D o2_crd = this.coordinates(own_prm2);
                        if (!o1_crd.identical(o2_crd)) {
                            return false;
                        }
                        JgclParameterDomain pdmn = this.parameterDomain();
                        double increase = 0.0;
                        double pTol = pdmn.isInfinite() ? JgclMachineEpsilon.DOUBLE : ((increase = Math.abs(pdmn.section().increase())) < 1.0 ? JgclMachineEpsilon.DOUBLE * increase : JgclMachineEpsilon.DOUBLE);
                        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
                        double savedPTol = condition.getToleranceForParameter();
                        condition.makeCopyWithToleranceForParameter(pTol).push();
                        try {
                            JgclParameterSection pint = own_prm1 > own_prm2 ? new JgclParameterSection(own_prm2, own_prm1 - own_prm2) : new JgclParameterSection(own_prm1, own_prm2 - own_prm1);
                            double leng = this.length(pint);
                            double dTol = condition.getToleranceForDistance();
                            if (leng < dTol) {
                                bl4 = true;
                                Object var20_17 = null;
                                break block6;
                            }
                            if (!pdmn.isPeriodic()) {
                                bl3 = false;
                                break block7;
                            }
                            double start = own_prm1 > own_prm2 ? own_prm1 : own_prm2;
                            pint = new JgclParameterSection(start, increase -= pint.increase());
                            leng = this.length(pint);
                            if (leng < dTol) {
                                bl2 = true;
                                break block8;
                            }
                            bl = false;
                            break block9;
                        }
                        catch (Throwable throwable) {
                            Object var20_21 = null;
                            JgclConditionOfOperation.pop();
                            throw throwable;
                        }
                    }
                    JgclConditionOfOperation.pop();
                    return bl4;
                }
                Object var20_18 = null;
                JgclConditionOfOperation.pop();
                return bl3;
            }
            Object var20_19 = null;
            JgclConditionOfOperation.pop();
            return bl2;
        }
        Object var20_20 = null;
        JgclConditionOfOperation.pop();
        return bl;
    }

    public abstract JgclPointOnCurve3D[] projectFrom(JgclPoint3D var1) throws JgclIndefiniteSolution;

    public abstract JgclPolyline3D toPolyline(JgclParameterSection var1, JgclToleranceForDistance var2);

    public abstract JgclBsplineCurve3D toBsplineCurve(JgclParameterSection var1);

    public abstract JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D var1) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint3D[] intersect(JgclLine3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint3D[] intersect(JgclCircle3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint3D[] intersect(JgclEllipse3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint3D[] intersect(JgclHyperbola3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint3D[] intersect(JgclParabola3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint3D[] intersect(JgclPolyline3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D var1, boolean var2) throws JgclIndefiniteSolution;

    public abstract JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D var1) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D var1, boolean var2) throws JgclIndefiniteSolution;

    JgclIntersectionPoint3D[] intersect(JgclCurveBoundedSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclRectangularTrimmedSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return mate.intersect(this, !doExchange);
    }

    public abstract JgclParametricCurve3D parallelTranslate(JgclVector3D var1);

    public int dimension() {
        return 3;
    }

    public boolean is3D() {
        return true;
    }

    abstract int type();

    abstract JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D var1, double var2, double var4);

    abstract JgclPoint3D getPointNotOnLine(JgclLine3D var1);

    public JgclPointOnCurve3D nearestProjectFrom(JgclPoint3D pnt) {
        JgclPointOnCurve3D[] proj;
        try {
            proj = this.projectFrom(pnt);
        }
        catch (JgclIndefiniteSolution e) {
            proj = new JgclPointOnCurve3D[]{(JgclPointOnCurve3D)e.suitable()};
        }
        if (proj.length == 0) {
            return null;
        }
        double dist = proj[0].distance2(pnt);
        int idx = 0;
        int i = 1;
        while (i < proj.length) {
            double dist2 = proj[i].distance2(pnt);
            if (dist2 < dist) {
                dist = dist2;
                idx = i;
            }
            ++i;
        }
        return proj[idx];
    }

    public JgclPointOnCurve3D nearestProjectWithDistanceFrom(JgclPoint3D pnt, double distance) {
        JgclPointOnCurve3D[] proj;
        try {
            proj = this.projectFrom(pnt);
        }
        catch (JgclIndefiniteSolution e) {
            proj = new JgclPointOnCurve3D[]{(JgclPointOnCurve3D)e.suitable()};
        }
        if (proj.length == 0) {
            return null;
        }
        double diff = Math.abs(distance - proj[0].distance(pnt));
        int idx = 0;
        int i = 1;
        while (i < proj.length) {
            double diff2 = Math.abs(distance - proj[i].distance(pnt));
            if (diff2 < diff) {
                diff = diff2;
                idx = i;
            }
            ++i;
        }
        return proj[idx];
    }

    public double pointToParameter(JgclPoint3D pnt) {
        JgclPointOnCurve3D proj = this.nearestProjectFrom(pnt);
        if (proj != null && pnt.identical(proj)) {
            return proj.parameter();
        }
        if (this.isFinite() && this.isOpen()) {
            double param = this.parameterDomain().section().lower();
            if (pnt.identical(new JgclPointOnCurve3D(this, param))) {
                return param;
            }
            param = this.parameterDomain().section().upper();
            if (pnt.identical(new JgclPointOnCurve3D(this, param))) {
                return param;
            }
        }
        if (this.hasPolyline()) {
            JgclBoundedCurve3D bounded = (JgclBoundedCurve3D)this;
            JgclPolyline3D polyline = bounded.toPolyline(this.getToleranceForDistanceAsObject());
            int i = 0;
            while (i < polyline.nPoints()) {
                JgclPointOnCurve3D pos = (JgclPointOnCurve3D)polyline.pointAt(i);
                if (pnt.identical(pos)) {
                    return pos.parameter();
                }
                ++i;
            }
        }
        throw new JgclInvalidArgumentValue();
    }

    int parameterValidity(double param) {
        JgclParameterDomain pDomain = this.parameterDomain();
        if (pDomain.isInfinite() || pDomain.isPeriodic()) {
            return 0;
        }
        double lower = pDomain.section().lower();
        double upper = pDomain.section().upper();
        double deltaDenom = 100.0;
        double delta = (upper - lower) / deltaDenom;
        double tol4Norm = this.getToleranceForDistance2();
        double tangentNorm = 0.0;
        if (param < lower) {
            double endParam = lower;
            while (endParam < upper) {
                JgclVector3D tangentVector = this.tangentVector(endParam);
                tangentNorm = tangentVector.norm();
                if (tangentNorm > tol4Norm) break;
                endParam += delta;
            }
            if (!(tangentNorm > tol4Norm)) {
                return 3;
            }
            double tol4Param = this.getToleranceForDistance() / Math.sqrt(tangentNorm);
            if (lower - param < tol4Param) {
                return 1;
            }
            return 3;
        }
        if (upper < param) {
            double endParam = upper;
            while (endParam > lower) {
                JgclVector3D tangentVector = this.tangentVector(endParam);
                tangentNorm = tangentVector.norm();
                if (tangentNorm > tol4Norm) break;
                endParam -= delta;
            }
            if (!(tangentNorm > tol4Norm)) {
                return 3;
            }
            double tol4Param = this.getToleranceForDistance() / Math.sqrt(tangentNorm);
            if (param - upper < tol4Param) {
                return 2;
            }
            return 3;
        }
        return 0;
    }

    protected abstract JgclParametricCurve3D doTransformBy(boolean var1, JgclCartesianTransformationOperator3D var2, Hashtable var3);

    public synchronized JgclParametricCurve3D transformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        if (transformedGeometries == null) {
            return this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        JgclParametricCurve3D transformed = (JgclParametricCurve3D)transformedGeometries.get(this);
        if (transformed == null) {
            transformed = this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
            transformedGeometries.put(this, transformed);
        }
        return transformed;
    }

    public synchronized JgclParametricCurve3D transformBy(JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(false, transformationOperator, transformedGeometries);
    }

    public synchronized JgclParametricCurve3D reverseTransformBy(JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(true, transformationOperator, transformedGeometries);
    }

    protected boolean hasPolyline() {
        return false;
    }

    protected boolean isComposedOfOnlyPolylines() {
        return false;
    }
}

