/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterRangeOnCurve3D;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnGeometry3D;

public class JgclPointOnCurve3D
extends JgclPointOnGeometry3D
implements JgclParameterRangeOnCurve3D {
    private JgclParametricCurve3D basisCurve;
    private double parameter;

    JgclPointOnCurve3D(JgclParametricCurve3D basisCurve, double parameter, boolean doCheck) {
        this(null, basisCurve, parameter, doCheck);
    }

    JgclPointOnCurve3D(JgclPoint3D point, JgclParametricCurve3D basisCurve, double parameter, boolean doCheck) {
        super(point);
        if (doCheck) {
            JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
            double pTol = condition.getToleranceForParameter();
            if (basisCurve == null) {
                throw new JgclInvalidArgumentValue();
            }
            basisCurve.checkValidity(parameter);
            if (point != null && !point.identical(basisCurve.coordinates(parameter))) {
                throw new JgclInvalidArgumentValue();
            }
        }
        this.basisCurve = basisCurve;
        this.parameter = parameter;
    }

    public JgclPointOnCurve3D(JgclParametricCurve3D basisCurve, double parameter) {
        this(null, basisCurve, parameter);
    }

    public JgclPointOnCurve3D(JgclPoint3D point, JgclParametricCurve3D basisCurve, double parameter) {
        this(point, basisCurve, parameter, true);
    }

    public JgclGeometry geometry() {
        return this.basisCurve();
    }

    public JgclParametricCurve3D basisCurve() {
        return this.basisCurve;
    }

    public double parameter() {
        return this.parameter;
    }

    JgclPoint3D coordinates() {
        JgclPoint3D coord;
        try {
            coord = this.basisCurve.coordinates(this.parameter);
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        return coord;
    }

    public boolean isPoint() {
        return true;
    }

    public boolean isSection() {
        return false;
    }

    boolean parametricallyIdentical(JgclPointOnCurve3D mate) {
        if (this.basisCurve() != mate.basisCurve()) {
            return false;
        }
        if (!this.identical(mate)) {
            return false;
        }
        return this.basisCurve().identicalParameter(this.parameter(), mate.parameter());
    }

    protected synchronized JgclPoint3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint3D tPoint = this.point();
        if (tPoint != null) {
            tPoint = tPoint.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        JgclParametricCurve3D tBasisCurve = this.basisCurve.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclPointOnCurve3D(tPoint, tBasisCurve, this.parameter, false);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tpoint");
        this.coordinates().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tbasisCurve");
        this.basisCurve.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tparameter\t" + this.parameter);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

