/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnGeometry3D;

public class JgclPointOnSurface3D
extends JgclPointOnGeometry3D {
    private JgclParametricSurface3D basisSurface;
    private double uParameter;
    private double vParameter;

    JgclPointOnSurface3D(JgclParametricSurface3D basisSurface, double uParameter, double vParameter, boolean doCheck) {
        this(null, basisSurface, uParameter, vParameter, doCheck);
    }

    JgclPointOnSurface3D(JgclPoint3D point, JgclParametricSurface3D basisSurface, double uParameter, double vParameter, boolean doCheck) {
        super(point);
        if (doCheck) {
            JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
            double pTol = condition.getToleranceForParameter();
            if (basisSurface == null) {
                throw new JgclInvalidArgumentValue();
            }
            if (basisSurface.type() != 33) {
                basisSurface.checkUValidity(uParameter);
                basisSurface.checkVValidity(vParameter);
            }
            if (point != null && !point.identical(basisSurface.coordinates(uParameter, vParameter))) {
                throw new JgclInvalidArgumentValue();
            }
        }
        this.basisSurface = basisSurface;
        this.uParameter = uParameter;
        this.vParameter = vParameter;
    }

    public JgclPointOnSurface3D(JgclParametricSurface3D basisSurface, double uParameter, double vParameter) {
        this(null, basisSurface, uParameter, vParameter);
    }

    JgclPointOnSurface3D(JgclParametricSurface3D basisSurface, JgclPoint2D pairOfParameters, boolean doCheck) {
        this(null, basisSurface, pairOfParameters.x(), pairOfParameters.y(), doCheck);
    }

    public JgclPointOnSurface3D(JgclParametricSurface3D basisSurface, JgclPoint2D pairOfParameters) {
        this(null, basisSurface, pairOfParameters.x(), pairOfParameters.y());
    }

    public JgclPointOnSurface3D(JgclPoint3D point, JgclParametricSurface3D basisSurface, double uParameter, double vParameter) {
        this(point, basisSurface, uParameter, vParameter, true);
    }

    public JgclGeometry geometry() {
        return this.basisSurface();
    }

    public JgclParametricSurface3D basisSurface() {
        return this.basisSurface;
    }

    public double uParameter() {
        return this.uParameter;
    }

    public double vParameter() {
        return this.vParameter;
    }

    public double[] parameters() {
        double[] param = new double[]{this.uParameter, this.vParameter};
        return param;
    }

    JgclPoint3D coordinates() {
        JgclPoint3D coord;
        try {
            coord = this.basisSurface.coordinates(this.uParameter, this.vParameter);
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        return coord;
    }

    protected synchronized JgclPoint3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint3D tPoint = this.point();
        if (tPoint != null) {
            tPoint = tPoint.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        JgclParametricSurface3D tBasisSurface = this.basisSurface.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclPointOnSurface3D(tPoint, tBasisSurface, this.uParameter, this.vParameter, false);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tpoint");
        this.coordinates().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tbasisSurface");
        this.basisSurface.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tuParameter\t" + this.uParameter);
        writer.println(String.valueOf(indent_tab) + "\tvParameter\t" + this.vParameter);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

