/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclFreeformSurfaceWithGivenControlPointsArray2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPureBezierCurveEvaluation;
import jp.go.ipa.jgcl.JgclVector2D;

class JgclPureBezierSurfaceWithGivenControlPointsArray2D
extends JgclFreeformSurfaceWithGivenControlPointsArray2D {
    JgclPureBezierSurfaceWithGivenControlPointsArray2D(double[][][] cpArray) {
        super(cpArray);
    }

    public int uDegree() {
        return this.uNControlPoints() - 1;
    }

    public int vDegree() {
        return this.vNControlPoints() - 1;
    }

    public JgclPoint2D coordinates(double uParam, double vParam) {
        boolean isPoly = this.isPolynomial();
        uParam = this.checkUParameter(uParam);
        vParam = this.checkVParameter(vParam);
        double[][][] cntlPnts = this.toDoubleArray();
        int uUicp = cntlPnts.length;
        int vUicp = cntlPnts[0].length;
        double[][] bzc = new double[uUicp][];
        int i = 0;
        while (i < uUicp) {
            bzc[i] = JgclPureBezierCurveEvaluation.coordinates(cntlPnts[i], vParam);
            ++i;
        }
        double[] d0D = JgclPureBezierCurveEvaluation.coordinates(bzc, uParam);
        if (!isPoly) {
            this.convRational0Deriv(d0D);
        }
        return new JgclCartesianPoint2D(d0D);
    }

    public JgclVector2D[] tangentVector(double uParam, double vParam) {
        double[][] ld1D = new double[2][];
        JgclVector2D[] d1D = new JgclVector2D[2];
        boolean isPoly = this.isPolynomial();
        uParam = this.checkUParameter(uParam);
        vParam = this.checkVParameter(vParam);
        double[][][] cntlPnts = this.toDoubleArray();
        int uUicp = cntlPnts.length;
        int vUicp = cntlPnts[0].length;
        double[][] pp = new double[uUicp][3];
        double[][] tt = new double[uUicp][3];
        int i = 0;
        while (i < uUicp) {
            JgclPureBezierCurveEvaluation.evaluation(cntlPnts[i], vParam, pp[i], tt[i], null, null);
            ++i;
        }
        ld1D[0] = new double[3];
        if (isPoly) {
            JgclPureBezierCurveEvaluation.evaluation(pp, uParam, null, ld1D[0], null, null);
            ld1D[1] = JgclPureBezierCurveEvaluation.coordinates(tt, uParam);
        } else {
            double[] ld0D = new double[3];
            JgclPureBezierCurveEvaluation.evaluation(pp, uParam, ld0D, ld1D[0], null, null);
            ld1D[1] = JgclPureBezierCurveEvaluation.coordinates(tt, uParam);
            this.convRational1Deriv(ld0D, ld1D[0], ld1D[1]);
        }
        int i2 = 0;
        while (i2 < 2) {
            d1D[i2] = new JgclLiteralVector2D(ld1D[i2]);
            ++i2;
        }
        return d1D;
    }

    double[][][][] allocateIntermediateDoubleArrayForDividing() {
        boolean isPoly = this.isPolynomial();
        int uUicp = this.uNControlPoints();
        int vUicp = this.vNControlPoints();
        double[][][][] bzss_array = new double[2][][][];
        int i = 0;
        while (i < 2) {
            bzss_array[i] = JgclFreeformSurfaceWithGivenControlPointsArray2D.allocateDoubleArray(isPoly, uUicp, vUicp);
            ++i;
        }
        return bzss_array;
    }

    public JgclPureBezierSurfaceWithGivenControlPointsArray2D[] uDivide(double uParam) {
        return this.uDivide(uParam, this.allocateIntermediateDoubleArrayForDividing());
    }

    JgclPureBezierSurfaceWithGivenControlPointsArray2D[] uDivide(double uParam, double[][][][] bzssArray) {
        int uUicp = this.uNControlPoints();
        int vUicp = this.vNControlPoints();
        uParam = this.checkUParameter(uParam);
        double[][][] cntlPnts = this.toDoubleArray();
        double[][] bzc = new double[uUicp][];
        double[][][] bzcsArray = new double[2][uUicp][];
        int i = 0;
        while (i < vUicp) {
            int j = 0;
            while (j < uUicp) {
                bzc[j] = cntlPnts[j][i];
                bzcsArray[0][j] = bzssArray[0][j][i];
                bzcsArray[1][j] = bzssArray[1][j][i];
                ++j;
            }
            try {
                JgclPureBezierCurveEvaluation.divide(bzc, uParam, bzcsArray);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        JgclPureBezierSurfaceWithGivenControlPointsArray2D[] bzss = new JgclPureBezierSurfaceWithGivenControlPointsArray2D[2];
        i = 0;
        while (i < 2) {
            try {
                bzss[i] = new JgclPureBezierSurfaceWithGivenControlPointsArray2D(bzssArray[i]);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return bzss;
    }

    public JgclPureBezierSurfaceWithGivenControlPointsArray2D[] vDivide(double vParam) {
        return this.vDivide(vParam, this.allocateIntermediateDoubleArrayForDividing());
    }

    JgclPureBezierSurfaceWithGivenControlPointsArray2D[] vDivide(double vParam, double[][][][] bzssArray) {
        int uUicp = this.uNControlPoints();
        int vUicp = this.vNControlPoints();
        vParam = this.checkVParameter(vParam);
        double[][][] cntlPnts = this.toDoubleArray();
        double[][][] bzcsArray = new double[2][][];
        int i = 0;
        while (i < uUicp) {
            bzcsArray[0] = bzssArray[0][i];
            bzcsArray[1] = bzssArray[1][i];
            try {
                JgclPureBezierCurveEvaluation.divide(cntlPnts[i], vParam, bzcsArray);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        JgclPureBezierSurfaceWithGivenControlPointsArray2D[] bzss = new JgclPureBezierSurfaceWithGivenControlPointsArray2D[2];
        i = 0;
        while (i < 2) {
            try {
                bzss[i] = new JgclPureBezierSurfaceWithGivenControlPointsArray2D(bzssArray[i]);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return bzss;
    }

    JgclParameterDomain getUParameterDomain() {
        try {
            return new JgclParameterDomain(false, 0.0, 1.0);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    JgclParameterDomain getVParameterDomain() {
        try {
            return new JgclParameterDomain(false, 0.0, 1.0);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    private double checkUParameter(double param) {
        this.checkUValidity(param);
        return this.uParameterDomain().force(param);
    }

    private double checkVParameter(double param) {
        this.checkVValidity(param);
        return this.vParameterDomain().force(param);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tuNControlPoints\t" + this.uNControlPoints());
        writer.println(String.valueOf(indent_tab) + "\tvNControlPoints\t" + this.vNControlPoints());
        writer.println(String.valueOf(indent_tab) + "\tcontrolPoints");
        double[][][] cntlPnts = this.toDoubleArray();
        int i = 0;
        while (i < cntlPnts.length) {
            int j = 0;
            while (j < cntlPnts[i].length) {
                writer.print(String.valueOf(indent_tab) + "\t");
                int k = 0;
                while (k < cntlPnts[i][j].length) {
                    if (k == 0) {
                        writer.print(String.valueOf(cntlPnts[i][j][k]));
                    } else {
                        writer.print(", " + cntlPnts[i][j][k]);
                    }
                    ++k;
                }
                writer.println("");
                ++j;
            }
            ++i;
        }
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

