/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBoundedCurve2D;
import jp.go.ipa.jgcl.JgclBoundedCurve3D;
import jp.go.ipa.jgcl.JgclBoundedSurface3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCompositeCurve2D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment2D;
import jp.go.ipa.jgcl.JgclConic3D;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclCylindricalSurface3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionCurve3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclListSorter;
import jp.go.ipa.jgcl.JgclMesh3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnGeometry3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclReducedToPoint;
import jp.go.ipa.jgcl.JgclSphericalSurface3D;
import jp.go.ipa.jgcl.JgclSurfaceDerivative3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclSweptSurface3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclRectangularTrimmedSurface3D
extends JgclBoundedSurface3D {
    JgclParametricSurface3D basisSurface;
    private double uParam1;
    private double uParam2;
    boolean uSense;
    private double vParam1;
    private double vParam2;
    boolean vSense;
    private JgclParameterSection uTrimmingSectionOnBasis;
    private JgclParameterSection vTrimmingSectionOnBasis;
    private JgclPolyline2D boundaryCurve;
    private JgclCartesianTransformationOperator2D paramTransformer;

    private double checkUParamValidity(double uParam) {
        if (this.basisSurface.isUPeriodic()) {
            JgclParameterDomain domain = this.basisSurface.uParameterDomain();
            return domain.wrap(uParam);
        }
        this.basisSurface.checkUValidity(uParam);
        return uParam;
    }

    private double checkVParamValidity(double vParam) {
        if (this.basisSurface.isVPeriodic()) {
            JgclParameterDomain domain = this.basisSurface.vParameterDomain();
            return domain.wrap(vParam);
        }
        this.basisSurface.checkVValidity(vParam);
        return vParam;
    }

    private void setFields(JgclParametricSurface3D basisSurface, double uParam1, double uParam2, double vParam1, double vParam2, boolean uSense, boolean vSense) {
        JgclParameterSection sec;
        this.basisSurface = basisSurface;
        this.uParam1 = uParam1 = this.checkUParamValidity(uParam1);
        this.uParam2 = uParam2 = this.checkUParamValidity(uParam2);
        this.vParam1 = vParam1 = this.checkVParamValidity(vParam1);
        this.vParam2 = vParam2 = this.checkVParamValidity(vParam2);
        double pTol = this.getToleranceForParameter();
        if (Math.abs(uParam2 - uParam1) < pTol || Math.abs(vParam2 - vParam1) < pTol) {
            throw new JgclInvalidArgumentValue();
        }
        if (basisSurface.isUPeriodic()) {
            sec = basisSurface.uParameterDomain().section();
            if (uSense) {
                if (uParam1 > uParam2) {
                    this.uParam2 = uParam2 += sec.increase();
                }
            } else if (uParam1 < uParam2) {
                this.uParam1 = uParam1 += sec.increase();
            }
        } else if (uSense ? uParam1 > uParam2 : uParam1 < uParam2) {
            throw new JgclInvalidArgumentValue();
        }
        if (basisSurface.isVPeriodic()) {
            sec = basisSurface.vParameterDomain().section();
            if (vSense) {
                if (vParam1 > vParam2) {
                    this.vParam2 = vParam2 += sec.increase();
                }
            } else if (vParam1 < vParam2) {
                this.uParam1 = vParam1 += sec.increase();
            }
        } else if (vSense ? vParam1 > vParam2 : vParam1 < vParam2) {
            throw new JgclInvalidArgumentValue();
        }
        this.uSense = uSense;
        this.vSense = vSense;
        this.uTrimmingSectionOnBasis = new JgclParameterSection(this.uParam1, this.uParam2 - this.uParam1);
        this.vTrimmingSectionOnBasis = new JgclParameterSection(this.vParam1, this.vParam2 - this.vParam1);
        JgclPoint2D[] boudnaryPoints = new JgclPoint2D[]{JgclPoint2D.of(this.uParam1, this.vParam1), JgclPoint2D.of(this.uParam2, this.vParam1), JgclPoint2D.of(this.uParam2, this.vParam2), JgclPoint2D.of(this.uParam1, this.vParam2)};
        this.boundaryCurve = new JgclPolyline2D(boudnaryPoints, true);
        double diffU = -this.uParam1;
        JgclVector2D axisU = JgclVector2D.xUnitVector;
        if (!this.uSense) {
            diffU = -diffU;
            axisU = axisU.reverse();
        }
        double diffV = -this.vParam1;
        JgclVector2D axisV = JgclVector2D.yUnitVector;
        if (!this.vSense) {
            diffV = -diffV;
            axisV = axisV.reverse();
        }
        this.paramTransformer = new JgclCartesianTransformationOperator2D(axisU, axisV, JgclPoint2D.of(diffU, diffV), 1.0);
    }

    public JgclRectangularTrimmedSurface3D(JgclParametricSurface3D basisSurface, double uParam1, double uParam2, double vParam1, double vParam2, boolean uSense, boolean vSense) {
        this.setFields(basisSurface, uParam1, uParam2, vParam1, vParam2, uSense, vSense);
    }

    public JgclRectangularTrimmedSurface3D(JgclParametricSurface3D basisSurface, JgclParameterSection uPint, JgclParameterSection vPint) {
        this.setFields(basisSurface, uPint.start(), uPint.end(), vPint.start(), vPint.end(), uPint.increase() > 0.0, vPint.increase() > 0.0);
    }

    public JgclParametricSurface3D basisSurface() {
        return this.basisSurface;
    }

    public double uParam1() {
        return this.uParam1;
    }

    public double uParam2() {
        return this.uParam2;
    }

    public double vParam1() {
        return this.vParam1;
    }

    public double vParam2() {
        return this.vParam2;
    }

    public boolean uSense() {
        return this.uSense;
    }

    public boolean vSense() {
        return this.vSense;
    }

    JgclParameterDomain getUParameterDomain() {
        try {
            return new JgclParameterDomain(false, 0.0, Math.abs(this.uParam2 - this.uParam1));
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    JgclParameterDomain getVParameterDomain() {
        try {
            return new JgclParameterDomain(false, 0.0, Math.abs(this.vParam2 - this.vParam1));
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    public double toBasisUParameter(double uParam) {
        this.checkUValidity(uParam);
        return this.uSense ? this.uParam1 + uParam : this.uParam1 - uParam;
    }

    public double toBasisVParameter(double vParam) {
        this.checkVValidity(vParam);
        return this.vSense ? this.vParam1 + vParam : this.vParam1 - vParam;
    }

    public JgclParameterSection toBasisUParameter(JgclParameterSection uPint) {
        double sp = this.toBasisUParameter(uPint.start());
        double ep = this.toBasisUParameter(uPint.end());
        return new JgclParameterSection(sp, ep - sp);
    }

    public JgclParameterSection toBasisVParameter(JgclParameterSection vPint) {
        double sp = this.toBasisVParameter(vPint.start());
        double ep = this.toBasisVParameter(vPint.end());
        return new JgclParameterSection(sp, ep - sp);
    }

    public double toOwnUParameter(double uParam) {
        return this.uSense ? uParam - this.uParam1 : this.uParam1 - uParam;
    }

    public double toOwnVParameter(double vParam) {
        return this.vSense ? vParam - this.vParam1 : this.vParam1 - vParam;
    }

    int type() {
        return 32;
    }

    public boolean isFreeform() {
        return this.basisSurface.isFreeform();
    }

    public JgclPoint3D coordinates(double uParam, double vParam) {
        return this.basisSurface.coordinates(this.toBasisUParameter(uParam), this.toBasisVParameter(vParam));
    }

    public JgclVector3D[] tangentVector(double uParam, double vParam) {
        return this.basisSurface.tangentVector(this.toBasisUParameter(uParam), this.toBasisVParameter(vParam));
    }

    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam) {
        return this.basisSurface.evaluation(this.toBasisUParameter(uParam), this.toBasisVParameter(vParam));
    }

    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point) throws JgclIndefiniteSolution {
        JgclPointOnSurface3D[] basisResults = this.basisSurface.projectFrom(point);
        Vector<JgclPointOnSurface3D> thisResults = new Vector<JgclPointOnSurface3D>();
        int i = 0;
        while (i < basisResults.length) {
            double vParam;
            double uParam = this.toOwnUParameter(basisResults[i].uParameter());
            if (this.contains(uParam, vParam = this.toOwnVParameter(basisResults[i].vParameter()))) {
                thisResults.addElement(new JgclPointOnSurface3D(this, uParam, vParam, false));
            }
            ++i;
        }
        Object[] results = new JgclPointOnSurface3D[thisResults.size()];
        thisResults.copyInto(results);
        return results;
    }

    public JgclMesh3D toMesh(JgclToleranceForDistance tol) {
        return this.toMesh(true, this.uTrimmingSectionOnBasis, this.vTrimmingSectionOnBasis, tol);
    }

    public JgclMesh3D toMesh(JgclParameterSection uPint, JgclParameterSection vPint, JgclToleranceForDistance tol) {
        return this.toMesh(false, uPint, vPint, tol);
    }

    private JgclMesh3D toMesh(boolean parametersAreOnBasis, JgclParameterSection uPint, JgclParameterSection vPint, JgclToleranceForDistance tol) {
        if (!parametersAreOnBasis) {
            uPint = this.toBasisUParameter(uPint);
            vPint = this.toBasisUParameter(vPint);
        }
        JgclMesh3D basisMesh = this.basisSurface.toMesh(uPint, vPint, tol);
        JgclPoint3D[][] thisPoints = new JgclPoint3D[basisMesh.uNPoints()][basisMesh.vNPoints()];
        int u = 0;
        while (u < basisMesh.uNPoints()) {
            int v = 0;
            while (v < basisMesh.vNPoints()) {
                JgclPointOnSurface3D basisPoint = (JgclPointOnSurface3D)basisMesh.pointAt(u, v);
                thisPoints[u][v] = new JgclPointOnSurface3D(this, this.toOwnUParameter(basisPoint.uParameter()), this.toOwnVParameter(basisPoint.vParameter()), false);
                ++v;
            }
            ++u;
        }
        return new JgclMesh3D(thisPoints, basisMesh.uClosed(), basisMesh.vClosed());
    }

    public JgclBsplineSurface3D toBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint) {
        return this.basisSurface.toBsplineSurface(this.toBasisUParameter(uPint), this.toBasisVParameter(vPint));
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate);
        return this.selectInternalIntersections(results, false);
    }

    JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate);
        return this.selectInternalIntersections(results, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.selectInternalIntersections(results, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclConic3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.selectInternalIntersections(results, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.selectInternalIntersections(results, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.selectInternalIntersections(results, doExchange);
    }

    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate) throws JgclIndefiniteSolution {
        int basisType = this.basisSurface.type();
        JgclSurfaceSurfaceInterference3D[] results = basisType == 20 || basisType == 21 ? ((JgclSweptSurface3D)this.basisSurface).intersect(this.uTrimmingSectionOnBasis, this.vTrimmingSectionOnBasis, mate) : this.basisSurface.intersect(mate);
        return this.trimIntersectionsWithBoundaries(mate, results, false);
    }

    public JgclBsplineSurface3D offsetByBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint, double magni, int side, JgclToleranceForDistance tol) {
        JgclBsplineSurface3D convertedBspline = this.toBsplineSurface(uPint, vPint);
        return convertedBspline.offsetByBsplineSurface(convertedBspline.uParameterDomain().section(), convertedBspline.vParameterDomain().section(), magni, side, tol);
    }

    public JgclParametricCurve3D uIsoParametricCurve(double uParam) throws JgclReducedToPoint {
        JgclParametricCurve3D basisCurve = this.basisSurface.uIsoParametricCurve(this.toBasisUParameter(uParam));
        return new JgclTrimmedCurve3D(basisCurve, this.vTrimmingSectionOnBasis);
    }

    public JgclParametricCurve3D vIsoParametricCurve(double vParam) throws JgclReducedToPoint {
        JgclParametricCurve3D basisCurve = this.basisSurface.vIsoParametricCurve(this.toBasisVParameter(vParam));
        return new JgclTrimmedCurve3D(basisCurve, this.uTrimmingSectionOnBasis);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) {
        JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) {
        JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection, JgclParameterSection vParameterSection, double tolerance, double[] scalingFactor) {
        Vector basisResults = this.basisSurface.toNonStructuredPoints(this.toBasisUParameter(uParameterSection), this.toBasisVParameter(vParameterSection), tolerance, scalingFactor);
        Vector<JgclPointOnSurface3D> results = new Vector<JgclPointOnSurface3D>();
        Enumeration e = basisResults.elements();
        while (e.hasMoreElements()) {
            JgclPointOnSurface3D pos = (JgclPointOnSurface3D)e.nextElement();
            results.addElement(new JgclPointOnSurface3D(this, this.toOwnUParameter(pos.uParameter()), this.toOwnVParameter(pos.vParameter()), false));
        }
        return results;
    }

    public boolean contains(double uParam, double vParam) {
        if (!this.isValidUParameter(uParam)) {
            return false;
        }
        return this.isValidVParameter(vParam);
    }

    public boolean contains(JgclPoint2D point2D) {
        return this.contains(point2D.x(), point2D.y());
    }

    public boolean containsBasis(double uParam, double vParam) {
        if (!this.uTrimmingSectionOnBasis.isValid(uParam)) {
            return false;
        }
        return this.vTrimmingSectionOnBasis.isValid(vParam);
    }

    public boolean containsBasis(JgclPoint2D point2D) {
        return this.containsBasis(point2D.x(), point2D.y());
    }

    private boolean containsBasisWithWrapping(double uParam, double vParam) {
        return this.containsBasis(this.basisSurface.uParameterDomain().wrap(uParam), this.basisSurface.vParameterDomain().wrap(vParam));
    }

    private boolean containsBasisWithWrapping(JgclPoint2D point2D) {
        return this.containsBasis(this.basisSurface.uParameterDomain().wrap(point2D.x()), this.basisSurface.vParameterDomain().wrap(point2D.y()));
    }

    private boolean intersectionIsInternal(JgclIntersectionPoint3D ints, boolean doExchange) {
        JgclPointOnSurface3D pointOnSurface = !doExchange ? (JgclPointOnSurface3D)ints.pointOnGeometry1() : (JgclPointOnSurface3D)ints.pointOnGeometry2();
        return this.containsBasisWithWrapping(pointOnSurface.uParameter(), pointOnSurface.vParameter());
    }

    private JgclIntersectionPoint3D changeTargetOfIntersection(JgclIntersectionPoint3D ints, boolean doExchange) {
        JgclPointOnGeometry3D pog1 = ints.pointOnGeometry1();
        JgclPointOnGeometry3D pog2 = ints.pointOnGeometry2();
        if (!doExchange) {
            JgclPointOnSurface3D pos = (JgclPointOnSurface3D)pog1;
            double uParam = this.basisSurface.uParameterDomain().wrap(pos.uParameter());
            double vParam = this.basisSurface.vParameterDomain().wrap(pos.vParameter());
            pog1 = new JgclPointOnSurface3D(this, this.toOwnUParameter(uParam), this.toOwnVParameter(vParam), false);
        } else {
            JgclPointOnSurface3D pos = (JgclPointOnSurface3D)pog2;
            double uParam = this.basisSurface.uParameterDomain().wrap(pos.uParameter());
            double vParam = this.basisSurface.vParameterDomain().wrap(pos.vParameter());
            pog2 = new JgclPointOnSurface3D(this, this.toOwnUParameter(uParam), this.toOwnVParameter(vParam), false);
        }
        return new JgclIntersectionPoint3D(ints.coordinates(), pog1, pog2, false);
    }

    private JgclIntersectionCurve3D changeTargetOfIntersection(JgclIntersectionCurve3D ints, boolean doExchange) {
        JgclParametricSurface3D basisSurface2;
        JgclParametricSurface3D basisSurface1;
        if (!doExchange) {
            basisSurface1 = this;
            basisSurface2 = ints.basisSurface2();
        } else {
            basisSurface1 = ints.basisSurface1();
            basisSurface2 = this;
        }
        return new JgclIntersectionCurve3D(ints.curve3d(), basisSurface1, ints.curve2d1(), basisSurface2, ints.curve2d2(), ints.masterRepresentation());
    }

    JgclIntersectionPoint3D[] selectInternalIntersections(JgclIntersectionPoint3D[] intersections, boolean doExchange) {
        Vector<JgclIntersectionPoint3D> innerPoints = new Vector<JgclIntersectionPoint3D>();
        int i = 0;
        while (i < intersections.length) {
            if (this.intersectionIsInternal(intersections[i], doExchange)) {
                JgclIntersectionPoint3D ints = this.changeTargetOfIntersection(intersections[i], doExchange);
                innerPoints.addElement(ints);
            }
            ++i;
        }
        Object[] results = new JgclIntersectionPoint3D[innerPoints.size()];
        innerPoints.copyInto(results);
        return results;
    }

    private JgclIntersectionCurve3D makeIntersectionClose(JgclIntersectionCurve3D theIntersection) {
        JgclParametricCurve2D curve2d2;
        JgclParametricCurve2D curve2d1;
        boolean changed = false;
        JgclParametricCurve3D curve3d = theIntersection.curve3d();
        if (curve3d.isClosed() && !curve3d.isPeriodic() && curve3d.type() == 20) {
            JgclPolyline3D polyline3d = (JgclPolyline3D)curve3d;
            int nPoints = polyline3d.nPoints() - 1;
            JgclPoint3D[] points = new JgclPoint3D[nPoints];
            int i = 0;
            while (i < nPoints) {
                points[i] = polyline3d.pointAt(i);
                ++i;
            }
            curve3d = new JgclPolyline3D(points, true);
            changed = true;
        }
        if ((curve2d1 = theIntersection.curve2d1()).isClosed() && !curve2d1.isPeriodic() && curve2d1 instanceof JgclPolyline2D) {
            JgclPolyline2D polyline2d = (JgclPolyline2D)curve2d1;
            int nPoints = polyline2d.nPoints() - 1;
            JgclPoint2D[] points = new JgclPoint2D[nPoints];
            int i = 0;
            while (i < nPoints) {
                points[i] = polyline2d.pointAt(i);
                ++i;
            }
            curve2d1 = new JgclPolyline2D(points, true);
            changed = true;
        }
        if ((curve2d2 = theIntersection.curve2d2()).isClosed() && !curve2d2.isPeriodic() && curve2d2 instanceof JgclPolyline2D) {
            JgclPolyline2D polyline2d = (JgclPolyline2D)curve2d2;
            int nPoints = polyline2d.nPoints() - 1;
            JgclPoint2D[] points = new JgclPoint2D[nPoints];
            int i = 0;
            while (i < nPoints) {
                points[i] = polyline2d.pointAt(i);
                ++i;
            }
            curve2d2 = new JgclPolyline2D(points, true);
            changed = true;
        }
        if (!changed) {
            return theIntersection;
        }
        return new JgclIntersectionCurve3D(curve3d, theIntersection.basisSurface1(), curve2d1, theIntersection.basisSurface2(), curve2d2, theIntersection.masterRepresentation());
    }

    private double getParameterWithCurve3D(JgclParametricCurve3D curve3d, JgclPoint3D point3d) {
        double nearDist;
        JgclPointOnCurve3D nearProj3d;
        JgclPoint3D nearestProj3d = null;
        double nearestDist = Double.NaN;
        JgclPointOnCurve3D lowerPoint = null;
        JgclPoint3D upperPoint = null;
        if (curve3d.isFinite() && curve3d.isOpen()) {
            lowerPoint = new JgclPointOnCurve3D(curve3d, curve3d.parameterDomain().section().lower());
            upperPoint = new JgclPointOnCurve3D(curve3d, curve3d.parameterDomain().section().upper());
        }
        JgclPolyline3D polyline3d = null;
        if (curve3d.hasPolyline()) {
            JgclBoundedCurve3D bounded3d = (JgclBoundedCurve3D)curve3d;
            polyline3d = bounded3d.toPolyline(this.getToleranceForDistanceAsObject());
        }
        if ((nearProj3d = curve3d.nearestProjectFrom(point3d)) != null) {
            nearDist = nearProj3d.distance(point3d);
            if (nearestProj3d == null || nearDist < nearestDist) {
                nearestProj3d = nearProj3d;
                nearestDist = nearDist;
            }
        }
        if (lowerPoint != null) {
            nearDist = lowerPoint.distance(point3d);
            if (nearestProj3d == null || nearDist < nearestDist) {
                nearestProj3d = lowerPoint;
                nearestDist = nearDist;
            }
        }
        if (upperPoint != null) {
            nearDist = upperPoint.distance(point3d);
            if (nearestProj3d == null || nearDist < nearestDist) {
                nearestProj3d = upperPoint;
                nearestDist = nearDist;
            }
        }
        if (polyline3d != null) {
            int i = 0;
            while (i < polyline3d.nPoints()) {
                nearDist = polyline3d.pointAt(i).distance(point3d);
                if (nearestProj3d == null || nearDist < nearestDist) {
                    nearestProj3d = (JgclPointOnCurve3D)polyline3d.pointAt(i);
                    nearestDist = nearDist;
                }
                ++i;
            }
        }
        if (nearestProj3d == null) {
            throw new JgclFatal("No projection.");
        }
        return nearestProj3d.parameter();
    }

    private double getParameterWithCurveOnSurface3D(JgclParametricSurface3D surface3d, JgclParametricCurve2D curve2d, JgclPoint3D point3d) {
        JgclPointOnSurface3D nearestProj3d = surface3d.nearestProjectFrom(point3d);
        if (nearestProj3d == null) {
            throw new JgclFatal("No projection in 3d.");
        }
        double[] param3d = nearestProj3d.parameters();
        JgclPointOnCurve2D lowerPoint = null;
        JgclPointOnCurve2D upperPoint = null;
        if (curve2d.isFinite() && curve2d.isOpen()) {
            lowerPoint = new JgclPointOnCurve2D(curve2d, curve2d.parameterDomain().section().lower());
            upperPoint = new JgclPointOnCurve2D(curve2d, curve2d.parameterDomain().section().upper());
        }
        JgclPolyline2D polyline2d = null;
        if (curve2d.hasPolyline()) {
            JgclBoundedCurve2D bounded2d = (JgclBoundedCurve2D)curve2d;
            polyline2d = bounded2d.toPolyline(this.getToleranceForDistanceAsObject());
        }
        int nU = 1;
        double dU = Double.NaN;
        int nV = 1;
        double dV = Double.NaN;
        if (surface3d.type() != 33) {
            if (surface3d.isUPeriodic()) {
                nU = 3;
                dU = surface3d.uParameterDomain().section().increase();
            }
            if (surface3d.isVPeriodic()) {
                nV = 3;
                dV = surface3d.vParameterDomain().section().increase();
            }
        }
        JgclPointOnCurve2D nearestProj2d = null;
        double nearestDist = Double.NaN;
        int iU = 0;
        while (iU < nU) {
            double pU;
            switch (iU) {
                case 1: {
                    pU = param3d[0] - dU;
                    break;
                }
                case 2: {
                    pU = param3d[0] + dU;
                    break;
                }
                default: {
                    pU = param3d[0];
                }
            }
            int iV = 0;
            while (iV < nV) {
                double nearDist;
                double pV;
                switch (iV) {
                    case 1: {
                        pV = param3d[1] - dV;
                        break;
                    }
                    case 2: {
                        pV = param3d[1] + dV;
                        break;
                    }
                    default: {
                        pV = param3d[1];
                    }
                }
                JgclCartesianPoint2D point2d = JgclPoint2D.of(pU, pV);
                JgclPointOnCurve2D nearProj2d = curve2d.nearestProjectFrom(point2d);
                if (nearProj2d != null) {
                    nearDist = nearProj2d.distance(point2d);
                    if (nearestProj2d == null || nearDist < nearestDist) {
                        nearestProj2d = nearProj2d;
                        nearestDist = nearDist;
                    }
                }
                if (lowerPoint != null) {
                    nearDist = lowerPoint.distance(point2d);
                    if (nearestProj2d == null || nearDist < nearestDist) {
                        nearestProj2d = lowerPoint;
                        nearestDist = nearDist;
                    }
                }
                if (upperPoint != null) {
                    nearDist = upperPoint.distance(point2d);
                    if (nearestProj2d == null || nearDist < nearestDist) {
                        nearestProj2d = upperPoint;
                        nearestDist = nearDist;
                    }
                }
                if (polyline2d != null) {
                    int i = 0;
                    while (i < polyline2d.nPoints()) {
                        nearDist = polyline2d.pointAt(i).distance(point2d);
                        if (nearestProj2d == null || nearDist < nearestDist) {
                            nearestProj2d = (JgclPointOnCurve2D)polyline2d.pointAt(i);
                            nearestDist = nearDist;
                        }
                        ++i;
                    }
                }
                ++iV;
            }
            ++iU;
        }
        if (nearestProj2d == null) {
            throw new JgclFatal("No projection in 2d.");
        }
        return nearestProj2d.parameter();
    }

    private JgclIntersectionPoint2D[] getIntersectionsWithBoundary(JgclPolyline2D boundaryCurve, JgclParametricCurve2D intsT) {
        JgclIntersectionPoint2D[] intsWithBoundary;
        int nU = 1;
        double dU = Double.NaN;
        int nV = 1;
        double dV = Double.NaN;
        if (this.basisSurface.type() != 33) {
            if (this.basisSurface.isUPeriodic()) {
                nU = 3;
                dU = this.basisSurface.uParameterDomain().section().increase();
            }
            if (this.basisSurface.isVPeriodic()) {
                nV = 3;
                dV = this.basisSurface.vParameterDomain().section().increase();
            }
        }
        Vector<JgclIntersectionPoint2D[]> intsWithBoundaryList = new Vector<JgclIntersectionPoint2D[]>();
        int nInts = 0;
        int iU = 0;
        while (iU < nU) {
            double pU;
            switch (iU) {
                case 1: {
                    pU = -dU;
                    break;
                }
                case 2: {
                    pU = dU;
                    break;
                }
                default: {
                    pU = 0.0;
                }
            }
            int iV = 0;
            while (iV < nV) {
                JgclPolyline2D tBoundaryCurve;
                double pV;
                switch (iV) {
                    case 1: {
                        pV = -dV;
                        break;
                    }
                    case 2: {
                        pV = dV;
                        break;
                    }
                    default: {
                        pV = 0.0;
                    }
                }
                if (iU == 0 && iV == 0) {
                    tBoundaryCurve = boundaryCurve;
                } else {
                    JgclCartesianTransformationOperator2D transformer = new JgclCartesianTransformationOperator2D(null, null, JgclPoint2D.of(pU, pV), 1.0);
                    tBoundaryCurve = (JgclPolyline2D)boundaryCurve.transformBy(transformer, null);
                }
                intsWithBoundary = tBoundaryCurve.intersect(intsT);
                if (intsWithBoundary.length > 0) {
                    intsWithBoundaryList.addElement(intsWithBoundary);
                    nInts += intsWithBoundary.length;
                }
                ++iV;
            }
            ++iU;
        }
        JgclIntersectionPoint2D[] result = new JgclIntersectionPoint2D[nInts];
        int iResult = 0;
        Enumeration e = intsWithBoundaryList.elements();
        while (e.hasMoreElements()) {
            intsWithBoundary = (JgclIntersectionPoint2D[])e.nextElement();
            int i = 0;
            while (i < intsWithBoundary.length) {
                result[iResult++] = intsWithBoundary[i];
                ++i;
            }
        }
        return result;
    }

    private double wrapParameterIntoOpenSection(double param, JgclParameterSection section) {
        while (param < section.lower()) {
            param += section.absIncrease();
        }
        while (param > section.upper()) {
            param -= section.absIncrease();
        }
        return param;
    }

    private JgclParametricCurve2D connectHeadToTail(JgclParametricCurve2D curve, double sp, double ep) {
        JgclParameterSection section = curve.parameterDomain().section();
        double sp1 = this.wrapParameterIntoOpenSection(sp, section);
        double ep1 = section.upper();
        double sp2 = section.lower();
        double ep2 = this.wrapParameterIntoOpenSection(ep, section);
        JgclPoint2D lowerCoord = curve.coordinates(section.lower());
        JgclPoint2D upperCoord = curve.coordinates(section.upper());
        JgclVector2D period = upperCoord.subtract(lowerCoord);
        JgclCartesianTransformationOperator2D transformer = new JgclCartesianTransformationOperator2D(null, null, period.toPoint2D(), 1.0);
        JgclParametricCurve2D curve1 = curve;
        JgclParametricCurve2D curve2 = curve.transformBy(transformer, null);
        JgclTrimmedCurve2D tCurve1 = new JgclTrimmedCurve2D(curve1, sp1, ep1, true);
        JgclTrimmedCurve2D tCurve2 = new JgclTrimmedCurve2D(curve2, sp2, ep2, true);
        JgclCompositeCurveSegment2D[] segments = new JgclCompositeCurveSegment2D[]{new JgclCompositeCurveSegment2D(1, true, tCurve1), new JgclCompositeCurveSegment2D(0, true, tCurve2)};
        return new JgclCompositeCurve2D(segments, false);
    }

    private JgclIntersectionCurve3D trimIntersection2(boolean doExchange, JgclIntersectionCurve3D theIntersection, boolean isOpenT, boolean isOpenM, boolean crossBoundary, double spT, double ipT) {
        JgclParameterSection section;
        boolean isOpen;
        double epT = spT + ipT;
        JgclParametricCurve3D curve3d = theIntersection.curve3d();
        double sp = spT;
        double ep = epT;
        curve3d = new JgclTrimmedCurve3D(curve3d, sp, ep, true);
        JgclParametricCurve2D curve2d1 = theIntersection.curve2d1();
        sp = spT;
        ep = epT;
        boolean bl = isOpen = !doExchange ? isOpenT : isOpenM;
        if (crossBoundary && isOpen) {
            section = curve2d1.parameterDomain().section();
            sp = this.wrapParameterIntoOpenSection(sp, section);
            ep = this.wrapParameterIntoOpenSection(ep, section);
        }
        curve2d1 = sp < ep || !isOpen ? new JgclTrimmedCurve2D(curve2d1, sp, ep, true) : this.connectHeadToTail(curve2d1, sp, ep);
        JgclParametricCurve2D curve2d2 = theIntersection.curve2d2();
        sp = spT;
        ep = epT;
        boolean bl2 = isOpen = !doExchange ? isOpenM : isOpenT;
        if (crossBoundary && isOpen) {
            section = curve2d2.parameterDomain().section();
            sp = this.wrapParameterIntoOpenSection(sp, section);
            ep = this.wrapParameterIntoOpenSection(ep, section);
        }
        curve2d2 = sp < ep || !isOpen ? new JgclTrimmedCurve2D(curve2d2, sp, ep, true) : this.connectHeadToTail(curve2d2, sp, ep);
        return new JgclIntersectionCurve3D(curve3d, theIntersection.basisSurface1(), curve2d1, theIntersection.basisSurface2(), curve2d2, theIntersection.masterRepresentation());
    }

    private JgclIntersectionCurve3D trimIntersection(boolean doExchange, JgclIntersectionCurve3D theIntersection, JgclParametricCurve2D intsT, JgclParameterSection sectionOfIntsT, boolean isOpenT, boolean isOpenM, boolean crossBoundary, double spT, double ipT) {
        boolean isOpen;
        if (theIntersection.curve3d().isComposedOfOnlyPolylines() && theIntersection.curve2d1().isComposedOfOnlyPolylines() && theIntersection.curve2d2().isComposedOfOnlyPolylines()) {
            JgclParameterSection section3d = theIntersection.curve3d().parameterDomain().section();
            JgclParameterSection section2d1 = theIntersection.curve2d1().parameterDomain().section();
            JgclParameterSection section2d2 = theIntersection.curve2d2().parameterDomain().section();
            if (section3d.identical(section2d1) && section3d.identical(section2d2)) {
                return this.trimIntersection2(doExchange, theIntersection, isOpenT, isOpenM, crossBoundary, spT, ipT);
            }
        }
        double epT = spT + ipT;
        if (crossBoundary && isOpenT) {
            spT = this.wrapParameterIntoOpenSection(spT, sectionOfIntsT);
            epT = this.wrapParameterIntoOpenSection(epT, sectionOfIntsT);
        }
        JgclPoint2D spnt2d = intsT.coordinates(spT);
        JgclPoint2D epnt2d = intsT.coordinates(epT);
        JgclPoint3D spnt3d = this.basisSurface.coordinates(spnt2d.x(), spnt2d.y());
        JgclPoint3D epnt3d = this.basisSurface.coordinates(epnt2d.x(), epnt2d.y());
        JgclParametricCurve3D curve3d = theIntersection.curve3d();
        double sp = this.getParameterWithCurve3D(curve3d, spnt3d);
        double ep = this.getParameterWithCurve3D(curve3d, epnt3d);
        curve3d = new JgclTrimmedCurve3D(curve3d, sp, ep, true);
        JgclParametricCurve2D curve2d1 = theIntersection.curve2d1();
        if (!doExchange) {
            sp = spT;
            ep = epT;
            isOpen = isOpenT;
        } else {
            sp = this.getParameterWithCurveOnSurface3D(theIntersection.basisSurface1(), curve2d1, spnt3d);
            ep = this.getParameterWithCurveOnSurface3D(theIntersection.basisSurface1(), curve2d1, epnt3d);
            isOpen = isOpenM;
        }
        curve2d1 = sp < ep || !isOpen ? new JgclTrimmedCurve2D(curve2d1, sp, ep, true) : this.connectHeadToTail(curve2d1, sp, ep);
        JgclParametricCurve2D curve2d2 = theIntersection.curve2d2();
        if (!doExchange) {
            sp = this.getParameterWithCurveOnSurface3D(theIntersection.basisSurface2(), curve2d2, spnt3d);
            ep = this.getParameterWithCurveOnSurface3D(theIntersection.basisSurface2(), curve2d2, epnt3d);
            isOpen = isOpenM;
        } else {
            sp = spT;
            ep = epT;
            isOpen = isOpenT;
        }
        curve2d2 = sp < ep || !isOpen ? new JgclTrimmedCurve2D(curve2d2, sp, ep, true) : this.connectHeadToTail(curve2d2, sp, ep);
        return new JgclIntersectionCurve3D(curve3d, theIntersection.basisSurface1(), curve2d1, theIntersection.basisSurface2(), curve2d2, theIntersection.masterRepresentation());
    }

    private JgclParametricCurve2D moveIntoPrimarySections(JgclParametricCurve2D curve) {
        double lower = curve.parameterDomain().section().lower();
        double upper = curve.parameterDomain().section().upper();
        double middle = (lower + upper) / 2.0;
        JgclPoint2D lowerPoint = curve.coordinates(lower);
        JgclPoint2D upperPoint = curve.coordinates(upper);
        JgclPoint2D middlePoint = curve.coordinates(middle);
        int nU = 1;
        double dU = Double.NaN;
        int nV = 1;
        double dV = Double.NaN;
        if (this.basisSurface.type() != 33) {
            if (this.basisSurface.isUPeriodic()) {
                nU = 3;
                dU = this.basisSurface.uParameterDomain().section().increase();
            }
            if (this.basisSurface.isVPeriodic()) {
                nV = 3;
                dV = this.basisSurface.vParameterDomain().section().increase();
            }
        }
        int iU = 0;
        while (iU < nU) {
            double pU;
            switch (iU) {
                case 1: {
                    pU = -dU;
                    break;
                }
                case 2: {
                    pU = dU;
                    break;
                }
                default: {
                    pU = 0.0;
                }
            }
            int iV = 0;
            while (iV < nV) {
                JgclPoint2D tMiddlePoint;
                JgclPoint2D tUpperPoint;
                JgclPoint2D tLowerPoint;
                JgclCartesianTransformationOperator2D transformer;
                double pV;
                switch (iV) {
                    case 1: {
                        pV = -dV;
                        break;
                    }
                    case 2: {
                        pV = dV;
                        break;
                    }
                    default: {
                        pV = 0.0;
                    }
                }
                if (iU == 0 && iV == 0) {
                    transformer = null;
                    tLowerPoint = lowerPoint;
                    tUpperPoint = upperPoint;
                    tMiddlePoint = middlePoint;
                } else {
                    transformer = new JgclCartesianTransformationOperator2D(null, null, JgclPoint2D.of(pU, pV), 1.0);
                    tLowerPoint = lowerPoint.transformBy(transformer, null);
                    tUpperPoint = upperPoint.transformBy(transformer, null);
                    tMiddlePoint = middlePoint.transformBy(transformer, null);
                }
                if (this.containsBasis(tLowerPoint) && this.containsBasis(tUpperPoint) && this.containsBasis(tMiddlePoint)) {
                    if (transformer == null) {
                        return curve;
                    }
                    return curve.transformBy(transformer, null);
                }
                ++iV;
            }
            ++iU;
        }
        return null;
    }

    private JgclIntersectionCurve3D changeParameterSpaceOfIntersection(JgclIntersectionCurve3D ints, boolean doExchange) {
        JgclParametricCurve2D curve2d1 = ints.curve2d1();
        JgclParametricCurve2D curve2d2 = ints.curve2d2();
        if (!doExchange) {
            curve2d1 = this.moveIntoPrimarySections(curve2d1).transformBy(this.paramTransformer, null);
        } else {
            curve2d2 = this.moveIntoPrimarySections(curve2d2).transformBy(this.paramTransformer, null);
        }
        return new JgclIntersectionCurve3D(ints.curve3d(), ints.basisSurface1(), curve2d1, ints.basisSurface2(), curve2d2, ints.masterRepresentation());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    JgclSurfaceSurfaceInterference3D[] trimIntersectionsWithBoundaries(JgclParametricSurface3D mate, JgclSurfaceSurfaceInterference3D[] intersections, boolean doExchange) {
        i = 0;
        while (i < intersections.length) {
            if (intersections[i].isIntersectionPoint()) {
                ints /* !! */  = intersections[i].toIntersectionPoint();
                intersections[i] = this.changeTargetOfIntersection(ints /* !! */ , doExchange);
            } else {
                ints /* !! */  = intersections[i].toIntersectionCurve();
                intersections[i] = this.changeTargetOfIntersection((JgclIntersectionCurve3D)ints /* !! */ , doExchange);
            }
            ++i;
        }
        results = new Vector<JgclGeometry>();
        iwbiBothEnds = new IntersectionWithBoundaryInfo[2];
        comparator = new 1(iwbiBothEnds);
        i = 0;
        while (i < intersections.length) {
            block33: {
                block34: {
                    block32: {
                        if (!intersections[i].isIntersectionPoint()) break block32;
                        ints = intersections[i].toIntersectionPoint();
                        if (this.intersectionIsInternal(ints, doExchange)) {
                            results.addElement(ints);
                        }
                        break block33;
                    }
                    theIntersection = intersections[i].toIntersectionCurve();
                    theIntersection = this.makeIntersectionClose(theIntersection);
                    if (!doExchange) {
                        intsT = theIntersection.curve2d1();
                        intsM = theIntersection.curve2d2();
                    } else {
                        intsT = theIntersection.curve2d2();
                        intsM = theIntersection.curve2d1();
                    }
                    isOpen3 = theIntersection.curve3d().isOpen();
                    isOpenT = intsT.isOpen();
                    isOpenM = intsM.isOpen();
                    domainOfIntsT = intsT.parameterDomain();
                    sectionOfIntsT = domainOfIntsT.section();
                    listOfIntersectionsWithBoundaries = new Vector<IntersectionWithBoundaryInfo>();
                    intsWithBoundary = this.getIntersectionsWithBoundary(this.boundaryCurve, intsT);
                    k = 0;
                    while (k < intsWithBoundary.length) {
                        iwbi = new IntersectionWithBoundaryInfo(true, intsWithBoundary[k].pointOnCurve2().parameter());
                        listOfIntersectionsWithBoundaries.addElement(iwbi);
                        ++k;
                    }
                    iwbiBothEnds[0] = null;
                    iwbiBothEnds[1] = null;
                    addEndPoints = false;
                    if (isOpen3) {
                        if (intsT.isFinite()) {
                            iwbiBothEnds[0] = new IntersectionWithBoundaryInfo(false, sectionOfIntsT.start());
                            iwbiBothEnds[1] = new IntersectionWithBoundaryInfo(false, sectionOfIntsT.end());
                            listOfIntersectionsWithBoundaries.addElement(iwbiBothEnds[0]);
                            listOfIntersectionsWithBoundaries.addElement(iwbiBothEnds[1]);
                            addEndPoints = true;
                        }
                    } else if (listOfIntersectionsWithBoundaries.size() == 1) {
                        iwbi = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(0);
                        iwbi2 = new IntersectionWithBoundaryInfo(iwbi.onBoundary, iwbi.curveParameter);
                        listOfIntersectionsWithBoundaries.addElement(iwbi2);
                    }
                    if (listOfIntersectionsWithBoundaries.size() != 0) break block34;
                    v0 = aParameter = intsT.isFinite() == true ? sectionOfIntsT.start() : 0.0;
                    if (this.containsBasisWithWrapping(intsT.coordinates(aParameter))) {
                        results.addElement(this.changeParameterSpaceOfIntersection(theIntersection, doExchange));
                    }
                    break block33;
                }
                JgclListSorter.doSorting(listOfIntersectionsWithBoundaries, comparator);
                nIntervals = isOpen3 == true ? listOfIntersectionsWithBoundaries.size() - 1 : listOfIntersectionsWithBoundaries.size();
                listOfTrimmingIntervals = new Vector<TrimmingInterval>();
                trimmingInterval = null;
                sIdx = 0;
                sIwb = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(0);
                j = 1;
                while (j <= nIntervals) {
                    block36: {
                        block35: {
                            sp = sIwb.curveParameter;
                            if (!isOpen3 && j >= nIntervals) break block35;
                            eIdx = j;
                            eIwb = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(j);
                            crossBoundary = false;
                            ip = eIwb.curveParameter - sIwb.curveParameter;
                            if (sIwb != iwbiBothEnds[0] && eIwb != iwbiBothEnds[1] || !(Math.abs(ip) < this.getToleranceForParameter())) ** GOTO lbl-1000
                            sIdx = eIdx;
                            sIwb = eIwb;
                            break block36;
                        }
                        eIdx = 0;
                        eIwb = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(0);
                        crossBoundary = true;
                        ip = eIwb.curveParameter - sIwb.curveParameter + sectionOfIntsT.increase();
                        if (Math.abs(ip) < this.getToleranceForParameter()) {
                            sIdx = eIdx;
                            sIwb = eIwb;
                        } else lbl-1000:
                        // 2 sources

                        {
                            mp = sp + ip / 2.0;
                            if (addEndPoints) {
                                if (j == 1) {
                                    mp = sp;
                                } else if (j == nIntervals) {
                                    mp = sp + ip;
                                }
                            }
                            if (crossBoundary && isOpenT) {
                                if (mp < sectionOfIntsT.lower()) {
                                    mp += sectionOfIntsT.absIncrease();
                                }
                                if (mp > sectionOfIntsT.upper()) {
                                    mp -= sectionOfIntsT.absIncrease();
                                }
                            }
                            if (this.containsBasisWithWrapping(intsT.coordinates(mp))) {
                                if (trimmingInterval != null && trimmingInterval.eIdx == sIdx) {
                                    trimmingInterval.eIdx = eIdx;
                                } else {
                                    trimmingInterval = new TrimmingInterval(sIdx, eIdx);
                                    listOfTrimmingIntervals.addElement(trimmingInterval);
                                }
                            }
                            sIdx = eIdx;
                            sIwb = eIwb;
                        }
                    }
                    ++j;
                }
                nIntervals = listOfTrimmingIntervals.size();
                if (nIntervals > 1) {
                    head = (TrimmingInterval)listOfTrimmingIntervals.firstElement();
                    tail = (TrimmingInterval)listOfTrimmingIntervals.lastElement();
                    if (head.sIdx == tail.eIdx) {
                        head.sIdx = tail.sIdx;
                        --nIntervals;
                    }
                }
                j = 0;
                while (j < nIntervals) {
                    trimmingInterval = (TrimmingInterval)listOfTrimmingIntervals.elementAt(j);
                    sIwb = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(trimmingInterval.sIdx);
                    eIwb = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(trimmingInterval.eIdx);
                    sp = sIwb.curveParameter;
                    if (trimmingInterval.sIdx < trimmingInterval.eIdx) {
                        crossBoundary = false;
                        ip = eIwb.curveParameter - sIwb.curveParameter;
                    } else {
                        crossBoundary = true;
                        ip = eIwb.curveParameter - sIwb.curveParameter + sectionOfIntsT.increase();
                    }
                    if (!(ip < this.getToleranceForParameter()) && !((theTrimmedIntersection3 = (JgclBoundedCurve3D)(theTrimmedIntersection = this.trimIntersection(doExchange, theIntersection, intsT, sectionOfIntsT, isOpenT, isOpenM, crossBoundary, sp, ip)).curve3d()).length() < this.getToleranceForDistance())) {
                        results.addElement(this.changeParameterSpaceOfIntersection(theTrimmedIntersection, doExchange));
                    }
                    ++j;
                }
            }
            ++i;
        }
        intersections = new JgclSurfaceSurfaceInterference3D[results.size()];
        results.copyInto(intersections);
        return intersections;
    }

    protected synchronized JgclParametricSurface3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclParametricSurface3D tBasisSurface = this.basisSurface.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclRectangularTrimmedSurface3D(tBasisSurface, this.uParam1, this.uParam2, this.vParam1, this.vParam2, this.uSense, this.vSense);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tbasisSurface");
        this.basisSurface.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tuParam1\t" + this.uParam1);
        writer.println(String.valueOf(indent_tab) + "\tuParam2\t" + this.uParam2);
        writer.println(String.valueOf(indent_tab) + "\tvParam1\t" + this.vParam1);
        writer.println(String.valueOf(indent_tab) + "\tvParam2\t" + this.vParam2);
        writer.println(String.valueOf(indent_tab) + "\tuSense\t" + this.uSense);
        writer.println(String.valueOf(indent_tab) + "\tvSense\t" + this.vSense);
        writer.println(String.valueOf(indent_tab) + "End");
    }

    private class IntersectionWithBoundaryInfo {
        boolean onBoundary;
        double curveParameter;

        IntersectionWithBoundaryInfo() {
            JgclRectangularTrimmedSurface3D.this = JgclRectangularTrimmedSurface3D.this;
        }

        IntersectionWithBoundaryInfo(boolean onBoundary, double curveParameter) {
            JgclRectangularTrimmedSurface3D.this = JgclRectangularTrimmedSurface3D.this;
            this.onBoundary = onBoundary;
            this.curveParameter = curveParameter;
        }
    }

    private class TrimmingInterval {
        int sIdx;
        int eIdx;

        TrimmingInterval(int sIdx, int eIdx) {
            JgclRectangularTrimmedSurface3D.this = JgclRectangularTrimmedSurface3D.this;
            this.sIdx = sIdx;
            this.eIdx = eIdx;
        }
    }

    private static final class 1
    implements JgclListSorter.ObjectComparator {
        private final /* synthetic */ IntersectionWithBoundaryInfo[] val$iwbiBothEnds;

        public boolean latterIsGreaterThanFormer(Object former, Object latter) {
            IntersectionWithBoundaryInfo f = (IntersectionWithBoundaryInfo)former;
            IntersectionWithBoundaryInfo l = (IntersectionWithBoundaryInfo)latter;
            if (f == l) {
                return false;
            }
            if (f == this.val$iwbiBothEnds[0] || l == this.val$iwbiBothEnds[1]) {
                return true;
            }
            if (l == this.val$iwbiBothEnds[0] || f == this.val$iwbiBothEnds[1]) {
                return false;
            }
            return f.curveParameter < l.curveParameter;
        }

        /* synthetic */ 1(IntersectionWithBoundaryInfo[] val$iwbiBothEnds) {
            this.val$iwbiBothEnds = val$iwbiBothEnds;
        }
    }
}

