/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBoundedLine2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterferenceList;
import jp.go.ipa.jgcl.JgclEnclosingBox2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclOverlapCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclVector2D;

class JgclSelfIntsPol2D {
    private JgclPolyline2D polyline;
    private JgclVector2D[] polylineUvecs;
    private double[] polylineLengs;
    private JgclEnclosingBox2D polylineEncls;

    private JgclSelfIntsPol2D(JgclPolyline2D polyline) {
        this(polyline, null, null, null);
    }

    private JgclSelfIntsPol2D(JgclPolyline2D polyline, JgclVector2D[] polylineUvecs, double[] polylineLengs, JgclEnclosingBox2D polylineEncls) {
        this.polyline = polyline;
        this.polylineUvecs = polylineUvecs;
        this.polylineLengs = polylineLengs;
        this.polylineEncls = polylineEncls;
    }

    private JgclCurveCurveInterferenceList getInterference() {
        JgclCurveCurveInterferenceList interferenceList = new JgclCurveCurveInterferenceList(this.polyline, this.polyline);
        int nSegments = this.polyline.nSegments();
        if (nSegments < 3) {
            return interferenceList;
        }
        SegmentInfo[] segmentInfo2 = new SegmentInfo[nSegments];
        int i = 0;
        while (i < nSegments) {
            segmentInfo2[i] = this.polylineUvecs == null ? new SegmentInfo(this.polyline.pointAt(i), this.polyline.pointAt(i + 1)) : new SegmentInfo(this.polyline.pointAt(i), this.polyline.pointAt(i + 1), this.polylineUvecs[i], this.polylineLengs[i]);
            ++i;
        }
        i = 0;
        while (i < nSegments) {
            if (!(segmentInfo2[i].tol < 0.0)) {
                int j = i + 1;
                while (j < nSegments) {
                    JgclCurveCurveInterference2D intf;
                    if (!(segmentInfo2[j].tol < 0.0) && segmentInfo2[i].box.hasIntersection(segmentInfo2[j].box) && (intf = segmentInfo2[i].bln.interfere1(segmentInfo2[j].bln, segmentInfo2[i].udir, segmentInfo2[j].udir, segmentInfo2[i].leng, segmentInfo2[j].leng)) != null) {
                        if (intf.isIntersectionPoint()) {
                            if (!(i + 1 == j || this.polyline.isPeriodic() && i == 0 && j == nSegments - 1)) {
                                JgclIntersectionPoint2D ints = intf.toIntersectionPoint();
                                interferenceList.addAsIntersection(ints.coordinates(), ints.pointOnCurve1().parameter() + (double)i, ints.pointOnCurve2().parameter() + (double)j, segmentInfo2[i].tol, segmentInfo2[j].tol);
                            }
                        } else {
                            JgclOverlapCurve2D ovlp = intf.toOverlapCurve();
                            interferenceList.addAsOverlap(ovlp.start1() + (double)i, ovlp.start2() + (double)j, ovlp.increase1(), ovlp.increase2(), segmentInfo2[i].tol, segmentInfo2[j].tol, segmentInfo2[i].tol, segmentInfo2[j].tol);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        interferenceList.removeOverlapsContainedInOtherOverlap();
        interferenceList.removeIntersectionsContainedInOverlap();
        return interferenceList;
    }

    static JgclIntersectionPoint2D[] intersection(JgclPolyline2D polyline) {
        JgclSelfIntsPol2D doObj = new JgclSelfIntsPol2D(polyline);
        return doObj.getInterference().toJgclIntersectionPoint2DArray(false);
    }

    static JgclCurveCurveInterference2D[] interference(JgclPolyline2D polyline) {
        JgclSelfIntsPol2D doObj = new JgclSelfIntsPol2D(polyline);
        return doObj.getInterference().toJgclCurveCurveInterference2DArray(false);
    }

    static JgclCurveCurveInterference2D[] interference(JgclPolyline2D polyline, JgclVector2D[] polylineUvecs, double[] polylineLengs, JgclEnclosingBox2D polylineEncls) {
        JgclSelfIntsPol2D doObj = new JgclSelfIntsPol2D(polyline, polylineUvecs, polylineLengs, polylineEncls);
        return doObj.getInterference().toJgclCurveCurveInterference2DArray(false);
    }

    private class SegmentInfo {
        private JgclBoundedLine2D bln;
        private JgclVector2D udir;
        private double leng;
        private double tol;
        private JgclEnclosingBox2D box;

        private SegmentInfo(JgclPoint2D spnt, JgclPoint2D epnt, JgclVector2D udir, double leng) {
            JgclSelfIntsPol2D.this = JgclSelfIntsPol2D.this;
            double d_tol = spnt.getToleranceForDistance();
            this.bln = new JgclBoundedLine2D(spnt, epnt);
            if (udir == null) {
                this.udir = this.bln.unitizedDirection();
                this.leng = this.bln.length();
            } else {
                this.udir = udir;
                this.leng = leng;
            }
            this.tol = this.leng < d_tol ? -1.0 : d_tol / this.leng;
            this.box = this.bln.enclosingBox();
        }

        private SegmentInfo(JgclPoint2D spnt, JgclPoint2D epnt) {
            this(spnt, epnt, null, 0.0);
        }
    }
}

