/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclCompositeCurve3D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment3D;
import jp.go.ipa.jgcl.JgclCurveCurvature3D;
import jp.go.ipa.jgcl.JgclCurveDerivative3D;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclHyperbola3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclNullArgument;
import jp.go.ipa.jgcl.JgclParabola3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPreferredSurfaceCurveRepresentation;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclRealFunctionWithOneVariable;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclSurfaceCurve3D
extends JgclParametricCurve3D {
    private JgclParametricCurve3D curve3d;
    private JgclParametricSurface3D basisSurface1;
    private JgclParametricCurve2D curve2d1;
    private JgclParametricSurface3D basisSurface2;
    private JgclParametricCurve2D curve2d2;
    private int masterRepresentation;

    public JgclSurfaceCurve3D(JgclParametricCurve3D curve3d, JgclParametricSurface3D basisSurface, JgclParametricCurve2D curve2d, int masterRepresentation) {
        if (curve3d == null && curve2d == null) {
            throw new JgclNullArgument();
        }
        if (basisSurface == null) {
            throw new JgclNullArgument();
        }
        switch (masterRepresentation) {
            case 0: {
                if (curve3d != null) break;
                throw new JgclInvalidArgumentValue();
            }
            case 1: {
                if (curve2d != null) break;
                throw new JgclInvalidArgumentValue();
            }
            default: {
                throw new JgclInvalidArgumentValue();
            }
        }
        this.curve3d = curve3d;
        this.basisSurface1 = basisSurface;
        this.curve2d1 = curve2d;
        this.basisSurface2 = null;
        this.curve2d2 = null;
        this.masterRepresentation = masterRepresentation;
    }

    protected JgclSurfaceCurve3D(JgclParametricCurve3D curve3d, JgclParametricSurface3D basisSurface1, JgclParametricCurve2D curve2d1, JgclParametricSurface3D basisSurface2, JgclParametricCurve2D curve2d2, int masterRepresentation) {
        if (curve3d == null && curve2d1 == null && curve2d2 == null) {
            throw new JgclNullArgument();
        }
        if (basisSurface1 == null || basisSurface2 == null) {
            throw new JgclNullArgument();
        }
        switch (masterRepresentation) {
            case 0: {
                if (curve3d != null) break;
                throw new JgclInvalidArgumentValue();
            }
            case 1: {
                if (curve2d1 != null) break;
                throw new JgclInvalidArgumentValue();
            }
            case 2: {
                if (curve2d2 != null) break;
                throw new JgclInvalidArgumentValue();
            }
            default: {
                throw new JgclInvalidArgumentValue();
            }
        }
        this.curve3d = curve3d;
        this.basisSurface1 = basisSurface1;
        this.curve2d1 = curve2d1;
        this.basisSurface2 = basisSurface2;
        this.curve2d2 = curve2d2;
        this.masterRepresentation = masterRepresentation;
    }

    public JgclSurfaceCurve3D(JgclParametricCurve3D curve3d, JgclParametricSurface3D basisSurface) {
        if (curve3d == null || basisSurface == null) {
            throw new JgclNullArgument();
        }
        this.curve3d = curve3d;
        this.basisSurface1 = basisSurface;
        this.curve2d1 = null;
        this.basisSurface2 = null;
        this.curve2d2 = null;
        this.masterRepresentation = 0;
    }

    public JgclSurfaceCurve3D(JgclParametricSurface3D basisSurface, JgclParametricCurve2D curve2d) {
        if (curve2d == null || basisSurface == null) {
            throw new JgclNullArgument();
        }
        this.curve3d = null;
        this.basisSurface1 = basisSurface;
        this.curve2d1 = curve2d;
        this.basisSurface2 = null;
        this.curve2d2 = null;
        this.masterRepresentation = 1;
    }

    public JgclParametricCurve3D curve3d() {
        return this.curve3d;
    }

    public JgclParametricSurface3D basisSurface1() {
        return this.basisSurface1;
    }

    public JgclParametricCurve2D curve2d1() {
        return this.curve2d1;
    }

    public JgclParametricSurface3D basisSurface2() {
        return this.basisSurface2;
    }

    public JgclParametricCurve2D curve2d2() {
        return this.curve2d2;
    }

    public JgclParametricSurface3D basisSurface() {
        return this.basisSurface1();
    }

    public JgclParametricCurve2D curve2d() {
        return this.curve2d1();
    }

    public int masterRepresentation() {
        return this.masterRepresentation;
    }

    public double length(JgclParameterSection pint) {
        if (this.masterRepresentation() == 0) {
            return this.curve3d().length(pint);
        }
        1 realFunction = new 1();
        double dTol = this.getToleranceForDistance() / 2.0;
        return JgclMath.getDefiniteIntegral(realFunction, pint, dTol);
    }

    public JgclPoint3D coordinates(double param) {
        JgclParametricCurve2D curve2d;
        JgclParametricSurface3D basisSurface;
        if (this.masterRepresentation() == 0) {
            return this.curve3d().coordinates(param);
        }
        if (this.masterRepresentation() == 1) {
            basisSurface = this.basisSurface1();
            curve2d = this.curve2d1();
        } else {
            basisSurface = this.basisSurface2();
            curve2d = this.curve2d2();
        }
        JgclPoint2D paramS = curve2d.coordinates(param);
        return basisSurface.coordinates(paramS.x(), paramS.y());
    }

    public JgclVector3D tangentVector(double param) {
        JgclParametricCurve2D curve2d;
        JgclParametricSurface3D basisSurface;
        if (this.masterRepresentation() == 0) {
            return this.curve3d().tangentVector(param);
        }
        if (this.masterRepresentation() == 1) {
            basisSurface = this.basisSurface1();
            curve2d = this.curve2d1();
        } else {
            basisSurface = this.basisSurface2();
            curve2d = this.curve2d2();
        }
        JgclVector2D tngC = curve2d.tangentVector(param);
        JgclPoint2D paramS = curve2d.coordinates(param);
        JgclVector3D[] tngS = basisSurface.tangentVector(paramS.x(), paramS.y());
        return tngS[0].multiply(tngC.x()).add(tngS[1].multiply(tngC.y()));
    }

    public JgclCurveCurvature3D curvature(double param) {
        if (this.masterRepresentation() == 0) {
            return this.curve3d().curvature(param);
        }
        throw new JgclNotSupported();
    }

    public JgclCurveDerivative3D evaluation(double param) {
        if (this.masterRepresentation() == 0) {
            return this.curve3d().evaluation(param);
        }
        throw new JgclNotSupported();
    }

    public double torsion(double param) {
        if (this.masterRepresentation() == 0) {
            return this.curve3d().torsion(param);
        }
        throw new JgclNotSupported();
    }

    public JgclPointOnCurve3D[] singular() throws JgclIndefiniteSolution {
        if (this.masterRepresentation() == 0) {
            JgclPointOnCurve3D[] sol;
            try {
                sol = this.curve3d().singular();
            }
            catch (JgclIndefiniteSolution e) {
                JgclPointOnCurve3D sol1 = (JgclPointOnCurve3D)e.suitable();
                sol1 = new JgclPointOnCurve3D(this, sol1.parameter(), false);
                throw new JgclIndefiniteSolution(sol1);
            }
            int i = 0;
            while (i < sol.length) {
                sol[i] = new JgclPointOnCurve3D(this, sol[i].parameter(), false);
                ++i;
            }
            return sol;
        }
        throw new JgclNotSupported();
    }

    public JgclPointOnCurve3D[] inflexion() throws JgclIndefiniteSolution {
        if (this.masterRepresentation() == 0) {
            JgclPointOnCurve3D[] sol;
            try {
                sol = this.curve3d().inflexion();
            }
            catch (JgclIndefiniteSolution e) {
                JgclPointOnCurve3D sol1 = (JgclPointOnCurve3D)e.suitable();
                sol1 = new JgclPointOnCurve3D(this, sol1.parameter(), false);
                throw new JgclIndefiniteSolution(sol1);
            }
            int i = 0;
            while (i < sol.length) {
                sol[i] = new JgclPointOnCurve3D(this, sol[i].parameter(), false);
                ++i;
            }
            return sol;
        }
        throw new JgclNotSupported();
    }

    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D point) throws JgclIndefiniteSolution {
        if (this.masterRepresentation() == 0) {
            JgclPointOnCurve3D[] sol;
            try {
                sol = this.curve3d().projectFrom(point);
            }
            catch (JgclIndefiniteSolution e) {
                JgclPointOnCurve3D sol1 = (JgclPointOnCurve3D)e.suitable();
                sol1 = new JgclPointOnCurve3D(this, sol1.parameter(), false);
                throw new JgclIndefiniteSolution(sol1);
            }
            int i = 0;
            while (i < sol.length) {
                sol[i] = new JgclPointOnCurve3D(this, sol[i].parameter(), false);
                ++i;
            }
            return sol;
        }
        throw new JgclNotSupported();
    }

    public JgclPolyline3D toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol) {
        if (this.masterRepresentation() == 0) {
            JgclPolyline3D pol = this.curve3d().toPolyline(pint, tol);
            int nPnts = pol.nPoints();
            JgclPoint3D[] pnts = new JgclPoint3D[nPnts];
            int i = 0;
            while (i < nPnts) {
                JgclPointOnCurve3D poc = (JgclPointOnCurve3D)pol.pointAt(i);
                pnts[i] = new JgclPointOnCurve3D(this, poc.parameter(), false);
                ++i;
            }
            return new JgclPolyline3D(pnts, pol.closed());
        }
        throw new JgclNotSupported();
    }

    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
        if (this.masterRepresentation() == 0) {
            return this.curve3d().toBsplineCurve(pint);
        }
        throw new JgclNotSupported();
    }

    private JgclIntersectionPoint3D[] doIntersection(JgclGeometry mate, boolean doExchange) throws JgclIndefiniteSolution {
        if (!mate.is3D() || !mate.isParametric() || mate.isPoint()) {
            throw new JgclFatal();
        }
        if (this.masterRepresentation() == 0) {
            JgclIntersectionPoint3D[] sol;
            try {
                sol = mate.isCurve() ? this.curve3d().intersect((JgclParametricCurve3D)mate) : this.curve3d().intersect((JgclParametricSurface3D)mate);
            }
            catch (JgclIndefiniteSolution e) {
                JgclIntersectionPoint3D sol1 = (JgclIntersectionPoint3D)e.suitable();
                sol1 = (JgclIntersectionPoint3D)sol1.changeCurve1(this);
                if (doExchange) {
                    sol1 = sol1.exchange();
                }
                throw new JgclIndefiniteSolution(sol1);
            }
            int i = 0;
            while (i < sol.length) {
                sol[i] = (JgclIntersectionPoint3D)sol[i].changeCurve1(this);
                if (doExchange) {
                    sol[i] = sol[i].exchange();
                }
                ++i;
            }
            return sol;
        }
        throw new JgclNotSupported();
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        return this.doIntersection(mate, false);
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.doIntersection(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.doIntersection(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.doIntersection(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.doIntersection(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.doIntersection(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.doIntersection(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.doIntersection(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.doIntersection(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.doIntersection(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.doIntersection(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.doIntersection(mate, doExchange);
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate) throws JgclIndefiniteSolution {
        return this.doIntersection(mate, false);
    }

    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.doIntersection(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.doIntersection(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.doIntersection(mate, doExchange);
    }

    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
        throw new JgclNotSupported();
    }

    JgclParameterDomain getParameterDomain() {
        if (this.masterRepresentation() == 0) {
            return this.curve3d().getParameterDomain();
        }
        JgclParametricCurve2D curve2d = this.masterRepresentation() == 1 ? this.curve2d1() : this.curve2d2();
        return curve2d.getParameterDomain();
    }

    boolean getClosedFlag() {
        JgclParametricCurve2D curve2d;
        if (this.masterRepresentation() == 0) {
            return this.curve3d().getClosedFlag();
        }
        if (this.masterRepresentation() == 1) {
            JgclParametricSurface3D basisSurface = this.basisSurface1();
            curve2d = this.curve2d1();
        } else {
            JgclParametricSurface3D basisSurface = this.basisSurface2();
            curve2d = this.curve2d2();
        }
        if (curve2d.isPeriodic()) {
            return true;
        }
        if (curve2d.isInfinite()) {
            return false;
        }
        JgclParameterSection section = curve2d.parameterDomain().section();
        return this.coordinates(section.start()).identical(this.coordinates(section.end()));
    }

    int type() {
        return 26;
    }

    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns, double rCos, double rSin) {
        throw new JgclNotSupported();
    }

    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
        throw new JgclNotSupported();
    }

    protected synchronized JgclParametricCurve3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclParametricCurve3D tCurve3d = this.curve3d;
        JgclParametricSurface3D tBasisSurface1 = this.basisSurface1;
        JgclParametricSurface3D tBasisSurface2 = this.basisSurface2;
        if (tCurve3d != null) {
            tCurve3d = tCurve3d.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        if (tBasisSurface1 != null) {
            tBasisSurface1 = tBasisSurface1.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        if (tBasisSurface2 != null) {
            tBasisSurface2 = tBasisSurface2.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        return new JgclSurfaceCurve3D(tCurve3d, tBasisSurface1, this.curve2d1, tBasisSurface2, this.curve2d2, this.masterRepresentation);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        if (this.curve3d != null) {
            writer.println(String.valueOf(indent_tab) + "\tcurve3d");
            this.curve3d.output(writer, indent + 2);
        }
        writer.println(String.valueOf(indent_tab) + "\tbasisSurface1");
        this.basisSurface1.output(writer, indent + 2);
        if (this.curve2d1 != null) {
            writer.println(String.valueOf(indent_tab) + "\tcurve2d1");
            this.curve2d1.output(writer, indent + 2);
        }
        if (this.basisSurface2 != null) {
            writer.println(String.valueOf(indent_tab) + "\tbasisSurface2");
            this.basisSurface2.output(writer, indent + 2);
            if (this.curve2d2 != null) {
                writer.println(String.valueOf(indent_tab) + "\tcurve2d2");
                this.curve2d2.output(writer, indent + 2);
            }
        }
        writer.println(String.valueOf(indent_tab) + "\tmasterRepresentation\t" + JgclPreferredSurfaceCurveRepresentation.toString(this.masterRepresentation));
        writer.println(String.valueOf(indent_tab) + "End");
    }

    private final class 1
    implements JgclRealFunctionWithOneVariable {
        public double evaluate(double parameter) {
            return JgclSurfaceCurve3D.this.tangentVector(parameter).length();
        }

        /* synthetic */ 1() {
        }
    }
}

