/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclCurveCurvature;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclMachineEpsilon;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclSurfaceCurvature3D;
import jp.go.ipa.jgcl.JgclSurfaceDerivative;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclSurfaceDerivative3D
extends JgclSurfaceDerivative {
    private final JgclPoint3D d0;
    private final JgclVector3D du;
    private final JgclVector3D dv;
    private final JgclVector3D duu;
    private final JgclVector3D duv;
    private final JgclVector3D dvv;

    public JgclSurfaceDerivative3D(JgclPoint3D d0, JgclVector3D du, JgclVector3D dv, JgclVector3D duu, JgclVector3D duv, JgclVector3D dvv) {
        this.d0 = d0;
        this.du = du;
        this.dv = dv;
        this.duu = duu;
        this.duv = duv;
        this.dvv = dvv;
    }

    public JgclPoint3D d0() {
        return this.d0;
    }

    public JgclVector3D du() {
        return this.du;
    }

    public JgclVector3D dv() {
        return this.dv;
    }

    public JgclVector3D duu() {
        return this.duu;
    }

    public JgclVector3D duv() {
        return this.duv;
    }

    public JgclVector3D dvv() {
        return this.dvv;
    }

    public JgclSurfaceCurvature3D principalCurvature() {
        JgclRealPolynomial poly;
        double[] AAA = new double[3];
        JgclVector3D[] dir = new JgclVector3D[2];
        double m_eps = JgclMachineEpsilon.DOUBLE;
        JgclVector3D UNV = this.du.crossProduct(this.dv).unitized();
        double LLL = UNV.x() * this.duu.x() + UNV.y() * this.duu.y() + UNV.z() * this.duu.z();
        double MMM = UNV.x() * this.duv.x() + UNV.y() * this.duv.y() + UNV.z() * this.duv.z();
        double NNN = UNV.x() * this.dvv.x() + UNV.y() * this.dvv.y() + UNV.z() * this.dvv.z();
        double EEE = this.du.x() * this.du.x() + this.du.y() * this.du.y() + this.du.z() * this.du.z();
        double FFF = this.du.x() * this.dv.x() + this.du.y() * this.dv.y() + this.du.z() * this.dv.z();
        double GGG = this.dv.x() * this.dv.x() + this.dv.y() * this.dv.y() + this.dv.z() * this.dv.z();
        AAA[2] = EEE * GGG - FFF * FFF;
        if (Math.abs(AAA[2]) < m_eps) {
            double[] pcv = new double[2];
            pcv[1] = 0.0;
            pcv[0] = 0.0;
            dir[0] = dir[1] = JgclVector3D.zeroVector;
            return new JgclSurfaceCurvature3D(pcv, dir);
        }
        AAA[1] = 2.0 * FFF * MMM - EEE * NNN - GGG * LLL;
        AAA[0] = LLL * NNN - MMM * MMM;
        try {
            poly = new JgclRealPolynomial(AAA);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        double[] pcv = poly.getRootsIfQuadric();
        if (pcv.length != 2 || JgclCurveCurvature.identical(pcv[0], pcv[1])) {
            if (pcv.length != 2) {
                pcv = new double[2];
            }
            pcv[0] = pcv[1] = -AAA[1] / (2.0 * AAA[2]);
            dir[0] = dir[1] = JgclVector3D.zeroVector;
            return new JgclSurfaceCurvature3D(pcv, dir);
        }
        if (Math.abs(MMM) < m_eps && Math.abs(FFF) < m_eps) {
            double pcv_val = LLL / EEE;
            if (Math.abs(pcv[0] - pcv_val) < Math.abs(pcv[1] - pcv_val)) {
                dir[0] = this.du;
                dir[1] = this.dv;
            } else {
                dir[0] = this.dv;
                dir[1] = this.du;
            }
            int i = 0;
            while (i < 2) {
                dir[i] = dir[i].unitized();
                ++i;
            }
        } else {
            int i = 0;
            while (i < 2) {
                if (Math.abs(MMM - pcv[i] * FFF) > m_eps) {
                    double XI = 1.0;
                    double ETA = -(LLL - pcv[i] * EEE) / (MMM - pcv[i] * FFF);
                    dir[i] = new JgclLiteralVector3D(XI * this.du.x() + ETA * this.dv.x(), XI * this.du.y() + ETA * this.dv.y(), XI * this.du.z() + ETA * this.dv.z());
                } else {
                    dir[i] = this.dv;
                }
                dir[i] = dir[i].unitized();
                ++i;
            }
        }
        if (Math.abs(pcv[0]) < Math.abs(pcv[1])) {
            double swap1 = pcv[0];
            pcv[0] = pcv[1];
            pcv[1] = swap1;
            JgclVector3D swap2 = dir[0];
            dir[0] = dir[1];
            dir[1] = swap2;
        }
        return new JgclSurfaceCurvature3D(pcv, dir);
    }
}

