/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCurveDerivative3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclMesh3D;
import jp.go.ipa.jgcl.JgclOfst3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclSurfaceDerivative3D;
import jp.go.ipa.jgcl.JgclSweptSurface3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclSurfaceOfLinearExtrusion3D
extends JgclSweptSurface3D {
    private JgclVector3D extrusionAxis;

    public JgclSurfaceOfLinearExtrusion3D(JgclParametricCurve3D sweptCurve, JgclVector3D extrusionAxis) {
        super(sweptCurve);
        this.setExtrusionAxis(extrusionAxis);
    }

    private void setExtrusionAxis(JgclVector3D extrusionAxis) {
        if (extrusionAxis == null) {
            throw new JgclInvalidArgumentValue();
        }
        this.extrusionAxis = extrusionAxis;
    }

    public JgclVector3D extrusionAxis() {
        return this.extrusionAxis;
    }

    public JgclPoint3D coordinates(double uParam, double vParam) {
        return this.sweptCurve().coordinates(uParam).add(this.extrusionAxis.multiply(vParam));
    }

    public JgclVector3D[] tangentVector(double uParam, double vParam) {
        JgclVector3D[] tng = new JgclVector3D[]{this.sweptCurve().tangentVector(uParam), this.extrusionAxis};
        return tng;
    }

    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam) {
        JgclVector3D duv;
        JgclCurveDerivative3D crv_drv = this.sweptCurve().evaluation(uParam);
        JgclPoint3D d0 = crv_drv.d0D().add(this.extrusionAxis.multiply(vParam));
        JgclVector3D du = crv_drv.d1D();
        JgclVector3D dv = this.extrusionAxis;
        JgclVector3D duu = crv_drv.d2D();
        JgclVector3D dvv = duv = JgclVector3D.zeroVector;
        return new JgclSurfaceDerivative3D(d0, du, dv, duu, duv, dvv);
    }

    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point) throws JgclIndefiniteSolution {
        JgclLine3D line = new JgclLine3D(JgclPoint3D.origin, this.extrusionAxis);
        JgclPoint3D point_on_curve = this.sweptCurve().getPointNotOnLine(line);
        JgclVector3D normal = this.extrusionAxis;
        JgclPlane3D plane = new JgclPlane3D(point_on_curve, normal);
        JgclPointOnSurface3D lpoint = plane.projectFrom(point)[0];
        JgclAxis2Placement3D position = new JgclAxis2Placement3D(lpoint, normal, normal.verticalVector().unitized());
        JgclCartesianTransformationOperator3D cto = new JgclCartesianTransformationOperator3D(position, 1.0);
        JgclPointOnCurve3D[] lproj = this.sweptCurve().projectFrom(lpoint);
        JgclPointOnSurface3D[] proj = new JgclPointOnSurface3D[lproj.length];
        JgclVector3D vector = point.subtract(lpoint);
        double flag = 1.0;
        if (!normal.identicalDirection(vector)) {
            flag = -1.0;
        }
        double vParam = flag * Math.sqrt(vector.norm() / normal.norm());
        int i = 0;
        while (i < lproj.length) {
            double uParam = lproj[i].parameter();
            proj[i] = new JgclPointOnSurface3D(this, uParam, vParam, false);
            ++i;
        }
        return proj;
    }

    public JgclMesh3D toMesh(JgclParameterSection uPint, JgclParameterSection vPint, JgclToleranceForDistance tol) {
        return this.makeMesh(1, uPint, vPint, tol);
    }

    private JgclMesh3D makeMesh(int meshType, JgclParameterSection uPint, JgclParameterSection vPint, JgclToleranceForDistance tol) {
        double vStart = vPint.start();
        double vEnd = vPint.end();
        double vMiddle = (vStart + vEnd) / 2.0;
        JgclPolyline3D pol = this.sweptCurve().toPolyline(uPint, tol);
        int u_npnts = pol.nPoints();
        JgclPoint3D[][] mesh = meshType == 1 ? new JgclPointOnSurface3D[u_npnts][2] : new JgclPointOnSurface3D[u_npnts][3];
        int i = 0;
        while (i < u_npnts) {
            JgclPointOnCurve3D poc = (JgclPointOnCurve3D)pol.pointAt(i);
            double uParam = poc.parameter();
            try {
                mesh[i][0] = new JgclPointOnSurface3D(this, uParam, vStart, false);
                if (meshType == 1) {
                    mesh[i][1] = new JgclPointOnSurface3D(this, uParam, vEnd, false);
                } else {
                    mesh[i][1] = new JgclPointOnSurface3D(this, uParam, vMiddle, false);
                    mesh[i][2] = new JgclPointOnSurface3D(this, uParam, vEnd, false);
                }
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return new JgclMesh3D(mesh, false);
    }

    public JgclBsplineSurface3D toBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint) {
        JgclBsplineCurve3D uBsplineCurve = this.sweptCurve().toBsplineCurve(uPint);
        int uNPoints = uBsplineCurve.nControlPoints();
        int vNPoints = 2;
        JgclPoint3D[][] controlPoints = new JgclPoint3D[uNPoints][vNPoints];
        double[][] weights = new double[uNPoints][vNPoints];
        JgclVector3D vLowerVec = this.extrusionAxis().multiply(vPint.start());
        JgclVector3D vUpperVec = this.extrusionAxis().multiply(vPint.end());
        int ui = 0;
        while (ui < uNPoints) {
            JgclPoint3D uPoint = uBsplineCurve.controlPointAt(ui);
            controlPoints[ui][0] = uPoint.add(vLowerVec);
            controlPoints[ui][1] = uPoint.add(vUpperVec);
            double d = uBsplineCurve.weightAt(ui);
            weights[ui][1] = d;
            weights[ui][0] = d;
            ++ui;
        }
        return new JgclBsplineSurface3D(uBsplineCurve.knotData(), JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment, controlPoints, weights);
    }

    public JgclBsplineSurface3D offsetByBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint, double magni, int side, JgclToleranceForDistance tol) {
        JgclOfst3D doObj = new JgclOfst3D(this, uPint, vPint, magni, side, tol);
        return doObj.offset();
    }

    public JgclParametricCurve3D uIsoParametricCurve(double uParam) {
        return new JgclLine3D(this.sweptCurve().coordinates(uParam), this.extrusionAxis);
    }

    public JgclParametricCurve3D vIsoParametricCurve(double vParam) {
        JgclVector3D moveVec = this.extrusionAxis.multiply(vParam);
        return this.sweptCurve().parallelTranslate(moveVec);
    }

    JgclParameterDomain getUParameterDomain() {
        return this.sweptCurve().parameterDomain();
    }

    JgclParameterDomain getVParameterDomain() {
        return new JgclParameterDomain();
    }

    int type() {
        return 20;
    }

    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection, JgclParameterSection vParameterSection, double tolerance, double[] scalingFactor) {
        Vector<JgclPoint3D> result = new Vector<JgclPoint3D>();
        JgclMesh3D mesh = this.makeMesh(2, uParameterSection, vParameterSection, new JgclToleranceForDistance(tolerance));
        double uScale = 0.0;
        int u = 0;
        while (u < mesh.uNPoints()) {
            if (u > 0) {
                uScale += mesh.pointAt(u, 0).distance(mesh.pointAt(u - 1, 0));
            }
            int v = 0;
            while (v < mesh.vNPoints()) {
                result.addElement(mesh.pointAt(u, v));
                ++v;
            }
            ++u;
        }
        scalingFactor[0] = uScale /= uParameterSection.increase();
        scalingFactor[1] = 1.0;
        return result;
    }

    protected synchronized JgclParametricSurface3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclParametricCurve3D tSweptCurve = this.sweptCurve().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        JgclVector3D tExtrusionAxis = this.extrusionAxis.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclSurfaceOfLinearExtrusion3D(tSweptCurve, tExtrusionAxis);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tsweptCurve");
        this.sweptCurve().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\textrusionAxis");
        this.extrusionAxis.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

