/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBoundedCurve3D;
import jp.go.ipa.jgcl.JgclBoundedLine3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclCompositeCurve3D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCurveCurvature3D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference3D;
import jp.go.ipa.jgcl.JgclCurveCurveInterferenceList;
import jp.go.ipa.jgcl.JgclCurveDerivative3D;
import jp.go.ipa.jgcl.JgclCurveSurfaceInterferenceList;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclHyperbola3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclParabola3D;
import jp.go.ipa.jgcl.JgclParameterConversion3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmingPreference;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclTrimmedCurve3D
extends JgclBoundedCurve3D {
    private JgclParametricCurve3D basisCurve;
    private JgclPoint3D tPnt1;
    private JgclPoint3D tPnt2;
    private double tParam1;
    private double tParam2;
    private int masterRepresentation1;
    private int masterRepresentation2;
    private boolean senseAgreement;

    private double checkParamValidity(double param) {
        if (this.basisCurve.isPeriodic()) {
            JgclParameterDomain domain = this.basisCurve.parameterDomain();
            return domain.wrap(param);
        }
        this.basisCurve.checkValidity(param);
        return param;
    }

    private void checkPointValidity(JgclPoint3D pnt, double param) {
        if (pnt != null && !this.basisCurve.coordinates(param).identical(pnt)) {
            throw new JgclInvalidArgumentValue();
        }
    }

    private void setParams(JgclParametricCurve3D basisCurve, JgclPoint3D tPnt1, JgclPoint3D tPnt2, double tParam1, double tParam2, int masterRepresentation1, int masterRepresentation2, boolean senseAgreement) {
        this.basisCurve = basisCurve;
        this.tParam1 = tParam1 = this.checkParamValidity(tParam1);
        this.tParam2 = tParam2 = this.checkParamValidity(tParam2);
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double pTol = condition.getToleranceForParameter();
        if (Math.abs(tParam2 - tParam1) < pTol) {
            throw new JgclInvalidArgumentValue();
        }
        this.checkPointValidity(tPnt1, tParam1);
        this.tPnt1 = tPnt1;
        this.checkPointValidity(tPnt2, tParam2);
        this.tPnt2 = tPnt2;
        this.masterRepresentation1 = masterRepresentation1;
        this.masterRepresentation2 = masterRepresentation2;
        if (basisCurve.isPeriodic()) {
            JgclParameterSection sec = basisCurve.parameterDomain().section();
            if (senseAgreement) {
                if (tParam1 > tParam2) {
                    this.tParam2 = tParam2 += sec.increase();
                }
            } else if (tParam1 < tParam2) {
                this.tParam1 = tParam1 += sec.increase();
            }
        } else if (senseAgreement ? tParam1 > tParam2 : tParam1 < tParam2) {
            throw new JgclInvalidArgumentValue();
        }
        this.senseAgreement = senseAgreement;
    }

    JgclTrimmedCurve3D(JgclParametricCurve3D basisCurve, JgclPoint3D tPnt1, JgclPoint3D tPnt2, double tParam1, double tParam2, int masterRepresentation1, int masterRepresentation2, boolean senseAgreement) {
        this.setParams(basisCurve, tPnt1, tPnt2, tParam1, tParam2, masterRepresentation1, masterRepresentation2, senseAgreement);
    }

    public JgclTrimmedCurve3D(JgclParametricCurve3D basisCurve, JgclPoint3D tPnt1, JgclPoint3D tPnt2, boolean senseAgreement) {
        this.setParams(basisCurve, tPnt1, tPnt2, basisCurve.pointToParameter(tPnt1), basisCurve.pointToParameter(tPnt2), 0, 0, senseAgreement);
    }

    public JgclTrimmedCurve3D(JgclParametricCurve3D basisCurve, double tParam1, double tParam2, boolean senseAgreement) {
        this.setParams(basisCurve, null, null, tParam1, tParam2, 1, 1, senseAgreement);
    }

    public JgclTrimmedCurve3D(JgclParametricCurve3D basisCurve, JgclParameterSection pint) {
        this.setParams(basisCurve, null, null, pint.start(), pint.end(), 1, 1, pint.increase() > 0.0);
    }

    public JgclParametricCurve3D basisCurve() {
        return this.basisCurve;
    }

    public JgclPoint3D tPnt1() {
        return this.tPnt1;
    }

    public JgclPoint3D tPnt2() {
        return this.tPnt2;
    }

    public double tParam1() {
        return this.tParam1;
    }

    public double tParam2() {
        return this.tParam2;
    }

    public int masterRepresentation1() {
        return this.masterRepresentation1;
    }

    public int masterRepresentation2() {
        return this.masterRepresentation2;
    }

    public boolean senseAgreement() {
        return this.senseAgreement;
    }

    public double toBasisParameter(double param) {
        this.checkValidity(param);
        if (this.senseAgreement) {
            return param + this.tParam1;
        }
        return this.tParam1 - param;
    }

    public JgclParameterSection toBasisParameter(JgclParameterSection pint) {
        double start = this.toBasisParameter(pint.start());
        double end = this.toBasisParameter(pint.end());
        return new JgclParameterSection(start, end - start);
    }

    /*
     * Unable to fully structure code
     */
    public double toOwnParameter(double param) {
        block8: {
            if (!this.basisCurve.isPeriodic()) break block8;
            absInc = this.basisCurve.parameterDomain().section().absIncrease();
            if (!this.senseAgreement) ** GOTO lbl14
            while (param < this.tParam1) {
                param += absInc;
            }
            while (this.tParam2 < param) {
                param -= absInc;
            }
            if (!(param < this.tParam1) || !(this.tParam1 - param > param + absInc - this.tParam2)) break block8;
            param += absInc;
            break block8;
lbl-1000:
            // 1 sources

            {
                param += absInc;
lbl14:
                // 2 sources

                ** while (param < this.tParam2)
            }
lbl15:
            // 2 sources

            while (this.tParam1 < param) {
                param -= absInc;
            }
            if (param < this.tParam2 && this.tParam2 - param > param + absInc - this.tParam1) {
                param += absInc;
            }
        }
        return this.senseAgreement != false ? param - this.tParam1 : this.tParam1 - param;
    }

    public double length(JgclParameterSection pint) {
        return this.basisCurve.length(this.toBasisParameter(pint));
    }

    public JgclPoint3D coordinates(double param) {
        return this.basisCurve.coordinates(this.toBasisParameter(param));
    }

    public JgclVector3D tangentVector(double param) {
        JgclVector3D tang = this.basisCurve.tangentVector(this.toBasisParameter(param));
        if (this.senseAgreement) {
            return tang;
        }
        return tang.multiply(-1.0);
    }

    public JgclCurveCurvature3D curvature(double param) {
        return this.basisCurve.curvature(this.toBasisParameter(param));
    }

    public double torsion(double param) {
        return this.basisCurve.torsion(this.toBasisParameter(param));
    }

    public JgclCurveDerivative3D evaluation(double param) {
        JgclCurveDerivative3D curv = this.basisCurve.evaluation(this.toBasisParameter(param));
        if (this.senseAgreement) {
            return curv;
        }
        JgclCurveDerivative3D rcurv = new JgclCurveDerivative3D(curv.d0D(), curv.d1D().multiply(-1.0), curv.d2D(), curv.d3D().multiply(-1.0));
        return rcurv;
    }

    private double forceComputedParameter(double param) {
        switch (this.parameterValidity(param)) {
            case 3: {
                param = Double.NaN;
                break;
            }
            case 1: {
                param = this.parameterDomain().section().lower();
                break;
            }
            case 2: {
                param = this.parameterDomain().section().upper();
                break;
            }
        }
        return param;
    }

    public JgclPointOnCurve3D[] singular() throws JgclIndefiniteSolution {
        Vector<JgclPointOnCurve3D> singularVec = new Vector<JgclPointOnCurve3D>();
        JgclPointOnCurve3D[] singular = this.basisCurve.singular();
        JgclParameterDomain domain = this.parameterDomain();
        int i = 0;
        while (i < singular.length) {
            double param = this.toOwnParameter(singular[i].parameter());
            if (!Double.isNaN(param = this.forceComputedParameter(param))) {
                try {
                    singularVec.addElement(new JgclPointOnCurve3D(this, param, false));
                }
                catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                    throw new JgclFatal();
                }
            }
            ++i;
        }
        Object[] thisSingular = new JgclPointOnCurve3D[singularVec.size()];
        singularVec.copyInto(thisSingular);
        return thisSingular;
    }

    public JgclPointOnCurve3D[] inflexion() throws JgclIndefiniteSolution {
        Vector<JgclPointOnCurve3D> inflexionVec = new Vector<JgclPointOnCurve3D>();
        JgclPointOnCurve3D[] inflexion = this.basisCurve.inflexion();
        JgclParameterDomain domain = this.parameterDomain();
        int i = 0;
        while (i < inflexion.length) {
            double param = this.toOwnParameter(inflexion[i].parameter());
            if (!Double.isNaN(param = this.forceComputedParameter(param))) {
                try {
                    inflexionVec.addElement(new JgclPointOnCurve3D(this, param, false));
                }
                catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                    throw new JgclFatal();
                }
            }
            ++i;
        }
        Object[] thisInflexion = new JgclPointOnCurve3D[inflexionVec.size()];
        inflexionVec.copyInto(thisInflexion);
        return thisInflexion;
    }

    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D point) throws JgclIndefiniteSolution {
        Vector<JgclPointOnCurve3D> projvec = new Vector<JgclPointOnCurve3D>();
        JgclPointOnCurve3D[] proj = this.basisCurve.projectFrom(point);
        JgclParameterDomain domain = this.parameterDomain();
        int i = 0;
        while (i < proj.length) {
            double param = this.toOwnParameter(proj[i].parameter());
            if (!Double.isNaN(param = this.forceComputedParameter(param))) {
                JgclPointOnCurve3D proj2;
                try {
                    proj2 = new JgclPointOnCurve3D(this, param, false);
                }
                catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                    throw new JgclFatal();
                }
                projvec.addElement(proj2);
            }
            ++i;
        }
        Object[] prj = new JgclPointOnCurve3D[projvec.size()];
        projvec.copyInto(prj);
        return prj;
    }

    public JgclPolyline3D toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol) {
        JgclPolyline3D pl = this.basisCurve.toPolyline(this.toBasisParameter(pint), tol);
        JgclPoint3D[] pnts = new JgclPoint3D[pl.nPoints()];
        int i = 0;
        while (i < pnts.length) {
            JgclPointOnCurve3D p = (JgclPointOnCurve3D)pl.pointAt(i);
            pnts[i] = new JgclPointOnCurve3D(this, this.toOwnParameter(p.parameter()), false);
            ++i;
        }
        return new JgclPolyline3D(pnts);
    }

    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
        return this.basisCurve.toBsplineCurve(this.toBasisParameter(pint));
    }

    private JgclIntersectionPoint3D[] doIntersect(JgclParametricCurve3D mate, boolean doExchange) {
        JgclIntersectionPoint3D[] ints;
        Vector<JgclIntersectionPoint3D> intsvec = new Vector<JgclIntersectionPoint3D>();
        try {
            ints = this.basisCurve.intersect(mate);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            ints = new JgclIntersectionPoint3D[]{};
        }
        JgclParameterDomain domain = this.parameterDomain();
        int i = 0;
        while (i < ints.length) {
            JgclPointOnCurve3D pnt1 = (JgclPointOnCurve3D)ints[i].pointOnGeometry1();
            double param = this.toOwnParameter(pnt1.parameter());
            if (!Double.isNaN(param = this.forceComputedParameter(param))) {
                JgclPointOnCurve3D pnts = new JgclPointOnCurve3D(this, param, false);
                JgclIntersectionPoint3D ints2 = new JgclIntersectionPoint3D(pnts, ints[i].pointOnCurve2(), false);
                intsvec.addElement(ints2);
            }
            ++i;
        }
        Object[] xints = new JgclIntersectionPoint3D[intsvec.size()];
        intsvec.copyInto(xints);
        if (doExchange) {
            int i2 = 0;
            while (i2 < xints.length) {
                xints[i2] = ((JgclIntersectionPoint3D)xints[i2]).exchange();
                ++i2;
            }
        }
        return xints;
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) {
        return this.doIntersect(mate, false);
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] doIntersect(JgclParametricSurface3D mate, boolean doExchange) {
        JgclIntersectionPoint3D[] intp;
        try {
            intp = this.basisCurve().intersect(mate);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            intp = new JgclIntersectionPoint3D[]{};
        }
        JgclCurveSurfaceInterferenceList intfList = new JgclCurveSurfaceInterferenceList(this, mate);
        int i = 0;
        while (i < intp.length) {
            JgclPointOnCurve3D crvPnt = (JgclPointOnCurve3D)intp[i].pointOnGeometry1();
            JgclPointOnSurface3D srfPnt = (JgclPointOnSurface3D)intp[i].pointOnGeometry2();
            double crvParam = this.toOwnParameter(crvPnt.parameter());
            if (!Double.isNaN(crvParam = this.forceComputedParameter(crvParam))) {
                intfList.addAsIntersection(intp[i].coordinates(), crvParam, srfPnt.uParameter(), srfPnt.vParameter());
            }
            ++i;
        }
        return intfList.toJgclIntersectionPoint3DArray(doExchange);
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate) {
        return this.doIntersect(mate, false);
    }

    JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    public JgclCurveCurveInterference3D[] interfere(JgclBoundedCurve3D mate) {
        return this.interfere(mate, false);
    }

    JgclCurveCurveInterference3D[] interfere(JgclBoundedCurve3D mate, boolean doExchange) {
        JgclParameterConversion3D conv;
        JgclBoundedCurve3D bcurve;
        JgclCurveCurveInterferenceList intfList = new JgclCurveCurveInterferenceList(this, mate);
        JgclParameterDomain domain = this.parameterDomain();
        JgclParameterSection sec = new JgclParameterSection(this.tParam1, this.tParam2 - this.tParam1);
        if (this.basisCurve instanceof JgclBoundedCurve3D) {
            bcurve = (JgclBoundedCurve3D)this.basisCurve;
            conv = new ToTrimConversion(this);
        } else {
            bcurve = this.basisCurve.toBsplineCurve(sec);
            conv = new BsplineConversion(this, bcurve);
        }
        JgclCurveCurveInterference3D[] intf = !doExchange ? bcurve.interfere(mate) : mate.interfere(bcurve);
        Vector<JgclCurveCurveInterference3D> vec = new Vector<JgclCurveCurveInterference3D>();
        int i = 0;
        while (i < intf.length) {
            JgclCurveCurveInterference3D trimintf = !doExchange ? intf[i].trim1(sec, conv) : intf[i].trim2(sec, conv);
            if (trimintf != null) {
                vec.addElement(trimintf);
            }
            ++i;
        }
        Object[] interf = new JgclCurveCurveInterference3D[vec.size()];
        vec.copyInto(interf);
        return interf;
    }

    JgclCurveCurveInterference3D[] interfere(JgclBoundedLine3D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve3D)mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclPolyline3D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve3D)mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclPureBezierCurve3D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve3D)mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclBsplineCurve3D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve3D)mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclTrimmedCurve3D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve3D)mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurve3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
        JgclParametricCurve3D newBasis = this.basisCurve.parallelTranslate(moveVec);
        JgclPoint3D newTPnt1 = this.tPnt1 != null ? this.tPnt1.add(moveVec) : null;
        JgclPoint3D newTPnt2 = this.tPnt2 != null ? this.tPnt2.add(moveVec) : null;
        return new JgclTrimmedCurve3D(newBasis, newTPnt1, newTPnt2, this.tParam1, this.tParam2, this.masterRepresentation1, this.masterRepresentation2, this.senseAgreement);
    }

    JgclParameterDomain getParameterDomain() {
        try {
            return new JgclParameterDomain(false, 0.0, Math.abs(this.tParam2 - this.tParam1));
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    public boolean isFreeform() {
        return this.basisCurve.isFreeform();
    }

    public JgclPoint3D startPoint() {
        JgclPoint3D pnt1;
        try {
            pnt1 = this.tPnt1 == null || this.masterRepresentation1 == 1 ? this.basisCurve.coordinates(this.tParam1) : this.tPnt1;
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        if (this.tPnt1 == null) {
            this.tPnt1 = pnt1;
        }
        return pnt1;
    }

    public JgclPoint3D endPoint() {
        JgclPoint3D pnt2;
        try {
            pnt2 = this.tPnt2 == null || this.masterRepresentation2 == 1 ? this.basisCurve.coordinates(this.tParam2) : this.tPnt2;
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        if (this.tPnt2 == null) {
            this.tPnt2 = pnt2;
        }
        return pnt2;
    }

    int type() {
        return 23;
    }

    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns, double rCos, double rSin) {
        JgclPoint3D r_tPnt2;
        JgclParametricCurve3D r_basis = this.basisCurve().rotateZ(trns, rCos, rSin);
        JgclPoint3D r_tPnt1 = this.tPnt1();
        if (r_tPnt1 != null) {
            r_tPnt1 = r_tPnt1.rotateZ(trns, rCos, rSin);
        }
        if ((r_tPnt2 = this.tPnt2()) != null) {
            r_tPnt2 = r_tPnt2.rotateZ(trns, rCos, rSin);
        }
        return new JgclTrimmedCurve3D(r_basis, r_tPnt1, r_tPnt2, this.tParam1(), this.tParam2(), this.masterRepresentation1(), this.masterRepresentation2(), this.senseAgreement());
    }

    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
        JgclParameterSection pint = this.parameterDomain().section();
        JgclBsplineCurve3D b_spline = this.toBsplineCurve(pint);
        return b_spline.getPointNotOnLine(line);
    }

    protected synchronized JgclParametricCurve3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclParametricCurve3D tBasisCurve = this.basisCurve().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        JgclPoint3D tTPnt1 = null;
        JgclPoint3D tTPnt2 = null;
        if (this.masterRepresentation1() == 0) {
            tTPnt1 = this.tPnt1().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        if (this.masterRepresentation2() == 0) {
            tTPnt2 = this.tPnt2().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        return new JgclTrimmedCurve3D(tBasisCurve, tTPnt1, tTPnt2, this.tParam1(), this.tParam2(), this.masterRepresentation1(), this.masterRepresentation2(), this.senseAgreement());
    }

    protected boolean hasPolyline() {
        return this.basisCurve.hasPolyline();
    }

    protected boolean isComposedOfOnlyPolylines() {
        return this.basisCurve.isComposedOfOnlyPolylines();
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tbasisCurve");
        this.basisCurve.output(writer, indent + 2);
        if (this.tPnt1 != null) {
            writer.println(String.valueOf(indent_tab) + "\ttPnt1");
            this.tPnt1.output(writer, indent + 2);
        }
        if (this.tPnt2 != null) {
            writer.println(String.valueOf(indent_tab) + "\ttPnt2");
            this.tPnt2.output(writer, indent + 2);
        }
        writer.println(String.valueOf(indent_tab) + "\ttParam1\t" + this.tParam1);
        writer.println(String.valueOf(indent_tab) + "\ttParam2\t" + this.tParam2);
        writer.println(String.valueOf(indent_tab) + "\tmasterRepresentation1\t" + JgclTrimmingPreference.toString(this.masterRepresentation1));
        writer.println(String.valueOf(indent_tab) + "\tmasterRepresentation2\t" + JgclTrimmingPreference.toString(this.masterRepresentation2));
        writer.println(String.valueOf(indent_tab) + "\tsenseAgreement\t" + this.senseAgreement);
        writer.println(String.valueOf(indent_tab) + "End");
    }

    class ToTrimConversion
    extends JgclParameterConversion3D {
        JgclTrimmedCurve3D curve;

        ToTrimConversion(JgclTrimmedCurve3D curve) {
            JgclTrimmedCurve3D.this = JgclTrimmedCurve3D.this;
            this.curve = curve;
        }

        double convParameter(double param) {
            return this.curve.toOwnParameter(param);
        }

        JgclParametricCurve3D convCurve(double param) {
            return this.curve;
        }
    }

    class BsplineConversion
    extends JgclParameterConversion3D {
        JgclTrimmedCurve3D curve;
        JgclBoundedCurve3D bcurve;

        BsplineConversion(JgclTrimmedCurve3D curve, JgclBoundedCurve3D bcurve) {
            JgclTrimmedCurve3D.this = JgclTrimmedCurve3D.this;
            this.curve = curve;
            this.bcurve = bcurve;
        }

        double convParameter(double param) {
            JgclPointOnCurve3D pnt = new JgclPointOnCurve3D(this.bcurve, param, false);
            double bparam = this.curve.basisCurve().pointToParameter(pnt);
            return this.curve.toOwnParameter(bparam);
        }

        JgclParametricCurve3D convCurve(double param) {
            return this.curve;
        }
    }
}

