/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclLiteralVector1D;
import jp.go.ipa.jgcl.JgclPoint1D;
import jp.go.ipa.jgcl.JgclVector;

public abstract class JgclVector1D
extends JgclVector {
    public static final JgclVector1D zeroVector = new JgclLiteralVector1D(0.0);
    public static final JgclVector1D xUnitVector = new JgclLiteralVector1D(1.0, true);
    public static final JgclVector1D nagativeXUnitVector = new JgclLiteralVector1D(-1.0, true);
    private JgclVector1D unitized;

    protected JgclVector1D() {
        this.unitized = null;
    }

    protected JgclVector1D(boolean confirmedAsUnitized) {
        this.unitized = confirmedAsUnitized ? this : null;
    }

    public static JgclVector1D zeroVector() {
        return zeroVector;
    }

    public static JgclVector1D xUnitVector() {
        return xUnitVector;
    }

    public int dimension() {
        return 1;
    }

    public boolean is1D() {
        return true;
    }

    public abstract double x();

    public JgclVector1D unitized() {
        if (this.unitized != null) {
            return this.unitized;
        }
        if (!(this.x() < 0.0)) {
            this.unitized = xUnitVector;
            return this.unitized;
        }
        this.unitized = nagativeXUnitVector;
        return this.unitized;
    }

    public JgclVector1D reverse() {
        return new JgclLiteralVector1D(-this.x());
    }

    public double dotProduct(JgclVector1D mate) {
        return this.x() * mate.x();
    }

    public JgclVector1D add(JgclVector1D mate) {
        return new JgclLiteralVector1D(this.x() + mate.x());
    }

    public JgclVector1D subtract(JgclVector1D mate) {
        return new JgclLiteralVector1D(this.x() - mate.x());
    }

    public JgclVector1D multiply(double scale) {
        return new JgclLiteralVector1D(this.x() * scale);
    }

    public JgclVector1D divide(double scale) {
        return new JgclLiteralVector1D(this.x() / scale);
    }

    public boolean identical(JgclVector1D mate) {
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        return Math.abs(this.x() - mate.x()) < dTol;
    }

    public double length() {
        return Math.abs(this.x());
    }

    public double magnitude() {
        return Math.abs(this.x());
    }

    public double norm() {
        double val = this.x();
        return val * val;
    }

    public JgclPoint1D toPoint1D() {
        return JgclPoint1D.of(this.x());
    }

    public static JgclLiteralVector1D of(double x) {
        return new JgclLiteralVector1D(x);
    }
}

