/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclUtil;
import jp.go.ipa.jgcl.JgclVector;
import jp.go.ipa.jgcl.JgclZeroLength;

public abstract class JgclVector2D
extends JgclVector {
    public static final JgclVector2D zeroVector = new JgclLiteralVector2D(0.0, 0.0);
    public static final JgclVector2D xUnitVector = new JgclLiteralVector2D(1.0, 0.0, true);
    public static final JgclVector2D yUnitVector = new JgclLiteralVector2D(0.0, 1.0, true);
    private JgclVector2D unitized;

    protected JgclVector2D() {
        this.unitized = null;
    }

    protected JgclVector2D(boolean confirmedAsUnitized) {
        this.unitized = confirmedAsUnitized ? this : null;
    }

    public static JgclVector2D zeroVector() {
        return zeroVector;
    }

    public static JgclVector2D xUnitVector() {
        return xUnitVector;
    }

    public static JgclVector2D yUnitVector() {
        return yUnitVector;
    }

    public int dimension() {
        return 2;
    }

    public boolean is2D() {
        return true;
    }

    public abstract double x();

    public abstract double y();

    public JgclVector2D unitized() {
        if (this.unitized != null) {
            return this.unitized;
        }
        double leng = this.length();
        if (!JgclUtil.isDividable(Math.max(this.x(), this.y()), leng)) {
            this.unitized = zeroVector;
            return this.unitized;
        }
        this.unitized = new JgclLiteralVector2D(this.x() / leng, this.y() / leng, true);
        return this.unitized;
    }

    public JgclVector2D reverse() {
        return new JgclLiteralVector2D(-this.x(), -this.y());
    }

    public JgclVector2D verticalVector() {
        return new JgclLiteralVector2D(-this.y(), this.x());
    }

    public double dotProduct(JgclVector2D mate) {
        return this.x() * mate.x() + this.y() * mate.y();
    }

    public double zOfCrossProduct(JgclVector2D mate) {
        return this.x() * mate.y() - this.y() * mate.x();
    }

    public JgclVector2D add(JgclVector2D mate) {
        return new JgclLiteralVector2D(this.x() + mate.x(), this.y() + mate.y());
    }

    public JgclVector2D subtract(JgclVector2D mate) {
        return new JgclLiteralVector2D(this.x() - mate.x(), this.y() - mate.y());
    }

    public JgclVector2D multiply(double scale) {
        return new JgclLiteralVector2D(this.x() * scale, this.y() * scale);
    }

    public JgclVector2D divide(double scale) {
        return new JgclLiteralVector2D(this.x() / scale, this.y() / scale);
    }

    public boolean identical(JgclVector2D mate) {
        double yv;
        double dTol2 = this.getToleranceForDistance2();
        double xv = this.x() - mate.x();
        return xv * xv + (yv = this.y() - mate.y()) * yv < dTol2;
    }

    private boolean identicalDirection(JgclVector2D mate, boolean allowReversed) {
        boolean result;
        double aTol = this.getToleranceForAngle();
        double dTol2 = this.getToleranceForDistance2();
        if (this.norm() < dTol2 || mate.norm() < dTol2) {
            result = true;
        } else {
            double zOfCrossProd;
            double dotProd = this.dotProduct(mate);
            if (allowReversed) {
                dotProd = Math.abs(dotProd);
            }
            result = Math.abs(Math.atan2(zOfCrossProd = this.zOfCrossProduct(mate), dotProd)) < aTol;
        }
        return result;
    }

    public boolean identicalDirection(JgclVector2D mate) {
        return this.identicalDirection(mate, false);
    }

    public boolean parallelDirection(JgclVector2D mate) {
        return this.identicalDirection(mate, true);
    }

    public double norm() {
        double xv = this.x();
        double yv = this.y();
        return xv * xv + yv * yv;
    }

    public JgclPoint2D toPoint2D() {
        return JgclPoint2D.of(this.x(), this.y());
    }

    public double[] toDoubleArray() {
        double[] array = new double[]{this.x(), this.y()};
        return array;
    }

    public double angleWith(JgclVector2D mate) {
        JgclVector2D mateUnitVec;
        JgclVector2D thisUnitVec;
        try {
            thisUnitVec = this.unitized();
            mateUnitVec = mate.unitized();
        }
        catch (JgclZeroLength jgclZeroLength) {
            return 0.0;
        }
        double dotProduct = thisUnitVec.dotProduct(mateUnitVec);
        if (dotProduct > 1.0) {
            dotProduct = 1.0;
        }
        if (dotProduct < -1.0) {
            dotProduct = -1.0;
        }
        double theta = Math.acos(dotProduct);
        if (thisUnitVec.zOfCrossProduct(mateUnitVec) < 0.0) {
            theta = Math.PI * 2 - theta;
        }
        return theta;
    }

    protected abstract JgclVector2D doTransformBy(boolean var1, JgclCartesianTransformationOperator2D var2, Hashtable var3);

    public synchronized JgclVector2D transformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        if (transformedGeometries == null) {
            return this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        JgclVector2D transformed = (JgclVector2D)transformedGeometries.get(this);
        if (transformed == null) {
            transformed = this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
            transformedGeometries.put(this, transformed);
        }
        return transformed;
    }

    public synchronized JgclVector2D transformBy(JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(false, transformationOperator, transformedGeometries);
    }

    public synchronized JgclVector2D reverseTransformBy(JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(true, transformationOperator, transformedGeometries);
    }

    public static JgclLiteralVector2D of(double x, double y) {
        return new JgclLiteralVector2D(x, y);
    }

    public static JgclLiteralVector2D of(double[] components) {
        return new JgclLiteralVector2D(components);
    }
}

