/*
 * ߎ(Approximation)ꂽBsplineȐ𐶐邽߂̃NX(3D)
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclApproximation3D.java,v 1.11 2000/04/26 09:38:41 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * ߎ(Approximation)ꂽBsplineȐ𐶐邽߂̃NX(3D)
 *
 * @version $Revision: 1.11 $, $Date: 2000/04/26 09:38:41 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclApproximation3D extends JgclApproximation {
    /**
     * ߎ_
     *
     * @see JgclPoint3D
     */
    private JgclPoint3D[] points;

    /**
     * n_ƏI_̐ڐ --- [0]Fn_A[1]FI_
     * (`̏ꍇ null ̂܂)
     *
     * @see JgclVector3D
     */
    private JgclVector3D[] endVectors = null;

    /**
     * _Ap[^^ăIuWFNg\z
     *
     * @param points		_
     * @param params		p[^
     * @param endVectors	n_,I_̐ڐ
     * @param isClosed		`ǂ
     * @see JgclPoint3D
     * @see JgclVector3D
     */
    JgclApproximation3D(JgclPoint3D[] points, double[] params,
			JgclVector3D[] endVectors,
			boolean isClosed) {
	super(points.length, params, isClosed);
	this.points  = points;

	if (!isClosed) {
	    // J`̏ꍇ͐_̗[̏ݒ
	    if (endVectors == null)
		this.endVectors = JgclInterpolation3D.besselPoints(points, params);
	    else
		this.endVectors = endVectors;
	}
    }

    // 
    // ȉ͋e덷^ċߎꍇɕKvȏ
    // gh3aprcBsc3_Rev2, gh3aprcCBsc3_Rev2 (in gh3aprcBscR2.c) ڐA
    //

    /**
     * _̒Ԃ̐x𖞂Ă邩ǂ𒲂ׂ
     *
     * @param bsc	ߎꂽȐ
     * @param mid_tol	_̒Ԃ̐x
     * @return		x𖞂Ă邩ǂ
     * @see	JgclBsplineCurve3D
     */
    private boolean tolerated2(JgclBsplineCurve3D bsc, double mid_tol) {
	JgclPoint3D mid_pnt;
	double mid_param;
	JgclPoint3D mid_param_crd;
	int i, j;

	if (!isClosed) {
	    for (i = 0; i < (nPoints - 1); i++) {
		mid_pnt = points[i].midPoint(points[i+1]);
		mid_param = 0.5 * params[i] + 0.5 * params[i+1];
		mid_param_crd = bsc.coordinates(mid_param);
		if (mid_pnt.distance(mid_param_crd) > mid_tol)
		    return false;
	    }
	} else {
	    for (i = 0, j = 1; i < nPoints; i++, j++) {
		mid_pnt = points[i].midPoint(points[j % nPoints]);
		mid_param = 0.5 * params[i] + 0.5 * params[j];
		mid_param_crd = bsc.coordinates(mid_param);
		if (mid_pnt.distance(mid_param_crd) > mid_tol)
		    return false;
	    }
	}
	
	return true;
    }

    /**
     * ȗ߂B
     *
     * @param lower	l
     * @param upper	l
     * @param bsc_intp	⊮ꂽ BsplineȐ
     * @return		ȗ̔z
     * @see	JgclBsplineCurve3D
     */
    private double[] getCurvatures(int lower, int upper, JgclBsplineCurve3D bsc_intp) {
	double[] curvatures = new double[nPoints];
	for (int i = lower; i <= upper; i++) {
	    curvatures[i] = bsc_intp.curvature(params[i]).curvature();
	}

	return curvatures;
    }

    // 
    // ȉ̓ZOg(mbg)^ċߎꍇɕKvȏ
    // gh3aprxBsc3, gh3aprxCBsc3 (in gh3aprxBsc.c) ڐA
    // 

    /**
     * _𒼐ɓeB
     * @param dApnt	e_A
     * @param dBpnt	̓_B
     * @param dBdir	̃xNgB
     * @return		Bւ̓_A̐̑
     */
    private JgclPoint3D projectPointLine(JgclPoint3D dApnt,
					 JgclPoint3D dBpnt,
					 JgclVector3D dBdir)
    {
	JgclVector3D euvec;	// unitized vector of line
	JgclVector3D evpp;	// vector from dBpnt to dApnt
	double edot;		// dot product

	// set unit vector of dBdir
	euvec = dBdir.unitized();

	evpp = dApnt.subtract(dBpnt);
	edot = euvec.dotProduct(evpp);
	return dBpnt.add(euvec.multiply(edot));
    }

    /**
     * e_ points[i]  ̃p[^l params[i] ɑΉȐ
     * _̋(c)Ԃ
     *
     * @param bsc	ߎꂽȐ
     * @return	c̔z
     * @see	JgclBsplineCurve3D
     */
    private double[] compResiduals(JgclBsplineCurve3D bsc) {
	JgclPoint3D bpnt;
	int npnts = points.length;
	double[] res = new double[npnts];

	if (debug)
	    bsc.output(System.err);

	for (int i = 0; i < npnts; i++) {
	    bpnt = bsc.coordinates(params[i]);
	    res[i] = points[i].distance(bpnt);

	    if (debug) {
		System.err.println("i = " + i);
		System.err.println("params[" + i + "] = " + params[i]);
		System.err.println("bpnt[" + i + "] = (" 
				   + bpnt.x() + ", " + bpnt.y() + ", " + bpnt.z() + ")");
		System.err.println("res[" + i + "] = " + res[i]);
	    }
	}

	return res;
    }

    /**
     * _ X ߎ
     *
     * @param	ߎvẐ߂̃RrAs
     * @return	_ X ̔z
     * @see JgclMatrix
     */
    private JgclMatrix.LinearLeastSquareSolution fitX(JgclMatrix matrix) {
	if (debug)
	    System.err.println("[getting fitX]");

	double[] rightHandSideVector = new double[matrix.getRowSize()];
	for (int i = 0; i < rightHandSideVector.length; i++) {
	    rightHandSideVector[i] = points[i].x();
	}

	return matrix.solveLinearLeastSquare2(rightHandSideVector);
    }
    
    /**
     * _ Y ߎ
     *
     * @param	ߎvẐ߂̃RrAs
     * @return    _ Y ̔z
     * @see JgclMatrix
     */
    private JgclMatrix.LinearLeastSquareSolution fitY(JgclMatrix matrix) {
	if (debug)
	    System.err.println("[getting fitY]");

	double[] rightHandSideVector = new double[matrix.getRowSize()];
	for (int i = 0; i < rightHandSideVector.length; i++) {
	    rightHandSideVector[i] = points[i].y();
	}

	return matrix.solveLinearLeastSquare2(rightHandSideVector);
    }

    /**
     * _ Z ߎ
     *
     * @param	ߎvẐ߂̃RrAs
     * @return    _ Z ̔z
     * @see JgclMatrix
     */
    private JgclMatrix.LinearLeastSquareSolution fitZ(JgclMatrix matrix) {
	if (debug)
	    System.err.println("[getting fitZ]");

	double[] rightHandSideVector = new double[matrix.getRowSize()];
	for (int i = 0; i < rightHandSideVector.length; i++) {
	    rightHandSideVector[i] = points[i].z();
	}

	return matrix.solveLinearLeastSquare2(rightHandSideVector);
    }

    /**
     * _߂
     *
     * @param knotData	Bsplinẽmbg
     * @return    _
     */
    private JgclCartesianPoint3D[] getControlPoints(JgclBsplineKnot knotData) {
	JgclMatrix matrix = getDesignMatrix(knotData);

	JgclMatrix.LinearLeastSquareSolution x = fitX(matrix);
	JgclMatrix.LinearLeastSquareSolution y = fitY(matrix);
	JgclMatrix.LinearLeastSquareSolution z = fitZ(matrix);

	JgclCartesianPoint3D[] controlPoints =
	    new JgclCartesianPoint3D[knotData.nControlPoints()];
	for (int i = 0; i < knotData.nControlPoints(); i++) {
	    controlPoints[i] = new JgclCartesianPoint3D(x.solutionAt(i),
							y.solutionAt(i),
							z.solutionAt(i));
	}
	return controlPoints;
    }

    /**
     * _ߎBsplineȐ߂B
     * (Ăꍇ gh2aprxBsc3, JĂꍇ gh2aprxCBsc3)
     * <p>
     * _ߎBsplineȐŏ@pċ߂B
     * Ȑnsegs̃ZOgAknotsŎw肳ꂽmbgB
     * </p>
     *
     * @param nsegs	ZOg̐
     * @param knots	mbg(nsegs+1LłAȍ~͖)
     * @return    ߎꂽ BsplineȐ
     * @see	JgclBsplineCurve3D
     */
    JgclBsplineCurve3D getApproximationWithKnots(int nsegs, double[] knots) {
	if (nsegs < minSegmentNumber() || nsegs > maxSegmentNumber())
	    throw new JgclInvalidArgumentValue();

	// Knot Data
	JgclBsplineKnot knotData = getKnotData(nsegs, knots);

	// _
	JgclPoint3D[] control = getControlPoints(knotData);
	if (debug) {
	    for (int i = 0; i < control.length; i++) {
		System.err.println("control[" + i + "] = ("
				   + control[i].x() + ", "
				   + control[i].y() + ", "
				   + control[i].z() +")");
	    }
	}

	// JĂꍇ
	if (!isClosed) {
	    // adjust the neighbour of endpoints with a given tangential
	    // direction
	    control[1] =  projectPointLine(control[1], control[0], endVectors[0]);
	    control[control.length - 2]
		= projectPointLine(control[control.length - 2], control[control.length - 1], endVectors[1]);
	}

	return new JgclBsplineCurve3D(knotData, control, null);
    }

    /**
     * _ߎ3BsplineȐ߂B
     * (Ăꍇ gh3aprxBsc3, JĂꍇ gh3aprxCBsc3)
     * <p>
     * _^ꂽxŋߎBsplineȐ߂B
     * </p>
     *
     * @param tol	ߎRaXvCȐ̐xB
     *			Ȑ͗^ꂽ_ɑ΂Ă̋e덷ȓŐB
     * @param midTol	ߎRaXvCȐ̐x(_̒Ԃ̐x)B
     *			Ȑ͗^ꂽ_̂ꂼ̒ԓ_ɑ΂
     *			̋e덷ȓŐB
     * @return    ߎꂽ BsplineȐ
     * @see	JgclBsplineCurve3D
     * @see	JgclToleranceForDistance
     */
    JgclBsplineCurve3D getApproximationWithTolerance(JgclToleranceForDistance tol,
						     JgclToleranceForDistance midTol) {
	/*
	 * ߂ɗ^ꂽ_ԂȐ߂ĂB
	 * ̋Ȑ͋ߎȐ̎wWƂȂA
	 * ܂^ꂽe덷𖞂Ȃꍇɂ͂̋ȐԋpB
	 */
	JgclBsplineCurve3D intp_bsc = new JgclBsplineCurve3D(points, params, endVectors, isClosed);

	if (debug)
	    intp_bsc.output(System.err);
	 
	/*
	 * ԂȐp^ꂽe_ł̋ȗ߂Ă
	 */
	int upper, lower;
	lower = 2;
	if (isClosed) {
	    upper = nPoints - 2;
	} else {
	    upper = nPoints - 3;
	}

	double[] curvatures = getCurvatures(lower, upper, intp_bsc);
	double[] sortedCurvatures = (double[])curvatures.clone();
	if (lower < upper) {
	    JgclUtil.sortDoubleArray(sortedCurvatures, lower, upper);
	}

	/*
	 * ߎȐ̃ZOg̏l߂
	 */
	int[] nsegs = new int[nPoints + MARGIN];
	int nsegI = 0;
	if ((nsegs[nsegI] = initSegmentNumber()) < 0)
	    return intp_bsc;		// nPoints is too few

	/*
	 * ȍ~AߎȐx𖞂Ăꍇ́A
	 * ZOg炵AȂꍇ͑₵čċߎ݂B
	 * JԂāAx𖞂ƂZOgȂ
	 * Ȑ߂B
	 */
	double[] knots = new double[nPoints + MARGIN];
	boolean isTolerated;

	JgclBsplineCurve3D bsc = null;
	JgclBsplineCurve3D aprx_bsc = null;
	int bsc_nseg = nsegs[nsegI];

	while (true) {
	    // ZOgmbg
	    double ep;
	    if (isClosed)
		ep = params[nPoints];
	    else
		ep = params[nPoints - 1];
	    if (compKnots(params[0], ep, nsegs[nsegI], lower, upper,
			  curvatures, sortedCurvatures, knots)) {
		// ZOg^ċߎȐ𓾂
		aprx_bsc = getApproximationWithKnots(nsegs[nsegI], knots);
		// c𓾂
		double[] res = compResiduals(aprx_bsc);

		// e덷𖞂?
		if (tolerated(tol.value(), res) &&
		    tolerated2(aprx_bsc, midTol.value())) {
		    isTolerated = true;
		    bsc = aprx_bsc;
		    bsc_nseg = nsegs[nsegI];
		} else {
		    isTolerated = false;
		}
	    } else {
		// ݂̃ZOgł̓mbgȂ
		aprx_bsc = null;
		isTolerated = false;
	    }

	    // ̃ZOg𓾂
	    if (!reNewSegmentNumber(nsegs, nsegI, isTolerated))
		break;	// ȏ㎎ZOgȂ

	    nsegI++;
	}

	if (isClosed && bsc != null && bsc_nseg >= (nPoints - degree)) {
	    /*
	     * if closed curve is desired and the number of segments of obtained
	     * curve is near as the number of given points, there is a fear of
	     * zig-zag winding. therefore we discard that for safety.
	     */
	    if (debug)
		System.err.println("nseg = " + bsc_nseg + ", discarded");
	    bsc = null;
	}

	if (bsc == null) {	// x𖞂ߎȐ͓Ȃ
	    bsc = intp_bsc;	// ԋȐԋp
	}
	return bsc;
    }

    /**
     * fobOpCvOB
     */
    public static void main(String argv[]) {
	JgclToleranceForDistance tol = new JgclToleranceForDistance(0.1);
	JgclToleranceForDistance mid_tol = new JgclToleranceForDistance(10.0);

	System.out.println("Main: [creating JgclApproximation3D.]");

	// for closed case
	if (true) {
	    JgclCartesianPoint3D p0 = new JgclCartesianPoint3D(0.0, 0.0, 0.0);
	    JgclCartesianPoint3D p1 = new JgclCartesianPoint3D(0.4, 0.6, 0.1);
	    JgclCartesianPoint3D p2 = new JgclCartesianPoint3D(1.0, 1.0, 0.2);
	    JgclCartesianPoint3D p3 = new JgclCartesianPoint3D(1.6, 0.6, 0.3);
	    JgclCartesianPoint3D p4 = new JgclCartesianPoint3D(2.0, 0.0, 0.4);
	    JgclCartesianPoint3D p5 = new JgclCartesianPoint3D(1.6, -0.6, 0.3);
	    JgclCartesianPoint3D p6 = new JgclCartesianPoint3D(1.0, -1.0, 0.2);
	    JgclCartesianPoint3D p7 = new JgclCartesianPoint3D(0.4, -0.6, 0.1);

	    JgclCartesianPoint3D[] pntsClosed = {p0, p1, p2, p3, p4, p5, p6, p7};
	    double[] prmsClosed = {0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0};
	    JgclApproximation3D aprxClosed =
		new JgclApproximation3D(pntsClosed, prmsClosed, null, true);
	    System.out.println("Main: [creating JgclBsplineCurve3D.]");
	    JgclBsplineCurve3D bsplineClosed = aprxClosed.getApproximationWithTolerance(tol, mid_tol);
	    System.out.println("\nMain: [JgclApproximation3D Closed Test]");
	    bsplineClosed.output(System.out);
	}

	// for open case
	if (true) {
	    JgclCartesianPoint3D p0 = new JgclCartesianPoint3D(0.0, 0.0, 0.0);
	    JgclCartesianPoint3D p1 = new JgclCartesianPoint3D(0.4, 0.2, 0.1);
	    JgclCartesianPoint3D p2 = new JgclCartesianPoint3D(1.0, 0.3, 0.2);
	    JgclCartesianPoint3D p3 = new JgclCartesianPoint3D(1.6, 0.25, 0.3);
	    JgclCartesianPoint3D p4 = new JgclCartesianPoint3D(2.0, 0.2, 0.4);
	    JgclCartesianPoint3D p5 = new JgclCartesianPoint3D(2.4, 0.25, 0.5);
	    JgclCartesianPoint3D p6 = new JgclCartesianPoint3D(3.0, 0.3, 0.4);
	    JgclCartesianPoint3D p7 = new JgclCartesianPoint3D(3.6, 0.25, 0.3);
	    JgclCartesianPoint3D p8 = new JgclCartesianPoint3D(4.0, 0.2, 0.2);
	    JgclLiteralVector3D sv = new JgclLiteralVector3D(0.4, 0.2, 0.1);
	    JgclLiteralVector3D ev = new JgclLiteralVector3D(0.4, -0.05, -0.1);

	    JgclCartesianPoint3D[] pntsOpen = {p0, p1, p2, p3, p4, p5, p6, p7, p8};
	    double[] prmsOpen = {0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0};
	    JgclLiteralVector3D[] endvecs = {sv, ev};
	    JgclApproximation3D aprxOpen =
		new JgclApproximation3D(pntsOpen, prmsOpen, endvecs, false);
	    System.out.println("\n\nMain: [creating Open JgclBsplineCurve3D.]");
	    JgclBsplineCurve3D bsplineOpen = aprxOpen.getApproximationWithTolerance(tol, mid_tol);
	    System.out.println("\nMain: [JgclApproximation3D Open Test]");
	    bsplineOpen.output(System.out);
	}
    }
}

// end of file
